/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.DependentStatus;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.DependentStatusBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.DependentStatusFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.RequirementStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RequirementStatusFluent<A extends RequirementStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DependentStatusBuilder> dependents = new ArrayList();
    private String group;
    private String kind;
    private String message;
    private String name;
    private String status;
    private String uuid;
    private String version;
    private Map<String, Object> additionalProperties;

    public RequirementStatusFluent() {
    }

    public RequirementStatusFluent(RequirementStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RequirementStatus instance) {
        RequirementStatus requirementStatus = instance = instance != null ? instance : new RequirementStatus();
        if (instance != null) {
            this.withDependents(instance.getDependents());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withMessage(instance.getMessage());
            this.withName(instance.getName());
            this.withStatus(instance.getStatus());
            this.withUuid(instance.getUuid());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDependents(int index, DependentStatus item) {
        if (this.dependents == null) {
            this.dependents = new ArrayList();
        }
        DependentStatusBuilder builder = new DependentStatusBuilder(item);
        if (index < 0 || index >= this.dependents.size()) {
            this._visitables.get("dependents").add(builder);
            this.dependents.add(builder);
        } else {
            this._visitables.get("dependents").add(builder);
            this.dependents.add(index, builder);
        }
        return (A)this;
    }

    public A setToDependents(int index, DependentStatus item) {
        if (this.dependents == null) {
            this.dependents = new ArrayList();
        }
        DependentStatusBuilder builder = new DependentStatusBuilder(item);
        if (index < 0 || index >= this.dependents.size()) {
            this._visitables.get("dependents").add(builder);
            this.dependents.add(builder);
        } else {
            this._visitables.get("dependents").add(builder);
            this.dependents.set(index, builder);
        }
        return (A)this;
    }

    public A addToDependents(DependentStatus ... items) {
        if (this.dependents == null) {
            this.dependents = new ArrayList();
        }
        for (DependentStatus item : items) {
            DependentStatusBuilder builder = new DependentStatusBuilder(item);
            this._visitables.get("dependents").add(builder);
            this.dependents.add(builder);
        }
        return (A)this;
    }

    public A addAllToDependents(Collection<DependentStatus> items) {
        if (this.dependents == null) {
            this.dependents = new ArrayList();
        }
        for (DependentStatus item : items) {
            DependentStatusBuilder builder = new DependentStatusBuilder(item);
            this._visitables.get("dependents").add(builder);
            this.dependents.add(builder);
        }
        return (A)this;
    }

    public A removeFromDependents(DependentStatus ... items) {
        if (this.dependents == null) {
            return (A)this;
        }
        for (DependentStatus item : items) {
            DependentStatusBuilder builder = new DependentStatusBuilder(item);
            this._visitables.get("dependents").remove(builder);
            this.dependents.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDependents(Collection<DependentStatus> items) {
        if (this.dependents == null) {
            return (A)this;
        }
        for (DependentStatus item : items) {
            DependentStatusBuilder builder = new DependentStatusBuilder(item);
            this._visitables.get("dependents").remove(builder);
            this.dependents.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDependents(Predicate<DependentStatusBuilder> predicate) {
        if (this.dependents == null) {
            return (A)this;
        }
        Iterator<DependentStatusBuilder> each = this.dependents.iterator();
        Object visitables = this._visitables.get("dependents");
        while (each.hasNext()) {
            DependentStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DependentStatus> buildDependents() {
        return this.dependents != null ? RequirementStatusFluent.build(this.dependents) : null;
    }

    public DependentStatus buildDependent(int index) {
        return this.dependents.get(index).build();
    }

    public DependentStatus buildFirstDependent() {
        return this.dependents.get(0).build();
    }

    public DependentStatus buildLastDependent() {
        return this.dependents.get(this.dependents.size() - 1).build();
    }

    public DependentStatus buildMatchingDependent(Predicate<DependentStatusBuilder> predicate) {
        for (DependentStatusBuilder item : this.dependents) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDependent(Predicate<DependentStatusBuilder> predicate) {
        for (DependentStatusBuilder item : this.dependents) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependents(List<DependentStatus> dependents) {
        if (this.dependents != null) {
            this._visitables.get("dependents").clear();
        }
        if (dependents != null) {
            this.dependents = new ArrayList();
            for (DependentStatus item : dependents) {
                this.addToDependents(item);
            }
        } else {
            this.dependents = null;
        }
        return (A)this;
    }

    public A withDependents(DependentStatus ... dependents) {
        if (this.dependents != null) {
            this.dependents.clear();
            this._visitables.remove("dependents");
        }
        if (dependents != null) {
            for (DependentStatus item : dependents) {
                this.addToDependents(item);
            }
        }
        return (A)this;
    }

    public boolean hasDependents() {
        return this.dependents != null && !this.dependents.isEmpty();
    }

    public DependentsNested<A> addNewDependent() {
        return new DependentsNested(-1, null);
    }

    public DependentsNested<A> addNewDependentLike(DependentStatus item) {
        return new DependentsNested(-1, item);
    }

    public DependentsNested<A> setNewDependentLike(int index, DependentStatus item) {
        return new DependentsNested(index, item);
    }

    public DependentsNested<A> editDependent(int index) {
        if (this.dependents.size() <= index) {
            throw new RuntimeException("Can't edit dependents. Index exceeds size.");
        }
        return this.setNewDependentLike(index, this.buildDependent(index));
    }

    public DependentsNested<A> editFirstDependent() {
        if (this.dependents.size() == 0) {
            throw new RuntimeException("Can't edit first dependents. The list is empty.");
        }
        return this.setNewDependentLike(0, this.buildDependent(0));
    }

    public DependentsNested<A> editLastDependent() {
        int index = this.dependents.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependents. The list is empty.");
        }
        return this.setNewDependentLike(index, this.buildDependent(index));
    }

    public DependentsNested<A> editMatchingDependent(Predicate<DependentStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependents.size(); ++i) {
            if (!predicate.test(this.dependents.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependents. No match found.");
        }
        return this.setNewDependentLike(index, this.buildDependent(index));
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status = status;
        return (A)this;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public String getUuid() {
        return this.uuid;
    }

    public A withUuid(String uuid) {
        this.uuid = uuid;
        return (A)this;
    }

    public boolean hasUuid() {
        return this.uuid != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequirementStatusFluent that = (RequirementStatusFluent)o;
        if (!Objects.equals(this.dependents, that.dependents)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!Objects.equals(this.uuid, that.uuid)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dependents, this.group, this.kind, this.message, this.name, this.status, this.uuid, this.version, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dependents != null && !this.dependents.isEmpty()) {
            sb.append("dependents:");
            sb.append(String.valueOf(this.dependents) + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.uuid != null) {
            sb.append("uuid:");
            sb.append(this.uuid + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DependentsNested<N>
    extends DependentStatusFluent<DependentsNested<N>>
    implements Nested<N> {
        DependentStatusBuilder builder;
        int index;

        DependentsNested(int index, DependentStatus item) {
            this.index = index;
            this.builder = new DependentStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RequirementStatusFluent.this.setToDependents(this.index, this.builder.build());
        }

        public N endDependent() {
            return this.and();
        }
    }
}

