/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.packages.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.CSVDescription;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.CSVDescriptionBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.CSVDescriptionFluent;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.ChannelEntry;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.ChannelEntryBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.ChannelEntryFluent;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.Deprecation;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.DeprecationBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.DeprecationFluent;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.PackageChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PackageChannelFluent<A extends PackageChannelFluent<A>>
extends BaseFluent<A> {
    private String currentCSV;
    private CSVDescriptionBuilder currentCSVDesc;
    private DeprecationBuilder deprecation;
    private ArrayList<ChannelEntryBuilder> entries = new ArrayList();
    private String name;
    private Map<String, Object> additionalProperties;

    public PackageChannelFluent() {
    }

    public PackageChannelFluent(PackageChannel instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PackageChannel instance) {
        PackageChannel packageChannel = instance = instance != null ? instance : new PackageChannel();
        if (instance != null) {
            this.withCurrentCSV(instance.getCurrentCSV());
            this.withCurrentCSVDesc(instance.getCurrentCSVDesc());
            this.withDeprecation(instance.getDeprecation());
            this.withEntries(instance.getEntries());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCurrentCSV() {
        return this.currentCSV;
    }

    public A withCurrentCSV(String currentCSV) {
        this.currentCSV = currentCSV;
        return (A)this;
    }

    public boolean hasCurrentCSV() {
        return this.currentCSV != null;
    }

    public CSVDescription buildCurrentCSVDesc() {
        return this.currentCSVDesc != null ? this.currentCSVDesc.build() : null;
    }

    public A withCurrentCSVDesc(CSVDescription currentCSVDesc) {
        this._visitables.remove("currentCSVDesc");
        if (currentCSVDesc != null) {
            this.currentCSVDesc = new CSVDescriptionBuilder(currentCSVDesc);
            this._visitables.get("currentCSVDesc").add(this.currentCSVDesc);
        } else {
            this.currentCSVDesc = null;
            this._visitables.get("currentCSVDesc").remove(this.currentCSVDesc);
        }
        return (A)this;
    }

    public boolean hasCurrentCSVDesc() {
        return this.currentCSVDesc != null;
    }

    public CurrentCSVDescNested<A> withNewCurrentCSVDesc() {
        return new CurrentCSVDescNested(null);
    }

    public CurrentCSVDescNested<A> withNewCurrentCSVDescLike(CSVDescription item) {
        return new CurrentCSVDescNested(item);
    }

    public CurrentCSVDescNested<A> editCurrentCSVDesc() {
        return this.withNewCurrentCSVDescLike(Optional.ofNullable(this.buildCurrentCSVDesc()).orElse(null));
    }

    public CurrentCSVDescNested<A> editOrNewCurrentCSVDesc() {
        return this.withNewCurrentCSVDescLike(Optional.ofNullable(this.buildCurrentCSVDesc()).orElse(new CSVDescriptionBuilder().build()));
    }

    public CurrentCSVDescNested<A> editOrNewCurrentCSVDescLike(CSVDescription item) {
        return this.withNewCurrentCSVDescLike(Optional.ofNullable(this.buildCurrentCSVDesc()).orElse(item));
    }

    public Deprecation buildDeprecation() {
        return this.deprecation != null ? this.deprecation.build() : null;
    }

    public A withDeprecation(Deprecation deprecation) {
        this._visitables.remove("deprecation");
        if (deprecation != null) {
            this.deprecation = new DeprecationBuilder(deprecation);
            this._visitables.get("deprecation").add(this.deprecation);
        } else {
            this.deprecation = null;
            this._visitables.get("deprecation").remove(this.deprecation);
        }
        return (A)this;
    }

    public boolean hasDeprecation() {
        return this.deprecation != null;
    }

    public A withNewDeprecation(String message) {
        return this.withDeprecation(new Deprecation(message));
    }

    public DeprecationNested<A> withNewDeprecation() {
        return new DeprecationNested(null);
    }

    public DeprecationNested<A> withNewDeprecationLike(Deprecation item) {
        return new DeprecationNested(item);
    }

    public DeprecationNested<A> editDeprecation() {
        return this.withNewDeprecationLike(Optional.ofNullable(this.buildDeprecation()).orElse(null));
    }

    public DeprecationNested<A> editOrNewDeprecation() {
        return this.withNewDeprecationLike(Optional.ofNullable(this.buildDeprecation()).orElse(new DeprecationBuilder().build()));
    }

    public DeprecationNested<A> editOrNewDeprecationLike(Deprecation item) {
        return this.withNewDeprecationLike(Optional.ofNullable(this.buildDeprecation()).orElse(item));
    }

    public A addToEntries(int index, ChannelEntry item) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
        if (index < 0 || index >= this.entries.size()) {
            this._visitables.get("entries").add(builder);
            this.entries.add(builder);
        } else {
            this._visitables.get("entries").add(builder);
            this.entries.add(index, builder);
        }
        return (A)this;
    }

    public A setToEntries(int index, ChannelEntry item) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
        if (index < 0 || index >= this.entries.size()) {
            this._visitables.get("entries").add(builder);
            this.entries.add(builder);
        } else {
            this._visitables.get("entries").add(builder);
            this.entries.set(index, builder);
        }
        return (A)this;
    }

    public A addToEntries(ChannelEntry ... items) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        for (ChannelEntry item : items) {
            ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
            this._visitables.get("entries").add(builder);
            this.entries.add(builder);
        }
        return (A)this;
    }

    public A addAllToEntries(Collection<ChannelEntry> items) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        for (ChannelEntry item : items) {
            ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
            this._visitables.get("entries").add(builder);
            this.entries.add(builder);
        }
        return (A)this;
    }

    public A removeFromEntries(ChannelEntry ... items) {
        if (this.entries == null) {
            return (A)this;
        }
        for (ChannelEntry item : items) {
            ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
            this._visitables.get("entries").remove(builder);
            this.entries.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEntries(Collection<ChannelEntry> items) {
        if (this.entries == null) {
            return (A)this;
        }
        for (ChannelEntry item : items) {
            ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
            this._visitables.get("entries").remove(builder);
            this.entries.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEntries(Predicate<ChannelEntryBuilder> predicate) {
        if (this.entries == null) {
            return (A)this;
        }
        Iterator<ChannelEntryBuilder> each = this.entries.iterator();
        Object visitables = this._visitables.get("entries");
        while (each.hasNext()) {
            ChannelEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ChannelEntry> buildEntries() {
        return this.entries != null ? PackageChannelFluent.build(this.entries) : null;
    }

    public ChannelEntry buildEntry(int index) {
        return this.entries.get(index).build();
    }

    public ChannelEntry buildFirstEntry() {
        return this.entries.get(0).build();
    }

    public ChannelEntry buildLastEntry() {
        return this.entries.get(this.entries.size() - 1).build();
    }

    public ChannelEntry buildMatchingEntry(Predicate<ChannelEntryBuilder> predicate) {
        for (ChannelEntryBuilder item : this.entries) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEntry(Predicate<ChannelEntryBuilder> predicate) {
        for (ChannelEntryBuilder item : this.entries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEntries(List<ChannelEntry> entries) {
        if (this.entries != null) {
            this._visitables.get("entries").clear();
        }
        if (entries != null) {
            this.entries = new ArrayList();
            for (ChannelEntry item : entries) {
                this.addToEntries(item);
            }
        } else {
            this.entries = null;
        }
        return (A)this;
    }

    public A withEntries(ChannelEntry ... entries) {
        if (this.entries != null) {
            this.entries.clear();
            this._visitables.remove("entries");
        }
        if (entries != null) {
            for (ChannelEntry item : entries) {
                this.addToEntries(item);
            }
        }
        return (A)this;
    }

    public boolean hasEntries() {
        return this.entries != null && !this.entries.isEmpty();
    }

    public EntriesNested<A> addNewEntry() {
        return new EntriesNested(-1, null);
    }

    public EntriesNested<A> addNewEntryLike(ChannelEntry item) {
        return new EntriesNested(-1, item);
    }

    public EntriesNested<A> setNewEntryLike(int index, ChannelEntry item) {
        return new EntriesNested(index, item);
    }

    public EntriesNested<A> editEntry(int index) {
        if (this.entries.size() <= index) {
            throw new RuntimeException("Can't edit entries. Index exceeds size.");
        }
        return this.setNewEntryLike(index, this.buildEntry(index));
    }

    public EntriesNested<A> editFirstEntry() {
        if (this.entries.size() == 0) {
            throw new RuntimeException("Can't edit first entries. The list is empty.");
        }
        return this.setNewEntryLike(0, this.buildEntry(0));
    }

    public EntriesNested<A> editLastEntry() {
        int index = this.entries.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last entries. The list is empty.");
        }
        return this.setNewEntryLike(index, this.buildEntry(index));
    }

    public EntriesNested<A> editMatchingEntry(Predicate<ChannelEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!predicate.test(this.entries.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching entries. No match found.");
        }
        return this.setNewEntryLike(index, this.buildEntry(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PackageChannelFluent that = (PackageChannelFluent)o;
        if (!Objects.equals(this.currentCSV, that.currentCSV)) {
            return false;
        }
        if (!Objects.equals(this.currentCSVDesc, that.currentCSVDesc)) {
            return false;
        }
        if (!Objects.equals(this.deprecation, that.deprecation)) {
            return false;
        }
        if (!Objects.equals(this.entries, that.entries)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentCSV, this.currentCSVDesc, this.deprecation, this.entries, this.name, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentCSV != null) {
            sb.append("currentCSV:");
            sb.append(this.currentCSV + ",");
        }
        if (this.currentCSVDesc != null) {
            sb.append("currentCSVDesc:");
            sb.append(String.valueOf(this.currentCSVDesc) + ",");
        }
        if (this.deprecation != null) {
            sb.append("deprecation:");
            sb.append(String.valueOf(this.deprecation) + ",");
        }
        if (this.entries != null && !this.entries.isEmpty()) {
            sb.append("entries:");
            sb.append(String.valueOf(this.entries) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EntriesNested<N>
    extends ChannelEntryFluent<EntriesNested<N>>
    implements Nested<N> {
        ChannelEntryBuilder builder;
        int index;

        EntriesNested(int index, ChannelEntry item) {
            this.index = index;
            this.builder = new ChannelEntryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PackageChannelFluent.this.setToEntries(this.index, this.builder.build());
        }

        public N endEntry() {
            return this.and();
        }
    }

    public class DeprecationNested<N>
    extends DeprecationFluent<DeprecationNested<N>>
    implements Nested<N> {
        DeprecationBuilder builder;

        DeprecationNested(Deprecation item) {
            this.builder = new DeprecationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PackageChannelFluent.this.withDeprecation(this.builder.build());
        }

        public N endDeprecation() {
            return this.and();
        }
    }

    public class CurrentCSVDescNested<N>
    extends CSVDescriptionFluent<CurrentCSVDescNested<N>>
    implements Nested<N> {
        CSVDescriptionBuilder builder;

        CurrentCSVDescNested(CSVDescription item) {
            this.builder = new CSVDescriptionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PackageChannelFluent.this.withCurrentCSVDesc(this.builder.build());
        }

        public N endCurrentCSVDesc() {
            return this.and();
        }
    }
}

