/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.operator.v1.MachineConfigurationStatus;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicyStatus;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicyStatusBuilder;
import io.fabric8.openshift.api.model.operator.v1.NodeDisruptionPolicyStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineConfigurationStatusFluent<A extends MachineConfigurationStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private NodeDisruptionPolicyStatusBuilder nodeDisruptionPolicyStatus;
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public MachineConfigurationStatusFluent() {
    }

    public MachineConfigurationStatusFluent(MachineConfigurationStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineConfigurationStatus instance) {
        MachineConfigurationStatus machineConfigurationStatus = instance = instance != null ? instance : new MachineConfigurationStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withNodeDisruptionPolicyStatus(instance.getNodeDisruptionPolicyStatus());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public NodeDisruptionPolicyStatus buildNodeDisruptionPolicyStatus() {
        return this.nodeDisruptionPolicyStatus != null ? this.nodeDisruptionPolicyStatus.build() : null;
    }

    public A withNodeDisruptionPolicyStatus(NodeDisruptionPolicyStatus nodeDisruptionPolicyStatus) {
        this._visitables.remove("nodeDisruptionPolicyStatus");
        if (nodeDisruptionPolicyStatus != null) {
            this.nodeDisruptionPolicyStatus = new NodeDisruptionPolicyStatusBuilder(nodeDisruptionPolicyStatus);
            this._visitables.get("nodeDisruptionPolicyStatus").add(this.nodeDisruptionPolicyStatus);
        } else {
            this.nodeDisruptionPolicyStatus = null;
            this._visitables.get("nodeDisruptionPolicyStatus").remove(this.nodeDisruptionPolicyStatus);
        }
        return (A)this;
    }

    public boolean hasNodeDisruptionPolicyStatus() {
        return this.nodeDisruptionPolicyStatus != null;
    }

    public NodeDisruptionPolicyStatusNested<A> withNewNodeDisruptionPolicyStatus() {
        return new NodeDisruptionPolicyStatusNested(null);
    }

    public NodeDisruptionPolicyStatusNested<A> withNewNodeDisruptionPolicyStatusLike(NodeDisruptionPolicyStatus item) {
        return new NodeDisruptionPolicyStatusNested(item);
    }

    public NodeDisruptionPolicyStatusNested<A> editNodeDisruptionPolicyStatus() {
        return this.withNewNodeDisruptionPolicyStatusLike(Optional.ofNullable(this.buildNodeDisruptionPolicyStatus()).orElse(null));
    }

    public NodeDisruptionPolicyStatusNested<A> editOrNewNodeDisruptionPolicyStatus() {
        return this.withNewNodeDisruptionPolicyStatusLike(Optional.ofNullable(this.buildNodeDisruptionPolicyStatus()).orElse(new NodeDisruptionPolicyStatusBuilder().build()));
    }

    public NodeDisruptionPolicyStatusNested<A> editOrNewNodeDisruptionPolicyStatusLike(NodeDisruptionPolicyStatus item) {
        return this.withNewNodeDisruptionPolicyStatusLike(Optional.ofNullable(this.buildNodeDisruptionPolicyStatus()).orElse(item));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigurationStatusFluent that = (MachineConfigurationStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.nodeDisruptionPolicyStatus, that.nodeDisruptionPolicyStatus)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.nodeDisruptionPolicyStatus, this.observedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.nodeDisruptionPolicyStatus != null) {
            sb.append("nodeDisruptionPolicyStatus:");
            sb.append(String.valueOf(this.nodeDisruptionPolicyStatus) + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NodeDisruptionPolicyStatusNested<N>
    extends NodeDisruptionPolicyStatusFluent<NodeDisruptionPolicyStatusNested<N>>
    implements Nested<N> {
        NodeDisruptionPolicyStatusBuilder builder;

        NodeDisruptionPolicyStatusNested(NodeDisruptionPolicyStatus item) {
            this.builder = new NodeDisruptionPolicyStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigurationStatusFluent.this.withNodeDisruptionPolicyStatus(this.builder.build());
        }

        public N endNodeDisruptionPolicyStatus() {
            return this.and();
        }
    }
}

