/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.AzureSDConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AzureSDConfigFluent<A extends AzureSDConfigFluent<A>>
extends BaseFluent<A> {
    private String authenticationMethod;
    private String clientID;
    private SecretKeySelector clientSecret;
    private String environment;
    private Integer port;
    private String refreshInterval;
    private String resourceGroup;
    private String subscriptionID;
    private String tenantID;
    private Map<String, Object> additionalProperties;

    public AzureSDConfigFluent() {
    }

    public AzureSDConfigFluent(AzureSDConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AzureSDConfig instance) {
        AzureSDConfig azureSDConfig = instance = instance != null ? instance : new AzureSDConfig();
        if (instance != null) {
            this.withAuthenticationMethod(instance.getAuthenticationMethod());
            this.withClientID(instance.getClientID());
            this.withClientSecret(instance.getClientSecret());
            this.withEnvironment(instance.getEnvironment());
            this.withPort(instance.getPort());
            this.withRefreshInterval(instance.getRefreshInterval());
            this.withResourceGroup(instance.getResourceGroup());
            this.withSubscriptionID(instance.getSubscriptionID());
            this.withTenantID(instance.getTenantID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public A withAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return (A)this;
    }

    public boolean hasAuthenticationMethod() {
        return this.authenticationMethod != null;
    }

    public String getClientID() {
        return this.clientID;
    }

    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)this;
    }

    public boolean hasClientID() {
        return this.clientID != null;
    }

    public SecretKeySelector getClientSecret() {
        return this.clientSecret;
    }

    public A withClientSecret(SecretKeySelector clientSecret) {
        this.clientSecret = clientSecret;
        return (A)this;
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(String key, String name, Boolean optional) {
        return this.withClientSecret(new SecretKeySelector(key, name, optional));
    }

    public String getEnvironment() {
        return this.environment;
    }

    public A withEnvironment(String environment) {
        this.environment = environment;
        return (A)this;
    }

    public boolean hasEnvironment() {
        return this.environment != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public A withRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)this;
    }

    public boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public A withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return (A)this;
    }

    public boolean hasResourceGroup() {
        return this.resourceGroup != null;
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public A withSubscriptionID(String subscriptionID) {
        this.subscriptionID = subscriptionID;
        return (A)this;
    }

    public boolean hasSubscriptionID() {
        return this.subscriptionID != null;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public A withTenantID(String tenantID) {
        this.tenantID = tenantID;
        return (A)this;
    }

    public boolean hasTenantID() {
        return this.tenantID != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureSDConfigFluent that = (AzureSDConfigFluent)o;
        if (!Objects.equals(this.authenticationMethod, that.authenticationMethod)) {
            return false;
        }
        if (!Objects.equals(this.clientID, that.clientID)) {
            return false;
        }
        if (!Objects.equals(this.clientSecret, that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.environment, that.environment)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.refreshInterval, that.refreshInterval)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroup, that.resourceGroup)) {
            return false;
        }
        if (!Objects.equals(this.subscriptionID, that.subscriptionID)) {
            return false;
        }
        if (!Objects.equals(this.tenantID, that.tenantID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authenticationMethod, this.clientID, this.clientSecret, this.environment, this.port, this.refreshInterval, this.resourceGroup, this.subscriptionID, this.tenantID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authenticationMethod != null) {
            sb.append("authenticationMethod:");
            sb.append(this.authenticationMethod + ",");
        }
        if (this.clientID != null) {
            sb.append("clientID:");
            sb.append(this.clientID + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(String.valueOf(this.clientSecret) + ",");
        }
        if (this.environment != null) {
            sb.append("environment:");
            sb.append(this.environment + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.refreshInterval != null) {
            sb.append("refreshInterval:");
            sb.append(this.refreshInterval + ",");
        }
        if (this.resourceGroup != null) {
            sb.append("resourceGroup:");
            sb.append(this.resourceGroup + ",");
        }
        if (this.subscriptionID != null) {
            sb.append("subscriptionID:");
            sb.append(this.subscriptionID + ",");
        }
        if (this.tenantID != null) {
            sb.append("tenantID:");
            sb.append(this.tenantID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

