/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.monitoring.v1.NativeHistogramConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class NativeHistogramConfigFluent<A extends NativeHistogramConfigFluent<A>>
extends BaseFluent<A> {
    private Long nativeHistogramBucketLimit;
    private Quantity nativeHistogramMinBucketFactor;
    private Boolean scrapeClassicHistograms;
    private Map<String, Object> additionalProperties;

    public NativeHistogramConfigFluent() {
    }

    public NativeHistogramConfigFluent(NativeHistogramConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NativeHistogramConfig instance) {
        NativeHistogramConfig nativeHistogramConfig = instance = instance != null ? instance : new NativeHistogramConfig();
        if (instance != null) {
            this.withNativeHistogramBucketLimit(instance.getNativeHistogramBucketLimit());
            this.withNativeHistogramMinBucketFactor(instance.getNativeHistogramMinBucketFactor());
            this.withScrapeClassicHistograms(instance.getScrapeClassicHistograms());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getNativeHistogramBucketLimit() {
        return this.nativeHistogramBucketLimit;
    }

    public A withNativeHistogramBucketLimit(Long nativeHistogramBucketLimit) {
        this.nativeHistogramBucketLimit = nativeHistogramBucketLimit;
        return (A)this;
    }

    public boolean hasNativeHistogramBucketLimit() {
        return this.nativeHistogramBucketLimit != null;
    }

    public Quantity getNativeHistogramMinBucketFactor() {
        return this.nativeHistogramMinBucketFactor;
    }

    public A withNativeHistogramMinBucketFactor(Quantity nativeHistogramMinBucketFactor) {
        this.nativeHistogramMinBucketFactor = nativeHistogramMinBucketFactor;
        return (A)this;
    }

    public boolean hasNativeHistogramMinBucketFactor() {
        return this.nativeHistogramMinBucketFactor != null;
    }

    public A withNewNativeHistogramMinBucketFactor(String amount, String format) {
        return this.withNativeHistogramMinBucketFactor(new Quantity(amount, format));
    }

    public A withNewNativeHistogramMinBucketFactor(String amount) {
        return this.withNativeHistogramMinBucketFactor(new Quantity(amount));
    }

    public Boolean getScrapeClassicHistograms() {
        return this.scrapeClassicHistograms;
    }

    public A withScrapeClassicHistograms(Boolean scrapeClassicHistograms) {
        this.scrapeClassicHistograms = scrapeClassicHistograms;
        return (A)this;
    }

    public boolean hasScrapeClassicHistograms() {
        return this.scrapeClassicHistograms != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NativeHistogramConfigFluent that = (NativeHistogramConfigFluent)o;
        if (!Objects.equals(this.nativeHistogramBucketLimit, that.nativeHistogramBucketLimit)) {
            return false;
        }
        if (!Objects.equals(this.nativeHistogramMinBucketFactor, that.nativeHistogramMinBucketFactor)) {
            return false;
        }
        if (!Objects.equals(this.scrapeClassicHistograms, that.scrapeClassicHistograms)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nativeHistogramBucketLimit, this.nativeHistogramMinBucketFactor, this.scrapeClassicHistograms, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nativeHistogramBucketLimit != null) {
            sb.append("nativeHistogramBucketLimit:");
            sb.append(this.nativeHistogramBucketLimit + ",");
        }
        if (this.nativeHistogramMinBucketFactor != null) {
            sb.append("nativeHistogramMinBucketFactor:");
            sb.append(String.valueOf(this.nativeHistogramMinBucketFactor) + ",");
        }
        if (this.scrapeClassicHistograms != null) {
            sb.append("scrapeClassicHistograms:");
            sb.append(this.scrapeClassicHistograms + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withScrapeClassicHistograms() {
        return this.withScrapeClassicHistograms(true);
    }
}

