/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1.AlibabaResourceReference;
import io.fabric8.openshift.api.model.machine.v1.Tag;
import io.fabric8.openshift.api.model.machine.v1.TagBuilder;
import io.fabric8.openshift.api.model.machine.v1.TagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AlibabaResourceReferenceFluent<A extends AlibabaResourceReferenceFluent<A>>
extends BaseFluent<A> {
    private String id;
    private String name;
    private ArrayList<TagBuilder> tags = new ArrayList();
    private String type;
    private Map<String, Object> additionalProperties;

    public AlibabaResourceReferenceFluent() {
    }

    public AlibabaResourceReferenceFluent(AlibabaResourceReference instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlibabaResourceReference instance) {
        AlibabaResourceReference alibabaResourceReference = instance = instance != null ? instance : new AlibabaResourceReference();
        if (instance != null) {
            this.withId(instance.getId());
            this.withName(instance.getName());
            this.withTags(instance.getTags());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToTags(int index, Tag item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        TagBuilder builder = new TagBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get("tags").add(builder);
            this.tags.add(index, builder);
        }
        return (A)this;
    }

    public A setToTags(int index, Tag item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        TagBuilder builder = new TagBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get("tags").add(builder);
            this.tags.set(index, builder);
        }
        return (A)this;
    }

    public A addToTags(Tag ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (Tag item : items) {
            TagBuilder builder = new TagBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    public A addAllToTags(Collection<Tag> items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (Tag item : items) {
            TagBuilder builder = new TagBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    public A removeFromTags(Tag ... items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (Tag item : items) {
            TagBuilder builder = new TagBuilder(item);
            this._visitables.get("tags").remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTags(Collection<Tag> items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (Tag item : items) {
            TagBuilder builder = new TagBuilder(item);
            this._visitables.get("tags").remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTags(Predicate<TagBuilder> predicate) {
        if (this.tags == null) {
            return (A)this;
        }
        Iterator<TagBuilder> each = this.tags.iterator();
        Object visitables = this._visitables.get("tags");
        while (each.hasNext()) {
            TagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Tag> buildTags() {
        return this.tags != null ? AlibabaResourceReferenceFluent.build(this.tags) : null;
    }

    public Tag buildTag(int index) {
        return this.tags.get(index).build();
    }

    public Tag buildFirstTag() {
        return this.tags.get(0).build();
    }

    public Tag buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    public Tag buildMatchingTag(Predicate<TagBuilder> predicate) {
        for (TagBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<TagBuilder> predicate) {
        for (TagBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<Tag> tags) {
        if (this.tags != null) {
            this._visitables.get("tags").clear();
        }
        if (tags != null) {
            this.tags = new ArrayList();
            for (Tag item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    public A withTags(Tag ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove("tags");
        }
        if (tags != null) {
            for (Tag item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public A addNewTag(String key, String value) {
        return this.addToTags(new Tag(key, value));
    }

    public TagsNested<A> addNewTag() {
        return new TagsNested(-1, null);
    }

    public TagsNested<A> addNewTagLike(Tag item) {
        return new TagsNested(-1, item);
    }

    public TagsNested<A> setNewTagLike(int index, Tag item) {
        return new TagsNested(index, item);
    }

    public TagsNested<A> editTag(int index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException("Can't edit tags. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException("Can't edit first tags. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    public TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tags. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editMatchingTag(Predicate<TagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.test(this.tags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tags. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlibabaResourceReferenceFluent that = (AlibabaResourceReferenceFluent)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.tags, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(String.valueOf(this.tags) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TagsNested<N>
    extends TagFluent<TagsNested<N>>
    implements Nested<N> {
        TagBuilder builder;
        int index;

        TagsNested(int index, Tag item) {
            this.index = index;
            this.builder = new TagBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaResourceReferenceFluent.this.setToTags(this.index, this.builder.build());
        }

        public N endTag() {
            return this.and();
        }
    }
}

