/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismElement;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismEndpoint;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismEndpointBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismEndpointFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PrismElementFluent<A extends PrismElementFluent<A>>
extends BaseFluent<A> {
    private PrismEndpointBuilder endpoint;
    private String name;
    private String uuid;
    private Map<String, Object> additionalProperties;

    public PrismElementFluent() {
    }

    public PrismElementFluent(PrismElement instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PrismElement instance) {
        PrismElement prismElement = instance = instance != null ? instance : new PrismElement();
        if (instance != null) {
            this.withEndpoint(instance.getEndpoint());
            this.withName(instance.getName());
            this.withUuid(instance.getUuid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PrismEndpoint buildEndpoint() {
        return this.endpoint != null ? this.endpoint.build() : null;
    }

    public A withEndpoint(PrismEndpoint endpoint) {
        this._visitables.remove("endpoint");
        if (endpoint != null) {
            this.endpoint = new PrismEndpointBuilder(endpoint);
            this._visitables.get("endpoint").add(this.endpoint);
        } else {
            this.endpoint = null;
            this._visitables.get("endpoint").remove(this.endpoint);
        }
        return (A)this;
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public A withNewEndpoint(String address, Integer port) {
        return this.withEndpoint(new PrismEndpoint(address, port));
    }

    public EndpointNested<A> withNewEndpoint() {
        return new EndpointNested(null);
    }

    public EndpointNested<A> withNewEndpointLike(PrismEndpoint item) {
        return new EndpointNested(item);
    }

    public EndpointNested<A> editEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(null));
    }

    public EndpointNested<A> editOrNewEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(new PrismEndpointBuilder().build()));
    }

    public EndpointNested<A> editOrNewEndpointLike(PrismEndpoint item) {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getUuid() {
        return this.uuid;
    }

    public A withUuid(String uuid) {
        this.uuid = uuid;
        return (A)this;
    }

    public boolean hasUuid() {
        return this.uuid != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrismElementFluent that = (PrismElementFluent)o;
        if (!Objects.equals(this.endpoint, that.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.uuid, that.uuid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.endpoint, this.name, this.uuid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append(String.valueOf(this.endpoint) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.uuid != null) {
            sb.append("uuid:");
            sb.append(this.uuid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EndpointNested<N>
    extends PrismEndpointFluent<EndpointNested<N>>
    implements Nested<N> {
        PrismEndpointBuilder builder;

        EndpointNested(PrismEndpoint item) {
            this.builder = new PrismEndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PrismElementFluent.this.withEndpoint(this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }
}

