/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.nutanix.v1.DataDisk;
import io.fabric8.openshift.api.model.installer.nutanix.v1.DataDiskBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.DataDiskFluent;
import io.fabric8.openshift.api.model.installer.nutanix.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.nutanix.v1.OSDisk;
import io.fabric8.openshift.api.model.installer.nutanix.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.OSDiskFluent;
import io.fabric8.openshift.api.model.machine.v1.NutanixCategory;
import io.fabric8.openshift.api.model.machine.v1.NutanixGPU;
import io.fabric8.openshift.api.model.machine.v1.NutanixResourceIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private String bootType;
    private List<NutanixCategory> categories = new ArrayList<NutanixCategory>();
    private Long coresPerSocket;
    private Long cpus;
    private ArrayList<DataDiskBuilder> dataDisks = new ArrayList();
    private List<String> failureDomains = new ArrayList<String>();
    private List<NutanixGPU> gpus = new ArrayList<NutanixGPU>();
    private Long memoryMiB;
    private OSDiskBuilder osDisk;
    private NutanixResourceIdentifier project;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withBootType(instance.getBootType());
            this.withCategories(instance.getCategories());
            this.withCoresPerSocket(instance.getCoresPerSocket());
            this.withCpus(instance.getCpus());
            this.withDataDisks(instance.getDataDisks());
            this.withFailureDomains(instance.getFailureDomains());
            this.withGpus(instance.getGpus());
            this.withMemoryMiB(instance.getMemoryMiB());
            this.withOsDisk(instance.getOsDisk());
            this.withProject(instance.getProject());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBootType() {
        return this.bootType;
    }

    public A withBootType(String bootType) {
        this.bootType = bootType;
        return (A)this;
    }

    public boolean hasBootType() {
        return this.bootType != null;
    }

    public A addToCategories(int index, NutanixCategory item) {
        if (this.categories == null) {
            this.categories = new ArrayList<NutanixCategory>();
        }
        this.categories.add(index, item);
        return (A)this;
    }

    public A setToCategories(int index, NutanixCategory item) {
        if (this.categories == null) {
            this.categories = new ArrayList<NutanixCategory>();
        }
        this.categories.set(index, item);
        return (A)this;
    }

    public A addToCategories(NutanixCategory ... items) {
        if (this.categories == null) {
            this.categories = new ArrayList<NutanixCategory>();
        }
        for (NutanixCategory item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    public A addAllToCategories(Collection<NutanixCategory> items) {
        if (this.categories == null) {
            this.categories = new ArrayList<NutanixCategory>();
        }
        for (NutanixCategory item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    public A removeFromCategories(NutanixCategory ... items) {
        if (this.categories == null) {
            return (A)this;
        }
        for (NutanixCategory item : items) {
            this.categories.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCategories(Collection<NutanixCategory> items) {
        if (this.categories == null) {
            return (A)this;
        }
        for (NutanixCategory item : items) {
            this.categories.remove(item);
        }
        return (A)this;
    }

    public List<NutanixCategory> getCategories() {
        return this.categories;
    }

    public NutanixCategory getCategory(int index) {
        return this.categories.get(index);
    }

    public NutanixCategory getFirstCategory() {
        return this.categories.get(0);
    }

    public NutanixCategory getLastCategory() {
        return this.categories.get(this.categories.size() - 1);
    }

    public NutanixCategory getMatchingCategory(Predicate<NutanixCategory> predicate) {
        for (NutanixCategory item : this.categories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCategory(Predicate<NutanixCategory> predicate) {
        for (NutanixCategory item : this.categories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCategories(List<NutanixCategory> categories) {
        if (categories != null) {
            this.categories = new ArrayList<NutanixCategory>();
            for (NutanixCategory item : categories) {
                this.addToCategories(item);
            }
        } else {
            this.categories = null;
        }
        return (A)this;
    }

    public A withCategories(NutanixCategory ... categories) {
        if (this.categories != null) {
            this.categories.clear();
            this._visitables.remove("categories");
        }
        if (categories != null) {
            for (NutanixCategory item : categories) {
                this.addToCategories(item);
            }
        }
        return (A)this;
    }

    public boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    public A addNewCategory(String key, String value) {
        return this.addToCategories(new NutanixCategory(key, value));
    }

    public Long getCoresPerSocket() {
        return this.coresPerSocket;
    }

    public A withCoresPerSocket(Long coresPerSocket) {
        this.coresPerSocket = coresPerSocket;
        return (A)this;
    }

    public boolean hasCoresPerSocket() {
        return this.coresPerSocket != null;
    }

    public Long getCpus() {
        return this.cpus;
    }

    public A withCpus(Long cpus) {
        this.cpus = cpus;
        return (A)this;
    }

    public boolean hasCpus() {
        return this.cpus != null;
    }

    public A addToDataDisks(int index, DataDisk item) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        DataDiskBuilder builder = new DataDiskBuilder(item);
        if (index < 0 || index >= this.dataDisks.size()) {
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(builder);
        } else {
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(index, builder);
        }
        return (A)this;
    }

    public A setToDataDisks(int index, DataDisk item) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        DataDiskBuilder builder = new DataDiskBuilder(item);
        if (index < 0 || index >= this.dataDisks.size()) {
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(builder);
        } else {
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.set(index, builder);
        }
        return (A)this;
    }

    public A addToDataDisks(DataDisk ... items) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(builder);
        }
        return (A)this;
    }

    public A addAllToDataDisks(Collection<DataDisk> items) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(builder);
        }
        return (A)this;
    }

    public A removeFromDataDisks(DataDisk ... items) {
        if (this.dataDisks == null) {
            return (A)this;
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get("dataDisks").remove(builder);
            this.dataDisks.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDataDisks(Collection<DataDisk> items) {
        if (this.dataDisks == null) {
            return (A)this;
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get("dataDisks").remove(builder);
            this.dataDisks.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDataDisks(Predicate<DataDiskBuilder> predicate) {
        if (this.dataDisks == null) {
            return (A)this;
        }
        Iterator<DataDiskBuilder> each = this.dataDisks.iterator();
        Object visitables = this._visitables.get("dataDisks");
        while (each.hasNext()) {
            DataDiskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DataDisk> buildDataDisks() {
        return this.dataDisks != null ? MachinePoolFluent.build(this.dataDisks) : null;
    }

    public DataDisk buildDataDisk(int index) {
        return this.dataDisks.get(index).build();
    }

    public DataDisk buildFirstDataDisk() {
        return this.dataDisks.get(0).build();
    }

    public DataDisk buildLastDataDisk() {
        return this.dataDisks.get(this.dataDisks.size() - 1).build();
    }

    public DataDisk buildMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        for (DataDiskBuilder item : this.dataDisks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        for (DataDiskBuilder item : this.dataDisks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDataDisks(List<DataDisk> dataDisks) {
        if (this.dataDisks != null) {
            this._visitables.get("dataDisks").clear();
        }
        if (dataDisks != null) {
            this.dataDisks = new ArrayList();
            for (DataDisk item : dataDisks) {
                this.addToDataDisks(item);
            }
        } else {
            this.dataDisks = null;
        }
        return (A)this;
    }

    public A withDataDisks(DataDisk ... dataDisks) {
        if (this.dataDisks != null) {
            this.dataDisks.clear();
            this._visitables.remove("dataDisks");
        }
        if (dataDisks != null) {
            for (DataDisk item : dataDisks) {
                this.addToDataDisks(item);
            }
        }
        return (A)this;
    }

    public boolean hasDataDisks() {
        return this.dataDisks != null && !this.dataDisks.isEmpty();
    }

    public DataDisksNested<A> addNewDataDisk() {
        return new DataDisksNested(-1, null);
    }

    public DataDisksNested<A> addNewDataDiskLike(DataDisk item) {
        return new DataDisksNested(-1, item);
    }

    public DataDisksNested<A> setNewDataDiskLike(int index, DataDisk item) {
        return new DataDisksNested(index, item);
    }

    public DataDisksNested<A> editDataDisk(int index) {
        if (this.dataDisks.size() <= index) {
            throw new RuntimeException("Can't edit dataDisks. Index exceeds size.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDisksNested<A> editFirstDataDisk() {
        if (this.dataDisks.size() == 0) {
            throw new RuntimeException("Can't edit first dataDisks. The list is empty.");
        }
        return this.setNewDataDiskLike(0, this.buildDataDisk(0));
    }

    public DataDisksNested<A> editLastDataDisk() {
        int index = this.dataDisks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dataDisks. The list is empty.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDisksNested<A> editMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dataDisks.size(); ++i) {
            if (!predicate.test(this.dataDisks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dataDisks. No match found.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public A addToFailureDomains(int index, String item) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList<String>();
        }
        this.failureDomains.add(index, item);
        return (A)this;
    }

    public A setToFailureDomains(int index, String item) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList<String>();
        }
        this.failureDomains.set(index, item);
        return (A)this;
    }

    public A addToFailureDomains(String ... items) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList<String>();
        }
        for (String item : items) {
            this.failureDomains.add(item);
        }
        return (A)this;
    }

    public A addAllToFailureDomains(Collection<String> items) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList<String>();
        }
        for (String item : items) {
            this.failureDomains.add(item);
        }
        return (A)this;
    }

    public A removeFromFailureDomains(String ... items) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        for (String item : items) {
            this.failureDomains.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromFailureDomains(Collection<String> items) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        for (String item : items) {
            this.failureDomains.remove(item);
        }
        return (A)this;
    }

    public List<String> getFailureDomains() {
        return this.failureDomains;
    }

    public String getFailureDomain(int index) {
        return this.failureDomains.get(index);
    }

    public String getFirstFailureDomain() {
        return this.failureDomains.get(0);
    }

    public String getLastFailureDomain() {
        return this.failureDomains.get(this.failureDomains.size() - 1);
    }

    public String getMatchingFailureDomain(Predicate<String> predicate) {
        for (String item : this.failureDomains) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFailureDomain(Predicate<String> predicate) {
        for (String item : this.failureDomains) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFailureDomains(List<String> failureDomains) {
        if (failureDomains != null) {
            this.failureDomains = new ArrayList<String>();
            for (String item : failureDomains) {
                this.addToFailureDomains(item);
            }
        } else {
            this.failureDomains = null;
        }
        return (A)this;
    }

    public A withFailureDomains(String ... failureDomains) {
        if (this.failureDomains != null) {
            this.failureDomains.clear();
            this._visitables.remove("failureDomains");
        }
        if (failureDomains != null) {
            for (String item : failureDomains) {
                this.addToFailureDomains(item);
            }
        }
        return (A)this;
    }

    public boolean hasFailureDomains() {
        return this.failureDomains != null && !this.failureDomains.isEmpty();
    }

    public A addToGpus(int index, NutanixGPU item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList<NutanixGPU>();
        }
        this.gpus.add(index, item);
        return (A)this;
    }

    public A setToGpus(int index, NutanixGPU item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList<NutanixGPU>();
        }
        this.gpus.set(index, item);
        return (A)this;
    }

    public A addToGpus(NutanixGPU ... items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList<NutanixGPU>();
        }
        for (NutanixGPU item : items) {
            this.gpus.add(item);
        }
        return (A)this;
    }

    public A addAllToGpus(Collection<NutanixGPU> items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList<NutanixGPU>();
        }
        for (NutanixGPU item : items) {
            this.gpus.add(item);
        }
        return (A)this;
    }

    public A removeFromGpus(NutanixGPU ... items) {
        if (this.gpus == null) {
            return (A)this;
        }
        for (NutanixGPU item : items) {
            this.gpus.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromGpus(Collection<NutanixGPU> items) {
        if (this.gpus == null) {
            return (A)this;
        }
        for (NutanixGPU item : items) {
            this.gpus.remove(item);
        }
        return (A)this;
    }

    public List<NutanixGPU> getGpus() {
        return this.gpus;
    }

    public NutanixGPU getGpus(int index) {
        return this.gpus.get(index);
    }

    public NutanixGPU getFirstGpus() {
        return this.gpus.get(0);
    }

    public NutanixGPU getLastGpus() {
        return this.gpus.get(this.gpus.size() - 1);
    }

    public NutanixGPU getMatchingGpus(Predicate<NutanixGPU> predicate) {
        for (NutanixGPU item : this.gpus) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGpus(Predicate<NutanixGPU> predicate) {
        for (NutanixGPU item : this.gpus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGpus(List<NutanixGPU> gpus) {
        if (gpus != null) {
            this.gpus = new ArrayList<NutanixGPU>();
            for (NutanixGPU item : gpus) {
                this.addToGpus(item);
            }
        } else {
            this.gpus = null;
        }
        return (A)this;
    }

    public A withGpus(NutanixGPU ... gpus) {
        if (this.gpus != null) {
            this.gpus.clear();
            this._visitables.remove("gpus");
        }
        if (gpus != null) {
            for (NutanixGPU item : gpus) {
                this.addToGpus(item);
            }
        }
        return (A)this;
    }

    public boolean hasGpus() {
        return this.gpus != null && !this.gpus.isEmpty();
    }

    public A addNewGpus(Integer deviceID, String name, String type) {
        return this.addToGpus(new NutanixGPU(deviceID, name, type));
    }

    public Long getMemoryMiB() {
        return this.memoryMiB;
    }

    public A withMemoryMiB(Long memoryMiB) {
        this.memoryMiB = memoryMiB;
        return (A)this;
    }

    public boolean hasMemoryMiB() {
        return this.memoryMiB != null;
    }

    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    public A withOsDisk(OSDisk osDisk) {
        this._visitables.remove("osDisk");
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get("osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get("osDisk").remove(this.osDisk);
        }
        return (A)this;
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public A withNewOsDisk(Long diskSizeGiB) {
        return this.withOsDisk(new OSDisk(diskSizeGiB));
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNested(item);
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new OSDiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public NutanixResourceIdentifier getProject() {
        return this.project;
    }

    public A withProject(NutanixResourceIdentifier project) {
        this.project = project;
        return (A)this;
    }

    public boolean hasProject() {
        return this.project != null;
    }

    public A withNewProject(String name, String type, String uuid) {
        return this.withProject(new NutanixResourceIdentifier(name, type, uuid));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.bootType, that.bootType)) {
            return false;
        }
        if (!Objects.equals(this.categories, that.categories)) {
            return false;
        }
        if (!Objects.equals(this.coresPerSocket, that.coresPerSocket)) {
            return false;
        }
        if (!Objects.equals(this.cpus, that.cpus)) {
            return false;
        }
        if (!Objects.equals(this.dataDisks, that.dataDisks)) {
            return false;
        }
        if (!Objects.equals(this.failureDomains, that.failureDomains)) {
            return false;
        }
        if (!Objects.equals(this.gpus, that.gpus)) {
            return false;
        }
        if (!Objects.equals(this.memoryMiB, that.memoryMiB)) {
            return false;
        }
        if (!Objects.equals(this.osDisk, that.osDisk)) {
            return false;
        }
        if (!Objects.equals(this.project, that.project)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bootType, this.categories, this.coresPerSocket, this.cpus, this.dataDisks, this.failureDomains, this.gpus, this.memoryMiB, this.osDisk, this.project, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootType != null) {
            sb.append("bootType:");
            sb.append(this.bootType + ",");
        }
        if (this.categories != null && !this.categories.isEmpty()) {
            sb.append("categories:");
            sb.append(String.valueOf(this.categories) + ",");
        }
        if (this.coresPerSocket != null) {
            sb.append("coresPerSocket:");
            sb.append(this.coresPerSocket + ",");
        }
        if (this.cpus != null) {
            sb.append("cpus:");
            sb.append(this.cpus + ",");
        }
        if (this.dataDisks != null && !this.dataDisks.isEmpty()) {
            sb.append("dataDisks:");
            sb.append(String.valueOf(this.dataDisks) + ",");
        }
        if (this.failureDomains != null && !this.failureDomains.isEmpty()) {
            sb.append("failureDomains:");
            sb.append(String.valueOf(this.failureDomains) + ",");
        }
        if (this.gpus != null && !this.gpus.isEmpty()) {
            sb.append("gpus:");
            sb.append(String.valueOf(this.gpus) + ",");
        }
        if (this.memoryMiB != null) {
            sb.append("memoryMiB:");
            sb.append(this.memoryMiB + ",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(String.valueOf(this.osDisk) + ",");
        }
        if (this.project != null) {
            sb.append("project:");
            sb.append(String.valueOf(this.project) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OsDiskNested<N>
    extends OSDiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        OSDiskBuilder builder;

        OsDiskNested(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }

    public class DataDisksNested<N>
    extends DataDiskFluent<DataDisksNested<N>>
    implements Nested<N> {
        DataDiskBuilder builder;
        int index;

        DataDisksNested(int index, DataDisk item) {
            this.index = index;
            this.builder = new DataDiskBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.setToDataDisks(this.index, this.builder.build());
        }

        public N endDataDisk() {
            return this.and();
        }
    }
}

