/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMapping;
import io.fabric8.openshift.api.model.config.v1.UsernamePrefix;
import io.fabric8.openshift.api.model.config.v1.UsernamePrefixBuilder;
import io.fabric8.openshift.api.model.config.v1.UsernamePrefixFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class UsernameClaimMappingFluent<A extends UsernameClaimMappingFluent<A>>
extends BaseFluent<A> {
    private String claim;
    private UsernamePrefixBuilder prefix;
    private String prefixPolicy;
    private Map<String, Object> additionalProperties;

    public UsernameClaimMappingFluent() {
    }

    public UsernameClaimMappingFluent(UsernameClaimMapping instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(UsernameClaimMapping instance) {
        UsernameClaimMapping usernameClaimMapping = instance = instance != null ? instance : new UsernameClaimMapping();
        if (instance != null) {
            this.withClaim(instance.getClaim());
            this.withPrefix(instance.getPrefix());
            this.withPrefixPolicy(instance.getPrefixPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClaim() {
        return this.claim;
    }

    public A withClaim(String claim) {
        this.claim = claim;
        return (A)this;
    }

    public boolean hasClaim() {
        return this.claim != null;
    }

    public UsernamePrefix buildPrefix() {
        return this.prefix != null ? this.prefix.build() : null;
    }

    public A withPrefix(UsernamePrefix prefix) {
        this._visitables.remove("prefix");
        if (prefix != null) {
            this.prefix = new UsernamePrefixBuilder(prefix);
            this._visitables.get("prefix").add(this.prefix);
        } else {
            this.prefix = null;
            this._visitables.get("prefix").remove(this.prefix);
        }
        return (A)this;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public A withNewPrefix(String prefixString) {
        return this.withPrefix(new UsernamePrefix(prefixString));
    }

    public PrefixNested<A> withNewPrefix() {
        return new PrefixNested(null);
    }

    public PrefixNested<A> withNewPrefixLike(UsernamePrefix item) {
        return new PrefixNested(item);
    }

    public PrefixNested<A> editPrefix() {
        return this.withNewPrefixLike(Optional.ofNullable(this.buildPrefix()).orElse(null));
    }

    public PrefixNested<A> editOrNewPrefix() {
        return this.withNewPrefixLike(Optional.ofNullable(this.buildPrefix()).orElse(new UsernamePrefixBuilder().build()));
    }

    public PrefixNested<A> editOrNewPrefixLike(UsernamePrefix item) {
        return this.withNewPrefixLike(Optional.ofNullable(this.buildPrefix()).orElse(item));
    }

    public String getPrefixPolicy() {
        return this.prefixPolicy;
    }

    public A withPrefixPolicy(String prefixPolicy) {
        this.prefixPolicy = prefixPolicy;
        return (A)this;
    }

    public boolean hasPrefixPolicy() {
        return this.prefixPolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UsernameClaimMappingFluent that = (UsernameClaimMappingFluent)o;
        if (!Objects.equals(this.claim, that.claim)) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        if (!Objects.equals(this.prefixPolicy, that.prefixPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.claim, this.prefix, this.prefixPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claim != null) {
            sb.append("claim:");
            sb.append(this.claim + ",");
        }
        if (this.prefix != null) {
            sb.append("prefix:");
            sb.append(String.valueOf(this.prefix) + ",");
        }
        if (this.prefixPolicy != null) {
            sb.append("prefixPolicy:");
            sb.append(this.prefixPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PrefixNested<N>
    extends UsernamePrefixFluent<PrefixNested<N>>
    implements Nested<N> {
        UsernamePrefixBuilder builder;

        PrefixNested(UsernamePrefix item) {
            this.builder = new UsernamePrefixBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)UsernameClaimMappingFluent.this.withPrefix(this.builder.build());
        }

        public N endPrefix() {
            return this.and();
        }
    }
}

