/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.config.v1.MaxAgePolicy;
import io.fabric8.openshift.api.model.config.v1.MaxAgePolicyBuilder;
import io.fabric8.openshift.api.model.config.v1.MaxAgePolicyFluent;
import io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RequiredHSTSPolicyFluent<A extends RequiredHSTSPolicyFluent<A>>
extends BaseFluent<A> {
    private List<String> domainPatterns = new ArrayList<String>();
    private String includeSubDomainsPolicy;
    private MaxAgePolicyBuilder maxAge;
    private LabelSelectorBuilder namespaceSelector;
    private String preloadPolicy;
    private Map<String, Object> additionalProperties;

    public RequiredHSTSPolicyFluent() {
    }

    public RequiredHSTSPolicyFluent(RequiredHSTSPolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RequiredHSTSPolicy instance) {
        RequiredHSTSPolicy requiredHSTSPolicy = instance = instance != null ? instance : new RequiredHSTSPolicy();
        if (instance != null) {
            this.withDomainPatterns(instance.getDomainPatterns());
            this.withIncludeSubDomainsPolicy(instance.getIncludeSubDomainsPolicy());
            this.withMaxAge(instance.getMaxAge());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withPreloadPolicy(instance.getPreloadPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDomainPatterns(int index, String item) {
        if (this.domainPatterns == null) {
            this.domainPatterns = new ArrayList<String>();
        }
        this.domainPatterns.add(index, item);
        return (A)this;
    }

    public A setToDomainPatterns(int index, String item) {
        if (this.domainPatterns == null) {
            this.domainPatterns = new ArrayList<String>();
        }
        this.domainPatterns.set(index, item);
        return (A)this;
    }

    public A addToDomainPatterns(String ... items) {
        if (this.domainPatterns == null) {
            this.domainPatterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.domainPatterns.add(item);
        }
        return (A)this;
    }

    public A addAllToDomainPatterns(Collection<String> items) {
        if (this.domainPatterns == null) {
            this.domainPatterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.domainPatterns.add(item);
        }
        return (A)this;
    }

    public A removeFromDomainPatterns(String ... items) {
        if (this.domainPatterns == null) {
            return (A)this;
        }
        for (String item : items) {
            this.domainPatterns.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDomainPatterns(Collection<String> items) {
        if (this.domainPatterns == null) {
            return (A)this;
        }
        for (String item : items) {
            this.domainPatterns.remove(item);
        }
        return (A)this;
    }

    public List<String> getDomainPatterns() {
        return this.domainPatterns;
    }

    public String getDomainPattern(int index) {
        return this.domainPatterns.get(index);
    }

    public String getFirstDomainPattern() {
        return this.domainPatterns.get(0);
    }

    public String getLastDomainPattern() {
        return this.domainPatterns.get(this.domainPatterns.size() - 1);
    }

    public String getMatchingDomainPattern(Predicate<String> predicate) {
        for (String item : this.domainPatterns) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDomainPattern(Predicate<String> predicate) {
        for (String item : this.domainPatterns) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDomainPatterns(List<String> domainPatterns) {
        if (domainPatterns != null) {
            this.domainPatterns = new ArrayList<String>();
            for (String item : domainPatterns) {
                this.addToDomainPatterns(item);
            }
        } else {
            this.domainPatterns = null;
        }
        return (A)this;
    }

    public A withDomainPatterns(String ... domainPatterns) {
        if (this.domainPatterns != null) {
            this.domainPatterns.clear();
            this._visitables.remove("domainPatterns");
        }
        if (domainPatterns != null) {
            for (String item : domainPatterns) {
                this.addToDomainPatterns(item);
            }
        }
        return (A)this;
    }

    public boolean hasDomainPatterns() {
        return this.domainPatterns != null && !this.domainPatterns.isEmpty();
    }

    public String getIncludeSubDomainsPolicy() {
        return this.includeSubDomainsPolicy;
    }

    public A withIncludeSubDomainsPolicy(String includeSubDomainsPolicy) {
        this.includeSubDomainsPolicy = includeSubDomainsPolicy;
        return (A)this;
    }

    public boolean hasIncludeSubDomainsPolicy() {
        return this.includeSubDomainsPolicy != null;
    }

    public MaxAgePolicy buildMaxAge() {
        return this.maxAge != null ? this.maxAge.build() : null;
    }

    public A withMaxAge(MaxAgePolicy maxAge) {
        this._visitables.remove("maxAge");
        if (maxAge != null) {
            this.maxAge = new MaxAgePolicyBuilder(maxAge);
            this._visitables.get("maxAge").add(this.maxAge);
        } else {
            this.maxAge = null;
            this._visitables.get("maxAge").remove(this.maxAge);
        }
        return (A)this;
    }

    public boolean hasMaxAge() {
        return this.maxAge != null;
    }

    public A withNewMaxAge(Integer largestMaxAge, Integer smallestMaxAge) {
        return this.withMaxAge(new MaxAgePolicy(largestMaxAge, smallestMaxAge));
    }

    public MaxAgeNested<A> withNewMaxAge() {
        return new MaxAgeNested(null);
    }

    public MaxAgeNested<A> withNewMaxAgeLike(MaxAgePolicy item) {
        return new MaxAgeNested(item);
    }

    public MaxAgeNested<A> editMaxAge() {
        return this.withNewMaxAgeLike(Optional.ofNullable(this.buildMaxAge()).orElse(null));
    }

    public MaxAgeNested<A> editOrNewMaxAge() {
        return this.withNewMaxAgeLike(Optional.ofNullable(this.buildMaxAge()).orElse(new MaxAgePolicyBuilder().build()));
    }

    public MaxAgeNested<A> editOrNewMaxAgeLike(MaxAgePolicy item) {
        return this.withNewMaxAgeLike(Optional.ofNullable(this.buildMaxAge()).orElse(item));
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove("namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public String getPreloadPolicy() {
        return this.preloadPolicy;
    }

    public A withPreloadPolicy(String preloadPolicy) {
        this.preloadPolicy = preloadPolicy;
        return (A)this;
    }

    public boolean hasPreloadPolicy() {
        return this.preloadPolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequiredHSTSPolicyFluent that = (RequiredHSTSPolicyFluent)o;
        if (!Objects.equals(this.domainPatterns, that.domainPatterns)) {
            return false;
        }
        if (!Objects.equals(this.includeSubDomainsPolicy, that.includeSubDomainsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.maxAge, that.maxAge)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.preloadPolicy, that.preloadPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.domainPatterns, this.includeSubDomainsPolicy, this.maxAge, this.namespaceSelector, this.preloadPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainPatterns != null && !this.domainPatterns.isEmpty()) {
            sb.append("domainPatterns:");
            sb.append(String.valueOf(this.domainPatterns) + ",");
        }
        if (this.includeSubDomainsPolicy != null) {
            sb.append("includeSubDomainsPolicy:");
            sb.append(this.includeSubDomainsPolicy + ",");
        }
        if (this.maxAge != null) {
            sb.append("maxAge:");
            sb.append(String.valueOf(this.maxAge) + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(String.valueOf(this.namespaceSelector) + ",");
        }
        if (this.preloadPolicy != null) {
            sb.append("preloadPolicy:");
            sb.append(this.preloadPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RequiredHSTSPolicyFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class MaxAgeNested<N>
    extends MaxAgePolicyFluent<MaxAgeNested<N>>
    implements Nested<N> {
        MaxAgePolicyBuilder builder;

        MaxAgeNested(MaxAgePolicy item) {
            this.builder = new MaxAgePolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RequiredHSTSPolicyFluent.this.withMaxAge(this.builder.build());
        }

        public N endMaxAge() {
            return this.and();
        }
    }
}

