/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.Audit;
import io.fabric8.openshift.api.model.config.v1.AuditCustomRule;
import io.fabric8.openshift.api.model.config.v1.AuditCustomRuleBuilder;
import io.fabric8.openshift.api.model.config.v1.AuditCustomRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AuditFluent<A extends AuditFluent<A>>
extends BaseFluent<A> {
    private ArrayList<AuditCustomRuleBuilder> customRules = new ArrayList();
    private String profile;
    private Map<String, Object> additionalProperties;

    public AuditFluent() {
    }

    public AuditFluent(Audit instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Audit instance) {
        Audit audit = instance = instance != null ? instance : new Audit();
        if (instance != null) {
            this.withCustomRules(instance.getCustomRules());
            this.withProfile(instance.getProfile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCustomRules(int index, AuditCustomRule item) {
        if (this.customRules == null) {
            this.customRules = new ArrayList();
        }
        AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
        if (index < 0 || index >= this.customRules.size()) {
            this._visitables.get("customRules").add(builder);
            this.customRules.add(builder);
        } else {
            this._visitables.get("customRules").add(builder);
            this.customRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToCustomRules(int index, AuditCustomRule item) {
        if (this.customRules == null) {
            this.customRules = new ArrayList();
        }
        AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
        if (index < 0 || index >= this.customRules.size()) {
            this._visitables.get("customRules").add(builder);
            this.customRules.add(builder);
        } else {
            this._visitables.get("customRules").add(builder);
            this.customRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToCustomRules(AuditCustomRule ... items) {
        if (this.customRules == null) {
            this.customRules = new ArrayList();
        }
        for (AuditCustomRule item : items) {
            AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
            this._visitables.get("customRules").add(builder);
            this.customRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToCustomRules(Collection<AuditCustomRule> items) {
        if (this.customRules == null) {
            this.customRules = new ArrayList();
        }
        for (AuditCustomRule item : items) {
            AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
            this._visitables.get("customRules").add(builder);
            this.customRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromCustomRules(AuditCustomRule ... items) {
        if (this.customRules == null) {
            return (A)this;
        }
        for (AuditCustomRule item : items) {
            AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
            this._visitables.get("customRules").remove(builder);
            this.customRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromCustomRules(Collection<AuditCustomRule> items) {
        if (this.customRules == null) {
            return (A)this;
        }
        for (AuditCustomRule item : items) {
            AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
            this._visitables.get("customRules").remove(builder);
            this.customRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromCustomRules(Predicate<AuditCustomRuleBuilder> predicate) {
        if (this.customRules == null) {
            return (A)this;
        }
        Iterator<AuditCustomRuleBuilder> each = this.customRules.iterator();
        Object visitables = this._visitables.get("customRules");
        while (each.hasNext()) {
            AuditCustomRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AuditCustomRule> buildCustomRules() {
        return this.customRules != null ? AuditFluent.build(this.customRules) : null;
    }

    public AuditCustomRule buildCustomRule(int index) {
        return this.customRules.get(index).build();
    }

    public AuditCustomRule buildFirstCustomRule() {
        return this.customRules.get(0).build();
    }

    public AuditCustomRule buildLastCustomRule() {
        return this.customRules.get(this.customRules.size() - 1).build();
    }

    public AuditCustomRule buildMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
        for (AuditCustomRuleBuilder item : this.customRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
        for (AuditCustomRuleBuilder item : this.customRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCustomRules(List<AuditCustomRule> customRules) {
        if (this.customRules != null) {
            this._visitables.get("customRules").clear();
        }
        if (customRules != null) {
            this.customRules = new ArrayList();
            for (AuditCustomRule item : customRules) {
                this.addToCustomRules(item);
            }
        } else {
            this.customRules = null;
        }
        return (A)this;
    }

    public A withCustomRules(AuditCustomRule ... customRules) {
        if (this.customRules != null) {
            this.customRules.clear();
            this._visitables.remove("customRules");
        }
        if (customRules != null) {
            for (AuditCustomRule item : customRules) {
                this.addToCustomRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasCustomRules() {
        return this.customRules != null && !this.customRules.isEmpty();
    }

    public A addNewCustomRule(String group, String profile) {
        return this.addToCustomRules(new AuditCustomRule(group, profile));
    }

    public CustomRulesNested<A> addNewCustomRule() {
        return new CustomRulesNested(-1, null);
    }

    public CustomRulesNested<A> addNewCustomRuleLike(AuditCustomRule item) {
        return new CustomRulesNested(-1, item);
    }

    public CustomRulesNested<A> setNewCustomRuleLike(int index, AuditCustomRule item) {
        return new CustomRulesNested(index, item);
    }

    public CustomRulesNested<A> editCustomRule(int index) {
        if (this.customRules.size() <= index) {
            throw new RuntimeException("Can't edit customRules. Index exceeds size.");
        }
        return this.setNewCustomRuleLike(index, this.buildCustomRule(index));
    }

    public CustomRulesNested<A> editFirstCustomRule() {
        if (this.customRules.size() == 0) {
            throw new RuntimeException("Can't edit first customRules. The list is empty.");
        }
        return this.setNewCustomRuleLike(0, this.buildCustomRule(0));
    }

    public CustomRulesNested<A> editLastCustomRule() {
        int index = this.customRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last customRules. The list is empty.");
        }
        return this.setNewCustomRuleLike(index, this.buildCustomRule(index));
    }

    public CustomRulesNested<A> editMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.customRules.size(); ++i) {
            if (!predicate.test(this.customRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching customRules. No match found.");
        }
        return this.setNewCustomRuleLike(index, this.buildCustomRule(index));
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuditFluent that = (AuditFluent)o;
        if (!Objects.equals(this.customRules, that.customRules)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.customRules, this.profile, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.customRules != null && !this.customRules.isEmpty()) {
            sb.append("customRules:");
            sb.append(String.valueOf(this.customRules) + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CustomRulesNested<N>
    extends AuditCustomRuleFluent<CustomRulesNested<N>>
    implements Nested<N> {
        AuditCustomRuleBuilder builder;
        int index;

        CustomRulesNested(int index, AuditCustomRule item) {
            this.index = index;
            this.builder = new AuditCustomRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuditFluent.this.setToCustomRules(this.index, this.builder.build());
        }

        public N endCustomRule() {
            return this.and();
        }
    }
}

