/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.LocalObjectReference;
import io.fabric8.openshift.api.model.LocalObjectReferenceBuilder;
import io.fabric8.openshift.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.TLSConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TLSConfigFluent<A extends TLSConfigFluent<A>>
extends BaseFluent<A> {
    private String caCertificate;
    private String certificate;
    private String destinationCACertificate;
    private LocalObjectReferenceBuilder externalCertificate;
    private String insecureEdgeTerminationPolicy;
    private String key;
    private String termination;
    private Map<String, Object> additionalProperties;

    public TLSConfigFluent() {
    }

    public TLSConfigFluent(TLSConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TLSConfig instance) {
        TLSConfig tLSConfig = instance = instance != null ? instance : new TLSConfig();
        if (instance != null) {
            this.withCaCertificate(instance.getCaCertificate());
            this.withCertificate(instance.getCertificate());
            this.withDestinationCACertificate(instance.getDestinationCACertificate());
            this.withExternalCertificate(instance.getExternalCertificate());
            this.withInsecureEdgeTerminationPolicy(instance.getInsecureEdgeTerminationPolicy());
            this.withKey(instance.getKey());
            this.withTermination(instance.getTermination());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public A withCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
        return (A)this;
    }

    public boolean hasCaCertificate() {
        return this.caCertificate != null;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public A withCertificate(String certificate) {
        this.certificate = certificate;
        return (A)this;
    }

    public boolean hasCertificate() {
        return this.certificate != null;
    }

    public String getDestinationCACertificate() {
        return this.destinationCACertificate;
    }

    public A withDestinationCACertificate(String destinationCACertificate) {
        this.destinationCACertificate = destinationCACertificate;
        return (A)this;
    }

    public boolean hasDestinationCACertificate() {
        return this.destinationCACertificate != null;
    }

    public LocalObjectReference buildExternalCertificate() {
        return this.externalCertificate != null ? this.externalCertificate.build() : null;
    }

    public A withExternalCertificate(LocalObjectReference externalCertificate) {
        this._visitables.remove("externalCertificate");
        if (externalCertificate != null) {
            this.externalCertificate = new LocalObjectReferenceBuilder(externalCertificate);
            this._visitables.get("externalCertificate").add(this.externalCertificate);
        } else {
            this.externalCertificate = null;
            this._visitables.get("externalCertificate").remove(this.externalCertificate);
        }
        return (A)this;
    }

    public boolean hasExternalCertificate() {
        return this.externalCertificate != null;
    }

    public A withNewExternalCertificate(String name) {
        return this.withExternalCertificate(new LocalObjectReference(name));
    }

    public ExternalCertificateNested<A> withNewExternalCertificate() {
        return new ExternalCertificateNested(null);
    }

    public ExternalCertificateNested<A> withNewExternalCertificateLike(LocalObjectReference item) {
        return new ExternalCertificateNested(item);
    }

    public ExternalCertificateNested<A> editExternalCertificate() {
        return this.withNewExternalCertificateLike(Optional.ofNullable(this.buildExternalCertificate()).orElse(null));
    }

    public ExternalCertificateNested<A> editOrNewExternalCertificate() {
        return this.withNewExternalCertificateLike(Optional.ofNullable(this.buildExternalCertificate()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ExternalCertificateNested<A> editOrNewExternalCertificateLike(LocalObjectReference item) {
        return this.withNewExternalCertificateLike(Optional.ofNullable(this.buildExternalCertificate()).orElse(item));
    }

    public String getInsecureEdgeTerminationPolicy() {
        return this.insecureEdgeTerminationPolicy;
    }

    public A withInsecureEdgeTerminationPolicy(String insecureEdgeTerminationPolicy) {
        this.insecureEdgeTerminationPolicy = insecureEdgeTerminationPolicy;
        return (A)this;
    }

    public boolean hasInsecureEdgeTerminationPolicy() {
        return this.insecureEdgeTerminationPolicy != null;
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key = key;
        return (A)this;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public String getTermination() {
        return this.termination;
    }

    public A withTermination(String termination) {
        this.termination = termination;
        return (A)this;
    }

    public boolean hasTermination() {
        return this.termination != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSConfigFluent that = (TLSConfigFluent)o;
        if (!Objects.equals(this.caCertificate, that.caCertificate)) {
            return false;
        }
        if (!Objects.equals(this.certificate, that.certificate)) {
            return false;
        }
        if (!Objects.equals(this.destinationCACertificate, that.destinationCACertificate)) {
            return false;
        }
        if (!Objects.equals(this.externalCertificate, that.externalCertificate)) {
            return false;
        }
        if (!Objects.equals(this.insecureEdgeTerminationPolicy, that.insecureEdgeTerminationPolicy)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.termination, that.termination)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.caCertificate, this.certificate, this.destinationCACertificate, this.externalCertificate, this.insecureEdgeTerminationPolicy, this.key, this.termination, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caCertificate != null) {
            sb.append("caCertificate:");
            sb.append(this.caCertificate + ",");
        }
        if (this.certificate != null) {
            sb.append("certificate:");
            sb.append(this.certificate + ",");
        }
        if (this.destinationCACertificate != null) {
            sb.append("destinationCACertificate:");
            sb.append(this.destinationCACertificate + ",");
        }
        if (this.externalCertificate != null) {
            sb.append("externalCertificate:");
            sb.append(String.valueOf(this.externalCertificate) + ",");
        }
        if (this.insecureEdgeTerminationPolicy != null) {
            sb.append("insecureEdgeTerminationPolicy:");
            sb.append(this.insecureEdgeTerminationPolicy + ",");
        }
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.termination != null) {
            sb.append("termination:");
            sb.append(this.termination + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ExternalCertificateNested<N>
    extends LocalObjectReferenceFluent<ExternalCertificateNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ExternalCertificateNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TLSConfigFluent.this.withExternalCertificate(this.builder.build());
        }

        public N endExternalCertificate() {
            return this.and();
        }
    }
}

