/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointConditions;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHints;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"addresses", "conditions", "hints", "hostname", "nodeName", "targetRef", "topology"})
public class Endpoint
implements Editable<EndpointBuilder>,
KubernetesResource {
    @JsonProperty(value="addresses")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> addresses = new ArrayList<String>();
    @JsonProperty(value="conditions")
    private EndpointConditions conditions;
    @JsonProperty(value="hints")
    private EndpointHints hints;
    @JsonProperty(value="hostname")
    private String hostname;
    @JsonProperty(value="nodeName")
    private String nodeName;
    @JsonProperty(value="targetRef")
    private ObjectReference targetRef;
    @JsonProperty(value="topology")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> topology = new LinkedHashMap<String, String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public Endpoint() {
    }

    public Endpoint(List<String> addresses, EndpointConditions conditions, EndpointHints hints, String hostname, String nodeName, ObjectReference targetRef, Map<String, String> topology) {
        this.addresses = addresses;
        this.conditions = conditions;
        this.hints = hints;
        this.hostname = hostname;
        this.nodeName = nodeName;
        this.targetRef = targetRef;
        this.topology = topology;
    }

    @JsonProperty(value="addresses")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="addresses")
    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    @JsonProperty(value="conditions")
    public EndpointConditions getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    public void setConditions(EndpointConditions conditions) {
        this.conditions = conditions;
    }

    @JsonProperty(value="hints")
    public EndpointHints getHints() {
        return this.hints;
    }

    @JsonProperty(value="hints")
    public void setHints(EndpointHints hints) {
        this.hints = hints;
    }

    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="hostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @JsonProperty(value="nodeName")
    public String getNodeName() {
        return this.nodeName;
    }

    @JsonProperty(value="nodeName")
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @JsonProperty(value="targetRef")
    public ObjectReference getTargetRef() {
        return this.targetRef;
    }

    @JsonProperty(value="targetRef")
    public void setTargetRef(ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    @JsonProperty(value="topology")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getTopology() {
        return this.topology;
    }

    @JsonProperty(value="topology")
    public void setTopology(Map<String, String> topology) {
        this.topology = topology;
    }

    @Override
    @JsonIgnore
    public EndpointBuilder edit() {
        return new EndpointBuilder(this);
    }

    @JsonIgnore
    public EndpointBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "Endpoint(addresses=" + String.valueOf(this.getAddresses()) + ", conditions=" + String.valueOf(this.getConditions()) + ", hints=" + String.valueOf(this.getHints()) + ", hostname=" + this.getHostname() + ", nodeName=" + this.getNodeName() + ", targetRef=" + String.valueOf(this.getTargetRef()) + ", topology=" + String.valueOf(this.getTopology()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$addresses = this.getAddresses();
        List<String> other$addresses = other.getAddresses();
        if (this$addresses == null ? other$addresses != null : !((Object)this$addresses).equals(other$addresses)) {
            return false;
        }
        EndpointConditions this$conditions = this.getConditions();
        EndpointConditions other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        EndpointHints this$hints = this.getHints();
        EndpointHints other$hints = other.getHints();
        if (this$hints == null ? other$hints != null : !((Object)this$hints).equals(other$hints)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$nodeName = this.getNodeName();
        String other$nodeName = other.getNodeName();
        if (this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName)) {
            return false;
        }
        ObjectReference this$targetRef = this.getTargetRef();
        ObjectReference other$targetRef = other.getTargetRef();
        if (this$targetRef == null ? other$targetRef != null : !((Object)this$targetRef).equals(other$targetRef)) {
            return false;
        }
        Map<String, String> this$topology = this.getTopology();
        Map<String, String> other$topology = other.getTopology();
        if (this$topology == null ? other$topology != null : !((Object)this$topology).equals(other$topology)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Endpoint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $addresses = this.getAddresses();
        result = result * 59 + ($addresses == null ? 43 : ((Object)$addresses).hashCode());
        EndpointConditions $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        EndpointHints $hints = this.getHints();
        result = result * 59 + ($hints == null ? 43 : ((Object)$hints).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $nodeName = this.getNodeName();
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        ObjectReference $targetRef = this.getTargetRef();
        result = result * 59 + ($targetRef == null ? 43 : ((Object)$targetRef).hashCode());
        Map<String, String> $topology = this.getTopology();
        result = result * 59 + ($topology == null ? 43 : ((Object)$topology).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

