/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointHints;
import io.fabric8.kubernetes.api.model.discovery.v1.ForNode;
import io.fabric8.kubernetes.api.model.discovery.v1.ForNodeBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1.ForNodeFluent;
import io.fabric8.kubernetes.api.model.discovery.v1.ForZone;
import io.fabric8.kubernetes.api.model.discovery.v1.ForZoneBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1.ForZoneFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointHintsFluent<A extends EndpointHintsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ForNodeBuilder> forNodes = new ArrayList();
    private ArrayList<ForZoneBuilder> forZones = new ArrayList();
    private Map<String, Object> additionalProperties;

    public EndpointHintsFluent() {
    }

    public EndpointHintsFluent(EndpointHints instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EndpointHints instance) {
        EndpointHints endpointHints = instance = instance != null ? instance : new EndpointHints();
        if (instance != null) {
            this.withForNodes(instance.getForNodes());
            this.withForZones(instance.getForZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToForNodes(int index, ForNode item) {
        if (this.forNodes == null) {
            this.forNodes = new ArrayList();
        }
        ForNodeBuilder builder = new ForNodeBuilder(item);
        if (index < 0 || index >= this.forNodes.size()) {
            this._visitables.get("forNodes").add(builder);
            this.forNodes.add(builder);
        } else {
            this._visitables.get("forNodes").add(builder);
            this.forNodes.add(index, builder);
        }
        return (A)this;
    }

    public A setToForNodes(int index, ForNode item) {
        if (this.forNodes == null) {
            this.forNodes = new ArrayList();
        }
        ForNodeBuilder builder = new ForNodeBuilder(item);
        if (index < 0 || index >= this.forNodes.size()) {
            this._visitables.get("forNodes").add(builder);
            this.forNodes.add(builder);
        } else {
            this._visitables.get("forNodes").add(builder);
            this.forNodes.set(index, builder);
        }
        return (A)this;
    }

    public A addToForNodes(ForNode ... items) {
        if (this.forNodes == null) {
            this.forNodes = new ArrayList();
        }
        for (ForNode item : items) {
            ForNodeBuilder builder = new ForNodeBuilder(item);
            this._visitables.get("forNodes").add(builder);
            this.forNodes.add(builder);
        }
        return (A)this;
    }

    public A addAllToForNodes(Collection<ForNode> items) {
        if (this.forNodes == null) {
            this.forNodes = new ArrayList();
        }
        for (ForNode item : items) {
            ForNodeBuilder builder = new ForNodeBuilder(item);
            this._visitables.get("forNodes").add(builder);
            this.forNodes.add(builder);
        }
        return (A)this;
    }

    public A removeFromForNodes(ForNode ... items) {
        if (this.forNodes == null) {
            return (A)this;
        }
        for (ForNode item : items) {
            ForNodeBuilder builder = new ForNodeBuilder(item);
            this._visitables.get("forNodes").remove(builder);
            this.forNodes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromForNodes(Collection<ForNode> items) {
        if (this.forNodes == null) {
            return (A)this;
        }
        for (ForNode item : items) {
            ForNodeBuilder builder = new ForNodeBuilder(item);
            this._visitables.get("forNodes").remove(builder);
            this.forNodes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromForNodes(Predicate<ForNodeBuilder> predicate) {
        if (this.forNodes == null) {
            return (A)this;
        }
        Iterator<ForNodeBuilder> each = this.forNodes.iterator();
        Object visitables = this._visitables.get("forNodes");
        while (each.hasNext()) {
            ForNodeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ForNode> buildForNodes() {
        return this.forNodes != null ? EndpointHintsFluent.build(this.forNodes) : null;
    }

    public ForNode buildForNode(int index) {
        return this.forNodes.get(index).build();
    }

    public ForNode buildFirstForNode() {
        return this.forNodes.get(0).build();
    }

    public ForNode buildLastForNode() {
        return this.forNodes.get(this.forNodes.size() - 1).build();
    }

    public ForNode buildMatchingForNode(Predicate<ForNodeBuilder> predicate) {
        for (ForNodeBuilder item : this.forNodes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingForNode(Predicate<ForNodeBuilder> predicate) {
        for (ForNodeBuilder item : this.forNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withForNodes(List<ForNode> forNodes) {
        if (this.forNodes != null) {
            this._visitables.get("forNodes").clear();
        }
        if (forNodes != null) {
            this.forNodes = new ArrayList();
            for (ForNode item : forNodes) {
                this.addToForNodes(item);
            }
        } else {
            this.forNodes = null;
        }
        return (A)this;
    }

    public A withForNodes(ForNode ... forNodes) {
        if (this.forNodes != null) {
            this.forNodes.clear();
            this._visitables.remove("forNodes");
        }
        if (forNodes != null) {
            for (ForNode item : forNodes) {
                this.addToForNodes(item);
            }
        }
        return (A)this;
    }

    public boolean hasForNodes() {
        return this.forNodes != null && !this.forNodes.isEmpty();
    }

    public A addNewForNode(String name) {
        return this.addToForNodes(new ForNode(name));
    }

    public ForNodesNested<A> addNewForNode() {
        return new ForNodesNested(-1, null);
    }

    public ForNodesNested<A> addNewForNodeLike(ForNode item) {
        return new ForNodesNested(-1, item);
    }

    public ForNodesNested<A> setNewForNodeLike(int index, ForNode item) {
        return new ForNodesNested(index, item);
    }

    public ForNodesNested<A> editForNode(int index) {
        if (this.forNodes.size() <= index) {
            throw new RuntimeException("Can't edit forNodes. Index exceeds size.");
        }
        return this.setNewForNodeLike(index, this.buildForNode(index));
    }

    public ForNodesNested<A> editFirstForNode() {
        if (this.forNodes.size() == 0) {
            throw new RuntimeException("Can't edit first forNodes. The list is empty.");
        }
        return this.setNewForNodeLike(0, this.buildForNode(0));
    }

    public ForNodesNested<A> editLastForNode() {
        int index = this.forNodes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last forNodes. The list is empty.");
        }
        return this.setNewForNodeLike(index, this.buildForNode(index));
    }

    public ForNodesNested<A> editMatchingForNode(Predicate<ForNodeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.forNodes.size(); ++i) {
            if (!predicate.test(this.forNodes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching forNodes. No match found.");
        }
        return this.setNewForNodeLike(index, this.buildForNode(index));
    }

    public A addToForZones(int index, ForZone item) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        ForZoneBuilder builder = new ForZoneBuilder(item);
        if (index < 0 || index >= this.forZones.size()) {
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        } else {
            this._visitables.get("forZones").add(builder);
            this.forZones.add(index, builder);
        }
        return (A)this;
    }

    public A setToForZones(int index, ForZone item) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        ForZoneBuilder builder = new ForZoneBuilder(item);
        if (index < 0 || index >= this.forZones.size()) {
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        } else {
            this._visitables.get("forZones").add(builder);
            this.forZones.set(index, builder);
        }
        return (A)this;
    }

    public A addToForZones(ForZone ... items) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        for (ForZone item : items) {
            ForZoneBuilder builder = new ForZoneBuilder(item);
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        }
        return (A)this;
    }

    public A addAllToForZones(Collection<ForZone> items) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        for (ForZone item : items) {
            ForZoneBuilder builder = new ForZoneBuilder(item);
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        }
        return (A)this;
    }

    public A removeFromForZones(ForZone ... items) {
        if (this.forZones == null) {
            return (A)this;
        }
        for (ForZone item : items) {
            ForZoneBuilder builder = new ForZoneBuilder(item);
            this._visitables.get("forZones").remove(builder);
            this.forZones.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromForZones(Collection<ForZone> items) {
        if (this.forZones == null) {
            return (A)this;
        }
        for (ForZone item : items) {
            ForZoneBuilder builder = new ForZoneBuilder(item);
            this._visitables.get("forZones").remove(builder);
            this.forZones.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromForZones(Predicate<ForZoneBuilder> predicate) {
        if (this.forZones == null) {
            return (A)this;
        }
        Iterator<ForZoneBuilder> each = this.forZones.iterator();
        Object visitables = this._visitables.get("forZones");
        while (each.hasNext()) {
            ForZoneBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ForZone> buildForZones() {
        return this.forZones != null ? EndpointHintsFluent.build(this.forZones) : null;
    }

    public ForZone buildForZone(int index) {
        return this.forZones.get(index).build();
    }

    public ForZone buildFirstForZone() {
        return this.forZones.get(0).build();
    }

    public ForZone buildLastForZone() {
        return this.forZones.get(this.forZones.size() - 1).build();
    }

    public ForZone buildMatchingForZone(Predicate<ForZoneBuilder> predicate) {
        for (ForZoneBuilder item : this.forZones) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingForZone(Predicate<ForZoneBuilder> predicate) {
        for (ForZoneBuilder item : this.forZones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withForZones(List<ForZone> forZones) {
        if (this.forZones != null) {
            this._visitables.get("forZones").clear();
        }
        if (forZones != null) {
            this.forZones = new ArrayList();
            for (ForZone item : forZones) {
                this.addToForZones(item);
            }
        } else {
            this.forZones = null;
        }
        return (A)this;
    }

    public A withForZones(ForZone ... forZones) {
        if (this.forZones != null) {
            this.forZones.clear();
            this._visitables.remove("forZones");
        }
        if (forZones != null) {
            for (ForZone item : forZones) {
                this.addToForZones(item);
            }
        }
        return (A)this;
    }

    public boolean hasForZones() {
        return this.forZones != null && !this.forZones.isEmpty();
    }

    public A addNewForZone(String name) {
        return this.addToForZones(new ForZone(name));
    }

    public ForZonesNested<A> addNewForZone() {
        return new ForZonesNested(-1, null);
    }

    public ForZonesNested<A> addNewForZoneLike(ForZone item) {
        return new ForZonesNested(-1, item);
    }

    public ForZonesNested<A> setNewForZoneLike(int index, ForZone item) {
        return new ForZonesNested(index, item);
    }

    public ForZonesNested<A> editForZone(int index) {
        if (this.forZones.size() <= index) {
            throw new RuntimeException("Can't edit forZones. Index exceeds size.");
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    public ForZonesNested<A> editFirstForZone() {
        if (this.forZones.size() == 0) {
            throw new RuntimeException("Can't edit first forZones. The list is empty.");
        }
        return this.setNewForZoneLike(0, this.buildForZone(0));
    }

    public ForZonesNested<A> editLastForZone() {
        int index = this.forZones.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last forZones. The list is empty.");
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    public ForZonesNested<A> editMatchingForZone(Predicate<ForZoneBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.forZones.size(); ++i) {
            if (!predicate.test(this.forZones.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching forZones. No match found.");
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointHintsFluent that = (EndpointHintsFluent)o;
        if (!Objects.equals(this.forNodes, that.forNodes)) {
            return false;
        }
        if (!Objects.equals(this.forZones, that.forZones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.forNodes, this.forZones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.forNodes != null && !this.forNodes.isEmpty()) {
            sb.append("forNodes:");
            sb.append(String.valueOf(this.forNodes) + ",");
        }
        if (this.forZones != null && !this.forZones.isEmpty()) {
            sb.append("forZones:");
            sb.append(String.valueOf(this.forZones) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ForZonesNested<N>
    extends ForZoneFluent<ForZonesNested<N>>
    implements Nested<N> {
        ForZoneBuilder builder;
        int index;

        ForZonesNested(int index, ForZone item) {
            this.index = index;
            this.builder = new ForZoneBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointHintsFluent.this.setToForZones(this.index, this.builder.build());
        }

        public N endForZone() {
            return this.and();
        }
    }

    public class ForNodesNested<N>
    extends ForNodeFluent<ForNodesNested<N>>
    implements Nested<N> {
        ForNodeBuilder builder;
        int index;

        ForNodesNested(int index, ForNode item) {
            this.index = index;
            this.builder = new ForNodeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointHintsFluent.this.setToForNodes(this.index, this.builder.build());
        }

        public N endForNode() {
            return this.and();
        }
    }
}

