/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookup;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanCondition;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanConditionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanConditionFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanStatus;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Step;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.StepBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.StepFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class InstallPlanStatusFluent<A extends InstallPlanStatusFluent<A>>
extends BaseFluent<A> {
    private ObjectReferenceBuilder attenuatedServiceAccountRef;
    private ArrayList<BundleLookupBuilder> bundleLookups = new ArrayList();
    private List<String> catalogSources = new ArrayList<String>();
    private ArrayList<InstallPlanConditionBuilder> conditions = new ArrayList();
    private String message;
    private String phase;
    private ArrayList<StepBuilder> plan = new ArrayList();
    private String startTime;
    private Map<String, Object> additionalProperties;

    public InstallPlanStatusFluent() {
    }

    public InstallPlanStatusFluent(InstallPlanStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(InstallPlanStatus instance) {
        InstallPlanStatus installPlanStatus = instance = instance != null ? instance : new InstallPlanStatus();
        if (instance != null) {
            this.withAttenuatedServiceAccountRef(instance.getAttenuatedServiceAccountRef());
            this.withBundleLookups(instance.getBundleLookups());
            this.withCatalogSources(instance.getCatalogSources());
            this.withConditions(instance.getConditions());
            this.withMessage(instance.getMessage());
            this.withPhase(instance.getPhase());
            this.withPlan(instance.getPlan());
            this.withStartTime(instance.getStartTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ObjectReference buildAttenuatedServiceAccountRef() {
        return this.attenuatedServiceAccountRef != null ? this.attenuatedServiceAccountRef.build() : null;
    }

    public A withAttenuatedServiceAccountRef(ObjectReference attenuatedServiceAccountRef) {
        this._visitables.remove("attenuatedServiceAccountRef");
        if (attenuatedServiceAccountRef != null) {
            this.attenuatedServiceAccountRef = new ObjectReferenceBuilder(attenuatedServiceAccountRef);
            this._visitables.get("attenuatedServiceAccountRef").add(this.attenuatedServiceAccountRef);
        } else {
            this.attenuatedServiceAccountRef = null;
            this._visitables.get("attenuatedServiceAccountRef").remove(this.attenuatedServiceAccountRef);
        }
        return (A)this;
    }

    public boolean hasAttenuatedServiceAccountRef() {
        return this.attenuatedServiceAccountRef != null;
    }

    public AttenuatedServiceAccountRefNested<A> withNewAttenuatedServiceAccountRef() {
        return new AttenuatedServiceAccountRefNested(null);
    }

    public AttenuatedServiceAccountRefNested<A> withNewAttenuatedServiceAccountRefLike(ObjectReference item) {
        return new AttenuatedServiceAccountRefNested(item);
    }

    public AttenuatedServiceAccountRefNested<A> editAttenuatedServiceAccountRef() {
        return this.withNewAttenuatedServiceAccountRefLike(Optional.ofNullable(this.buildAttenuatedServiceAccountRef()).orElse(null));
    }

    public AttenuatedServiceAccountRefNested<A> editOrNewAttenuatedServiceAccountRef() {
        return this.withNewAttenuatedServiceAccountRefLike(Optional.ofNullable(this.buildAttenuatedServiceAccountRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public AttenuatedServiceAccountRefNested<A> editOrNewAttenuatedServiceAccountRefLike(ObjectReference item) {
        return this.withNewAttenuatedServiceAccountRefLike(Optional.ofNullable(this.buildAttenuatedServiceAccountRef()).orElse(item));
    }

    public A addToBundleLookups(int index, BundleLookup item) {
        if (this.bundleLookups == null) {
            this.bundleLookups = new ArrayList();
        }
        BundleLookupBuilder builder = new BundleLookupBuilder(item);
        if (index < 0 || index >= this.bundleLookups.size()) {
            this._visitables.get("bundleLookups").add(builder);
            this.bundleLookups.add(builder);
        } else {
            this._visitables.get("bundleLookups").add(builder);
            this.bundleLookups.add(index, builder);
        }
        return (A)this;
    }

    public A setToBundleLookups(int index, BundleLookup item) {
        if (this.bundleLookups == null) {
            this.bundleLookups = new ArrayList();
        }
        BundleLookupBuilder builder = new BundleLookupBuilder(item);
        if (index < 0 || index >= this.bundleLookups.size()) {
            this._visitables.get("bundleLookups").add(builder);
            this.bundleLookups.add(builder);
        } else {
            this._visitables.get("bundleLookups").add(builder);
            this.bundleLookups.set(index, builder);
        }
        return (A)this;
    }

    public A addToBundleLookups(BundleLookup ... items) {
        if (this.bundleLookups == null) {
            this.bundleLookups = new ArrayList();
        }
        for (BundleLookup item : items) {
            BundleLookupBuilder builder = new BundleLookupBuilder(item);
            this._visitables.get("bundleLookups").add(builder);
            this.bundleLookups.add(builder);
        }
        return (A)this;
    }

    public A addAllToBundleLookups(Collection<BundleLookup> items) {
        if (this.bundleLookups == null) {
            this.bundleLookups = new ArrayList();
        }
        for (BundleLookup item : items) {
            BundleLookupBuilder builder = new BundleLookupBuilder(item);
            this._visitables.get("bundleLookups").add(builder);
            this.bundleLookups.add(builder);
        }
        return (A)this;
    }

    public A removeFromBundleLookups(BundleLookup ... items) {
        if (this.bundleLookups == null) {
            return (A)this;
        }
        for (BundleLookup item : items) {
            BundleLookupBuilder builder = new BundleLookupBuilder(item);
            this._visitables.get("bundleLookups").remove(builder);
            this.bundleLookups.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromBundleLookups(Collection<BundleLookup> items) {
        if (this.bundleLookups == null) {
            return (A)this;
        }
        for (BundleLookup item : items) {
            BundleLookupBuilder builder = new BundleLookupBuilder(item);
            this._visitables.get("bundleLookups").remove(builder);
            this.bundleLookups.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromBundleLookups(Predicate<BundleLookupBuilder> predicate) {
        if (this.bundleLookups == null) {
            return (A)this;
        }
        Iterator<BundleLookupBuilder> each = this.bundleLookups.iterator();
        Object visitables = this._visitables.get("bundleLookups");
        while (each.hasNext()) {
            BundleLookupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<BundleLookup> buildBundleLookups() {
        return this.bundleLookups != null ? InstallPlanStatusFluent.build(this.bundleLookups) : null;
    }

    public BundleLookup buildBundleLookup(int index) {
        return this.bundleLookups.get(index).build();
    }

    public BundleLookup buildFirstBundleLookup() {
        return this.bundleLookups.get(0).build();
    }

    public BundleLookup buildLastBundleLookup() {
        return this.bundleLookups.get(this.bundleLookups.size() - 1).build();
    }

    public BundleLookup buildMatchingBundleLookup(Predicate<BundleLookupBuilder> predicate) {
        for (BundleLookupBuilder item : this.bundleLookups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBundleLookup(Predicate<BundleLookupBuilder> predicate) {
        for (BundleLookupBuilder item : this.bundleLookups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBundleLookups(List<BundleLookup> bundleLookups) {
        if (this.bundleLookups != null) {
            this._visitables.get("bundleLookups").clear();
        }
        if (bundleLookups != null) {
            this.bundleLookups = new ArrayList();
            for (BundleLookup item : bundleLookups) {
                this.addToBundleLookups(item);
            }
        } else {
            this.bundleLookups = null;
        }
        return (A)this;
    }

    public A withBundleLookups(BundleLookup ... bundleLookups) {
        if (this.bundleLookups != null) {
            this.bundleLookups.clear();
            this._visitables.remove("bundleLookups");
        }
        if (bundleLookups != null) {
            for (BundleLookup item : bundleLookups) {
                this.addToBundleLookups(item);
            }
        }
        return (A)this;
    }

    public boolean hasBundleLookups() {
        return this.bundleLookups != null && !this.bundleLookups.isEmpty();
    }

    public BundleLookupsNested<A> addNewBundleLookup() {
        return new BundleLookupsNested(-1, null);
    }

    public BundleLookupsNested<A> addNewBundleLookupLike(BundleLookup item) {
        return new BundleLookupsNested(-1, item);
    }

    public BundleLookupsNested<A> setNewBundleLookupLike(int index, BundleLookup item) {
        return new BundleLookupsNested(index, item);
    }

    public BundleLookupsNested<A> editBundleLookup(int index) {
        if (this.bundleLookups.size() <= index) {
            throw new RuntimeException("Can't edit bundleLookups. Index exceeds size.");
        }
        return this.setNewBundleLookupLike(index, this.buildBundleLookup(index));
    }

    public BundleLookupsNested<A> editFirstBundleLookup() {
        if (this.bundleLookups.size() == 0) {
            throw new RuntimeException("Can't edit first bundleLookups. The list is empty.");
        }
        return this.setNewBundleLookupLike(0, this.buildBundleLookup(0));
    }

    public BundleLookupsNested<A> editLastBundleLookup() {
        int index = this.bundleLookups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last bundleLookups. The list is empty.");
        }
        return this.setNewBundleLookupLike(index, this.buildBundleLookup(index));
    }

    public BundleLookupsNested<A> editMatchingBundleLookup(Predicate<BundleLookupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.bundleLookups.size(); ++i) {
            if (!predicate.test(this.bundleLookups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching bundleLookups. No match found.");
        }
        return this.setNewBundleLookupLike(index, this.buildBundleLookup(index));
    }

    public A addToCatalogSources(int index, String item) {
        if (this.catalogSources == null) {
            this.catalogSources = new ArrayList<String>();
        }
        this.catalogSources.add(index, item);
        return (A)this;
    }

    public A setToCatalogSources(int index, String item) {
        if (this.catalogSources == null) {
            this.catalogSources = new ArrayList<String>();
        }
        this.catalogSources.set(index, item);
        return (A)this;
    }

    public A addToCatalogSources(String ... items) {
        if (this.catalogSources == null) {
            this.catalogSources = new ArrayList<String>();
        }
        for (String item : items) {
            this.catalogSources.add(item);
        }
        return (A)this;
    }

    public A addAllToCatalogSources(Collection<String> items) {
        if (this.catalogSources == null) {
            this.catalogSources = new ArrayList<String>();
        }
        for (String item : items) {
            this.catalogSources.add(item);
        }
        return (A)this;
    }

    public A removeFromCatalogSources(String ... items) {
        if (this.catalogSources == null) {
            return (A)this;
        }
        for (String item : items) {
            this.catalogSources.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCatalogSources(Collection<String> items) {
        if (this.catalogSources == null) {
            return (A)this;
        }
        for (String item : items) {
            this.catalogSources.remove(item);
        }
        return (A)this;
    }

    public List<String> getCatalogSources() {
        return this.catalogSources;
    }

    public String getCatalogSource(int index) {
        return this.catalogSources.get(index);
    }

    public String getFirstCatalogSource() {
        return this.catalogSources.get(0);
    }

    public String getLastCatalogSource() {
        return this.catalogSources.get(this.catalogSources.size() - 1);
    }

    public String getMatchingCatalogSource(Predicate<String> predicate) {
        for (String item : this.catalogSources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCatalogSource(Predicate<String> predicate) {
        for (String item : this.catalogSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCatalogSources(List<String> catalogSources) {
        if (catalogSources != null) {
            this.catalogSources = new ArrayList<String>();
            for (String item : catalogSources) {
                this.addToCatalogSources(item);
            }
        } else {
            this.catalogSources = null;
        }
        return (A)this;
    }

    public A withCatalogSources(String ... catalogSources) {
        if (this.catalogSources != null) {
            this.catalogSources.clear();
            this._visitables.remove("catalogSources");
        }
        if (catalogSources != null) {
            for (String item : catalogSources) {
                this.addToCatalogSources(item);
            }
        }
        return (A)this;
    }

    public boolean hasCatalogSources() {
        return this.catalogSources != null && !this.catalogSources.isEmpty();
    }

    public A addToConditions(int index, InstallPlanCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, InstallPlanCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(InstallPlanCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (InstallPlanCondition item : items) {
            InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<InstallPlanCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (InstallPlanCondition item : items) {
            InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(InstallPlanCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (InstallPlanCondition item : items) {
            InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<InstallPlanCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (InstallPlanCondition item : items) {
            InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<InstallPlanConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<InstallPlanConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            InstallPlanConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<InstallPlanCondition> buildConditions() {
        return this.conditions != null ? InstallPlanStatusFluent.build(this.conditions) : null;
    }

    public InstallPlanCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public InstallPlanCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public InstallPlanCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public InstallPlanCondition buildMatchingCondition(Predicate<InstallPlanConditionBuilder> predicate) {
        for (InstallPlanConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<InstallPlanConditionBuilder> predicate) {
        for (InstallPlanConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<InstallPlanCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (InstallPlanCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(InstallPlanCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (InstallPlanCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(InstallPlanCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, InstallPlanCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<InstallPlanConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public A addToPlan(int index, Step item) {
        if (this.plan == null) {
            this.plan = new ArrayList();
        }
        StepBuilder builder = new StepBuilder(item);
        if (index < 0 || index >= this.plan.size()) {
            this._visitables.get("plan").add(builder);
            this.plan.add(builder);
        } else {
            this._visitables.get("plan").add(builder);
            this.plan.add(index, builder);
        }
        return (A)this;
    }

    public A setToPlan(int index, Step item) {
        if (this.plan == null) {
            this.plan = new ArrayList();
        }
        StepBuilder builder = new StepBuilder(item);
        if (index < 0 || index >= this.plan.size()) {
            this._visitables.get("plan").add(builder);
            this.plan.add(builder);
        } else {
            this._visitables.get("plan").add(builder);
            this.plan.set(index, builder);
        }
        return (A)this;
    }

    public A addToPlan(Step ... items) {
        if (this.plan == null) {
            this.plan = new ArrayList();
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get("plan").add(builder);
            this.plan.add(builder);
        }
        return (A)this;
    }

    public A addAllToPlan(Collection<Step> items) {
        if (this.plan == null) {
            this.plan = new ArrayList();
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get("plan").add(builder);
            this.plan.add(builder);
        }
        return (A)this;
    }

    public A removeFromPlan(Step ... items) {
        if (this.plan == null) {
            return (A)this;
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get("plan").remove(builder);
            this.plan.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPlan(Collection<Step> items) {
        if (this.plan == null) {
            return (A)this;
        }
        for (Step item : items) {
            StepBuilder builder = new StepBuilder(item);
            this._visitables.get("plan").remove(builder);
            this.plan.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPlan(Predicate<StepBuilder> predicate) {
        if (this.plan == null) {
            return (A)this;
        }
        Iterator<StepBuilder> each = this.plan.iterator();
        Object visitables = this._visitables.get("plan");
        while (each.hasNext()) {
            StepBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Step> buildPlan() {
        return this.plan != null ? InstallPlanStatusFluent.build(this.plan) : null;
    }

    public Step buildPlan(int index) {
        return this.plan.get(index).build();
    }

    public Step buildFirstPlan() {
        return this.plan.get(0).build();
    }

    public Step buildLastPlan() {
        return this.plan.get(this.plan.size() - 1).build();
    }

    public Step buildMatchingPlan(Predicate<StepBuilder> predicate) {
        for (StepBuilder item : this.plan) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPlan(Predicate<StepBuilder> predicate) {
        for (StepBuilder item : this.plan) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPlan(List<Step> plan) {
        if (this.plan != null) {
            this._visitables.get("plan").clear();
        }
        if (plan != null) {
            this.plan = new ArrayList();
            for (Step item : plan) {
                this.addToPlan(item);
            }
        } else {
            this.plan = null;
        }
        return (A)this;
    }

    public A withPlan(Step ... plan) {
        if (this.plan != null) {
            this.plan.clear();
            this._visitables.remove("plan");
        }
        if (plan != null) {
            for (Step item : plan) {
                this.addToPlan(item);
            }
        }
        return (A)this;
    }

    public boolean hasPlan() {
        return this.plan != null && !this.plan.isEmpty();
    }

    public PlanNested<A> addNewPlan() {
        return new PlanNested(-1, null);
    }

    public PlanNested<A> addNewPlanLike(Step item) {
        return new PlanNested(-1, item);
    }

    public PlanNested<A> setNewPlanLike(int index, Step item) {
        return new PlanNested(index, item);
    }

    public PlanNested<A> editPlan(int index) {
        if (this.plan.size() <= index) {
            throw new RuntimeException("Can't edit plan. Index exceeds size.");
        }
        return this.setNewPlanLike(index, this.buildPlan(index));
    }

    public PlanNested<A> editFirstPlan() {
        if (this.plan.size() == 0) {
            throw new RuntimeException("Can't edit first plan. The list is empty.");
        }
        return this.setNewPlanLike(0, this.buildPlan(0));
    }

    public PlanNested<A> editLastPlan() {
        int index = this.plan.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last plan. The list is empty.");
        }
        return this.setNewPlanLike(index, this.buildPlan(index));
    }

    public PlanNested<A> editMatchingPlan(Predicate<StepBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.plan.size(); ++i) {
            if (!predicate.test(this.plan.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching plan. No match found.");
        }
        return this.setNewPlanLike(index, this.buildPlan(index));
    }

    public String getStartTime() {
        return this.startTime;
    }

    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstallPlanStatusFluent that = (InstallPlanStatusFluent)o;
        if (!Objects.equals(this.attenuatedServiceAccountRef, that.attenuatedServiceAccountRef)) {
            return false;
        }
        if (!Objects.equals(this.bundleLookups, that.bundleLookups)) {
            return false;
        }
        if (!Objects.equals(this.catalogSources, that.catalogSources)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.plan, that.plan)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attenuatedServiceAccountRef, this.bundleLookups, this.catalogSources, this.conditions, this.message, this.phase, this.plan, this.startTime, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attenuatedServiceAccountRef != null) {
            sb.append("attenuatedServiceAccountRef:");
            sb.append(String.valueOf(this.attenuatedServiceAccountRef) + ",");
        }
        if (this.bundleLookups != null && !this.bundleLookups.isEmpty()) {
            sb.append("bundleLookups:");
            sb.append(String.valueOf(this.bundleLookups) + ",");
        }
        if (this.catalogSources != null && !this.catalogSources.isEmpty()) {
            sb.append("catalogSources:");
            sb.append(String.valueOf(this.catalogSources) + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.plan != null && !this.plan.isEmpty()) {
            sb.append("plan:");
            sb.append(String.valueOf(this.plan) + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PlanNested<N>
    extends StepFluent<PlanNested<N>>
    implements Nested<N> {
        StepBuilder builder;
        int index;

        PlanNested(int index, Step item) {
            this.index = index;
            this.builder = new StepBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallPlanStatusFluent.this.setToPlan(this.index, this.builder.build());
        }

        public N endPlan() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends InstallPlanConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        InstallPlanConditionBuilder builder;
        int index;

        ConditionsNested(int index, InstallPlanCondition item) {
            this.index = index;
            this.builder = new InstallPlanConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallPlanStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class BundleLookupsNested<N>
    extends BundleLookupFluent<BundleLookupsNested<N>>
    implements Nested<N> {
        BundleLookupBuilder builder;
        int index;

        BundleLookupsNested(int index, BundleLookup item) {
            this.index = index;
            this.builder = new BundleLookupBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallPlanStatusFluent.this.setToBundleLookups(this.index, this.builder.build());
        }

        public N endBundleLookup() {
            return this.and();
        }
    }

    public class AttenuatedServiceAccountRefNested<N>
    extends ObjectReferenceFluent<AttenuatedServiceAccountRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        AttenuatedServiceAccountRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallPlanStatusFluent.this.withAttenuatedServiceAccountRef(this.builder.build());
        }

        public N endAttenuatedServiceAccountRef() {
            return this.and();
        }
    }
}

