/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelectorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelectorFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.WebhookConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WebhookConfigFluent<A extends WebhookConfigFluent<A>>
extends BaseFluent<A> {
    private HTTPConfigBuilder httpConfig;
    private Integer maxAlerts;
    private Boolean sendResolved;
    private String url;
    private SecretKeySelectorBuilder urlSecret;
    private Map<String, Object> additionalProperties;

    public WebhookConfigFluent() {
    }

    public WebhookConfigFluent(WebhookConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WebhookConfig instance) {
        WebhookConfig webhookConfig = instance = instance != null ? instance : new WebhookConfig();
        if (instance != null) {
            this.withHttpConfig(instance.getHttpConfig());
            this.withMaxAlerts(instance.getMaxAlerts());
            this.withSendResolved(instance.getSendResolved());
            this.withUrl(instance.getUrl());
            this.withUrlSecret(instance.getUrlSecret());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove("httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public Integer getMaxAlerts() {
        return this.maxAlerts;
    }

    public A withMaxAlerts(Integer maxAlerts) {
        this.maxAlerts = maxAlerts;
        return (A)this;
    }

    public boolean hasMaxAlerts() {
        return this.maxAlerts != null;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public SecretKeySelector buildUrlSecret() {
        return this.urlSecret != null ? this.urlSecret.build() : null;
    }

    public A withUrlSecret(SecretKeySelector urlSecret) {
        this._visitables.remove("urlSecret");
        if (urlSecret != null) {
            this.urlSecret = new SecretKeySelectorBuilder(urlSecret);
            this._visitables.get("urlSecret").add(this.urlSecret);
        } else {
            this.urlSecret = null;
            this._visitables.get("urlSecret").remove(this.urlSecret);
        }
        return (A)this;
    }

    public boolean hasUrlSecret() {
        return this.urlSecret != null;
    }

    public A withNewUrlSecret(String key, String name) {
        return this.withUrlSecret(new SecretKeySelector(key, name));
    }

    public UrlSecretNested<A> withNewUrlSecret() {
        return new UrlSecretNested(null);
    }

    public UrlSecretNested<A> withNewUrlSecretLike(SecretKeySelector item) {
        return new UrlSecretNested(item);
    }

    public UrlSecretNested<A> editUrlSecret() {
        return this.withNewUrlSecretLike(Optional.ofNullable(this.buildUrlSecret()).orElse(null));
    }

    public UrlSecretNested<A> editOrNewUrlSecret() {
        return this.withNewUrlSecretLike(Optional.ofNullable(this.buildUrlSecret()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public UrlSecretNested<A> editOrNewUrlSecretLike(SecretKeySelector item) {
        return this.withNewUrlSecretLike(Optional.ofNullable(this.buildUrlSecret()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookConfigFluent that = (WebhookConfigFluent)o;
        if (!Objects.equals(this.httpConfig, that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.maxAlerts, that.maxAlerts)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.urlSecret, that.urlSecret)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.httpConfig, this.maxAlerts, this.sendResolved, this.url, this.urlSecret, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(String.valueOf(this.httpConfig) + ",");
        }
        if (this.maxAlerts != null) {
            sb.append("maxAlerts:");
            sb.append(this.maxAlerts + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.urlSecret != null) {
            sb.append("urlSecret:");
            sb.append(String.valueOf(this.urlSecret) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public class UrlSecretNested<N>
    extends SecretKeySelectorFluent<UrlSecretNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        UrlSecretNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebhookConfigFluent.this.withUrlSecret(this.builder.build());
        }

        public N endUrlSecret() {
            return this.and();
        }
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebhookConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

