/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSMachineProviderConfig;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReference;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.BlockDeviceMappingSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.BlockDeviceMappingSpecBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.BlockDeviceMappingSpecFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.LoadBalancerReference;
import io.fabric8.openshift.api.model.machine.v1beta1.LoadBalancerReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.LoadBalancerReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.MetadataServiceOptions;
import io.fabric8.openshift.api.model.machine.v1beta1.MetadataServiceOptionsBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.MetadataServiceOptionsFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.Placement;
import io.fabric8.openshift.api.model.machine.v1beta1.PlacementBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.PlacementFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.SpotMarketOptions;
import io.fabric8.openshift.api.model.machine.v1beta1.SpotMarketOptionsBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.SpotMarketOptionsFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.TagSpecification;
import io.fabric8.openshift.api.model.machine.v1beta1.TagSpecificationBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.TagSpecificationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AWSMachineProviderConfigFluent<A extends AWSMachineProviderConfigFluent<A>>
extends BaseFluent<A> {
    private AWSResourceReferenceBuilder ami;
    private String apiVersion;
    private ArrayList<BlockDeviceMappingSpecBuilder> blockDevices = new ArrayList();
    private String capacityReservationId;
    private LocalObjectReferenceBuilder credentialsSecret;
    private Long deviceIndex;
    private AWSResourceReferenceBuilder iamInstanceProfile;
    private String instanceType;
    private String keyName;
    private String kind;
    private ArrayList<LoadBalancerReferenceBuilder> loadBalancers = new ArrayList();
    private ObjectMetaBuilder metadata;
    private MetadataServiceOptionsBuilder metadataServiceOptions;
    private String networkInterfaceType;
    private PlacementBuilder placement;
    private String placementGroupName;
    private Integer placementGroupPartition;
    private Boolean publicIp;
    private ArrayList<AWSResourceReferenceBuilder> securityGroups = new ArrayList();
    private SpotMarketOptionsBuilder spotMarketOptions;
    private AWSResourceReferenceBuilder subnet;
    private ArrayList<TagSpecificationBuilder> tags = new ArrayList();
    private LocalObjectReferenceBuilder userDataSecret;
    private Map<String, Object> additionalProperties;

    public AWSMachineProviderConfigFluent() {
    }

    public AWSMachineProviderConfigFluent(AWSMachineProviderConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AWSMachineProviderConfig instance) {
        AWSMachineProviderConfig aWSMachineProviderConfig = instance = instance != null ? instance : new AWSMachineProviderConfig();
        if (instance != null) {
            this.withAmi(instance.getAmi());
            this.withApiVersion(instance.getApiVersion());
            this.withBlockDevices(instance.getBlockDevices());
            this.withCapacityReservationId(instance.getCapacityReservationId());
            this.withCredentialsSecret(instance.getCredentialsSecret());
            this.withDeviceIndex(instance.getDeviceIndex());
            this.withIamInstanceProfile(instance.getIamInstanceProfile());
            this.withInstanceType(instance.getInstanceType());
            this.withKeyName(instance.getKeyName());
            this.withKind(instance.getKind());
            this.withLoadBalancers(instance.getLoadBalancers());
            this.withMetadata(instance.getMetadata());
            this.withMetadataServiceOptions(instance.getMetadataServiceOptions());
            this.withNetworkInterfaceType(instance.getNetworkInterfaceType());
            this.withPlacement(instance.getPlacement());
            this.withPlacementGroupName(instance.getPlacementGroupName());
            this.withPlacementGroupPartition(instance.getPlacementGroupPartition());
            this.withPublicIp(instance.getPublicIp());
            this.withSecurityGroups(instance.getSecurityGroups());
            this.withSpotMarketOptions(instance.getSpotMarketOptions());
            this.withSubnet(instance.getSubnet());
            this.withTags(instance.getTags());
            this.withUserDataSecret(instance.getUserDataSecret());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AWSResourceReference buildAmi() {
        return this.ami != null ? this.ami.build() : null;
    }

    public A withAmi(AWSResourceReference ami) {
        this._visitables.remove("ami");
        if (ami != null) {
            this.ami = new AWSResourceReferenceBuilder(ami);
            this._visitables.get("ami").add(this.ami);
        } else {
            this.ami = null;
            this._visitables.get("ami").remove(this.ami);
        }
        return (A)this;
    }

    public boolean hasAmi() {
        return this.ami != null;
    }

    public AmiNested<A> withNewAmi() {
        return new AmiNested(null);
    }

    public AmiNested<A> withNewAmiLike(AWSResourceReference item) {
        return new AmiNested(item);
    }

    public AmiNested<A> editAmi() {
        return this.withNewAmiLike(Optional.ofNullable(this.buildAmi()).orElse(null));
    }

    public AmiNested<A> editOrNewAmi() {
        return this.withNewAmiLike(Optional.ofNullable(this.buildAmi()).orElse(new AWSResourceReferenceBuilder().build()));
    }

    public AmiNested<A> editOrNewAmiLike(AWSResourceReference item) {
        return this.withNewAmiLike(Optional.ofNullable(this.buildAmi()).orElse(item));
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToBlockDevices(int index, BlockDeviceMappingSpec item) {
        if (this.blockDevices == null) {
            this.blockDevices = new ArrayList();
        }
        BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);
        if (index < 0 || index >= this.blockDevices.size()) {
            this._visitables.get("blockDevices").add(builder);
            this.blockDevices.add(builder);
        } else {
            this._visitables.get("blockDevices").add(builder);
            this.blockDevices.add(index, builder);
        }
        return (A)this;
    }

    public A setToBlockDevices(int index, BlockDeviceMappingSpec item) {
        if (this.blockDevices == null) {
            this.blockDevices = new ArrayList();
        }
        BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);
        if (index < 0 || index >= this.blockDevices.size()) {
            this._visitables.get("blockDevices").add(builder);
            this.blockDevices.add(builder);
        } else {
            this._visitables.get("blockDevices").add(builder);
            this.blockDevices.set(index, builder);
        }
        return (A)this;
    }

    public A addToBlockDevices(BlockDeviceMappingSpec ... items) {
        if (this.blockDevices == null) {
            this.blockDevices = new ArrayList();
        }
        for (BlockDeviceMappingSpec item : items) {
            BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);
            this._visitables.get("blockDevices").add(builder);
            this.blockDevices.add(builder);
        }
        return (A)this;
    }

    public A addAllToBlockDevices(Collection<BlockDeviceMappingSpec> items) {
        if (this.blockDevices == null) {
            this.blockDevices = new ArrayList();
        }
        for (BlockDeviceMappingSpec item : items) {
            BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);
            this._visitables.get("blockDevices").add(builder);
            this.blockDevices.add(builder);
        }
        return (A)this;
    }

    public A removeFromBlockDevices(BlockDeviceMappingSpec ... items) {
        if (this.blockDevices == null) {
            return (A)this;
        }
        for (BlockDeviceMappingSpec item : items) {
            BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);
            this._visitables.get("blockDevices").remove(builder);
            this.blockDevices.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromBlockDevices(Collection<BlockDeviceMappingSpec> items) {
        if (this.blockDevices == null) {
            return (A)this;
        }
        for (BlockDeviceMappingSpec item : items) {
            BlockDeviceMappingSpecBuilder builder = new BlockDeviceMappingSpecBuilder(item);
            this._visitables.get("blockDevices").remove(builder);
            this.blockDevices.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromBlockDevices(Predicate<BlockDeviceMappingSpecBuilder> predicate) {
        if (this.blockDevices == null) {
            return (A)this;
        }
        Iterator<BlockDeviceMappingSpecBuilder> each = this.blockDevices.iterator();
        Object visitables = this._visitables.get("blockDevices");
        while (each.hasNext()) {
            BlockDeviceMappingSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<BlockDeviceMappingSpec> buildBlockDevices() {
        return this.blockDevices != null ? AWSMachineProviderConfigFluent.build(this.blockDevices) : null;
    }

    public BlockDeviceMappingSpec buildBlockDevice(int index) {
        return this.blockDevices.get(index).build();
    }

    public BlockDeviceMappingSpec buildFirstBlockDevice() {
        return this.blockDevices.get(0).build();
    }

    public BlockDeviceMappingSpec buildLastBlockDevice() {
        return this.blockDevices.get(this.blockDevices.size() - 1).build();
    }

    public BlockDeviceMappingSpec buildMatchingBlockDevice(Predicate<BlockDeviceMappingSpecBuilder> predicate) {
        for (BlockDeviceMappingSpecBuilder item : this.blockDevices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBlockDevice(Predicate<BlockDeviceMappingSpecBuilder> predicate) {
        for (BlockDeviceMappingSpecBuilder item : this.blockDevices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBlockDevices(List<BlockDeviceMappingSpec> blockDevices) {
        if (this.blockDevices != null) {
            this._visitables.get("blockDevices").clear();
        }
        if (blockDevices != null) {
            this.blockDevices = new ArrayList();
            for (BlockDeviceMappingSpec item : blockDevices) {
                this.addToBlockDevices(item);
            }
        } else {
            this.blockDevices = null;
        }
        return (A)this;
    }

    public A withBlockDevices(BlockDeviceMappingSpec ... blockDevices) {
        if (this.blockDevices != null) {
            this.blockDevices.clear();
            this._visitables.remove("blockDevices");
        }
        if (blockDevices != null) {
            for (BlockDeviceMappingSpec item : blockDevices) {
                this.addToBlockDevices(item);
            }
        }
        return (A)this;
    }

    public boolean hasBlockDevices() {
        return this.blockDevices != null && !this.blockDevices.isEmpty();
    }

    public BlockDevicesNested<A> addNewBlockDevice() {
        return new BlockDevicesNested(-1, null);
    }

    public BlockDevicesNested<A> addNewBlockDeviceLike(BlockDeviceMappingSpec item) {
        return new BlockDevicesNested(-1, item);
    }

    public BlockDevicesNested<A> setNewBlockDeviceLike(int index, BlockDeviceMappingSpec item) {
        return new BlockDevicesNested(index, item);
    }

    public BlockDevicesNested<A> editBlockDevice(int index) {
        if (this.blockDevices.size() <= index) {
            throw new RuntimeException("Can't edit blockDevices. Index exceeds size.");
        }
        return this.setNewBlockDeviceLike(index, this.buildBlockDevice(index));
    }

    public BlockDevicesNested<A> editFirstBlockDevice() {
        if (this.blockDevices.size() == 0) {
            throw new RuntimeException("Can't edit first blockDevices. The list is empty.");
        }
        return this.setNewBlockDeviceLike(0, this.buildBlockDevice(0));
    }

    public BlockDevicesNested<A> editLastBlockDevice() {
        int index = this.blockDevices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last blockDevices. The list is empty.");
        }
        return this.setNewBlockDeviceLike(index, this.buildBlockDevice(index));
    }

    public BlockDevicesNested<A> editMatchingBlockDevice(Predicate<BlockDeviceMappingSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.blockDevices.size(); ++i) {
            if (!predicate.test(this.blockDevices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching blockDevices. No match found.");
        }
        return this.setNewBlockDeviceLike(index, this.buildBlockDevice(index));
    }

    public String getCapacityReservationId() {
        return this.capacityReservationId;
    }

    public A withCapacityReservationId(String capacityReservationId) {
        this.capacityReservationId = capacityReservationId;
        return (A)this;
    }

    public boolean hasCapacityReservationId() {
        return this.capacityReservationId != null;
    }

    public LocalObjectReference buildCredentialsSecret() {
        return this.credentialsSecret != null ? this.credentialsSecret.build() : null;
    }

    public A withCredentialsSecret(LocalObjectReference credentialsSecret) {
        this._visitables.remove("credentialsSecret");
        if (credentialsSecret != null) {
            this.credentialsSecret = new LocalObjectReferenceBuilder(credentialsSecret);
            this._visitables.get("credentialsSecret").add(this.credentialsSecret);
        } else {
            this.credentialsSecret = null;
            this._visitables.get("credentialsSecret").remove(this.credentialsSecret);
        }
        return (A)this;
    }

    public boolean hasCredentialsSecret() {
        return this.credentialsSecret != null;
    }

    public A withNewCredentialsSecret(String name) {
        return this.withCredentialsSecret(new LocalObjectReference(name));
    }

    public CredentialsSecretNested<A> withNewCredentialsSecret() {
        return new CredentialsSecretNested(null);
    }

    public CredentialsSecretNested<A> withNewCredentialsSecretLike(LocalObjectReference item) {
        return new CredentialsSecretNested(item);
    }

    public CredentialsSecretNested<A> editCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(null));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecretLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(item));
    }

    public Long getDeviceIndex() {
        return this.deviceIndex;
    }

    public A withDeviceIndex(Long deviceIndex) {
        this.deviceIndex = deviceIndex;
        return (A)this;
    }

    public boolean hasDeviceIndex() {
        return this.deviceIndex != null;
    }

    public AWSResourceReference buildIamInstanceProfile() {
        return this.iamInstanceProfile != null ? this.iamInstanceProfile.build() : null;
    }

    public A withIamInstanceProfile(AWSResourceReference iamInstanceProfile) {
        this._visitables.remove("iamInstanceProfile");
        if (iamInstanceProfile != null) {
            this.iamInstanceProfile = new AWSResourceReferenceBuilder(iamInstanceProfile);
            this._visitables.get("iamInstanceProfile").add(this.iamInstanceProfile);
        } else {
            this.iamInstanceProfile = null;
            this._visitables.get("iamInstanceProfile").remove(this.iamInstanceProfile);
        }
        return (A)this;
    }

    public boolean hasIamInstanceProfile() {
        return this.iamInstanceProfile != null;
    }

    public IamInstanceProfileNested<A> withNewIamInstanceProfile() {
        return new IamInstanceProfileNested(null);
    }

    public IamInstanceProfileNested<A> withNewIamInstanceProfileLike(AWSResourceReference item) {
        return new IamInstanceProfileNested(item);
    }

    public IamInstanceProfileNested<A> editIamInstanceProfile() {
        return this.withNewIamInstanceProfileLike(Optional.ofNullable(this.buildIamInstanceProfile()).orElse(null));
    }

    public IamInstanceProfileNested<A> editOrNewIamInstanceProfile() {
        return this.withNewIamInstanceProfileLike(Optional.ofNullable(this.buildIamInstanceProfile()).orElse(new AWSResourceReferenceBuilder().build()));
    }

    public IamInstanceProfileNested<A> editOrNewIamInstanceProfileLike(AWSResourceReference item) {
        return this.withNewIamInstanceProfileLike(Optional.ofNullable(this.buildIamInstanceProfile()).orElse(item));
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public A withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return (A)this;
    }

    public boolean hasInstanceType() {
        return this.instanceType != null;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public A withKeyName(String keyName) {
        this.keyName = keyName;
        return (A)this;
    }

    public boolean hasKeyName() {
        return this.keyName != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToLoadBalancers(int index, LoadBalancerReference item) {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList();
        }
        LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
        if (index < 0 || index >= this.loadBalancers.size()) {
            this._visitables.get("loadBalancers").add(builder);
            this.loadBalancers.add(builder);
        } else {
            this._visitables.get("loadBalancers").add(builder);
            this.loadBalancers.add(index, builder);
        }
        return (A)this;
    }

    public A setToLoadBalancers(int index, LoadBalancerReference item) {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList();
        }
        LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
        if (index < 0 || index >= this.loadBalancers.size()) {
            this._visitables.get("loadBalancers").add(builder);
            this.loadBalancers.add(builder);
        } else {
            this._visitables.get("loadBalancers").add(builder);
            this.loadBalancers.set(index, builder);
        }
        return (A)this;
    }

    public A addToLoadBalancers(LoadBalancerReference ... items) {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList();
        }
        for (LoadBalancerReference item : items) {
            LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
            this._visitables.get("loadBalancers").add(builder);
            this.loadBalancers.add(builder);
        }
        return (A)this;
    }

    public A addAllToLoadBalancers(Collection<LoadBalancerReference> items) {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList();
        }
        for (LoadBalancerReference item : items) {
            LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
            this._visitables.get("loadBalancers").add(builder);
            this.loadBalancers.add(builder);
        }
        return (A)this;
    }

    public A removeFromLoadBalancers(LoadBalancerReference ... items) {
        if (this.loadBalancers == null) {
            return (A)this;
        }
        for (LoadBalancerReference item : items) {
            LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
            this._visitables.get("loadBalancers").remove(builder);
            this.loadBalancers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromLoadBalancers(Collection<LoadBalancerReference> items) {
        if (this.loadBalancers == null) {
            return (A)this;
        }
        for (LoadBalancerReference item : items) {
            LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
            this._visitables.get("loadBalancers").remove(builder);
            this.loadBalancers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromLoadBalancers(Predicate<LoadBalancerReferenceBuilder> predicate) {
        if (this.loadBalancers == null) {
            return (A)this;
        }
        Iterator<LoadBalancerReferenceBuilder> each = this.loadBalancers.iterator();
        Object visitables = this._visitables.get("loadBalancers");
        while (each.hasNext()) {
            LoadBalancerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<LoadBalancerReference> buildLoadBalancers() {
        return this.loadBalancers != null ? AWSMachineProviderConfigFluent.build(this.loadBalancers) : null;
    }

    public LoadBalancerReference buildLoadBalancer(int index) {
        return this.loadBalancers.get(index).build();
    }

    public LoadBalancerReference buildFirstLoadBalancer() {
        return this.loadBalancers.get(0).build();
    }

    public LoadBalancerReference buildLastLoadBalancer() {
        return this.loadBalancers.get(this.loadBalancers.size() - 1).build();
    }

    public LoadBalancerReference buildMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
        for (LoadBalancerReferenceBuilder item : this.loadBalancers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
        for (LoadBalancerReferenceBuilder item : this.loadBalancers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLoadBalancers(List<LoadBalancerReference> loadBalancers) {
        if (this.loadBalancers != null) {
            this._visitables.get("loadBalancers").clear();
        }
        if (loadBalancers != null) {
            this.loadBalancers = new ArrayList();
            for (LoadBalancerReference item : loadBalancers) {
                this.addToLoadBalancers(item);
            }
        } else {
            this.loadBalancers = null;
        }
        return (A)this;
    }

    public A withLoadBalancers(LoadBalancerReference ... loadBalancers) {
        if (this.loadBalancers != null) {
            this.loadBalancers.clear();
            this._visitables.remove("loadBalancers");
        }
        if (loadBalancers != null) {
            for (LoadBalancerReference item : loadBalancers) {
                this.addToLoadBalancers(item);
            }
        }
        return (A)this;
    }

    public boolean hasLoadBalancers() {
        return this.loadBalancers != null && !this.loadBalancers.isEmpty();
    }

    public A addNewLoadBalancer(String name, String type) {
        return this.addToLoadBalancers(new LoadBalancerReference(name, type));
    }

    public LoadBalancersNested<A> addNewLoadBalancer() {
        return new LoadBalancersNested(-1, null);
    }

    public LoadBalancersNested<A> addNewLoadBalancerLike(LoadBalancerReference item) {
        return new LoadBalancersNested(-1, item);
    }

    public LoadBalancersNested<A> setNewLoadBalancerLike(int index, LoadBalancerReference item) {
        return new LoadBalancersNested(index, item);
    }

    public LoadBalancersNested<A> editLoadBalancer(int index) {
        if (this.loadBalancers.size() <= index) {
            throw new RuntimeException("Can't edit loadBalancers. Index exceeds size.");
        }
        return this.setNewLoadBalancerLike(index, this.buildLoadBalancer(index));
    }

    public LoadBalancersNested<A> editFirstLoadBalancer() {
        if (this.loadBalancers.size() == 0) {
            throw new RuntimeException("Can't edit first loadBalancers. The list is empty.");
        }
        return this.setNewLoadBalancerLike(0, this.buildLoadBalancer(0));
    }

    public LoadBalancersNested<A> editLastLoadBalancer() {
        int index = this.loadBalancers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last loadBalancers. The list is empty.");
        }
        return this.setNewLoadBalancerLike(index, this.buildLoadBalancer(index));
    }

    public LoadBalancersNested<A> editMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.loadBalancers.size(); ++i) {
            if (!predicate.test(this.loadBalancers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching loadBalancers. No match found.");
        }
        return this.setNewLoadBalancerLike(index, this.buildLoadBalancer(index));
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public MetadataServiceOptions buildMetadataServiceOptions() {
        return this.metadataServiceOptions != null ? this.metadataServiceOptions.build() : null;
    }

    public A withMetadataServiceOptions(MetadataServiceOptions metadataServiceOptions) {
        this._visitables.remove("metadataServiceOptions");
        if (metadataServiceOptions != null) {
            this.metadataServiceOptions = new MetadataServiceOptionsBuilder(metadataServiceOptions);
            this._visitables.get("metadataServiceOptions").add(this.metadataServiceOptions);
        } else {
            this.metadataServiceOptions = null;
            this._visitables.get("metadataServiceOptions").remove(this.metadataServiceOptions);
        }
        return (A)this;
    }

    public boolean hasMetadataServiceOptions() {
        return this.metadataServiceOptions != null;
    }

    public A withNewMetadataServiceOptions(String authentication) {
        return this.withMetadataServiceOptions(new MetadataServiceOptions(authentication));
    }

    public MetadataServiceOptionsNested<A> withNewMetadataServiceOptions() {
        return new MetadataServiceOptionsNested(null);
    }

    public MetadataServiceOptionsNested<A> withNewMetadataServiceOptionsLike(MetadataServiceOptions item) {
        return new MetadataServiceOptionsNested(item);
    }

    public MetadataServiceOptionsNested<A> editMetadataServiceOptions() {
        return this.withNewMetadataServiceOptionsLike(Optional.ofNullable(this.buildMetadataServiceOptions()).orElse(null));
    }

    public MetadataServiceOptionsNested<A> editOrNewMetadataServiceOptions() {
        return this.withNewMetadataServiceOptionsLike(Optional.ofNullable(this.buildMetadataServiceOptions()).orElse(new MetadataServiceOptionsBuilder().build()));
    }

    public MetadataServiceOptionsNested<A> editOrNewMetadataServiceOptionsLike(MetadataServiceOptions item) {
        return this.withNewMetadataServiceOptionsLike(Optional.ofNullable(this.buildMetadataServiceOptions()).orElse(item));
    }

    public String getNetworkInterfaceType() {
        return this.networkInterfaceType;
    }

    public A withNetworkInterfaceType(String networkInterfaceType) {
        this.networkInterfaceType = networkInterfaceType;
        return (A)this;
    }

    public boolean hasNetworkInterfaceType() {
        return this.networkInterfaceType != null;
    }

    public Placement buildPlacement() {
        return this.placement != null ? this.placement.build() : null;
    }

    public A withPlacement(Placement placement) {
        this._visitables.remove("placement");
        if (placement != null) {
            this.placement = new PlacementBuilder(placement);
            this._visitables.get("placement").add(this.placement);
        } else {
            this.placement = null;
            this._visitables.get("placement").remove(this.placement);
        }
        return (A)this;
    }

    public boolean hasPlacement() {
        return this.placement != null;
    }

    public A withNewPlacement(String availabilityZone, String region, String tenancy) {
        return this.withPlacement(new Placement(availabilityZone, region, tenancy));
    }

    public PlacementNested<A> withNewPlacement() {
        return new PlacementNested(null);
    }

    public PlacementNested<A> withNewPlacementLike(Placement item) {
        return new PlacementNested(item);
    }

    public PlacementNested<A> editPlacement() {
        return this.withNewPlacementLike(Optional.ofNullable(this.buildPlacement()).orElse(null));
    }

    public PlacementNested<A> editOrNewPlacement() {
        return this.withNewPlacementLike(Optional.ofNullable(this.buildPlacement()).orElse(new PlacementBuilder().build()));
    }

    public PlacementNested<A> editOrNewPlacementLike(Placement item) {
        return this.withNewPlacementLike(Optional.ofNullable(this.buildPlacement()).orElse(item));
    }

    public String getPlacementGroupName() {
        return this.placementGroupName;
    }

    public A withPlacementGroupName(String placementGroupName) {
        this.placementGroupName = placementGroupName;
        return (A)this;
    }

    public boolean hasPlacementGroupName() {
        return this.placementGroupName != null;
    }

    public Integer getPlacementGroupPartition() {
        return this.placementGroupPartition;
    }

    public A withPlacementGroupPartition(Integer placementGroupPartition) {
        this.placementGroupPartition = placementGroupPartition;
        return (A)this;
    }

    public boolean hasPlacementGroupPartition() {
        return this.placementGroupPartition != null;
    }

    public Boolean getPublicIp() {
        return this.publicIp;
    }

    public A withPublicIp(Boolean publicIp) {
        this.publicIp = publicIp;
        return (A)this;
    }

    public boolean hasPublicIp() {
        return this.publicIp != null;
    }

    public A addToSecurityGroups(int index, AWSResourceReference item) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList();
        }
        AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);
        if (index < 0 || index >= this.securityGroups.size()) {
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(builder);
        } else {
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(index, builder);
        }
        return (A)this;
    }

    public A setToSecurityGroups(int index, AWSResourceReference item) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList();
        }
        AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);
        if (index < 0 || index >= this.securityGroups.size()) {
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(builder);
        } else {
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.set(index, builder);
        }
        return (A)this;
    }

    public A addToSecurityGroups(AWSResourceReference ... items) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList();
        }
        for (AWSResourceReference item : items) {
            AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(builder);
        }
        return (A)this;
    }

    public A addAllToSecurityGroups(Collection<AWSResourceReference> items) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList();
        }
        for (AWSResourceReference item : items) {
            AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(builder);
        }
        return (A)this;
    }

    public A removeFromSecurityGroups(AWSResourceReference ... items) {
        if (this.securityGroups == null) {
            return (A)this;
        }
        for (AWSResourceReference item : items) {
            AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);
            this._visitables.get("securityGroups").remove(builder);
            this.securityGroups.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSecurityGroups(Collection<AWSResourceReference> items) {
        if (this.securityGroups == null) {
            return (A)this;
        }
        for (AWSResourceReference item : items) {
            AWSResourceReferenceBuilder builder = new AWSResourceReferenceBuilder(item);
            this._visitables.get("securityGroups").remove(builder);
            this.securityGroups.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSecurityGroups(Predicate<AWSResourceReferenceBuilder> predicate) {
        if (this.securityGroups == null) {
            return (A)this;
        }
        Iterator<AWSResourceReferenceBuilder> each = this.securityGroups.iterator();
        Object visitables = this._visitables.get("securityGroups");
        while (each.hasNext()) {
            AWSResourceReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AWSResourceReference> buildSecurityGroups() {
        return this.securityGroups != null ? AWSMachineProviderConfigFluent.build(this.securityGroups) : null;
    }

    public AWSResourceReference buildSecurityGroup(int index) {
        return this.securityGroups.get(index).build();
    }

    public AWSResourceReference buildFirstSecurityGroup() {
        return this.securityGroups.get(0).build();
    }

    public AWSResourceReference buildLastSecurityGroup() {
        return this.securityGroups.get(this.securityGroups.size() - 1).build();
    }

    public AWSResourceReference buildMatchingSecurityGroup(Predicate<AWSResourceReferenceBuilder> predicate) {
        for (AWSResourceReferenceBuilder item : this.securityGroups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecurityGroup(Predicate<AWSResourceReferenceBuilder> predicate) {
        for (AWSResourceReferenceBuilder item : this.securityGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecurityGroups(List<AWSResourceReference> securityGroups) {
        if (this.securityGroups != null) {
            this._visitables.get("securityGroups").clear();
        }
        if (securityGroups != null) {
            this.securityGroups = new ArrayList();
            for (AWSResourceReference item : securityGroups) {
                this.addToSecurityGroups(item);
            }
        } else {
            this.securityGroups = null;
        }
        return (A)this;
    }

    public A withSecurityGroups(AWSResourceReference ... securityGroups) {
        if (this.securityGroups != null) {
            this.securityGroups.clear();
            this._visitables.remove("securityGroups");
        }
        if (securityGroups != null) {
            for (AWSResourceReference item : securityGroups) {
                this.addToSecurityGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasSecurityGroups() {
        return this.securityGroups != null && !this.securityGroups.isEmpty();
    }

    public SecurityGroupsNested<A> addNewSecurityGroup() {
        return new SecurityGroupsNested(-1, null);
    }

    public SecurityGroupsNested<A> addNewSecurityGroupLike(AWSResourceReference item) {
        return new SecurityGroupsNested(-1, item);
    }

    public SecurityGroupsNested<A> setNewSecurityGroupLike(int index, AWSResourceReference item) {
        return new SecurityGroupsNested(index, item);
    }

    public SecurityGroupsNested<A> editSecurityGroup(int index) {
        if (this.securityGroups.size() <= index) {
            throw new RuntimeException("Can't edit securityGroups. Index exceeds size.");
        }
        return this.setNewSecurityGroupLike(index, this.buildSecurityGroup(index));
    }

    public SecurityGroupsNested<A> editFirstSecurityGroup() {
        if (this.securityGroups.size() == 0) {
            throw new RuntimeException("Can't edit first securityGroups. The list is empty.");
        }
        return this.setNewSecurityGroupLike(0, this.buildSecurityGroup(0));
    }

    public SecurityGroupsNested<A> editLastSecurityGroup() {
        int index = this.securityGroups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last securityGroups. The list is empty.");
        }
        return this.setNewSecurityGroupLike(index, this.buildSecurityGroup(index));
    }

    public SecurityGroupsNested<A> editMatchingSecurityGroup(Predicate<AWSResourceReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.securityGroups.size(); ++i) {
            if (!predicate.test(this.securityGroups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching securityGroups. No match found.");
        }
        return this.setNewSecurityGroupLike(index, this.buildSecurityGroup(index));
    }

    public SpotMarketOptions buildSpotMarketOptions() {
        return this.spotMarketOptions != null ? this.spotMarketOptions.build() : null;
    }

    public A withSpotMarketOptions(SpotMarketOptions spotMarketOptions) {
        this._visitables.remove("spotMarketOptions");
        if (spotMarketOptions != null) {
            this.spotMarketOptions = new SpotMarketOptionsBuilder(spotMarketOptions);
            this._visitables.get("spotMarketOptions").add(this.spotMarketOptions);
        } else {
            this.spotMarketOptions = null;
            this._visitables.get("spotMarketOptions").remove(this.spotMarketOptions);
        }
        return (A)this;
    }

    public boolean hasSpotMarketOptions() {
        return this.spotMarketOptions != null;
    }

    public A withNewSpotMarketOptions(String maxPrice) {
        return this.withSpotMarketOptions(new SpotMarketOptions(maxPrice));
    }

    public SpotMarketOptionsNested<A> withNewSpotMarketOptions() {
        return new SpotMarketOptionsNested(null);
    }

    public SpotMarketOptionsNested<A> withNewSpotMarketOptionsLike(SpotMarketOptions item) {
        return new SpotMarketOptionsNested(item);
    }

    public SpotMarketOptionsNested<A> editSpotMarketOptions() {
        return this.withNewSpotMarketOptionsLike(Optional.ofNullable(this.buildSpotMarketOptions()).orElse(null));
    }

    public SpotMarketOptionsNested<A> editOrNewSpotMarketOptions() {
        return this.withNewSpotMarketOptionsLike(Optional.ofNullable(this.buildSpotMarketOptions()).orElse(new SpotMarketOptionsBuilder().build()));
    }

    public SpotMarketOptionsNested<A> editOrNewSpotMarketOptionsLike(SpotMarketOptions item) {
        return this.withNewSpotMarketOptionsLike(Optional.ofNullable(this.buildSpotMarketOptions()).orElse(item));
    }

    public AWSResourceReference buildSubnet() {
        return this.subnet != null ? this.subnet.build() : null;
    }

    public A withSubnet(AWSResourceReference subnet) {
        this._visitables.remove("subnet");
        if (subnet != null) {
            this.subnet = new AWSResourceReferenceBuilder(subnet);
            this._visitables.get("subnet").add(this.subnet);
        } else {
            this.subnet = null;
            this._visitables.get("subnet").remove(this.subnet);
        }
        return (A)this;
    }

    public boolean hasSubnet() {
        return this.subnet != null;
    }

    public SubnetNested<A> withNewSubnet() {
        return new SubnetNested(null);
    }

    public SubnetNested<A> withNewSubnetLike(AWSResourceReference item) {
        return new SubnetNested(item);
    }

    public SubnetNested<A> editSubnet() {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(null));
    }

    public SubnetNested<A> editOrNewSubnet() {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(new AWSResourceReferenceBuilder().build()));
    }

    public SubnetNested<A> editOrNewSubnetLike(AWSResourceReference item) {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(item));
    }

    public A addToTags(int index, TagSpecification item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        TagSpecificationBuilder builder = new TagSpecificationBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get("tags").add(builder);
            this.tags.add(index, builder);
        }
        return (A)this;
    }

    public A setToTags(int index, TagSpecification item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        TagSpecificationBuilder builder = new TagSpecificationBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get("tags").add(builder);
            this.tags.set(index, builder);
        }
        return (A)this;
    }

    public A addToTags(TagSpecification ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (TagSpecification item : items) {
            TagSpecificationBuilder builder = new TagSpecificationBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    public A addAllToTags(Collection<TagSpecification> items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (TagSpecification item : items) {
            TagSpecificationBuilder builder = new TagSpecificationBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    public A removeFromTags(TagSpecification ... items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (TagSpecification item : items) {
            TagSpecificationBuilder builder = new TagSpecificationBuilder(item);
            this._visitables.get("tags").remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTags(Collection<TagSpecification> items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (TagSpecification item : items) {
            TagSpecificationBuilder builder = new TagSpecificationBuilder(item);
            this._visitables.get("tags").remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTags(Predicate<TagSpecificationBuilder> predicate) {
        if (this.tags == null) {
            return (A)this;
        }
        Iterator<TagSpecificationBuilder> each = this.tags.iterator();
        Object visitables = this._visitables.get("tags");
        while (each.hasNext()) {
            TagSpecificationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<TagSpecification> buildTags() {
        return this.tags != null ? AWSMachineProviderConfigFluent.build(this.tags) : null;
    }

    public TagSpecification buildTag(int index) {
        return this.tags.get(index).build();
    }

    public TagSpecification buildFirstTag() {
        return this.tags.get(0).build();
    }

    public TagSpecification buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    public TagSpecification buildMatchingTag(Predicate<TagSpecificationBuilder> predicate) {
        for (TagSpecificationBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<TagSpecificationBuilder> predicate) {
        for (TagSpecificationBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<TagSpecification> tags) {
        if (this.tags != null) {
            this._visitables.get("tags").clear();
        }
        if (tags != null) {
            this.tags = new ArrayList();
            for (TagSpecification item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    public A withTags(TagSpecification ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove("tags");
        }
        if (tags != null) {
            for (TagSpecification item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public A addNewTag(String name, String value) {
        return this.addToTags(new TagSpecification(name, value));
    }

    public TagsNested<A> addNewTag() {
        return new TagsNested(-1, null);
    }

    public TagsNested<A> addNewTagLike(TagSpecification item) {
        return new TagsNested(-1, item);
    }

    public TagsNested<A> setNewTagLike(int index, TagSpecification item) {
        return new TagsNested(index, item);
    }

    public TagsNested<A> editTag(int index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException("Can't edit tags. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException("Can't edit first tags. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    public TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tags. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editMatchingTag(Predicate<TagSpecificationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.test(this.tags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tags. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public LocalObjectReference buildUserDataSecret() {
        return this.userDataSecret != null ? this.userDataSecret.build() : null;
    }

    public A withUserDataSecret(LocalObjectReference userDataSecret) {
        this._visitables.remove("userDataSecret");
        if (userDataSecret != null) {
            this.userDataSecret = new LocalObjectReferenceBuilder(userDataSecret);
            this._visitables.get("userDataSecret").add(this.userDataSecret);
        } else {
            this.userDataSecret = null;
            this._visitables.get("userDataSecret").remove(this.userDataSecret);
        }
        return (A)this;
    }

    public boolean hasUserDataSecret() {
        return this.userDataSecret != null;
    }

    public A withNewUserDataSecret(String name) {
        return this.withUserDataSecret(new LocalObjectReference(name));
    }

    public UserDataSecretNested<A> withNewUserDataSecret() {
        return new UserDataSecretNested(null);
    }

    public UserDataSecretNested<A> withNewUserDataSecretLike(LocalObjectReference item) {
        return new UserDataSecretNested(item);
    }

    public UserDataSecretNested<A> editUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(null));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecretLike(LocalObjectReference item) {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSMachineProviderConfigFluent that = (AWSMachineProviderConfigFluent)o;
        if (!Objects.equals(this.ami, that.ami)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.blockDevices, that.blockDevices)) {
            return false;
        }
        if (!Objects.equals(this.capacityReservationId, that.capacityReservationId)) {
            return false;
        }
        if (!Objects.equals(this.credentialsSecret, that.credentialsSecret)) {
            return false;
        }
        if (!Objects.equals(this.deviceIndex, that.deviceIndex)) {
            return false;
        }
        if (!Objects.equals(this.iamInstanceProfile, that.iamInstanceProfile)) {
            return false;
        }
        if (!Objects.equals(this.instanceType, that.instanceType)) {
            return false;
        }
        if (!Objects.equals(this.keyName, that.keyName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancers, that.loadBalancers)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.metadataServiceOptions, that.metadataServiceOptions)) {
            return false;
        }
        if (!Objects.equals(this.networkInterfaceType, that.networkInterfaceType)) {
            return false;
        }
        if (!Objects.equals(this.placement, that.placement)) {
            return false;
        }
        if (!Objects.equals(this.placementGroupName, that.placementGroupName)) {
            return false;
        }
        if (!Objects.equals(this.placementGroupPartition, that.placementGroupPartition)) {
            return false;
        }
        if (!Objects.equals(this.publicIp, that.publicIp)) {
            return false;
        }
        if (!Objects.equals(this.securityGroups, that.securityGroups)) {
            return false;
        }
        if (!Objects.equals(this.spotMarketOptions, that.spotMarketOptions)) {
            return false;
        }
        if (!Objects.equals(this.subnet, that.subnet)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.userDataSecret, that.userDataSecret)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ami, this.apiVersion, this.blockDevices, this.capacityReservationId, this.credentialsSecret, this.deviceIndex, this.iamInstanceProfile, this.instanceType, this.keyName, this.kind, this.loadBalancers, this.metadata, this.metadataServiceOptions, this.networkInterfaceType, this.placement, this.placementGroupName, this.placementGroupPartition, this.publicIp, this.securityGroups, this.spotMarketOptions, this.subnet, this.tags, this.userDataSecret, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ami != null) {
            sb.append("ami:");
            sb.append(String.valueOf(this.ami) + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.blockDevices != null && !this.blockDevices.isEmpty()) {
            sb.append("blockDevices:");
            sb.append(String.valueOf(this.blockDevices) + ",");
        }
        if (this.capacityReservationId != null) {
            sb.append("capacityReservationId:");
            sb.append(this.capacityReservationId + ",");
        }
        if (this.credentialsSecret != null) {
            sb.append("credentialsSecret:");
            sb.append(String.valueOf(this.credentialsSecret) + ",");
        }
        if (this.deviceIndex != null) {
            sb.append("deviceIndex:");
            sb.append(this.deviceIndex + ",");
        }
        if (this.iamInstanceProfile != null) {
            sb.append("iamInstanceProfile:");
            sb.append(String.valueOf(this.iamInstanceProfile) + ",");
        }
        if (this.instanceType != null) {
            sb.append("instanceType:");
            sb.append(this.instanceType + ",");
        }
        if (this.keyName != null) {
            sb.append("keyName:");
            sb.append(this.keyName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.loadBalancers != null && !this.loadBalancers.isEmpty()) {
            sb.append("loadBalancers:");
            sb.append(String.valueOf(this.loadBalancers) + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.metadataServiceOptions != null) {
            sb.append("metadataServiceOptions:");
            sb.append(String.valueOf(this.metadataServiceOptions) + ",");
        }
        if (this.networkInterfaceType != null) {
            sb.append("networkInterfaceType:");
            sb.append(this.networkInterfaceType + ",");
        }
        if (this.placement != null) {
            sb.append("placement:");
            sb.append(String.valueOf(this.placement) + ",");
        }
        if (this.placementGroupName != null) {
            sb.append("placementGroupName:");
            sb.append(this.placementGroupName + ",");
        }
        if (this.placementGroupPartition != null) {
            sb.append("placementGroupPartition:");
            sb.append(this.placementGroupPartition + ",");
        }
        if (this.publicIp != null) {
            sb.append("publicIp:");
            sb.append(this.publicIp + ",");
        }
        if (this.securityGroups != null && !this.securityGroups.isEmpty()) {
            sb.append("securityGroups:");
            sb.append(String.valueOf(this.securityGroups) + ",");
        }
        if (this.spotMarketOptions != null) {
            sb.append("spotMarketOptions:");
            sb.append(String.valueOf(this.spotMarketOptions) + ",");
        }
        if (this.subnet != null) {
            sb.append("subnet:");
            sb.append(String.valueOf(this.subnet) + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(String.valueOf(this.tags) + ",");
        }
        if (this.userDataSecret != null) {
            sb.append("userDataSecret:");
            sb.append(String.valueOf(this.userDataSecret) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPublicIp() {
        return this.withPublicIp(true);
    }

    public class UserDataSecretNested<N>
    extends LocalObjectReferenceFluent<UserDataSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        UserDataSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withUserDataSecret(this.builder.build());
        }

        public N endUserDataSecret() {
            return this.and();
        }
    }

    public class TagsNested<N>
    extends TagSpecificationFluent<TagsNested<N>>
    implements Nested<N> {
        TagSpecificationBuilder builder;
        int index;

        TagsNested(int index, TagSpecification item) {
            this.index = index;
            this.builder = new TagSpecificationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.setToTags(this.index, this.builder.build());
        }

        public N endTag() {
            return this.and();
        }
    }

    public class SubnetNested<N>
    extends AWSResourceReferenceFluent<SubnetNested<N>>
    implements Nested<N> {
        AWSResourceReferenceBuilder builder;

        SubnetNested(AWSResourceReference item) {
            this.builder = new AWSResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withSubnet(this.builder.build());
        }

        public N endSubnet() {
            return this.and();
        }
    }

    public class SpotMarketOptionsNested<N>
    extends SpotMarketOptionsFluent<SpotMarketOptionsNested<N>>
    implements Nested<N> {
        SpotMarketOptionsBuilder builder;

        SpotMarketOptionsNested(SpotMarketOptions item) {
            this.builder = new SpotMarketOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withSpotMarketOptions(this.builder.build());
        }

        public N endSpotMarketOptions() {
            return this.and();
        }
    }

    public class SecurityGroupsNested<N>
    extends AWSResourceReferenceFluent<SecurityGroupsNested<N>>
    implements Nested<N> {
        AWSResourceReferenceBuilder builder;
        int index;

        SecurityGroupsNested(int index, AWSResourceReference item) {
            this.index = index;
            this.builder = new AWSResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.setToSecurityGroups(this.index, this.builder.build());
        }

        public N endSecurityGroup() {
            return this.and();
        }
    }

    public class PlacementNested<N>
    extends PlacementFluent<PlacementNested<N>>
    implements Nested<N> {
        PlacementBuilder builder;

        PlacementNested(Placement item) {
            this.builder = new PlacementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withPlacement(this.builder.build());
        }

        public N endPlacement() {
            return this.and();
        }
    }

    public class MetadataServiceOptionsNested<N>
    extends MetadataServiceOptionsFluent<MetadataServiceOptionsNested<N>>
    implements Nested<N> {
        MetadataServiceOptionsBuilder builder;

        MetadataServiceOptionsNested(MetadataServiceOptions item) {
            this.builder = new MetadataServiceOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withMetadataServiceOptions(this.builder.build());
        }

        public N endMetadataServiceOptions() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class LoadBalancersNested<N>
    extends LoadBalancerReferenceFluent<LoadBalancersNested<N>>
    implements Nested<N> {
        LoadBalancerReferenceBuilder builder;
        int index;

        LoadBalancersNested(int index, LoadBalancerReference item) {
            this.index = index;
            this.builder = new LoadBalancerReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.setToLoadBalancers(this.index, this.builder.build());
        }

        public N endLoadBalancer() {
            return this.and();
        }
    }

    public class IamInstanceProfileNested<N>
    extends AWSResourceReferenceFluent<IamInstanceProfileNested<N>>
    implements Nested<N> {
        AWSResourceReferenceBuilder builder;

        IamInstanceProfileNested(AWSResourceReference item) {
            this.builder = new AWSResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withIamInstanceProfile(this.builder.build());
        }

        public N endIamInstanceProfile() {
            return this.and();
        }
    }

    public class CredentialsSecretNested<N>
    extends LocalObjectReferenceFluent<CredentialsSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withCredentialsSecret(this.builder.build());
        }

        public N endCredentialsSecret() {
            return this.and();
        }
    }

    public class BlockDevicesNested<N>
    extends BlockDeviceMappingSpecFluent<BlockDevicesNested<N>>
    implements Nested<N> {
        BlockDeviceMappingSpecBuilder builder;
        int index;

        BlockDevicesNested(int index, BlockDeviceMappingSpec item) {
            this.index = index;
            this.builder = new BlockDeviceMappingSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.setToBlockDevices(this.index, this.builder.build());
        }

        public N endBlockDevice() {
            return this.and();
        }
    }

    public class AmiNested<N>
    extends AWSResourceReferenceFluent<AmiNested<N>>
    implements Nested<N> {
        AWSResourceReferenceBuilder builder;

        AmiNested(AWSResourceReference item) {
            this.builder = new AWSResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSMachineProviderConfigFluent.this.withAmi(this.builder.build());
        }

        public N endAmi() {
            return this.and();
        }
    }
}

