/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.ProfileConfig;
import io.fabric8.openshift.api.model.tuned.v1.ProfileConfigBuilder;
import io.fabric8.openshift.api.model.tuned.v1.ProfileConfigFluent;
import io.fabric8.openshift.api.model.tuned.v1.ProfileSpec;
import io.fabric8.openshift.api.model.tuned.v1.TunedProfile;
import io.fabric8.openshift.api.model.tuned.v1.TunedProfileBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TunedProfileFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ProfileSpecFluent<A extends ProfileSpecFluent<A>>
extends BaseFluent<A> {
    private ProfileConfigBuilder config;
    private ArrayList<TunedProfileBuilder> profile = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ProfileSpecFluent() {
    }

    public ProfileSpecFluent(ProfileSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ProfileSpec instance) {
        ProfileSpec profileSpec = instance = instance != null ? instance : new ProfileSpec();
        if (instance != null) {
            this.withConfig(instance.getConfig());
            this.withProfile(instance.getProfile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ProfileConfig buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    public A withConfig(ProfileConfig config) {
        this._visitables.remove("config");
        if (config != null) {
            this.config = new ProfileConfigBuilder(config);
            this._visitables.get("config").add(this.config);
        } else {
            this.config = null;
            this._visitables.get("config").remove(this.config);
        }
        return (A)this;
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public ConfigNested<A> withNewConfig() {
        return new ConfigNested(null);
    }

    public ConfigNested<A> withNewConfigLike(ProfileConfig item) {
        return new ConfigNested(item);
    }

    public ConfigNested<A> editConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(null));
    }

    public ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(new ProfileConfigBuilder().build()));
    }

    public ConfigNested<A> editOrNewConfigLike(ProfileConfig item) {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(item));
    }

    public A addToProfile(int index, TunedProfile item) {
        if (this.profile == null) {
            this.profile = new ArrayList();
        }
        TunedProfileBuilder builder = new TunedProfileBuilder(item);
        if (index < 0 || index >= this.profile.size()) {
            this._visitables.get("profile").add(builder);
            this.profile.add(builder);
        } else {
            this._visitables.get("profile").add(builder);
            this.profile.add(index, builder);
        }
        return (A)this;
    }

    public A setToProfile(int index, TunedProfile item) {
        if (this.profile == null) {
            this.profile = new ArrayList();
        }
        TunedProfileBuilder builder = new TunedProfileBuilder(item);
        if (index < 0 || index >= this.profile.size()) {
            this._visitables.get("profile").add(builder);
            this.profile.add(builder);
        } else {
            this._visitables.get("profile").add(builder);
            this.profile.set(index, builder);
        }
        return (A)this;
    }

    public A addToProfile(TunedProfile ... items) {
        if (this.profile == null) {
            this.profile = new ArrayList();
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get("profile").add(builder);
            this.profile.add(builder);
        }
        return (A)this;
    }

    public A addAllToProfile(Collection<TunedProfile> items) {
        if (this.profile == null) {
            this.profile = new ArrayList();
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get("profile").add(builder);
            this.profile.add(builder);
        }
        return (A)this;
    }

    public A removeFromProfile(TunedProfile ... items) {
        if (this.profile == null) {
            return (A)this;
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get("profile").remove(builder);
            this.profile.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromProfile(Collection<TunedProfile> items) {
        if (this.profile == null) {
            return (A)this;
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get("profile").remove(builder);
            this.profile.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromProfile(Predicate<TunedProfileBuilder> predicate) {
        if (this.profile == null) {
            return (A)this;
        }
        Iterator<TunedProfileBuilder> each = this.profile.iterator();
        Object visitables = this._visitables.get("profile");
        while (each.hasNext()) {
            TunedProfileBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<TunedProfile> buildProfile() {
        return this.profile != null ? ProfileSpecFluent.build(this.profile) : null;
    }

    public TunedProfile buildProfile(int index) {
        return this.profile.get(index).build();
    }

    public TunedProfile buildFirstProfile() {
        return this.profile.get(0).build();
    }

    public TunedProfile buildLastProfile() {
        return this.profile.get(this.profile.size() - 1).build();
    }

    public TunedProfile buildMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        for (TunedProfileBuilder item : this.profile) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        for (TunedProfileBuilder item : this.profile) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProfile(List<TunedProfile> profile) {
        if (this.profile != null) {
            this._visitables.get("profile").clear();
        }
        if (profile != null) {
            this.profile = new ArrayList();
            for (TunedProfile item : profile) {
                this.addToProfile(item);
            }
        } else {
            this.profile = null;
        }
        return (A)this;
    }

    public A withProfile(TunedProfile ... profile) {
        if (this.profile != null) {
            this.profile.clear();
            this._visitables.remove("profile");
        }
        if (profile != null) {
            for (TunedProfile item : profile) {
                this.addToProfile(item);
            }
        }
        return (A)this;
    }

    public boolean hasProfile() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public A addNewProfile(String data, String name) {
        return this.addToProfile(new TunedProfile(data, name));
    }

    public ProfileNested<A> addNewProfile() {
        return new ProfileNested(-1, null);
    }

    public ProfileNested<A> addNewProfileLike(TunedProfile item) {
        return new ProfileNested(-1, item);
    }

    public ProfileNested<A> setNewProfileLike(int index, TunedProfile item) {
        return new ProfileNested(index, item);
    }

    public ProfileNested<A> editProfile(int index) {
        if (this.profile.size() <= index) {
            throw new RuntimeException("Can't edit profile. Index exceeds size.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public ProfileNested<A> editFirstProfile() {
        if (this.profile.size() == 0) {
            throw new RuntimeException("Can't edit first profile. The list is empty.");
        }
        return this.setNewProfileLike(0, this.buildProfile(0));
    }

    public ProfileNested<A> editLastProfile() {
        int index = this.profile.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last profile. The list is empty.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public ProfileNested<A> editMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.profile.size(); ++i) {
            if (!predicate.test(this.profile.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching profile. No match found.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProfileSpecFluent that = (ProfileSpecFluent)o;
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.config, this.profile, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.config != null) {
            sb.append("config:");
            sb.append(String.valueOf(this.config) + ",");
        }
        if (this.profile != null && !this.profile.isEmpty()) {
            sb.append("profile:");
            sb.append(String.valueOf(this.profile) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProfileNested<N>
    extends TunedProfileFluent<ProfileNested<N>>
    implements Nested<N> {
        TunedProfileBuilder builder;
        int index;

        ProfileNested(int index, TunedProfile item) {
            this.index = index;
            this.builder = new TunedProfileBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProfileSpecFluent.this.setToProfile(this.index, this.builder.build());
        }

        public N endProfile() {
            return this.and();
        }
    }

    public class ConfigNested<N>
    extends ProfileConfigFluent<ConfigNested<N>>
    implements Nested<N> {
        ProfileConfigBuilder builder;

        ConfigNested(ProfileConfig item) {
            this.builder = new ProfileConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProfileSpecFluent.this.withConfig(this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }
}

