/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedName;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedNameBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedNameFluent;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSNameResolverStatusFluent<A extends DNSNameResolverStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DNSNameResolverResolvedNameBuilder> resolvedNames = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DNSNameResolverStatusFluent() {
    }

    public DNSNameResolverStatusFluent(DNSNameResolverStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSNameResolverStatus instance) {
        DNSNameResolverStatus dNSNameResolverStatus = instance = instance != null ? instance : new DNSNameResolverStatus();
        if (instance != null) {
            this.withResolvedNames(instance.getResolvedNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToResolvedNames(int index, DNSNameResolverResolvedName item) {
        if (this.resolvedNames == null) {
            this.resolvedNames = new ArrayList();
        }
        DNSNameResolverResolvedNameBuilder builder = new DNSNameResolverResolvedNameBuilder(item);
        if (index < 0 || index >= this.resolvedNames.size()) {
            this._visitables.get("resolvedNames").add(builder);
            this.resolvedNames.add(builder);
        } else {
            this._visitables.get("resolvedNames").add(index, builder);
            this.resolvedNames.add(index, builder);
        }
        return (A)this;
    }

    public A setToResolvedNames(int index, DNSNameResolverResolvedName item) {
        if (this.resolvedNames == null) {
            this.resolvedNames = new ArrayList();
        }
        DNSNameResolverResolvedNameBuilder builder = new DNSNameResolverResolvedNameBuilder(item);
        if (index < 0 || index >= this.resolvedNames.size()) {
            this._visitables.get("resolvedNames").add(builder);
            this.resolvedNames.add(builder);
        } else {
            this._visitables.get("resolvedNames").set(index, builder);
            this.resolvedNames.set(index, builder);
        }
        return (A)this;
    }

    public A addToResolvedNames(DNSNameResolverResolvedName ... items) {
        if (this.resolvedNames == null) {
            this.resolvedNames = new ArrayList();
        }
        for (DNSNameResolverResolvedName item : items) {
            DNSNameResolverResolvedNameBuilder builder = new DNSNameResolverResolvedNameBuilder(item);
            this._visitables.get("resolvedNames").add(builder);
            this.resolvedNames.add(builder);
        }
        return (A)this;
    }

    public A addAllToResolvedNames(Collection<DNSNameResolverResolvedName> items) {
        if (this.resolvedNames == null) {
            this.resolvedNames = new ArrayList();
        }
        for (DNSNameResolverResolvedName item : items) {
            DNSNameResolverResolvedNameBuilder builder = new DNSNameResolverResolvedNameBuilder(item);
            this._visitables.get("resolvedNames").add(builder);
            this.resolvedNames.add(builder);
        }
        return (A)this;
    }

    public A removeFromResolvedNames(DNSNameResolverResolvedName ... items) {
        if (this.resolvedNames == null) {
            return (A)this;
        }
        for (DNSNameResolverResolvedName item : items) {
            DNSNameResolverResolvedNameBuilder builder = new DNSNameResolverResolvedNameBuilder(item);
            this._visitables.get("resolvedNames").remove(builder);
            this.resolvedNames.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResolvedNames(Collection<DNSNameResolverResolvedName> items) {
        if (this.resolvedNames == null) {
            return (A)this;
        }
        for (DNSNameResolverResolvedName item : items) {
            DNSNameResolverResolvedNameBuilder builder = new DNSNameResolverResolvedNameBuilder(item);
            this._visitables.get("resolvedNames").remove(builder);
            this.resolvedNames.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResolvedNames(Predicate<DNSNameResolverResolvedNameBuilder> predicate) {
        if (this.resolvedNames == null) {
            return (A)this;
        }
        Iterator<DNSNameResolverResolvedNameBuilder> each = this.resolvedNames.iterator();
        Object visitables = this._visitables.get("resolvedNames");
        while (each.hasNext()) {
            DNSNameResolverResolvedNameBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DNSNameResolverResolvedName> buildResolvedNames() {
        return this.resolvedNames != null ? DNSNameResolverStatusFluent.build(this.resolvedNames) : null;
    }

    public DNSNameResolverResolvedName buildResolvedName(int index) {
        return this.resolvedNames.get(index).build();
    }

    public DNSNameResolverResolvedName buildFirstResolvedName() {
        return this.resolvedNames.get(0).build();
    }

    public DNSNameResolverResolvedName buildLastResolvedName() {
        return this.resolvedNames.get(this.resolvedNames.size() - 1).build();
    }

    public DNSNameResolverResolvedName buildMatchingResolvedName(Predicate<DNSNameResolverResolvedNameBuilder> predicate) {
        for (DNSNameResolverResolvedNameBuilder item : this.resolvedNames) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResolvedName(Predicate<DNSNameResolverResolvedNameBuilder> predicate) {
        for (DNSNameResolverResolvedNameBuilder item : this.resolvedNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResolvedNames(List<DNSNameResolverResolvedName> resolvedNames) {
        if (this.resolvedNames != null) {
            this._visitables.get("resolvedNames").clear();
        }
        if (resolvedNames != null) {
            this.resolvedNames = new ArrayList();
            for (DNSNameResolverResolvedName item : resolvedNames) {
                this.addToResolvedNames(item);
            }
        } else {
            this.resolvedNames = null;
        }
        return (A)this;
    }

    public A withResolvedNames(DNSNameResolverResolvedName ... resolvedNames) {
        if (this.resolvedNames != null) {
            this.resolvedNames.clear();
            this._visitables.remove("resolvedNames");
        }
        if (resolvedNames != null) {
            for (DNSNameResolverResolvedName item : resolvedNames) {
                this.addToResolvedNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasResolvedNames() {
        return this.resolvedNames != null && !this.resolvedNames.isEmpty();
    }

    public ResolvedNamesNested<A> addNewResolvedName() {
        return new ResolvedNamesNested(-1, null);
    }

    public ResolvedNamesNested<A> addNewResolvedNameLike(DNSNameResolverResolvedName item) {
        return new ResolvedNamesNested(-1, item);
    }

    public ResolvedNamesNested<A> setNewResolvedNameLike(int index, DNSNameResolverResolvedName item) {
        return new ResolvedNamesNested(index, item);
    }

    public ResolvedNamesNested<A> editResolvedName(int index) {
        if (this.resolvedNames.size() <= index) {
            throw new RuntimeException("Can't edit resolvedNames. Index exceeds size.");
        }
        return this.setNewResolvedNameLike(index, this.buildResolvedName(index));
    }

    public ResolvedNamesNested<A> editFirstResolvedName() {
        if (this.resolvedNames.size() == 0) {
            throw new RuntimeException("Can't edit first resolvedNames. The list is empty.");
        }
        return this.setNewResolvedNameLike(0, this.buildResolvedName(0));
    }

    public ResolvedNamesNested<A> editLastResolvedName() {
        int index = this.resolvedNames.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resolvedNames. The list is empty.");
        }
        return this.setNewResolvedNameLike(index, this.buildResolvedName(index));
    }

    public ResolvedNamesNested<A> editMatchingResolvedName(Predicate<DNSNameResolverResolvedNameBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resolvedNames.size(); ++i) {
            if (!predicate.test(this.resolvedNames.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resolvedNames. No match found.");
        }
        return this.setNewResolvedNameLike(index, this.buildResolvedName(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSNameResolverStatusFluent that = (DNSNameResolverStatusFluent)o;
        if (!Objects.equals(this.resolvedNames, that.resolvedNames)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resolvedNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resolvedNames != null && !this.resolvedNames.isEmpty()) {
            sb.append("resolvedNames:");
            sb.append(this.resolvedNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResolvedNamesNested<N>
    extends DNSNameResolverResolvedNameFluent<ResolvedNamesNested<N>>
    implements Nested<N> {
        DNSNameResolverResolvedNameBuilder builder;
        int index;

        ResolvedNamesNested(int index, DNSNameResolverResolvedName item) {
            this.index = index;
            this.builder = new DNSNameResolverResolvedNameBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSNameResolverStatusFluent.this.setToResolvedNames(this.index, this.builder.build());
        }

        public N endResolvedName() {
            return this.and();
        }
    }
}

