/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.CustomDeploy;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.CustomDeployBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.CustomDeployFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.HostSelector;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.HostSelectorBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.HostSelectorFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.Image;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.ImageBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.ImageFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.Metal3MachineSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Metal3MachineSpecFluent<A extends Metal3MachineSpecFluent<A>>
extends BaseFluent<A> {
    private String automatedCleaningMode;
    private CustomDeployBuilder customDeploy;
    private ObjectReferenceBuilder dataTemplate;
    private HostSelectorBuilder hostSelector;
    private ImageBuilder image;
    private SecretReference metaData;
    private SecretReference networkData;
    private String providerID;
    private SecretReference userData;
    private Map<String, Object> additionalProperties;

    public Metal3MachineSpecFluent() {
    }

    public Metal3MachineSpecFluent(Metal3MachineSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Metal3MachineSpec instance) {
        Metal3MachineSpec metal3MachineSpec = instance = instance != null ? instance : new Metal3MachineSpec();
        if (instance != null) {
            this.withAutomatedCleaningMode(instance.getAutomatedCleaningMode());
            this.withCustomDeploy(instance.getCustomDeploy());
            this.withDataTemplate(instance.getDataTemplate());
            this.withHostSelector(instance.getHostSelector());
            this.withImage(instance.getImage());
            this.withMetaData(instance.getMetaData());
            this.withNetworkData(instance.getNetworkData());
            this.withProviderID(instance.getProviderID());
            this.withUserData(instance.getUserData());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAutomatedCleaningMode() {
        return this.automatedCleaningMode;
    }

    public A withAutomatedCleaningMode(String automatedCleaningMode) {
        this.automatedCleaningMode = automatedCleaningMode;
        return (A)this;
    }

    public boolean hasAutomatedCleaningMode() {
        return this.automatedCleaningMode != null;
    }

    public CustomDeploy buildCustomDeploy() {
        return this.customDeploy != null ? this.customDeploy.build() : null;
    }

    public A withCustomDeploy(CustomDeploy customDeploy) {
        this._visitables.remove("customDeploy");
        if (customDeploy != null) {
            this.customDeploy = new CustomDeployBuilder(customDeploy);
            this._visitables.get("customDeploy").add(this.customDeploy);
        } else {
            this.customDeploy = null;
            this._visitables.get("customDeploy").remove(this.customDeploy);
        }
        return (A)this;
    }

    public boolean hasCustomDeploy() {
        return this.customDeploy != null;
    }

    public A withNewCustomDeploy(String method) {
        return this.withCustomDeploy(new CustomDeploy(method));
    }

    public CustomDeployNested<A> withNewCustomDeploy() {
        return new CustomDeployNested(null);
    }

    public CustomDeployNested<A> withNewCustomDeployLike(CustomDeploy item) {
        return new CustomDeployNested(item);
    }

    public CustomDeployNested<A> editCustomDeploy() {
        return this.withNewCustomDeployLike(Optional.ofNullable(this.buildCustomDeploy()).orElse(null));
    }

    public CustomDeployNested<A> editOrNewCustomDeploy() {
        return this.withNewCustomDeployLike(Optional.ofNullable(this.buildCustomDeploy()).orElse(new CustomDeployBuilder().build()));
    }

    public CustomDeployNested<A> editOrNewCustomDeployLike(CustomDeploy item) {
        return this.withNewCustomDeployLike(Optional.ofNullable(this.buildCustomDeploy()).orElse(item));
    }

    public ObjectReference buildDataTemplate() {
        return this.dataTemplate != null ? this.dataTemplate.build() : null;
    }

    public A withDataTemplate(ObjectReference dataTemplate) {
        this._visitables.remove("dataTemplate");
        if (dataTemplate != null) {
            this.dataTemplate = new ObjectReferenceBuilder(dataTemplate);
            this._visitables.get("dataTemplate").add(this.dataTemplate);
        } else {
            this.dataTemplate = null;
            this._visitables.get("dataTemplate").remove(this.dataTemplate);
        }
        return (A)this;
    }

    public boolean hasDataTemplate() {
        return this.dataTemplate != null;
    }

    public DataTemplateNested<A> withNewDataTemplate() {
        return new DataTemplateNested(null);
    }

    public DataTemplateNested<A> withNewDataTemplateLike(ObjectReference item) {
        return new DataTemplateNested(item);
    }

    public DataTemplateNested<A> editDataTemplate() {
        return this.withNewDataTemplateLike(Optional.ofNullable(this.buildDataTemplate()).orElse(null));
    }

    public DataTemplateNested<A> editOrNewDataTemplate() {
        return this.withNewDataTemplateLike(Optional.ofNullable(this.buildDataTemplate()).orElse(new ObjectReferenceBuilder().build()));
    }

    public DataTemplateNested<A> editOrNewDataTemplateLike(ObjectReference item) {
        return this.withNewDataTemplateLike(Optional.ofNullable(this.buildDataTemplate()).orElse(item));
    }

    public HostSelector buildHostSelector() {
        return this.hostSelector != null ? this.hostSelector.build() : null;
    }

    public A withHostSelector(HostSelector hostSelector) {
        this._visitables.remove("hostSelector");
        if (hostSelector != null) {
            this.hostSelector = new HostSelectorBuilder(hostSelector);
            this._visitables.get("hostSelector").add(this.hostSelector);
        } else {
            this.hostSelector = null;
            this._visitables.get("hostSelector").remove(this.hostSelector);
        }
        return (A)this;
    }

    public boolean hasHostSelector() {
        return this.hostSelector != null;
    }

    public HostSelectorNested<A> withNewHostSelector() {
        return new HostSelectorNested(null);
    }

    public HostSelectorNested<A> withNewHostSelectorLike(HostSelector item) {
        return new HostSelectorNested(item);
    }

    public HostSelectorNested<A> editHostSelector() {
        return this.withNewHostSelectorLike(Optional.ofNullable(this.buildHostSelector()).orElse(null));
    }

    public HostSelectorNested<A> editOrNewHostSelector() {
        return this.withNewHostSelectorLike(Optional.ofNullable(this.buildHostSelector()).orElse(new HostSelectorBuilder().build()));
    }

    public HostSelectorNested<A> editOrNewHostSelectorLike(HostSelector item) {
        return this.withNewHostSelectorLike(Optional.ofNullable(this.buildHostSelector()).orElse(item));
    }

    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    public A withImage(Image image) {
        this._visitables.remove("image");
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get("image").remove(this.image);
        }
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String checksum, String checksumType, String format, String url) {
        return this.withImage(new Image(checksum, checksumType, format, url));
    }

    public ImageNested<A> withNewImage() {
        return new ImageNested(null);
    }

    public ImageNested<A> withNewImageLike(Image item) {
        return new ImageNested(item);
    }

    public ImageNested<A> editImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(null));
    }

    public ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(new ImageBuilder().build()));
    }

    public ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(item));
    }

    public SecretReference getMetaData() {
        return this.metaData;
    }

    public A withMetaData(SecretReference metaData) {
        this.metaData = metaData;
        return (A)this;
    }

    public boolean hasMetaData() {
        return this.metaData != null;
    }

    public A withNewMetaData(String name, String namespace) {
        return this.withMetaData(new SecretReference(name, namespace));
    }

    public SecretReference getNetworkData() {
        return this.networkData;
    }

    public A withNetworkData(SecretReference networkData) {
        this.networkData = networkData;
        return (A)this;
    }

    public boolean hasNetworkData() {
        return this.networkData != null;
    }

    public A withNewNetworkData(String name, String namespace) {
        return this.withNetworkData(new SecretReference(name, namespace));
    }

    public String getProviderID() {
        return this.providerID;
    }

    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)this;
    }

    public boolean hasProviderID() {
        return this.providerID != null;
    }

    public SecretReference getUserData() {
        return this.userData;
    }

    public A withUserData(SecretReference userData) {
        this.userData = userData;
        return (A)this;
    }

    public boolean hasUserData() {
        return this.userData != null;
    }

    public A withNewUserData(String name, String namespace) {
        return this.withUserData(new SecretReference(name, namespace));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Metal3MachineSpecFluent that = (Metal3MachineSpecFluent)o;
        if (!Objects.equals(this.automatedCleaningMode, that.automatedCleaningMode)) {
            return false;
        }
        if (!Objects.equals(this.customDeploy, that.customDeploy)) {
            return false;
        }
        if (!Objects.equals(this.dataTemplate, that.dataTemplate)) {
            return false;
        }
        if (!Objects.equals(this.hostSelector, that.hostSelector)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.metaData, that.metaData)) {
            return false;
        }
        if (!Objects.equals(this.networkData, that.networkData)) {
            return false;
        }
        if (!Objects.equals(this.providerID, that.providerID)) {
            return false;
        }
        if (!Objects.equals(this.userData, that.userData)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.automatedCleaningMode, this.customDeploy, this.dataTemplate, this.hostSelector, this.image, this.metaData, this.networkData, this.providerID, this.userData, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.automatedCleaningMode != null) {
            sb.append("automatedCleaningMode:");
            sb.append(this.automatedCleaningMode + ",");
        }
        if (this.customDeploy != null) {
            sb.append("customDeploy:");
            sb.append(this.customDeploy + ",");
        }
        if (this.dataTemplate != null) {
            sb.append("dataTemplate:");
            sb.append(this.dataTemplate + ",");
        }
        if (this.hostSelector != null) {
            sb.append("hostSelector:");
            sb.append(this.hostSelector + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.metaData != null) {
            sb.append("metaData:");
            sb.append(this.metaData + ",");
        }
        if (this.networkData != null) {
            sb.append("networkData:");
            sb.append(this.networkData + ",");
        }
        if (this.providerID != null) {
            sb.append("providerID:");
            sb.append(this.providerID + ",");
        }
        if (this.userData != null) {
            sb.append("userData:");
            sb.append(this.userData + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ImageNested<N>
    extends ImageFluent<ImageNested<N>>
    implements Nested<N> {
        ImageBuilder builder;

        ImageNested(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)Metal3MachineSpecFluent.this.withImage(this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }

    public class HostSelectorNested<N>
    extends HostSelectorFluent<HostSelectorNested<N>>
    implements Nested<N> {
        HostSelectorBuilder builder;

        HostSelectorNested(HostSelector item) {
            this.builder = new HostSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)Metal3MachineSpecFluent.this.withHostSelector(this.builder.build());
        }

        public N endHostSelector() {
            return this.and();
        }
    }

    public class DataTemplateNested<N>
    extends ObjectReferenceFluent<DataTemplateNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        DataTemplateNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)Metal3MachineSpecFluent.this.withDataTemplate(this.builder.build());
        }

        public N endDataTemplate() {
            return this.and();
        }
    }

    public class CustomDeployNested<N>
    extends CustomDeployFluent<CustomDeployNested<N>>
    implements Nested<N> {
        CustomDeployBuilder builder;

        CustomDeployNested(CustomDeploy item) {
            this.builder = new CustomDeployBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)Metal3MachineSpecFluent.this.withCustomDeploy(this.builder.build());
        }

        public N endCustomDeploy() {
            return this.and();
        }
    }
}

