/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.BlockDeviceMappingSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.EBSBlockDeviceSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.EBSBlockDeviceSpecBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.EBSBlockDeviceSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BlockDeviceMappingSpecFluent<A extends BlockDeviceMappingSpecFluent<A>>
extends BaseFluent<A> {
    private String deviceName;
    private EBSBlockDeviceSpecBuilder ebs;
    private String noDevice;
    private String virtualName;
    private Map<String, Object> additionalProperties;

    public BlockDeviceMappingSpecFluent() {
    }

    public BlockDeviceMappingSpecFluent(BlockDeviceMappingSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BlockDeviceMappingSpec instance) {
        BlockDeviceMappingSpec blockDeviceMappingSpec = instance = instance != null ? instance : new BlockDeviceMappingSpec();
        if (instance != null) {
            this.withDeviceName(instance.getDeviceName());
            this.withEbs(instance.getEbs());
            this.withNoDevice(instance.getNoDevice());
            this.withVirtualName(instance.getVirtualName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public A withDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return (A)this;
    }

    public boolean hasDeviceName() {
        return this.deviceName != null;
    }

    public EBSBlockDeviceSpec buildEbs() {
        return this.ebs != null ? this.ebs.build() : null;
    }

    public A withEbs(EBSBlockDeviceSpec ebs) {
        this._visitables.remove("ebs");
        if (ebs != null) {
            this.ebs = new EBSBlockDeviceSpecBuilder(ebs);
            this._visitables.get("ebs").add(this.ebs);
        } else {
            this.ebs = null;
            this._visitables.get("ebs").remove(this.ebs);
        }
        return (A)this;
    }

    public boolean hasEbs() {
        return this.ebs != null;
    }

    public EbsNested<A> withNewEbs() {
        return new EbsNested(null);
    }

    public EbsNested<A> withNewEbsLike(EBSBlockDeviceSpec item) {
        return new EbsNested(item);
    }

    public EbsNested<A> editEbs() {
        return this.withNewEbsLike(Optional.ofNullable(this.buildEbs()).orElse(null));
    }

    public EbsNested<A> editOrNewEbs() {
        return this.withNewEbsLike(Optional.ofNullable(this.buildEbs()).orElse(new EBSBlockDeviceSpecBuilder().build()));
    }

    public EbsNested<A> editOrNewEbsLike(EBSBlockDeviceSpec item) {
        return this.withNewEbsLike(Optional.ofNullable(this.buildEbs()).orElse(item));
    }

    public String getNoDevice() {
        return this.noDevice;
    }

    public A withNoDevice(String noDevice) {
        this.noDevice = noDevice;
        return (A)this;
    }

    public boolean hasNoDevice() {
        return this.noDevice != null;
    }

    public String getVirtualName() {
        return this.virtualName;
    }

    public A withVirtualName(String virtualName) {
        this.virtualName = virtualName;
        return (A)this;
    }

    public boolean hasVirtualName() {
        return this.virtualName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockDeviceMappingSpecFluent that = (BlockDeviceMappingSpecFluent)o;
        if (!Objects.equals(this.deviceName, that.deviceName)) {
            return false;
        }
        if (!Objects.equals(this.ebs, that.ebs)) {
            return false;
        }
        if (!Objects.equals(this.noDevice, that.noDevice)) {
            return false;
        }
        if (!Objects.equals(this.virtualName, that.virtualName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.deviceName, this.ebs, this.noDevice, this.virtualName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deviceName != null) {
            sb.append("deviceName:");
            sb.append(this.deviceName + ",");
        }
        if (this.ebs != null) {
            sb.append("ebs:");
            sb.append(this.ebs + ",");
        }
        if (this.noDevice != null) {
            sb.append("noDevice:");
            sb.append(this.noDevice + ",");
        }
        if (this.virtualName != null) {
            sb.append("virtualName:");
            sb.append(this.virtualName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EbsNested<N>
    extends EBSBlockDeviceSpecFluent<EbsNested<N>>
    implements Nested<N> {
        EBSBlockDeviceSpecBuilder builder;

        EbsNested(EBSBlockDeviceSpec item) {
            this.builder = new EBSBlockDeviceSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BlockDeviceMappingSpecFluent.this.withEbs(this.builder.build());
        }

        public N endEbs() {
            return this.and();
        }
    }
}

