/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.AWSDNSZoneStatus;
import io.fabric8.openshift.api.model.hive.v1.AWSDNSZoneStatusBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSDNSZoneStatusFluent;
import io.fabric8.openshift.api.model.hive.v1.AzureDNSZoneStatus;
import io.fabric8.openshift.api.model.hive.v1.AzureDNSZoneStatusBuilder;
import io.fabric8.openshift.api.model.hive.v1.AzureDNSZoneStatusFluent;
import io.fabric8.openshift.api.model.hive.v1.DNSZoneCondition;
import io.fabric8.openshift.api.model.hive.v1.DNSZoneConditionBuilder;
import io.fabric8.openshift.api.model.hive.v1.DNSZoneConditionFluent;
import io.fabric8.openshift.api.model.hive.v1.DNSZoneStatus;
import io.fabric8.openshift.api.model.hive.v1.GCPDNSZoneStatus;
import io.fabric8.openshift.api.model.hive.v1.GCPDNSZoneStatusBuilder;
import io.fabric8.openshift.api.model.hive.v1.GCPDNSZoneStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DNSZoneStatusFluent<A extends DNSZoneStatusFluent<A>>
extends BaseFluent<A> {
    private AWSDNSZoneStatusBuilder aws;
    private AzureDNSZoneStatusBuilder azure;
    private ArrayList<DNSZoneConditionBuilder> conditions = new ArrayList();
    private GCPDNSZoneStatusBuilder gcp;
    private Long lastSyncGeneration;
    private String lastSyncTimestamp;
    private List<String> nameServers = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public DNSZoneStatusFluent() {
    }

    public DNSZoneStatusFluent(DNSZoneStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSZoneStatus instance) {
        DNSZoneStatus dNSZoneStatus = instance = instance != null ? instance : new DNSZoneStatus();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withConditions(instance.getConditions());
            this.withGcp(instance.getGcp());
            this.withLastSyncGeneration(instance.getLastSyncGeneration());
            this.withLastSyncTimestamp(instance.getLastSyncTimestamp());
            this.withNameServers(instance.getNameServers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AWSDNSZoneStatus buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    public A withAws(AWSDNSZoneStatus aws) {
        this._visitables.remove("aws");
        if (aws != null) {
            this.aws = new AWSDNSZoneStatusBuilder(aws);
            this._visitables.get("aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get("aws").remove(this.aws);
        }
        return (A)this;
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public A withNewAws(String zoneID) {
        return this.withAws(new AWSDNSZoneStatus(zoneID));
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public AwsNested<A> withNewAwsLike(AWSDNSZoneStatus item) {
        return new AwsNested(item);
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new AWSDNSZoneStatusBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(AWSDNSZoneStatus item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public AzureDNSZoneStatus buildAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    public A withAzure(AzureDNSZoneStatus azure) {
        this._visitables.remove("azure");
        if (azure != null) {
            this.azure = new AzureDNSZoneStatusBuilder(azure);
            this._visitables.get("azure").add(this.azure);
        } else {
            this.azure = null;
            this._visitables.get("azure").remove(this.azure);
        }
        return (A)this;
    }

    public boolean hasAzure() {
        return this.azure != null;
    }

    public AzureNested<A> withNewAzure() {
        return new AzureNested(null);
    }

    public AzureNested<A> withNewAzureLike(AzureDNSZoneStatus item) {
        return new AzureNested(item);
    }

    public AzureNested<A> editAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(null));
    }

    public AzureNested<A> editOrNewAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(new AzureDNSZoneStatusBuilder().build()));
    }

    public AzureNested<A> editOrNewAzureLike(AzureDNSZoneStatus item) {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(item));
    }

    public A addToConditions(int index, DNSZoneCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, DNSZoneCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(DNSZoneCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<DNSZoneCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(DNSZoneCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<DNSZoneCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<DNSZoneConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<DNSZoneConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            DNSZoneConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DNSZoneCondition> buildConditions() {
        return this.conditions != null ? DNSZoneStatusFluent.build(this.conditions) : null;
    }

    public DNSZoneCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public DNSZoneCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public DNSZoneCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public DNSZoneCondition buildMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        for (DNSZoneConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        for (DNSZoneConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<DNSZoneCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (DNSZoneCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(DNSZoneCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (DNSZoneCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(DNSZoneCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, DNSZoneCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public GCPDNSZoneStatus buildGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    public A withGcp(GCPDNSZoneStatus gcp) {
        this._visitables.remove("gcp");
        if (gcp != null) {
            this.gcp = new GCPDNSZoneStatusBuilder(gcp);
            this._visitables.get("gcp").add(this.gcp);
        } else {
            this.gcp = null;
            this._visitables.get("gcp").remove(this.gcp);
        }
        return (A)this;
    }

    public boolean hasGcp() {
        return this.gcp != null;
    }

    public A withNewGcp(String zoneName) {
        return this.withGcp(new GCPDNSZoneStatus(zoneName));
    }

    public GcpNested<A> withNewGcp() {
        return new GcpNested(null);
    }

    public GcpNested<A> withNewGcpLike(GCPDNSZoneStatus item) {
        return new GcpNested(item);
    }

    public GcpNested<A> editGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(null));
    }

    public GcpNested<A> editOrNewGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(new GCPDNSZoneStatusBuilder().build()));
    }

    public GcpNested<A> editOrNewGcpLike(GCPDNSZoneStatus item) {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(item));
    }

    public Long getLastSyncGeneration() {
        return this.lastSyncGeneration;
    }

    public A withLastSyncGeneration(Long lastSyncGeneration) {
        this.lastSyncGeneration = lastSyncGeneration;
        return (A)this;
    }

    public boolean hasLastSyncGeneration() {
        return this.lastSyncGeneration != null;
    }

    public String getLastSyncTimestamp() {
        return this.lastSyncTimestamp;
    }

    public A withLastSyncTimestamp(String lastSyncTimestamp) {
        this.lastSyncTimestamp = lastSyncTimestamp;
        return (A)this;
    }

    public boolean hasLastSyncTimestamp() {
        return this.lastSyncTimestamp != null;
    }

    public A addToNameServers(int index, String item) {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        this.nameServers.add(index, item);
        return (A)this;
    }

    public A setToNameServers(int index, String item) {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        this.nameServers.set(index, item);
        return (A)this;
    }

    public A addToNameServers(String ... items) {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameServers.add(item);
        }
        return (A)this;
    }

    public A addAllToNameServers(Collection<String> items) {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameServers.add(item);
        }
        return (A)this;
    }

    public A removeFromNameServers(String ... items) {
        if (this.nameServers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nameServers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNameServers(Collection<String> items) {
        if (this.nameServers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nameServers.remove(item);
        }
        return (A)this;
    }

    public List<String> getNameServers() {
        return this.nameServers;
    }

    public String getNameServer(int index) {
        return this.nameServers.get(index);
    }

    public String getFirstNameServer() {
        return this.nameServers.get(0);
    }

    public String getLastNameServer() {
        return this.nameServers.get(this.nameServers.size() - 1);
    }

    public String getMatchingNameServer(Predicate<String> predicate) {
        for (String item : this.nameServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNameServer(Predicate<String> predicate) {
        for (String item : this.nameServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNameServers(List<String> nameServers) {
        if (nameServers != null) {
            this.nameServers = new ArrayList<String>();
            for (String item : nameServers) {
                this.addToNameServers(item);
            }
        } else {
            this.nameServers = null;
        }
        return (A)this;
    }

    public A withNameServers(String ... nameServers) {
        if (this.nameServers != null) {
            this.nameServers.clear();
            this._visitables.remove("nameServers");
        }
        if (nameServers != null) {
            for (String item : nameServers) {
                this.addToNameServers(item);
            }
        }
        return (A)this;
    }

    public boolean hasNameServers() {
        return this.nameServers != null && !this.nameServers.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSZoneStatusFluent that = (DNSZoneStatusFluent)o;
        if (!Objects.equals(this.aws, that.aws)) {
            return false;
        }
        if (!Objects.equals(this.azure, that.azure)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.gcp, that.gcp)) {
            return false;
        }
        if (!Objects.equals(this.lastSyncGeneration, that.lastSyncGeneration)) {
            return false;
        }
        if (!Objects.equals(this.lastSyncTimestamp, that.lastSyncTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.nameServers, that.nameServers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aws, this.azure, this.conditions, this.gcp, this.lastSyncGeneration, this.lastSyncTimestamp, this.nameServers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append(this.aws + ",");
        }
        if (this.azure != null) {
            sb.append("azure:");
            sb.append(this.azure + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.gcp != null) {
            sb.append("gcp:");
            sb.append(this.gcp + ",");
        }
        if (this.lastSyncGeneration != null) {
            sb.append("lastSyncGeneration:");
            sb.append(this.lastSyncGeneration + ",");
        }
        if (this.lastSyncTimestamp != null) {
            sb.append("lastSyncTimestamp:");
            sb.append(this.lastSyncTimestamp + ",");
        }
        if (this.nameServers != null && !this.nameServers.isEmpty()) {
            sb.append("nameServers:");
            sb.append(this.nameServers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class GcpNested<N>
    extends GCPDNSZoneStatusFluent<GcpNested<N>>
    implements Nested<N> {
        GCPDNSZoneStatusBuilder builder;

        GcpNested(GCPDNSZoneStatus item) {
            this.builder = new GCPDNSZoneStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluent.this.withGcp(this.builder.build());
        }

        public N endGcp() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends DNSZoneConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        DNSZoneConditionBuilder builder;
        int index;

        ConditionsNested(int index, DNSZoneCondition item) {
            this.index = index;
            this.builder = new DNSZoneConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AzureNested<N>
    extends AzureDNSZoneStatusFluent<AzureNested<N>>
    implements Nested<N> {
        AzureDNSZoneStatusBuilder builder;

        AzureNested(AzureDNSZoneStatus item) {
            this.builder = new AzureDNSZoneStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluent.this.withAzure(this.builder.build());
        }

        public N endAzure() {
            return this.and();
        }
    }

    public class AwsNested<N>
    extends AWSDNSZoneStatusFluent<AwsNested<N>>
    implements Nested<N> {
        AWSDNSZoneStatusBuilder builder;

        AwsNested(AWSDNSZoneStatus item) {
            this.builder = new AWSDNSZoneStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

