/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.Device;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.ResourcePool;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.ResourcePoolBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.ResourcePoolFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.ResourceSliceSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ResourceSliceSpecFluent<A extends ResourceSliceSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean allNodes;
    private ArrayList<DeviceBuilder> devices = new ArrayList();
    private String driver;
    private String nodeName;
    private NodeSelector nodeSelector;
    private ResourcePoolBuilder pool;
    private Map<String, Object> additionalProperties;

    public ResourceSliceSpecFluent() {
    }

    public ResourceSliceSpecFluent(ResourceSliceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceSliceSpec instance) {
        ResourceSliceSpec resourceSliceSpec = instance = instance != null ? instance : new ResourceSliceSpec();
        if (instance != null) {
            this.withAllNodes(instance.getAllNodes());
            this.withDevices(instance.getDevices());
            this.withDriver(instance.getDriver());
            this.withNodeName(instance.getNodeName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPool(instance.getPool());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public A withAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return (A)this;
    }

    public boolean hasAllNodes() {
        return this.allNodes != null;
    }

    public A addToDevices(int index, Device item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        DeviceBuilder builder = new DeviceBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get("devices").add(index, builder);
            this.devices.add(index, builder);
        }
        return (A)this;
    }

    public A setToDevices(int index, Device item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        DeviceBuilder builder = new DeviceBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get("devices").set(index, builder);
            this.devices.set(index, builder);
        }
        return (A)this;
    }

    public A addToDevices(Device ... items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (Device item : items) {
            DeviceBuilder builder = new DeviceBuilder(item);
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        }
        return (A)this;
    }

    public A addAllToDevices(Collection<Device> items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (Device item : items) {
            DeviceBuilder builder = new DeviceBuilder(item);
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        }
        return (A)this;
    }

    public A removeFromDevices(Device ... items) {
        if (this.devices == null) {
            return (A)this;
        }
        for (Device item : items) {
            DeviceBuilder builder = new DeviceBuilder(item);
            this._visitables.get("devices").remove(builder);
            this.devices.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDevices(Collection<Device> items) {
        if (this.devices == null) {
            return (A)this;
        }
        for (Device item : items) {
            DeviceBuilder builder = new DeviceBuilder(item);
            this._visitables.get("devices").remove(builder);
            this.devices.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDevices(Predicate<DeviceBuilder> predicate) {
        if (this.devices == null) {
            return (A)this;
        }
        Iterator<DeviceBuilder> each = this.devices.iterator();
        Object visitables = this._visitables.get("devices");
        while (each.hasNext()) {
            DeviceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Device> buildDevices() {
        return this.devices != null ? ResourceSliceSpecFluent.build(this.devices) : null;
    }

    public Device buildDevice(int index) {
        return this.devices.get(index).build();
    }

    public Device buildFirstDevice() {
        return this.devices.get(0).build();
    }

    public Device buildLastDevice() {
        return this.devices.get(this.devices.size() - 1).build();
    }

    public Device buildMatchingDevice(Predicate<DeviceBuilder> predicate) {
        for (DeviceBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDevice(Predicate<DeviceBuilder> predicate) {
        for (DeviceBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDevices(List<Device> devices) {
        if (this.devices != null) {
            this._visitables.get("devices").clear();
        }
        if (devices != null) {
            this.devices = new ArrayList();
            for (Device item : devices) {
                this.addToDevices(item);
            }
        } else {
            this.devices = null;
        }
        return (A)this;
    }

    public A withDevices(Device ... devices) {
        if (this.devices != null) {
            this.devices.clear();
            this._visitables.remove("devices");
        }
        if (devices != null) {
            for (Device item : devices) {
                this.addToDevices(item);
            }
        }
        return (A)this;
    }

    public boolean hasDevices() {
        return this.devices != null && !this.devices.isEmpty();
    }

    public DevicesNested<A> addNewDevice() {
        return new DevicesNested(-1, null);
    }

    public DevicesNested<A> addNewDeviceLike(Device item) {
        return new DevicesNested(-1, item);
    }

    public DevicesNested<A> setNewDeviceLike(int index, Device item) {
        return new DevicesNested(index, item);
    }

    public DevicesNested<A> editDevice(int index) {
        if (this.devices.size() <= index) {
            throw new RuntimeException("Can't edit devices. Index exceeds size.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editFirstDevice() {
        if (this.devices.size() == 0) {
            throw new RuntimeException("Can't edit first devices. The list is empty.");
        }
        return this.setNewDeviceLike(0, this.buildDevice(0));
    }

    public DevicesNested<A> editLastDevice() {
        int index = this.devices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last devices. The list is empty.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editMatchingDevice(Predicate<DeviceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!predicate.test(this.devices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching devices. No match found.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public A withNodeSelector(NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public ResourcePool buildPool() {
        return this.pool != null ? this.pool.build() : null;
    }

    public A withPool(ResourcePool pool) {
        this._visitables.remove("pool");
        if (pool != null) {
            this.pool = new ResourcePoolBuilder(pool);
            this._visitables.get("pool").add(this.pool);
        } else {
            this.pool = null;
            this._visitables.get("pool").remove(this.pool);
        }
        return (A)this;
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public A withNewPool(Long generation, String name, Long resourceSliceCount) {
        return this.withPool(new ResourcePool(generation, name, resourceSliceCount));
    }

    public PoolNested<A> withNewPool() {
        return new PoolNested(null);
    }

    public PoolNested<A> withNewPoolLike(ResourcePool item) {
        return new PoolNested(item);
    }

    public PoolNested<A> editPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(null));
    }

    public PoolNested<A> editOrNewPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(new ResourcePoolBuilder().build()));
    }

    public PoolNested<A> editOrNewPoolLike(ResourcePool item) {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceSliceSpecFluent that = (ResourceSliceSpecFluent)o;
        if (!Objects.equals(this.allNodes, that.allNodes)) {
            return false;
        }
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allNodes, this.devices, this.driver, this.nodeName, this.nodeSelector, this.pool, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allNodes != null) {
            sb.append("allNodes:");
            sb.append(this.allNodes + ",");
        }
        if (this.devices != null && !this.devices.isEmpty()) {
            sb.append("devices:");
            sb.append(this.devices + ",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllNodes() {
        return this.withAllNodes(true);
    }

    public class PoolNested<N>
    extends ResourcePoolFluent<PoolNested<N>>
    implements Nested<N> {
        ResourcePoolBuilder builder;

        PoolNested(ResourcePool item) {
            this.builder = new ResourcePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceSliceSpecFluent.this.withPool(this.builder.build());
        }

        public N endPool() {
            return this.and();
        }
    }

    public class DevicesNested<N>
    extends DeviceFluent<DevicesNested<N>>
    implements Nested<N> {
        DeviceBuilder builder;
        int index;

        DevicesNested(int index, Device item) {
            this.index = index;
            this.builder = new DeviceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceSliceSpecFluent.this.setToDevices(this.index, this.builder.build());
        }

        public N endDevice() {
            return this.and();
        }
    }
}

