/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.FrontendTLSValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FrontendTLSValidationFluent<A extends FrontendTLSValidationFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ObjectReferenceBuilder> caCertificateRefs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public FrontendTLSValidationFluent() {
    }

    public FrontendTLSValidationFluent(FrontendTLSValidation instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(FrontendTLSValidation instance) {
        FrontendTLSValidation frontendTLSValidation = instance = instance != null ? instance : new FrontendTLSValidation();
        if (instance != null) {
            this.withCaCertificateRefs(instance.getCaCertificateRefs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCaCertificateRefs(int index, ObjectReference item) {
        if (this.caCertificateRefs == null) {
            this.caCertificateRefs = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.caCertificateRefs.size()) {
            this._visitables.get("caCertificateRefs").add(builder);
            this.caCertificateRefs.add(builder);
        } else {
            this._visitables.get("caCertificateRefs").add(index, builder);
            this.caCertificateRefs.add(index, builder);
        }
        return (A)this;
    }

    public A setToCaCertificateRefs(int index, ObjectReference item) {
        if (this.caCertificateRefs == null) {
            this.caCertificateRefs = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.caCertificateRefs.size()) {
            this._visitables.get("caCertificateRefs").add(builder);
            this.caCertificateRefs.add(builder);
        } else {
            this._visitables.get("caCertificateRefs").set(index, builder);
            this.caCertificateRefs.set(index, builder);
        }
        return (A)this;
    }

    public A addToCaCertificateRefs(ObjectReference ... items) {
        if (this.caCertificateRefs == null) {
            this.caCertificateRefs = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("caCertificateRefs").add(builder);
            this.caCertificateRefs.add(builder);
        }
        return (A)this;
    }

    public A addAllToCaCertificateRefs(Collection<ObjectReference> items) {
        if (this.caCertificateRefs == null) {
            this.caCertificateRefs = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("caCertificateRefs").add(builder);
            this.caCertificateRefs.add(builder);
        }
        return (A)this;
    }

    public A removeFromCaCertificateRefs(ObjectReference ... items) {
        if (this.caCertificateRefs == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("caCertificateRefs").remove(builder);
            this.caCertificateRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromCaCertificateRefs(Collection<ObjectReference> items) {
        if (this.caCertificateRefs == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("caCertificateRefs").remove(builder);
            this.caCertificateRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromCaCertificateRefs(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.caCertificateRefs == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.caCertificateRefs.iterator();
        Object visitables = this._visitables.get("caCertificateRefs");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ObjectReference> buildCaCertificateRefs() {
        return this.caCertificateRefs != null ? FrontendTLSValidationFluent.build(this.caCertificateRefs) : null;
    }

    public ObjectReference buildCaCertificateRef(int index) {
        return this.caCertificateRefs.get(index).build();
    }

    public ObjectReference buildFirstCaCertificateRef() {
        return this.caCertificateRefs.get(0).build();
    }

    public ObjectReference buildLastCaCertificateRef() {
        return this.caCertificateRefs.get(this.caCertificateRefs.size() - 1).build();
    }

    public ObjectReference buildMatchingCaCertificateRef(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.caCertificateRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCaCertificateRef(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.caCertificateRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCaCertificateRefs(List<ObjectReference> caCertificateRefs) {
        if (this.caCertificateRefs != null) {
            this._visitables.get("caCertificateRefs").clear();
        }
        if (caCertificateRefs != null) {
            this.caCertificateRefs = new ArrayList();
            for (ObjectReference item : caCertificateRefs) {
                this.addToCaCertificateRefs(item);
            }
        } else {
            this.caCertificateRefs = null;
        }
        return (A)this;
    }

    public A withCaCertificateRefs(ObjectReference ... caCertificateRefs) {
        if (this.caCertificateRefs != null) {
            this.caCertificateRefs.clear();
            this._visitables.remove("caCertificateRefs");
        }
        if (caCertificateRefs != null) {
            for (ObjectReference item : caCertificateRefs) {
                this.addToCaCertificateRefs(item);
            }
        }
        return (A)this;
    }

    public boolean hasCaCertificateRefs() {
        return this.caCertificateRefs != null && !this.caCertificateRefs.isEmpty();
    }

    public CaCertificateRefsNested<A> addNewCaCertificateRef() {
        return new CaCertificateRefsNested(-1, null);
    }

    public CaCertificateRefsNested<A> addNewCaCertificateRefLike(ObjectReference item) {
        return new CaCertificateRefsNested(-1, item);
    }

    public CaCertificateRefsNested<A> setNewCaCertificateRefLike(int index, ObjectReference item) {
        return new CaCertificateRefsNested(index, item);
    }

    public CaCertificateRefsNested<A> editCaCertificateRef(int index) {
        if (this.caCertificateRefs.size() <= index) {
            throw new RuntimeException("Can't edit caCertificateRefs. Index exceeds size.");
        }
        return this.setNewCaCertificateRefLike(index, this.buildCaCertificateRef(index));
    }

    public CaCertificateRefsNested<A> editFirstCaCertificateRef() {
        if (this.caCertificateRefs.size() == 0) {
            throw new RuntimeException("Can't edit first caCertificateRefs. The list is empty.");
        }
        return this.setNewCaCertificateRefLike(0, this.buildCaCertificateRef(0));
    }

    public CaCertificateRefsNested<A> editLastCaCertificateRef() {
        int index = this.caCertificateRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last caCertificateRefs. The list is empty.");
        }
        return this.setNewCaCertificateRefLike(index, this.buildCaCertificateRef(index));
    }

    public CaCertificateRefsNested<A> editMatchingCaCertificateRef(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.caCertificateRefs.size(); ++i) {
            if (!predicate.test(this.caCertificateRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching caCertificateRefs. No match found.");
        }
        return this.setNewCaCertificateRefLike(index, this.buildCaCertificateRef(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FrontendTLSValidationFluent that = (FrontendTLSValidationFluent)o;
        if (!Objects.equals(this.caCertificateRefs, that.caCertificateRefs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.caCertificateRefs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caCertificateRefs != null && !this.caCertificateRefs.isEmpty()) {
            sb.append("caCertificateRefs:");
            sb.append(this.caCertificateRefs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CaCertificateRefsNested<N>
    extends ObjectReferenceFluent<CaCertificateRefsNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        CaCertificateRefsNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FrontendTLSValidationFluent.this.setToCaCertificateRefs(this.index, this.builder.build());
        }

        public N endCaCertificateRef() {
            return this.and();
        }
    }
}

