/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admission.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionRequest;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionRequestBuilder;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionRequestFluent;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluent;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReview;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AdmissionReviewFluent<A extends AdmissionReviewFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private AdmissionRequestBuilder request;
    private AdmissionResponseBuilder response;
    private Map<String, Object> additionalProperties;

    public AdmissionReviewFluent() {
    }

    public AdmissionReviewFluent(AdmissionReview instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AdmissionReview instance) {
        AdmissionReview admissionReview = instance = instance != null ? instance : new AdmissionReview();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withRequest(instance.getRequest());
            this.withResponse(instance.getResponse());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public AdmissionRequest buildRequest() {
        return this.request != null ? this.request.build() : null;
    }

    public A withRequest(AdmissionRequest request) {
        this._visitables.remove("request");
        if (request != null) {
            this.request = new AdmissionRequestBuilder(request);
            this._visitables.get("request").add(this.request);
        } else {
            this.request = null;
            this._visitables.get("request").remove(this.request);
        }
        return (A)this;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public RequestNested<A> withNewRequest() {
        return new RequestNested(null);
    }

    public RequestNested<A> withNewRequestLike(AdmissionRequest item) {
        return new RequestNested(item);
    }

    public RequestNested<A> editRequest() {
        return this.withNewRequestLike(Optional.ofNullable(this.buildRequest()).orElse(null));
    }

    public RequestNested<A> editOrNewRequest() {
        return this.withNewRequestLike(Optional.ofNullable(this.buildRequest()).orElse(new AdmissionRequestBuilder().build()));
    }

    public RequestNested<A> editOrNewRequestLike(AdmissionRequest item) {
        return this.withNewRequestLike(Optional.ofNullable(this.buildRequest()).orElse(item));
    }

    public AdmissionResponse buildResponse() {
        return this.response != null ? this.response.build() : null;
    }

    public A withResponse(AdmissionResponse response) {
        this._visitables.remove("response");
        if (response != null) {
            this.response = new AdmissionResponseBuilder(response);
            this._visitables.get("response").add(this.response);
        } else {
            this.response = null;
            this._visitables.get("response").remove(this.response);
        }
        return (A)this;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public ResponseNested<A> withNewResponse() {
        return new ResponseNested(null);
    }

    public ResponseNested<A> withNewResponseLike(AdmissionResponse item) {
        return new ResponseNested(item);
    }

    public ResponseNested<A> editResponse() {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(null));
    }

    public ResponseNested<A> editOrNewResponse() {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(new AdmissionResponseBuilder().build()));
    }

    public ResponseNested<A> editOrNewResponseLike(AdmissionResponse item) {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdmissionReviewFluent that = (AdmissionReviewFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        if (!Objects.equals(this.response, that.response)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.request, this.response, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.response != null) {
            sb.append("response:");
            sb.append(this.response + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResponseNested<N>
    extends AdmissionResponseFluent<ResponseNested<N>>
    implements Nested<N> {
        AdmissionResponseBuilder builder;

        ResponseNested(AdmissionResponse item) {
            this.builder = new AdmissionResponseBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AdmissionReviewFluent.this.withResponse(this.builder.build());
        }

        public N endResponse() {
            return this.and();
        }
    }

    public class RequestNested<N>
    extends AdmissionRequestFluent<RequestNested<N>>
    implements Nested<N> {
        AdmissionRequestBuilder builder;

        RequestNested(AdmissionRequest item) {
            this.builder = new AdmissionRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AdmissionReviewFluent.this.withRequest(this.builder.build());
        }

        public N endRequest() {
            return this.and();
        }
    }
}

