/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataIPv4DHCP;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev4;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev4Builder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev4Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkDataIPv4DHCPFluent<A extends NetworkDataIPv4DHCPFluent<A>>
extends BaseFluent<A> {
    private String id;
    private String link;
    private ArrayList<NetworkDataRoutev4Builder> routes = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NetworkDataIPv4DHCPFluent() {
    }

    public NetworkDataIPv4DHCPFluent(NetworkDataIPv4DHCP instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkDataIPv4DHCP instance) {
        NetworkDataIPv4DHCP networkDataIPv4DHCP = instance = instance != null ? instance : new NetworkDataIPv4DHCP();
        if (instance != null) {
            this.withId(instance.getId());
            this.withLink(instance.getLink());
            this.withRoutes(instance.getRoutes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public String getLink() {
        return this.link;
    }

    public A withLink(String link) {
        this.link = link;
        return (A)this;
    }

    public boolean hasLink() {
        return this.link != null;
    }

    public A addToRoutes(int index, NetworkDataRoutev4 item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        NetworkDataRoutev4Builder builder = new NetworkDataRoutev4Builder(item);
        if (index < 0 || index >= this.routes.size()) {
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        } else {
            this._visitables.get("routes").add(index, builder);
            this.routes.add(index, builder);
        }
        return (A)this;
    }

    public A setToRoutes(int index, NetworkDataRoutev4 item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        NetworkDataRoutev4Builder builder = new NetworkDataRoutev4Builder(item);
        if (index < 0 || index >= this.routes.size()) {
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        } else {
            this._visitables.get("routes").set(index, builder);
            this.routes.set(index, builder);
        }
        return (A)this;
    }

    public A addToRoutes(NetworkDataRoutev4 ... items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (NetworkDataRoutev4 item : items) {
            NetworkDataRoutev4Builder builder = new NetworkDataRoutev4Builder(item);
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        }
        return (A)this;
    }

    public A addAllToRoutes(Collection<NetworkDataRoutev4> items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (NetworkDataRoutev4 item : items) {
            NetworkDataRoutev4Builder builder = new NetworkDataRoutev4Builder(item);
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        }
        return (A)this;
    }

    public A removeFromRoutes(NetworkDataRoutev4 ... items) {
        if (this.routes == null) {
            return (A)this;
        }
        for (NetworkDataRoutev4 item : items) {
            NetworkDataRoutev4Builder builder = new NetworkDataRoutev4Builder(item);
            this._visitables.get("routes").remove(builder);
            this.routes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRoutes(Collection<NetworkDataRoutev4> items) {
        if (this.routes == null) {
            return (A)this;
        }
        for (NetworkDataRoutev4 item : items) {
            NetworkDataRoutev4Builder builder = new NetworkDataRoutev4Builder(item);
            this._visitables.get("routes").remove(builder);
            this.routes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRoutes(Predicate<NetworkDataRoutev4Builder> predicate) {
        if (this.routes == null) {
            return (A)this;
        }
        Iterator<NetworkDataRoutev4Builder> each = this.routes.iterator();
        Object visitables = this._visitables.get("routes");
        while (each.hasNext()) {
            NetworkDataRoutev4Builder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkDataRoutev4> buildRoutes() {
        return this.routes != null ? NetworkDataIPv4DHCPFluent.build(this.routes) : null;
    }

    public NetworkDataRoutev4 buildRoute(int index) {
        return this.routes.get(index).build();
    }

    public NetworkDataRoutev4 buildFirstRoute() {
        return this.routes.get(0).build();
    }

    public NetworkDataRoutev4 buildLastRoute() {
        return this.routes.get(this.routes.size() - 1).build();
    }

    public NetworkDataRoutev4 buildMatchingRoute(Predicate<NetworkDataRoutev4Builder> predicate) {
        for (NetworkDataRoutev4Builder item : this.routes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRoute(Predicate<NetworkDataRoutev4Builder> predicate) {
        for (NetworkDataRoutev4Builder item : this.routes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoutes(List<NetworkDataRoutev4> routes) {
        if (this.routes != null) {
            this._visitables.get("routes").clear();
        }
        if (routes != null) {
            this.routes = new ArrayList();
            for (NetworkDataRoutev4 item : routes) {
                this.addToRoutes(item);
            }
        } else {
            this.routes = null;
        }
        return (A)this;
    }

    public A withRoutes(NetworkDataRoutev4 ... routes) {
        if (this.routes != null) {
            this.routes.clear();
            this._visitables.remove("routes");
        }
        if (routes != null) {
            for (NetworkDataRoutev4 item : routes) {
                this.addToRoutes(item);
            }
        }
        return (A)this;
    }

    public boolean hasRoutes() {
        return this.routes != null && !this.routes.isEmpty();
    }

    public RoutesNested<A> addNewRoute() {
        return new RoutesNested(-1, null);
    }

    public RoutesNested<A> addNewRouteLike(NetworkDataRoutev4 item) {
        return new RoutesNested(-1, item);
    }

    public RoutesNested<A> setNewRouteLike(int index, NetworkDataRoutev4 item) {
        return new RoutesNested(index, item);
    }

    public RoutesNested<A> editRoute(int index) {
        if (this.routes.size() <= index) {
            throw new RuntimeException("Can't edit routes. Index exceeds size.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public RoutesNested<A> editFirstRoute() {
        if (this.routes.size() == 0) {
            throw new RuntimeException("Can't edit first routes. The list is empty.");
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    public RoutesNested<A> editLastRoute() {
        int index = this.routes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last routes. The list is empty.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public RoutesNested<A> editMatchingRoute(Predicate<NetworkDataRoutev4Builder> predicate) {
        int index = -1;
        for (int i = 0; i < this.routes.size(); ++i) {
            if (!predicate.test(this.routes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching routes. No match found.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataIPv4DHCPFluent that = (NetworkDataIPv4DHCPFluent)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.link, that.link)) {
            return false;
        }
        if (!Objects.equals(this.routes, that.routes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.link, this.routes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.link != null) {
            sb.append("link:");
            sb.append(this.link + ",");
        }
        if (this.routes != null && !this.routes.isEmpty()) {
            sb.append("routes:");
            sb.append(this.routes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RoutesNested<N>
    extends NetworkDataRoutev4Fluent<RoutesNested<N>>
    implements Nested<N> {
        NetworkDataRoutev4Builder builder;
        int index;

        RoutesNested(int index, NetworkDataRoutev4 item) {
            this.index = index;
            this.builder = new NetworkDataRoutev4Builder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDataIPv4DHCPFluent.this.setToRoutes(this.index, this.builder.build());
        }

        public N endRoute() {
            return this.and();
        }
    }
}

