/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1.AWSFailureDomain;
import io.fabric8.openshift.api.model.machine.v1.AWSFailureDomainPlacement;
import io.fabric8.openshift.api.model.machine.v1.AWSFailureDomainPlacementBuilder;
import io.fabric8.openshift.api.model.machine.v1.AWSFailureDomainPlacementFluent;
import io.fabric8.openshift.api.model.machine.v1.AWSResourceReference;
import io.fabric8.openshift.api.model.machine.v1.AWSResourceReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1.AWSResourceReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AWSFailureDomainFluent<A extends AWSFailureDomainFluent<A>>
extends BaseFluent<A> {
    private AWSFailureDomainPlacementBuilder placement;
    private AWSResourceReferenceBuilder subnet;
    private Map<String, Object> additionalProperties;

    public AWSFailureDomainFluent() {
    }

    public AWSFailureDomainFluent(AWSFailureDomain instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AWSFailureDomain instance) {
        AWSFailureDomain aWSFailureDomain = instance = instance != null ? instance : new AWSFailureDomain();
        if (instance != null) {
            this.withPlacement(instance.getPlacement());
            this.withSubnet(instance.getSubnet());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AWSFailureDomainPlacement buildPlacement() {
        return this.placement != null ? this.placement.build() : null;
    }

    public A withPlacement(AWSFailureDomainPlacement placement) {
        this._visitables.remove("placement");
        if (placement != null) {
            this.placement = new AWSFailureDomainPlacementBuilder(placement);
            this._visitables.get("placement").add(this.placement);
        } else {
            this.placement = null;
            this._visitables.get("placement").remove(this.placement);
        }
        return (A)this;
    }

    public boolean hasPlacement() {
        return this.placement != null;
    }

    public A withNewPlacement(String availabilityZone) {
        return this.withPlacement(new AWSFailureDomainPlacement(availabilityZone));
    }

    public PlacementNested<A> withNewPlacement() {
        return new PlacementNested(null);
    }

    public PlacementNested<A> withNewPlacementLike(AWSFailureDomainPlacement item) {
        return new PlacementNested(item);
    }

    public PlacementNested<A> editPlacement() {
        return this.withNewPlacementLike(Optional.ofNullable(this.buildPlacement()).orElse(null));
    }

    public PlacementNested<A> editOrNewPlacement() {
        return this.withNewPlacementLike(Optional.ofNullable(this.buildPlacement()).orElse(new AWSFailureDomainPlacementBuilder().build()));
    }

    public PlacementNested<A> editOrNewPlacementLike(AWSFailureDomainPlacement item) {
        return this.withNewPlacementLike(Optional.ofNullable(this.buildPlacement()).orElse(item));
    }

    public AWSResourceReference buildSubnet() {
        return this.subnet != null ? this.subnet.build() : null;
    }

    public A withSubnet(AWSResourceReference subnet) {
        this._visitables.remove("subnet");
        if (subnet != null) {
            this.subnet = new AWSResourceReferenceBuilder(subnet);
            this._visitables.get("subnet").add(this.subnet);
        } else {
            this.subnet = null;
            this._visitables.get("subnet").remove(this.subnet);
        }
        return (A)this;
    }

    public boolean hasSubnet() {
        return this.subnet != null;
    }

    public SubnetNested<A> withNewSubnet() {
        return new SubnetNested(null);
    }

    public SubnetNested<A> withNewSubnetLike(AWSResourceReference item) {
        return new SubnetNested(item);
    }

    public SubnetNested<A> editSubnet() {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(null));
    }

    public SubnetNested<A> editOrNewSubnet() {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(new AWSResourceReferenceBuilder().build()));
    }

    public SubnetNested<A> editOrNewSubnetLike(AWSResourceReference item) {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSFailureDomainFluent that = (AWSFailureDomainFluent)o;
        if (!Objects.equals(this.placement, that.placement)) {
            return false;
        }
        if (!Objects.equals(this.subnet, that.subnet)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.placement, this.subnet, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.placement != null) {
            sb.append("placement:");
            sb.append(this.placement + ",");
        }
        if (this.subnet != null) {
            sb.append("subnet:");
            sb.append(this.subnet + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubnetNested<N>
    extends AWSResourceReferenceFluent<SubnetNested<N>>
    implements Nested<N> {
        AWSResourceReferenceBuilder builder;

        SubnetNested(AWSResourceReference item) {
            this.builder = new AWSResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSFailureDomainFluent.this.withSubnet(this.builder.build());
        }

        public N endSubnet() {
            return this.and();
        }
    }

    public class PlacementNested<N>
    extends AWSFailureDomainPlacementFluent<PlacementNested<N>>
    implements Nested<N> {
        AWSFailureDomainPlacementBuilder builder;

        PlacementNested(AWSFailureDomainPlacement item) {
            this.builder = new AWSFailureDomainPlacementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSFailureDomainFluent.this.withPlacement(this.builder.build());
        }

        public N endPlacement() {
            return this.and();
        }
    }
}

