/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPU;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPUBuilder;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPUFluent;
import io.fabric8.openshift.api.model.installer.ovirt.v1.Disk;
import io.fabric8.openshift.api.model.installer.ovirt.v1.DiskBuilder;
import io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluent;
import io.fabric8.openshift.api.model.installer.ovirt.v1.MachinePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private List<String> affinityGroupsNames = new ArrayList<String>();
    private String autoPinningPolicy;
    private Boolean clone;
    private CPUBuilder cpu;
    private String format;
    private Integer hugepages;
    private String instanceTypeID;
    private Integer memoryMB;
    private DiskBuilder osDisk;
    private Boolean sparse;
    private String vmType;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withAffinityGroupsNames(instance.getAffinityGroupsNames());
            this.withAutoPinningPolicy(instance.getAutoPinningPolicy());
            this.withClone(instance.getClone());
            this.withCpu(instance.getCpu());
            this.withFormat(instance.getFormat());
            this.withHugepages(instance.getHugepages());
            this.withInstanceTypeID(instance.getInstanceTypeID());
            this.withMemoryMB(instance.getMemoryMB());
            this.withOsDisk(instance.getOsDisk());
            this.withSparse(instance.getSparse());
            this.withVmType(instance.getVmType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAffinityGroupsNames(int index, String item) {
        if (this.affinityGroupsNames == null) {
            this.affinityGroupsNames = new ArrayList<String>();
        }
        this.affinityGroupsNames.add(index, item);
        return (A)this;
    }

    public A setToAffinityGroupsNames(int index, String item) {
        if (this.affinityGroupsNames == null) {
            this.affinityGroupsNames = new ArrayList<String>();
        }
        this.affinityGroupsNames.set(index, item);
        return (A)this;
    }

    public A addToAffinityGroupsNames(String ... items) {
        if (this.affinityGroupsNames == null) {
            this.affinityGroupsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.affinityGroupsNames.add(item);
        }
        return (A)this;
    }

    public A addAllToAffinityGroupsNames(Collection<String> items) {
        if (this.affinityGroupsNames == null) {
            this.affinityGroupsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.affinityGroupsNames.add(item);
        }
        return (A)this;
    }

    public A removeFromAffinityGroupsNames(String ... items) {
        if (this.affinityGroupsNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.affinityGroupsNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAffinityGroupsNames(Collection<String> items) {
        if (this.affinityGroupsNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.affinityGroupsNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getAffinityGroupsNames() {
        return this.affinityGroupsNames;
    }

    public String getAffinityGroupsName(int index) {
        return this.affinityGroupsNames.get(index);
    }

    public String getFirstAffinityGroupsName() {
        return this.affinityGroupsNames.get(0);
    }

    public String getLastAffinityGroupsName() {
        return this.affinityGroupsNames.get(this.affinityGroupsNames.size() - 1);
    }

    public String getMatchingAffinityGroupsName(Predicate<String> predicate) {
        for (String item : this.affinityGroupsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAffinityGroupsName(Predicate<String> predicate) {
        for (String item : this.affinityGroupsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAffinityGroupsNames(List<String> affinityGroupsNames) {
        if (affinityGroupsNames != null) {
            this.affinityGroupsNames = new ArrayList<String>();
            for (String item : affinityGroupsNames) {
                this.addToAffinityGroupsNames(item);
            }
        } else {
            this.affinityGroupsNames = null;
        }
        return (A)this;
    }

    public A withAffinityGroupsNames(String ... affinityGroupsNames) {
        if (this.affinityGroupsNames != null) {
            this.affinityGroupsNames.clear();
            this._visitables.remove("affinityGroupsNames");
        }
        if (affinityGroupsNames != null) {
            for (String item : affinityGroupsNames) {
                this.addToAffinityGroupsNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasAffinityGroupsNames() {
        return this.affinityGroupsNames != null && !this.affinityGroupsNames.isEmpty();
    }

    public String getAutoPinningPolicy() {
        return this.autoPinningPolicy;
    }

    public A withAutoPinningPolicy(String autoPinningPolicy) {
        this.autoPinningPolicy = autoPinningPolicy;
        return (A)this;
    }

    public boolean hasAutoPinningPolicy() {
        return this.autoPinningPolicy != null;
    }

    public Boolean getClone() {
        return this.clone;
    }

    public A withClone(Boolean clone) {
        this.clone = clone;
        return (A)this;
    }

    public boolean hasClone() {
        return this.clone != null;
    }

    public CPU buildCpu() {
        return this.cpu != null ? this.cpu.build() : null;
    }

    public A withCpu(CPU cpu) {
        this._visitables.remove("cpu");
        if (cpu != null) {
            this.cpu = new CPUBuilder(cpu);
            this._visitables.get("cpu").add(this.cpu);
        } else {
            this.cpu = null;
            this._visitables.get("cpu").remove(this.cpu);
        }
        return (A)this;
    }

    public boolean hasCpu() {
        return this.cpu != null;
    }

    public A withNewCpu(Integer cores, Integer sockets, Integer threads) {
        return this.withCpu(new CPU(cores, sockets, threads));
    }

    public CpuNested<A> withNewCpu() {
        return new CpuNested(null);
    }

    public CpuNested<A> withNewCpuLike(CPU item) {
        return new CpuNested(item);
    }

    public CpuNested<A> editCpu() {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(null));
    }

    public CpuNested<A> editOrNewCpu() {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(new CPUBuilder().build()));
    }

    public CpuNested<A> editOrNewCpuLike(CPU item) {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(item));
    }

    public String getFormat() {
        return this.format;
    }

    public A withFormat(String format) {
        this.format = format;
        return (A)this;
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public Integer getHugepages() {
        return this.hugepages;
    }

    public A withHugepages(Integer hugepages) {
        this.hugepages = hugepages;
        return (A)this;
    }

    public boolean hasHugepages() {
        return this.hugepages != null;
    }

    public String getInstanceTypeID() {
        return this.instanceTypeID;
    }

    public A withInstanceTypeID(String instanceTypeID) {
        this.instanceTypeID = instanceTypeID;
        return (A)this;
    }

    public boolean hasInstanceTypeID() {
        return this.instanceTypeID != null;
    }

    public Integer getMemoryMB() {
        return this.memoryMB;
    }

    public A withMemoryMB(Integer memoryMB) {
        this.memoryMB = memoryMB;
        return (A)this;
    }

    public boolean hasMemoryMB() {
        return this.memoryMB != null;
    }

    public Disk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    public A withOsDisk(Disk osDisk) {
        this._visitables.remove("osDisk");
        if (osDisk != null) {
            this.osDisk = new DiskBuilder(osDisk);
            this._visitables.get("osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get("osDisk").remove(this.osDisk);
        }
        return (A)this;
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public A withNewOsDisk(Long sizeGB) {
        return this.withOsDisk(new Disk(sizeGB));
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public OsDiskNested<A> withNewOsDiskLike(Disk item) {
        return new OsDiskNested(item);
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new DiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(Disk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public Boolean getSparse() {
        return this.sparse;
    }

    public A withSparse(Boolean sparse) {
        this.sparse = sparse;
        return (A)this;
    }

    public boolean hasSparse() {
        return this.sparse != null;
    }

    public String getVmType() {
        return this.vmType;
    }

    public A withVmType(String vmType) {
        this.vmType = vmType;
        return (A)this;
    }

    public boolean hasVmType() {
        return this.vmType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.affinityGroupsNames, that.affinityGroupsNames)) {
            return false;
        }
        if (!Objects.equals(this.autoPinningPolicy, that.autoPinningPolicy)) {
            return false;
        }
        if (!Objects.equals(this.clone, that.clone)) {
            return false;
        }
        if (!Objects.equals(this.cpu, that.cpu)) {
            return false;
        }
        if (!Objects.equals(this.format, that.format)) {
            return false;
        }
        if (!Objects.equals(this.hugepages, that.hugepages)) {
            return false;
        }
        if (!Objects.equals(this.instanceTypeID, that.instanceTypeID)) {
            return false;
        }
        if (!Objects.equals(this.memoryMB, that.memoryMB)) {
            return false;
        }
        if (!Objects.equals(this.osDisk, that.osDisk)) {
            return false;
        }
        if (!Objects.equals(this.sparse, that.sparse)) {
            return false;
        }
        if (!Objects.equals(this.vmType, that.vmType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.affinityGroupsNames, this.autoPinningPolicy, this.clone, this.cpu, this.format, this.hugepages, this.instanceTypeID, this.memoryMB, this.osDisk, this.sparse, this.vmType, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.affinityGroupsNames != null && !this.affinityGroupsNames.isEmpty()) {
            sb.append("affinityGroupsNames:");
            sb.append(this.affinityGroupsNames + ",");
        }
        if (this.autoPinningPolicy != null) {
            sb.append("autoPinningPolicy:");
            sb.append(this.autoPinningPolicy + ",");
        }
        if (this.clone != null) {
            sb.append("clone:");
            sb.append(this.clone + ",");
        }
        if (this.cpu != null) {
            sb.append("cpu:");
            sb.append(this.cpu + ",");
        }
        if (this.format != null) {
            sb.append("format:");
            sb.append(this.format + ",");
        }
        if (this.hugepages != null) {
            sb.append("hugepages:");
            sb.append(this.hugepages + ",");
        }
        if (this.instanceTypeID != null) {
            sb.append("instanceTypeID:");
            sb.append(this.instanceTypeID + ",");
        }
        if (this.memoryMB != null) {
            sb.append("memoryMB:");
            sb.append(this.memoryMB + ",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(this.osDisk + ",");
        }
        if (this.sparse != null) {
            sb.append("sparse:");
            sb.append(this.sparse + ",");
        }
        if (this.vmType != null) {
            sb.append("vmType:");
            sb.append(this.vmType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withClone() {
        return this.withClone(true);
    }

    public A withSparse() {
        return this.withSparse(true);
    }

    public class OsDiskNested<N>
    extends DiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        DiskBuilder builder;

        OsDiskNested(Disk item) {
            this.builder = new DiskBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }

    public class CpuNested<N>
    extends CPUFluent<CpuNested<N>>
    implements Nested<N> {
        CPUBuilder builder;

        CpuNested(CPU item) {
            this.builder = new CPUBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withCpu(this.builder.build());
        }

        public N endCpu() {
            return this.and();
        }
    }
}

