/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkSubnet;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkSubnetBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkSubnetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSPrivateLinkInventoryFluent<A extends AWSPrivateLinkInventoryFluent<A>>
extends BaseFluent<A> {
    private String region;
    private ArrayList<AWSPrivateLinkSubnetBuilder> subnets = new ArrayList();
    private String vpcID;
    private Map<String, Object> additionalProperties;

    public AWSPrivateLinkInventoryFluent() {
    }

    public AWSPrivateLinkInventoryFluent(AWSPrivateLinkInventory instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AWSPrivateLinkInventory instance) {
        AWSPrivateLinkInventory aWSPrivateLinkInventory = instance = instance != null ? instance : new AWSPrivateLinkInventory();
        if (instance != null) {
            this.withRegion(instance.getRegion());
            this.withSubnets(instance.getSubnets());
            this.withVpcID(instance.getVpcID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToSubnets(int index, AWSPrivateLinkSubnet item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
        if (index < 0 || index >= this.subnets.size()) {
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        } else {
            this._visitables.get("subnets").add(index, builder);
            this.subnets.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubnets(int index, AWSPrivateLinkSubnet item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
        if (index < 0 || index >= this.subnets.size()) {
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        } else {
            this._visitables.get("subnets").set(index, builder);
            this.subnets.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubnets(AWSPrivateLinkSubnet ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (AWSPrivateLinkSubnet item : items) {
            AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubnets(Collection<AWSPrivateLinkSubnet> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (AWSPrivateLinkSubnet item : items) {
            AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubnets(AWSPrivateLinkSubnet ... items) {
        if (this.subnets == null) {
            return (A)this;
        }
        for (AWSPrivateLinkSubnet item : items) {
            AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
            this._visitables.get("subnets").remove(builder);
            this.subnets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubnets(Collection<AWSPrivateLinkSubnet> items) {
        if (this.subnets == null) {
            return (A)this;
        }
        for (AWSPrivateLinkSubnet item : items) {
            AWSPrivateLinkSubnetBuilder builder = new AWSPrivateLinkSubnetBuilder(item);
            this._visitables.get("subnets").remove(builder);
            this.subnets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubnets(Predicate<AWSPrivateLinkSubnetBuilder> predicate) {
        if (this.subnets == null) {
            return (A)this;
        }
        Iterator<AWSPrivateLinkSubnetBuilder> each = this.subnets.iterator();
        Object visitables = this._visitables.get("subnets");
        while (each.hasNext()) {
            AWSPrivateLinkSubnetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AWSPrivateLinkSubnet> buildSubnets() {
        return this.subnets != null ? AWSPrivateLinkInventoryFluent.build(this.subnets) : null;
    }

    public AWSPrivateLinkSubnet buildSubnet(int index) {
        return this.subnets.get(index).build();
    }

    public AWSPrivateLinkSubnet buildFirstSubnet() {
        return this.subnets.get(0).build();
    }

    public AWSPrivateLinkSubnet buildLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1).build();
    }

    public AWSPrivateLinkSubnet buildMatchingSubnet(Predicate<AWSPrivateLinkSubnetBuilder> predicate) {
        for (AWSPrivateLinkSubnetBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubnet(Predicate<AWSPrivateLinkSubnetBuilder> predicate) {
        for (AWSPrivateLinkSubnetBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubnets(List<AWSPrivateLinkSubnet> subnets) {
        if (this.subnets != null) {
            this._visitables.get("subnets").clear();
        }
        if (subnets != null) {
            this.subnets = new ArrayList();
            for (AWSPrivateLinkSubnet item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)this;
    }

    public A withSubnets(AWSPrivateLinkSubnet ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
            this._visitables.remove("subnets");
        }
        if (subnets != null) {
            for (AWSPrivateLinkSubnet item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    public A addNewSubnet(String availabilityZone, String subnetID) {
        return this.addToSubnets(new AWSPrivateLinkSubnet(availabilityZone, subnetID));
    }

    public SubnetsNested<A> addNewSubnet() {
        return new SubnetsNested(-1, null);
    }

    public SubnetsNested<A> addNewSubnetLike(AWSPrivateLinkSubnet item) {
        return new SubnetsNested(-1, item);
    }

    public SubnetsNested<A> setNewSubnetLike(int index, AWSPrivateLinkSubnet item) {
        return new SubnetsNested(index, item);
    }

    public SubnetsNested<A> editSubnet(int index) {
        if (this.subnets.size() <= index) {
            throw new RuntimeException("Can't edit subnets. Index exceeds size.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public SubnetsNested<A> editFirstSubnet() {
        if (this.subnets.size() == 0) {
            throw new RuntimeException("Can't edit first subnets. The list is empty.");
        }
        return this.setNewSubnetLike(0, this.buildSubnet(0));
    }

    public SubnetsNested<A> editLastSubnet() {
        int index = this.subnets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subnets. The list is empty.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public SubnetsNested<A> editMatchingSubnet(Predicate<AWSPrivateLinkSubnetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subnets.size(); ++i) {
            if (!predicate.test(this.subnets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subnets. No match found.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public String getVpcID() {
        return this.vpcID;
    }

    public A withVpcID(String vpcID) {
        this.vpcID = vpcID;
        return (A)this;
    }

    public boolean hasVpcID() {
        return this.vpcID != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSPrivateLinkInventoryFluent that = (AWSPrivateLinkInventoryFluent)o;
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.subnets, that.subnets)) {
            return false;
        }
        if (!Objects.equals(this.vpcID, that.vpcID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.region, this.subnets, this.vpcID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(this.subnets + ",");
        }
        if (this.vpcID != null) {
            sb.append("vpcID:");
            sb.append(this.vpcID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubnetsNested<N>
    extends AWSPrivateLinkSubnetFluent<SubnetsNested<N>>
    implements Nested<N> {
        AWSPrivateLinkSubnetBuilder builder;
        int index;

        SubnetsNested(int index, AWSPrivateLinkSubnet item) {
            this.index = index;
            this.builder = new AWSPrivateLinkSubnetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSPrivateLinkInventoryFluent.this.setToSubnets(this.index, this.builder.build());
        }

        public N endSubnet() {
            return this.and();
        }
    }
}

