/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.NamedRole;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.openshift.api.model.RoleFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NamedRoleFluent<A extends NamedRoleFluent<A>>
extends BaseFluent<A> {
    private String name;
    private RoleBuilder role;
    private Map<String, Object> additionalProperties;

    public NamedRoleFluent() {
    }

    public NamedRoleFluent(NamedRole instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamedRole instance) {
        NamedRole namedRole = instance = instance != null ? instance : new NamedRole();
        if (instance != null) {
            this.withName(instance.getName());
            this.withRole(instance.getRole());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Role buildRole() {
        return this.role != null ? this.role.build() : null;
    }

    public A withRole(Role role) {
        this._visitables.remove("role");
        if (role != null) {
            this.role = new RoleBuilder(role);
            this._visitables.get("role").add(this.role);
        } else {
            this.role = null;
            this._visitables.get("role").remove(this.role);
        }
        return (A)this;
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public RoleNested<A> withNewRole() {
        return new RoleNested(null);
    }

    public RoleNested<A> withNewRoleLike(Role item) {
        return new RoleNested(item);
    }

    public RoleNested<A> editRole() {
        return this.withNewRoleLike(Optional.ofNullable(this.buildRole()).orElse(null));
    }

    public RoleNested<A> editOrNewRole() {
        return this.withNewRoleLike(Optional.ofNullable(this.buildRole()).orElse(new RoleBuilder().build()));
    }

    public RoleNested<A> editOrNewRoleLike(Role item) {
        return this.withNewRoleLike(Optional.ofNullable(this.buildRole()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedRoleFluent that = (NamedRoleFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.role, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RoleNested<N>
    extends RoleFluent<RoleNested<N>>
    implements Nested<N> {
        RoleBuilder builder;

        RoleNested(Role item) {
            this.builder = new RoleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamedRoleFluent.this.withRole(this.builder.build());
        }

        public N endRole() {
            return this.and();
        }
    }
}

