/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class VolumeMountFluent<A extends VolumeMountFluent<A>>
extends BaseFluent<A> {
    private String mountPath;
    private String mountPropagation;
    private String name;
    private Boolean readOnly;
    private String recursiveReadOnly;
    private String subPath;
    private String subPathExpr;
    private Map<String, Object> additionalProperties;

    public VolumeMountFluent() {
    }

    public VolumeMountFluent(VolumeMount instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VolumeMount instance) {
        VolumeMount volumeMount = instance = instance != null ? instance : new VolumeMount();
        if (instance != null) {
            this.withMountPath(instance.getMountPath());
            this.withMountPropagation(instance.getMountPropagation());
            this.withName(instance.getName());
            this.withReadOnly(instance.getReadOnly());
            this.withRecursiveReadOnly(instance.getRecursiveReadOnly());
            this.withSubPath(instance.getSubPath());
            this.withSubPathExpr(instance.getSubPathExpr());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    public boolean hasMountPath() {
        return this.mountPath != null;
    }

    public String getMountPropagation() {
        return this.mountPropagation;
    }

    public A withMountPropagation(String mountPropagation) {
        this.mountPropagation = mountPropagation;
        return (A)this;
    }

    public boolean hasMountPropagation() {
        return this.mountPropagation != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public String getRecursiveReadOnly() {
        return this.recursiveReadOnly;
    }

    public A withRecursiveReadOnly(String recursiveReadOnly) {
        this.recursiveReadOnly = recursiveReadOnly;
        return (A)this;
    }

    public boolean hasRecursiveReadOnly() {
        return this.recursiveReadOnly != null;
    }

    public String getSubPath() {
        return this.subPath;
    }

    public A withSubPath(String subPath) {
        this.subPath = subPath;
        return (A)this;
    }

    public boolean hasSubPath() {
        return this.subPath != null;
    }

    public String getSubPathExpr() {
        return this.subPathExpr;
    }

    public A withSubPathExpr(String subPathExpr) {
        this.subPathExpr = subPathExpr;
        return (A)this;
    }

    public boolean hasSubPathExpr() {
        return this.subPathExpr != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeMountFluent that = (VolumeMountFluent)o;
        if (!Objects.equals(this.mountPath, that.mountPath)) {
            return false;
        }
        if (!Objects.equals(this.mountPropagation, that.mountPropagation)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.recursiveReadOnly, that.recursiveReadOnly)) {
            return false;
        }
        if (!Objects.equals(this.subPath, that.subPath)) {
            return false;
        }
        if (!Objects.equals(this.subPathExpr, that.subPathExpr)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mountPath, this.mountPropagation, this.name, this.readOnly, this.recursiveReadOnly, this.subPath, this.subPathExpr, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.mountPropagation != null) {
            sb.append("mountPropagation:");
            sb.append(this.mountPropagation + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.recursiveReadOnly != null) {
            sb.append("recursiveReadOnly:");
            sb.append(this.recursiveReadOnly + ",");
        }
        if (this.subPath != null) {
            sb.append("subPath:");
            sb.append(this.subPath + ",");
        }
        if (this.subPathExpr != null) {
            sb.append("subPathExpr:");
            sb.append(this.subPathExpr + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }
}

