/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1alpha1.OperatorCondition;
import io.fabric8.openshift.api.model.operator.v1alpha1.OperatorConditionBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.OperatorConditionFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.OperatorStatus;
import io.fabric8.openshift.api.model.operator.v1alpha1.VersionAvailability;
import io.fabric8.openshift.api.model.operator.v1alpha1.VersionAvailabilityBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.VersionAvailabilityFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OperatorStatusFluent<A extends OperatorStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<OperatorConditionBuilder> conditions = new ArrayList();
    private VersionAvailabilityBuilder currentVersionAvailability;
    private Long observedGeneration;
    private String state;
    private VersionAvailabilityBuilder targetVersionAvailability;
    private String taskSummary;
    private Map<String, Object> additionalProperties;

    public OperatorStatusFluent() {
    }

    public OperatorStatusFluent(OperatorStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OperatorStatus instance) {
        OperatorStatus operatorStatus = instance = instance != null ? instance : new OperatorStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withCurrentVersionAvailability(instance.getCurrentVersionAvailability());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withState(instance.getState());
            this.withTargetVersionAvailability(instance.getTargetVersionAvailability());
            this.withTaskSummary(instance.getTaskSummary());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<OperatorConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            OperatorConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<OperatorCondition> buildConditions() {
        return this.conditions != null ? OperatorStatusFluent.build(this.conditions) : null;
    }

    public OperatorCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public OperatorCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public OperatorCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<OperatorCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(OperatorCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, OperatorCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public VersionAvailability buildCurrentVersionAvailability() {
        return this.currentVersionAvailability != null ? this.currentVersionAvailability.build() : null;
    }

    public A withCurrentVersionAvailability(VersionAvailability currentVersionAvailability) {
        this._visitables.remove("currentVersionAvailability");
        if (currentVersionAvailability != null) {
            this.currentVersionAvailability = new VersionAvailabilityBuilder(currentVersionAvailability);
            this._visitables.get("currentVersionAvailability").add(this.currentVersionAvailability);
        } else {
            this.currentVersionAvailability = null;
            this._visitables.get("currentVersionAvailability").remove(this.currentVersionAvailability);
        }
        return (A)this;
    }

    public boolean hasCurrentVersionAvailability() {
        return this.currentVersionAvailability != null;
    }

    public CurrentVersionAvailabilityNested<A> withNewCurrentVersionAvailability() {
        return new CurrentVersionAvailabilityNested(null);
    }

    public CurrentVersionAvailabilityNested<A> withNewCurrentVersionAvailabilityLike(VersionAvailability item) {
        return new CurrentVersionAvailabilityNested(item);
    }

    public CurrentVersionAvailabilityNested<A> editCurrentVersionAvailability() {
        return this.withNewCurrentVersionAvailabilityLike(Optional.ofNullable(this.buildCurrentVersionAvailability()).orElse(null));
    }

    public CurrentVersionAvailabilityNested<A> editOrNewCurrentVersionAvailability() {
        return this.withNewCurrentVersionAvailabilityLike(Optional.ofNullable(this.buildCurrentVersionAvailability()).orElse(new VersionAvailabilityBuilder().build()));
    }

    public CurrentVersionAvailabilityNested<A> editOrNewCurrentVersionAvailabilityLike(VersionAvailability item) {
        return this.withNewCurrentVersionAvailabilityLike(Optional.ofNullable(this.buildCurrentVersionAvailability()).orElse(item));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getState() {
        return this.state;
    }

    public A withState(String state) {
        this.state = state;
        return (A)this;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public VersionAvailability buildTargetVersionAvailability() {
        return this.targetVersionAvailability != null ? this.targetVersionAvailability.build() : null;
    }

    public A withTargetVersionAvailability(VersionAvailability targetVersionAvailability) {
        this._visitables.remove("targetVersionAvailability");
        if (targetVersionAvailability != null) {
            this.targetVersionAvailability = new VersionAvailabilityBuilder(targetVersionAvailability);
            this._visitables.get("targetVersionAvailability").add(this.targetVersionAvailability);
        } else {
            this.targetVersionAvailability = null;
            this._visitables.get("targetVersionAvailability").remove(this.targetVersionAvailability);
        }
        return (A)this;
    }

    public boolean hasTargetVersionAvailability() {
        return this.targetVersionAvailability != null;
    }

    public TargetVersionAvailabilityNested<A> withNewTargetVersionAvailability() {
        return new TargetVersionAvailabilityNested(null);
    }

    public TargetVersionAvailabilityNested<A> withNewTargetVersionAvailabilityLike(VersionAvailability item) {
        return new TargetVersionAvailabilityNested(item);
    }

    public TargetVersionAvailabilityNested<A> editTargetVersionAvailability() {
        return this.withNewTargetVersionAvailabilityLike(Optional.ofNullable(this.buildTargetVersionAvailability()).orElse(null));
    }

    public TargetVersionAvailabilityNested<A> editOrNewTargetVersionAvailability() {
        return this.withNewTargetVersionAvailabilityLike(Optional.ofNullable(this.buildTargetVersionAvailability()).orElse(new VersionAvailabilityBuilder().build()));
    }

    public TargetVersionAvailabilityNested<A> editOrNewTargetVersionAvailabilityLike(VersionAvailability item) {
        return this.withNewTargetVersionAvailabilityLike(Optional.ofNullable(this.buildTargetVersionAvailability()).orElse(item));
    }

    public String getTaskSummary() {
        return this.taskSummary;
    }

    public A withTaskSummary(String taskSummary) {
        this.taskSummary = taskSummary;
        return (A)this;
    }

    public boolean hasTaskSummary() {
        return this.taskSummary != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatorStatusFluent that = (OperatorStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentVersionAvailability, that.currentVersionAvailability)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        if (!Objects.equals(this.targetVersionAvailability, that.targetVersionAvailability)) {
            return false;
        }
        if (!Objects.equals(this.taskSummary, that.taskSummary)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.currentVersionAvailability, this.observedGeneration, this.state, this.targetVersionAvailability, this.taskSummary, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentVersionAvailability != null) {
            sb.append("currentVersionAvailability:");
            sb.append(this.currentVersionAvailability + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state + ",");
        }
        if (this.targetVersionAvailability != null) {
            sb.append("targetVersionAvailability:");
            sb.append(this.targetVersionAvailability + ",");
        }
        if (this.taskSummary != null) {
            sb.append("taskSummary:");
            sb.append(this.taskSummary + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetVersionAvailabilityNested<N>
    extends VersionAvailabilityFluent<TargetVersionAvailabilityNested<N>>
    implements Nested<N> {
        VersionAvailabilityBuilder builder;

        TargetVersionAvailabilityNested(VersionAvailability item) {
            this.builder = new VersionAvailabilityBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OperatorStatusFluent.this.withTargetVersionAvailability(this.builder.build());
        }

        public N endTargetVersionAvailability() {
            return this.and();
        }
    }

    public class CurrentVersionAvailabilityNested<N>
    extends VersionAvailabilityFluent<CurrentVersionAvailabilityNested<N>>
    implements Nested<N> {
        VersionAvailabilityBuilder builder;

        CurrentVersionAvailabilityNested(VersionAvailability item) {
            this.builder = new VersionAvailabilityBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OperatorStatusFluent.this.withCurrentVersionAvailability(this.builder.build());
        }

        public N endCurrentVersionAvailability() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends OperatorConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        OperatorConditionBuilder builder;
        int index;

        ConditionsNested(int index, OperatorCondition item) {
            this.index = index;
            this.builder = new OperatorConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OperatorStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

