/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.MachineManager;
import io.fabric8.openshift.api.model.operator.v1.MachineManagerSelector;
import io.fabric8.openshift.api.model.operator.v1.MachineManagerSelectorBuilder;
import io.fabric8.openshift.api.model.operator.v1.MachineManagerSelectorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineManagerFluent<A extends MachineManagerFluent<A>>
extends BaseFluent<A> {
    private String apiGroup;
    private String resource;
    private MachineManagerSelectorBuilder selection;
    private Map<String, Object> additionalProperties;

    public MachineManagerFluent() {
    }

    public MachineManagerFluent(MachineManager instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineManager instance) {
        MachineManager machineManager = instance = instance != null ? instance : new MachineManager();
        if (instance != null) {
            this.withApiGroup(instance.getApiGroup());
            this.withResource(instance.getResource());
            this.withSelection(instance.getSelection());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiGroup() {
        return this.apiGroup;
    }

    public A withApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
        return (A)this;
    }

    public boolean hasApiGroup() {
        return this.apiGroup != null;
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public MachineManagerSelector buildSelection() {
        return this.selection != null ? this.selection.build() : null;
    }

    public A withSelection(MachineManagerSelector selection) {
        this._visitables.remove("selection");
        if (selection != null) {
            this.selection = new MachineManagerSelectorBuilder(selection);
            this._visitables.get("selection").add(this.selection);
        } else {
            this.selection = null;
            this._visitables.get("selection").remove(this.selection);
        }
        return (A)this;
    }

    public boolean hasSelection() {
        return this.selection != null;
    }

    public SelectionNested<A> withNewSelection() {
        return new SelectionNested(null);
    }

    public SelectionNested<A> withNewSelectionLike(MachineManagerSelector item) {
        return new SelectionNested(item);
    }

    public SelectionNested<A> editSelection() {
        return this.withNewSelectionLike(Optional.ofNullable(this.buildSelection()).orElse(null));
    }

    public SelectionNested<A> editOrNewSelection() {
        return this.withNewSelectionLike(Optional.ofNullable(this.buildSelection()).orElse(new MachineManagerSelectorBuilder().build()));
    }

    public SelectionNested<A> editOrNewSelectionLike(MachineManagerSelector item) {
        return this.withNewSelectionLike(Optional.ofNullable(this.buildSelection()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineManagerFluent that = (MachineManagerFluent)o;
        if (!Objects.equals(this.apiGroup, that.apiGroup)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals(this.selection, that.selection)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiGroup, this.resource, this.selection, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiGroup != null) {
            sb.append("apiGroup:");
            sb.append(this.apiGroup + ",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.selection != null) {
            sb.append("selection:");
            sb.append(this.selection + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectionNested<N>
    extends MachineManagerSelectorFluent<SelectionNested<N>>
    implements Nested<N> {
        MachineManagerSelectorBuilder builder;

        SelectionNested(MachineManagerSelector item) {
            this.builder = new MachineManagerSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineManagerFluent.this.withSelection(this.builder.build());
        }

        public N endSelection() {
            return this.and();
        }
    }
}

