/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.ingress.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.ingress.v1.DNSRecordStatus;
import io.fabric8.openshift.api.model.operator.ingress.v1.DNSZoneStatus;
import io.fabric8.openshift.api.model.operator.ingress.v1.DNSZoneStatusBuilder;
import io.fabric8.openshift.api.model.operator.ingress.v1.DNSZoneStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSRecordStatusFluent<A extends DNSRecordStatusFluent<A>>
extends BaseFluent<A> {
    private Long observedGeneration;
    private ArrayList<DNSZoneStatusBuilder> zones = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DNSRecordStatusFluent() {
    }

    public DNSRecordStatusFluent(DNSRecordStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSRecordStatus instance) {
        DNSRecordStatus dNSRecordStatus = instance = instance != null ? instance : new DNSRecordStatus();
        if (instance != null) {
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToZones(int index, DNSZoneStatus item) {
        if (this.zones == null) {
            this.zones = new ArrayList();
        }
        DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
        if (index < 0 || index >= this.zones.size()) {
            this._visitables.get("zones").add(builder);
            this.zones.add(builder);
        } else {
            this._visitables.get("zones").add(index, builder);
            this.zones.add(index, builder);
        }
        return (A)this;
    }

    public A setToZones(int index, DNSZoneStatus item) {
        if (this.zones == null) {
            this.zones = new ArrayList();
        }
        DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
        if (index < 0 || index >= this.zones.size()) {
            this._visitables.get("zones").add(builder);
            this.zones.add(builder);
        } else {
            this._visitables.get("zones").set(index, builder);
            this.zones.set(index, builder);
        }
        return (A)this;
    }

    public A addToZones(DNSZoneStatus ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList();
        }
        for (DNSZoneStatus item : items) {
            DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
            this._visitables.get("zones").add(builder);
            this.zones.add(builder);
        }
        return (A)this;
    }

    public A addAllToZones(Collection<DNSZoneStatus> items) {
        if (this.zones == null) {
            this.zones = new ArrayList();
        }
        for (DNSZoneStatus item : items) {
            DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
            this._visitables.get("zones").add(builder);
            this.zones.add(builder);
        }
        return (A)this;
    }

    public A removeFromZones(DNSZoneStatus ... items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (DNSZoneStatus item : items) {
            DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
            this._visitables.get("zones").remove(builder);
            this.zones.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromZones(Collection<DNSZoneStatus> items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (DNSZoneStatus item : items) {
            DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
            this._visitables.get("zones").remove(builder);
            this.zones.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromZones(Predicate<DNSZoneStatusBuilder> predicate) {
        if (this.zones == null) {
            return (A)this;
        }
        Iterator<DNSZoneStatusBuilder> each = this.zones.iterator();
        Object visitables = this._visitables.get("zones");
        while (each.hasNext()) {
            DNSZoneStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DNSZoneStatus> buildZones() {
        return this.zones != null ? DNSRecordStatusFluent.build(this.zones) : null;
    }

    public DNSZoneStatus buildZone(int index) {
        return this.zones.get(index).build();
    }

    public DNSZoneStatus buildFirstZone() {
        return this.zones.get(0).build();
    }

    public DNSZoneStatus buildLastZone() {
        return this.zones.get(this.zones.size() - 1).build();
    }

    public DNSZoneStatus buildMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        for (DNSZoneStatusBuilder item : this.zones) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        for (DNSZoneStatusBuilder item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<DNSZoneStatus> zones) {
        if (this.zones != null) {
            this._visitables.get("zones").clear();
        }
        if (zones != null) {
            this.zones = new ArrayList();
            for (DNSZoneStatus item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    public A withZones(DNSZoneStatus ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove("zones");
        }
        if (zones != null) {
            for (DNSZoneStatus item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public ZonesNested<A> addNewZone() {
        return new ZonesNested(-1, null);
    }

    public ZonesNested<A> addNewZoneLike(DNSZoneStatus item) {
        return new ZonesNested(-1, item);
    }

    public ZonesNested<A> setNewZoneLike(int index, DNSZoneStatus item) {
        return new ZonesNested(index, item);
    }

    public ZonesNested<A> editZone(int index) {
        if (this.zones.size() <= index) {
            throw new RuntimeException("Can't edit zones. Index exceeds size.");
        }
        return this.setNewZoneLike(index, this.buildZone(index));
    }

    public ZonesNested<A> editFirstZone() {
        if (this.zones.size() == 0) {
            throw new RuntimeException("Can't edit first zones. The list is empty.");
        }
        return this.setNewZoneLike(0, this.buildZone(0));
    }

    public ZonesNested<A> editLastZone() {
        int index = this.zones.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last zones. The list is empty.");
        }
        return this.setNewZoneLike(index, this.buildZone(index));
    }

    public ZonesNested<A> editMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.zones.size(); ++i) {
            if (!predicate.test(this.zones.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching zones. No match found.");
        }
        return this.setNewZoneLike(index, this.buildZone(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSRecordStatusFluent that = (DNSRecordStatusFluent)o;
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.observedGeneration, this.zones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ZonesNested<N>
    extends DNSZoneStatusFluent<ZonesNested<N>>
    implements Nested<N> {
        DNSZoneStatusBuilder builder;
        int index;

        ZonesNested(int index, DNSZoneStatus item) {
            this.index = index;
            this.builder = new DNSZoneStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSRecordStatusFluent.this.setToZones(this.index, this.builder.build());
        }

        public N endZone() {
            return this.and();
        }
    }
}

