/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev4;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataServicev4;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataServicev4Builder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataServicev4Fluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkGatewayv4;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkGatewayv4Builder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkGatewayv4Fluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkDataRoutev4Fluent<A extends NetworkDataRoutev4Fluent<A>>
extends BaseFluent<A> {
    private NetworkGatewayv4Builder gateway;
    private String network;
    private Integer prefix;
    private NetworkDataServicev4Builder services;
    private Map<String, Object> additionalProperties;

    public NetworkDataRoutev4Fluent() {
    }

    public NetworkDataRoutev4Fluent(NetworkDataRoutev4 instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkDataRoutev4 instance) {
        NetworkDataRoutev4 networkDataRoutev4 = instance = instance != null ? instance : new NetworkDataRoutev4();
        if (instance != null) {
            this.withGateway(instance.getGateway());
            this.withNetwork(instance.getNetwork());
            this.withPrefix(instance.getPrefix());
            this.withServices(instance.getServices());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NetworkGatewayv4 buildGateway() {
        return this.gateway != null ? this.gateway.build() : null;
    }

    public A withGateway(NetworkGatewayv4 gateway) {
        this._visitables.remove("gateway");
        if (gateway != null) {
            this.gateway = new NetworkGatewayv4Builder(gateway);
            this._visitables.get("gateway").add(this.gateway);
        } else {
            this.gateway = null;
            this._visitables.get("gateway").remove(this.gateway);
        }
        return (A)this;
    }

    public boolean hasGateway() {
        return this.gateway != null;
    }

    public A withNewGateway(String fromIPPool, String string) {
        return this.withGateway(new NetworkGatewayv4(fromIPPool, string));
    }

    public GatewayNested<A> withNewGateway() {
        return new GatewayNested(null);
    }

    public GatewayNested<A> withNewGatewayLike(NetworkGatewayv4 item) {
        return new GatewayNested(item);
    }

    public GatewayNested<A> editGateway() {
        return this.withNewGatewayLike(Optional.ofNullable(this.buildGateway()).orElse(null));
    }

    public GatewayNested<A> editOrNewGateway() {
        return this.withNewGatewayLike(Optional.ofNullable(this.buildGateway()).orElse(new NetworkGatewayv4Builder().build()));
    }

    public GatewayNested<A> editOrNewGatewayLike(NetworkGatewayv4 item) {
        return this.withNewGatewayLike(Optional.ofNullable(this.buildGateway()).orElse(item));
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public Integer getPrefix() {
        return this.prefix;
    }

    public A withPrefix(Integer prefix) {
        this.prefix = prefix;
        return (A)this;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public NetworkDataServicev4 buildServices() {
        return this.services != null ? this.services.build() : null;
    }

    public A withServices(NetworkDataServicev4 services) {
        this._visitables.remove("services");
        if (services != null) {
            this.services = new NetworkDataServicev4Builder(services);
            this._visitables.get("services").add(this.services);
        } else {
            this.services = null;
            this._visitables.get("services").remove(this.services);
        }
        return (A)this;
    }

    public boolean hasServices() {
        return this.services != null;
    }

    public ServicesNested<A> withNewServices() {
        return new ServicesNested(null);
    }

    public ServicesNested<A> withNewServicesLike(NetworkDataServicev4 item) {
        return new ServicesNested(item);
    }

    public ServicesNested<A> editServices() {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(null));
    }

    public ServicesNested<A> editOrNewServices() {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(new NetworkDataServicev4Builder().build()));
    }

    public ServicesNested<A> editOrNewServicesLike(NetworkDataServicev4 item) {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataRoutev4Fluent that = (NetworkDataRoutev4Fluent)o;
        if (!Objects.equals(this.gateway, that.gateway)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        if (!Objects.equals(this.services, that.services)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.gateway, this.network, this.prefix, this.services, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gateway != null) {
            sb.append("gateway:");
            sb.append(this.gateway + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.prefix != null) {
            sb.append("prefix:");
            sb.append(this.prefix + ",");
        }
        if (this.services != null) {
            sb.append("services:");
            sb.append(this.services + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServicesNested<N>
    extends NetworkDataServicev4Fluent<ServicesNested<N>>
    implements Nested<N> {
        NetworkDataServicev4Builder builder;

        ServicesNested(NetworkDataServicev4 item) {
            this.builder = new NetworkDataServicev4Builder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDataRoutev4Fluent.this.withServices(this.builder.build());
        }

        public N endServices() {
            return this.and();
        }
    }

    public class GatewayNested<N>
    extends NetworkGatewayv4Fluent<GatewayNested<N>>
    implements Nested<N> {
        NetworkGatewayv4Builder builder;

        GatewayNested(NetworkGatewayv4 item) {
            this.builder = new NetworkGatewayv4Builder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDataRoutev4Fluent.this.withGateway(this.builder.build());
        }

        public N endGateway() {
            return this.and();
        }
    }
}

