/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLink;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkBond;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkBondBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkBondFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkEthernet;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkEthernetBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkEthernetFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkVlan;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkVlanBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkVlanFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkDataLinkFluent<A extends NetworkDataLinkFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NetworkDataLinkBondBuilder> bonds = new ArrayList();
    private ArrayList<NetworkDataLinkEthernetBuilder> ethernets = new ArrayList();
    private ArrayList<NetworkDataLinkVlanBuilder> vlans = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NetworkDataLinkFluent() {
    }

    public NetworkDataLinkFluent(NetworkDataLink instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkDataLink instance) {
        NetworkDataLink networkDataLink = instance = instance != null ? instance : new NetworkDataLink();
        if (instance != null) {
            this.withBonds(instance.getBonds());
            this.withEthernets(instance.getEthernets());
            this.withVlans(instance.getVlans());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBonds(int index, NetworkDataLinkBond item) {
        if (this.bonds == null) {
            this.bonds = new ArrayList();
        }
        NetworkDataLinkBondBuilder builder = new NetworkDataLinkBondBuilder(item);
        if (index < 0 || index >= this.bonds.size()) {
            this._visitables.get("bonds").add(builder);
            this.bonds.add(builder);
        } else {
            this._visitables.get("bonds").add(index, builder);
            this.bonds.add(index, builder);
        }
        return (A)this;
    }

    public A setToBonds(int index, NetworkDataLinkBond item) {
        if (this.bonds == null) {
            this.bonds = new ArrayList();
        }
        NetworkDataLinkBondBuilder builder = new NetworkDataLinkBondBuilder(item);
        if (index < 0 || index >= this.bonds.size()) {
            this._visitables.get("bonds").add(builder);
            this.bonds.add(builder);
        } else {
            this._visitables.get("bonds").set(index, builder);
            this.bonds.set(index, builder);
        }
        return (A)this;
    }

    public A addToBonds(NetworkDataLinkBond ... items) {
        if (this.bonds == null) {
            this.bonds = new ArrayList();
        }
        for (NetworkDataLinkBond item : items) {
            NetworkDataLinkBondBuilder builder = new NetworkDataLinkBondBuilder(item);
            this._visitables.get("bonds").add(builder);
            this.bonds.add(builder);
        }
        return (A)this;
    }

    public A addAllToBonds(Collection<NetworkDataLinkBond> items) {
        if (this.bonds == null) {
            this.bonds = new ArrayList();
        }
        for (NetworkDataLinkBond item : items) {
            NetworkDataLinkBondBuilder builder = new NetworkDataLinkBondBuilder(item);
            this._visitables.get("bonds").add(builder);
            this.bonds.add(builder);
        }
        return (A)this;
    }

    public A removeFromBonds(NetworkDataLinkBond ... items) {
        if (this.bonds == null) {
            return (A)this;
        }
        for (NetworkDataLinkBond item : items) {
            NetworkDataLinkBondBuilder builder = new NetworkDataLinkBondBuilder(item);
            this._visitables.get("bonds").remove(builder);
            this.bonds.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromBonds(Collection<NetworkDataLinkBond> items) {
        if (this.bonds == null) {
            return (A)this;
        }
        for (NetworkDataLinkBond item : items) {
            NetworkDataLinkBondBuilder builder = new NetworkDataLinkBondBuilder(item);
            this._visitables.get("bonds").remove(builder);
            this.bonds.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromBonds(Predicate<NetworkDataLinkBondBuilder> predicate) {
        if (this.bonds == null) {
            return (A)this;
        }
        Iterator<NetworkDataLinkBondBuilder> each = this.bonds.iterator();
        Object visitables = this._visitables.get("bonds");
        while (each.hasNext()) {
            NetworkDataLinkBondBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkDataLinkBond> buildBonds() {
        return this.bonds != null ? NetworkDataLinkFluent.build(this.bonds) : null;
    }

    public NetworkDataLinkBond buildBond(int index) {
        return this.bonds.get(index).build();
    }

    public NetworkDataLinkBond buildFirstBond() {
        return this.bonds.get(0).build();
    }

    public NetworkDataLinkBond buildLastBond() {
        return this.bonds.get(this.bonds.size() - 1).build();
    }

    public NetworkDataLinkBond buildMatchingBond(Predicate<NetworkDataLinkBondBuilder> predicate) {
        for (NetworkDataLinkBondBuilder item : this.bonds) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBond(Predicate<NetworkDataLinkBondBuilder> predicate) {
        for (NetworkDataLinkBondBuilder item : this.bonds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBonds(List<NetworkDataLinkBond> bonds) {
        if (this.bonds != null) {
            this._visitables.get("bonds").clear();
        }
        if (bonds != null) {
            this.bonds = new ArrayList();
            for (NetworkDataLinkBond item : bonds) {
                this.addToBonds(item);
            }
        } else {
            this.bonds = null;
        }
        return (A)this;
    }

    public A withBonds(NetworkDataLinkBond ... bonds) {
        if (this.bonds != null) {
            this.bonds.clear();
            this._visitables.remove("bonds");
        }
        if (bonds != null) {
            for (NetworkDataLinkBond item : bonds) {
                this.addToBonds(item);
            }
        }
        return (A)this;
    }

    public boolean hasBonds() {
        return this.bonds != null && !this.bonds.isEmpty();
    }

    public BondsNested<A> addNewBond() {
        return new BondsNested(-1, null);
    }

    public BondsNested<A> addNewBondLike(NetworkDataLinkBond item) {
        return new BondsNested(-1, item);
    }

    public BondsNested<A> setNewBondLike(int index, NetworkDataLinkBond item) {
        return new BondsNested(index, item);
    }

    public BondsNested<A> editBond(int index) {
        if (this.bonds.size() <= index) {
            throw new RuntimeException("Can't edit bonds. Index exceeds size.");
        }
        return this.setNewBondLike(index, this.buildBond(index));
    }

    public BondsNested<A> editFirstBond() {
        if (this.bonds.size() == 0) {
            throw new RuntimeException("Can't edit first bonds. The list is empty.");
        }
        return this.setNewBondLike(0, this.buildBond(0));
    }

    public BondsNested<A> editLastBond() {
        int index = this.bonds.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last bonds. The list is empty.");
        }
        return this.setNewBondLike(index, this.buildBond(index));
    }

    public BondsNested<A> editMatchingBond(Predicate<NetworkDataLinkBondBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.bonds.size(); ++i) {
            if (!predicate.test(this.bonds.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching bonds. No match found.");
        }
        return this.setNewBondLike(index, this.buildBond(index));
    }

    public A addToEthernets(int index, NetworkDataLinkEthernet item) {
        if (this.ethernets == null) {
            this.ethernets = new ArrayList();
        }
        NetworkDataLinkEthernetBuilder builder = new NetworkDataLinkEthernetBuilder(item);
        if (index < 0 || index >= this.ethernets.size()) {
            this._visitables.get("ethernets").add(builder);
            this.ethernets.add(builder);
        } else {
            this._visitables.get("ethernets").add(index, builder);
            this.ethernets.add(index, builder);
        }
        return (A)this;
    }

    public A setToEthernets(int index, NetworkDataLinkEthernet item) {
        if (this.ethernets == null) {
            this.ethernets = new ArrayList();
        }
        NetworkDataLinkEthernetBuilder builder = new NetworkDataLinkEthernetBuilder(item);
        if (index < 0 || index >= this.ethernets.size()) {
            this._visitables.get("ethernets").add(builder);
            this.ethernets.add(builder);
        } else {
            this._visitables.get("ethernets").set(index, builder);
            this.ethernets.set(index, builder);
        }
        return (A)this;
    }

    public A addToEthernets(NetworkDataLinkEthernet ... items) {
        if (this.ethernets == null) {
            this.ethernets = new ArrayList();
        }
        for (NetworkDataLinkEthernet item : items) {
            NetworkDataLinkEthernetBuilder builder = new NetworkDataLinkEthernetBuilder(item);
            this._visitables.get("ethernets").add(builder);
            this.ethernets.add(builder);
        }
        return (A)this;
    }

    public A addAllToEthernets(Collection<NetworkDataLinkEthernet> items) {
        if (this.ethernets == null) {
            this.ethernets = new ArrayList();
        }
        for (NetworkDataLinkEthernet item : items) {
            NetworkDataLinkEthernetBuilder builder = new NetworkDataLinkEthernetBuilder(item);
            this._visitables.get("ethernets").add(builder);
            this.ethernets.add(builder);
        }
        return (A)this;
    }

    public A removeFromEthernets(NetworkDataLinkEthernet ... items) {
        if (this.ethernets == null) {
            return (A)this;
        }
        for (NetworkDataLinkEthernet item : items) {
            NetworkDataLinkEthernetBuilder builder = new NetworkDataLinkEthernetBuilder(item);
            this._visitables.get("ethernets").remove(builder);
            this.ethernets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEthernets(Collection<NetworkDataLinkEthernet> items) {
        if (this.ethernets == null) {
            return (A)this;
        }
        for (NetworkDataLinkEthernet item : items) {
            NetworkDataLinkEthernetBuilder builder = new NetworkDataLinkEthernetBuilder(item);
            this._visitables.get("ethernets").remove(builder);
            this.ethernets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEthernets(Predicate<NetworkDataLinkEthernetBuilder> predicate) {
        if (this.ethernets == null) {
            return (A)this;
        }
        Iterator<NetworkDataLinkEthernetBuilder> each = this.ethernets.iterator();
        Object visitables = this._visitables.get("ethernets");
        while (each.hasNext()) {
            NetworkDataLinkEthernetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkDataLinkEthernet> buildEthernets() {
        return this.ethernets != null ? NetworkDataLinkFluent.build(this.ethernets) : null;
    }

    public NetworkDataLinkEthernet buildEthernet(int index) {
        return this.ethernets.get(index).build();
    }

    public NetworkDataLinkEthernet buildFirstEthernet() {
        return this.ethernets.get(0).build();
    }

    public NetworkDataLinkEthernet buildLastEthernet() {
        return this.ethernets.get(this.ethernets.size() - 1).build();
    }

    public NetworkDataLinkEthernet buildMatchingEthernet(Predicate<NetworkDataLinkEthernetBuilder> predicate) {
        for (NetworkDataLinkEthernetBuilder item : this.ethernets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEthernet(Predicate<NetworkDataLinkEthernetBuilder> predicate) {
        for (NetworkDataLinkEthernetBuilder item : this.ethernets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEthernets(List<NetworkDataLinkEthernet> ethernets) {
        if (this.ethernets != null) {
            this._visitables.get("ethernets").clear();
        }
        if (ethernets != null) {
            this.ethernets = new ArrayList();
            for (NetworkDataLinkEthernet item : ethernets) {
                this.addToEthernets(item);
            }
        } else {
            this.ethernets = null;
        }
        return (A)this;
    }

    public A withEthernets(NetworkDataLinkEthernet ... ethernets) {
        if (this.ethernets != null) {
            this.ethernets.clear();
            this._visitables.remove("ethernets");
        }
        if (ethernets != null) {
            for (NetworkDataLinkEthernet item : ethernets) {
                this.addToEthernets(item);
            }
        }
        return (A)this;
    }

    public boolean hasEthernets() {
        return this.ethernets != null && !this.ethernets.isEmpty();
    }

    public EthernetsNested<A> addNewEthernet() {
        return new EthernetsNested(-1, null);
    }

    public EthernetsNested<A> addNewEthernetLike(NetworkDataLinkEthernet item) {
        return new EthernetsNested(-1, item);
    }

    public EthernetsNested<A> setNewEthernetLike(int index, NetworkDataLinkEthernet item) {
        return new EthernetsNested(index, item);
    }

    public EthernetsNested<A> editEthernet(int index) {
        if (this.ethernets.size() <= index) {
            throw new RuntimeException("Can't edit ethernets. Index exceeds size.");
        }
        return this.setNewEthernetLike(index, this.buildEthernet(index));
    }

    public EthernetsNested<A> editFirstEthernet() {
        if (this.ethernets.size() == 0) {
            throw new RuntimeException("Can't edit first ethernets. The list is empty.");
        }
        return this.setNewEthernetLike(0, this.buildEthernet(0));
    }

    public EthernetsNested<A> editLastEthernet() {
        int index = this.ethernets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ethernets. The list is empty.");
        }
        return this.setNewEthernetLike(index, this.buildEthernet(index));
    }

    public EthernetsNested<A> editMatchingEthernet(Predicate<NetworkDataLinkEthernetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ethernets.size(); ++i) {
            if (!predicate.test(this.ethernets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ethernets. No match found.");
        }
        return this.setNewEthernetLike(index, this.buildEthernet(index));
    }

    public A addToVlans(int index, NetworkDataLinkVlan item) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        NetworkDataLinkVlanBuilder builder = new NetworkDataLinkVlanBuilder(item);
        if (index < 0 || index >= this.vlans.size()) {
            this._visitables.get("vlans").add(builder);
            this.vlans.add(builder);
        } else {
            this._visitables.get("vlans").add(index, builder);
            this.vlans.add(index, builder);
        }
        return (A)this;
    }

    public A setToVlans(int index, NetworkDataLinkVlan item) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        NetworkDataLinkVlanBuilder builder = new NetworkDataLinkVlanBuilder(item);
        if (index < 0 || index >= this.vlans.size()) {
            this._visitables.get("vlans").add(builder);
            this.vlans.add(builder);
        } else {
            this._visitables.get("vlans").set(index, builder);
            this.vlans.set(index, builder);
        }
        return (A)this;
    }

    public A addToVlans(NetworkDataLinkVlan ... items) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        for (NetworkDataLinkVlan item : items) {
            NetworkDataLinkVlanBuilder builder = new NetworkDataLinkVlanBuilder(item);
            this._visitables.get("vlans").add(builder);
            this.vlans.add(builder);
        }
        return (A)this;
    }

    public A addAllToVlans(Collection<NetworkDataLinkVlan> items) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        for (NetworkDataLinkVlan item : items) {
            NetworkDataLinkVlanBuilder builder = new NetworkDataLinkVlanBuilder(item);
            this._visitables.get("vlans").add(builder);
            this.vlans.add(builder);
        }
        return (A)this;
    }

    public A removeFromVlans(NetworkDataLinkVlan ... items) {
        if (this.vlans == null) {
            return (A)this;
        }
        for (NetworkDataLinkVlan item : items) {
            NetworkDataLinkVlanBuilder builder = new NetworkDataLinkVlanBuilder(item);
            this._visitables.get("vlans").remove(builder);
            this.vlans.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVlans(Collection<NetworkDataLinkVlan> items) {
        if (this.vlans == null) {
            return (A)this;
        }
        for (NetworkDataLinkVlan item : items) {
            NetworkDataLinkVlanBuilder builder = new NetworkDataLinkVlanBuilder(item);
            this._visitables.get("vlans").remove(builder);
            this.vlans.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVlans(Predicate<NetworkDataLinkVlanBuilder> predicate) {
        if (this.vlans == null) {
            return (A)this;
        }
        Iterator<NetworkDataLinkVlanBuilder> each = this.vlans.iterator();
        Object visitables = this._visitables.get("vlans");
        while (each.hasNext()) {
            NetworkDataLinkVlanBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkDataLinkVlan> buildVlans() {
        return this.vlans != null ? NetworkDataLinkFluent.build(this.vlans) : null;
    }

    public NetworkDataLinkVlan buildVlan(int index) {
        return this.vlans.get(index).build();
    }

    public NetworkDataLinkVlan buildFirstVlan() {
        return this.vlans.get(0).build();
    }

    public NetworkDataLinkVlan buildLastVlan() {
        return this.vlans.get(this.vlans.size() - 1).build();
    }

    public NetworkDataLinkVlan buildMatchingVlan(Predicate<NetworkDataLinkVlanBuilder> predicate) {
        for (NetworkDataLinkVlanBuilder item : this.vlans) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVlan(Predicate<NetworkDataLinkVlanBuilder> predicate) {
        for (NetworkDataLinkVlanBuilder item : this.vlans) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVlans(List<NetworkDataLinkVlan> vlans) {
        if (this.vlans != null) {
            this._visitables.get("vlans").clear();
        }
        if (vlans != null) {
            this.vlans = new ArrayList();
            for (NetworkDataLinkVlan item : vlans) {
                this.addToVlans(item);
            }
        } else {
            this.vlans = null;
        }
        return (A)this;
    }

    public A withVlans(NetworkDataLinkVlan ... vlans) {
        if (this.vlans != null) {
            this.vlans.clear();
            this._visitables.remove("vlans");
        }
        if (vlans != null) {
            for (NetworkDataLinkVlan item : vlans) {
                this.addToVlans(item);
            }
        }
        return (A)this;
    }

    public boolean hasVlans() {
        return this.vlans != null && !this.vlans.isEmpty();
    }

    public VlansNested<A> addNewVlan() {
        return new VlansNested(-1, null);
    }

    public VlansNested<A> addNewVlanLike(NetworkDataLinkVlan item) {
        return new VlansNested(-1, item);
    }

    public VlansNested<A> setNewVlanLike(int index, NetworkDataLinkVlan item) {
        return new VlansNested(index, item);
    }

    public VlansNested<A> editVlan(int index) {
        if (this.vlans.size() <= index) {
            throw new RuntimeException("Can't edit vlans. Index exceeds size.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    public VlansNested<A> editFirstVlan() {
        if (this.vlans.size() == 0) {
            throw new RuntimeException("Can't edit first vlans. The list is empty.");
        }
        return this.setNewVlanLike(0, this.buildVlan(0));
    }

    public VlansNested<A> editLastVlan() {
        int index = this.vlans.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last vlans. The list is empty.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    public VlansNested<A> editMatchingVlan(Predicate<NetworkDataLinkVlanBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.vlans.size(); ++i) {
            if (!predicate.test(this.vlans.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching vlans. No match found.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataLinkFluent that = (NetworkDataLinkFluent)o;
        if (!Objects.equals(this.bonds, that.bonds)) {
            return false;
        }
        if (!Objects.equals(this.ethernets, that.ethernets)) {
            return false;
        }
        if (!Objects.equals(this.vlans, that.vlans)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bonds, this.ethernets, this.vlans, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bonds != null && !this.bonds.isEmpty()) {
            sb.append("bonds:");
            sb.append(this.bonds + ",");
        }
        if (this.ethernets != null && !this.ethernets.isEmpty()) {
            sb.append("ethernets:");
            sb.append(this.ethernets + ",");
        }
        if (this.vlans != null && !this.vlans.isEmpty()) {
            sb.append("vlans:");
            sb.append(this.vlans + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VlansNested<N>
    extends NetworkDataLinkVlanFluent<VlansNested<N>>
    implements Nested<N> {
        NetworkDataLinkVlanBuilder builder;
        int index;

        VlansNested(int index, NetworkDataLinkVlan item) {
            this.index = index;
            this.builder = new NetworkDataLinkVlanBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDataLinkFluent.this.setToVlans(this.index, this.builder.build());
        }

        public N endVlan() {
            return this.and();
        }
    }

    public class EthernetsNested<N>
    extends NetworkDataLinkEthernetFluent<EthernetsNested<N>>
    implements Nested<N> {
        NetworkDataLinkEthernetBuilder builder;
        int index;

        EthernetsNested(int index, NetworkDataLinkEthernet item) {
            this.index = index;
            this.builder = new NetworkDataLinkEthernetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDataLinkFluent.this.setToEthernets(this.index, this.builder.build());
        }

        public N endEthernet() {
            return this.and();
        }
    }

    public class BondsNested<N>
    extends NetworkDataLinkBondFluent<BondsNested<N>>
    implements Nested<N> {
        NetworkDataLinkBondBuilder builder;
        int index;

        BondsNested(int index, NetworkDataLinkBond item) {
            this.index = index;
            this.builder = new NetworkDataLinkBondBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDataLinkFluent.this.setToBonds(this.index, this.builder.build());
        }

        public N endBond() {
            return this.and();
        }
    }
}

