/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.AttachedImageReference;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.AttachedImageReferenceBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.AttachedImageReferenceFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.DataImageError;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.DataImageErrorBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.DataImageErrorFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.DataImageStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DataImageStatusFluent<A extends DataImageStatusFluent<A>>
extends BaseFluent<A> {
    private AttachedImageReferenceBuilder attachedImage;
    private DataImageErrorBuilder error;
    private String lastReconciled;
    private Map<String, Object> additionalProperties;

    public DataImageStatusFluent() {
    }

    public DataImageStatusFluent(DataImageStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DataImageStatus instance) {
        DataImageStatus dataImageStatus = instance = instance != null ? instance : new DataImageStatus();
        if (instance != null) {
            this.withAttachedImage(instance.getAttachedImage());
            this.withError(instance.getError());
            this.withLastReconciled(instance.getLastReconciled());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AttachedImageReference buildAttachedImage() {
        return this.attachedImage != null ? this.attachedImage.build() : null;
    }

    public A withAttachedImage(AttachedImageReference attachedImage) {
        this._visitables.remove("attachedImage");
        if (attachedImage != null) {
            this.attachedImage = new AttachedImageReferenceBuilder(attachedImage);
            this._visitables.get("attachedImage").add(this.attachedImage);
        } else {
            this.attachedImage = null;
            this._visitables.get("attachedImage").remove(this.attachedImage);
        }
        return (A)this;
    }

    public boolean hasAttachedImage() {
        return this.attachedImage != null;
    }

    public A withNewAttachedImage(String url) {
        return this.withAttachedImage(new AttachedImageReference(url));
    }

    public AttachedImageNested<A> withNewAttachedImage() {
        return new AttachedImageNested(null);
    }

    public AttachedImageNested<A> withNewAttachedImageLike(AttachedImageReference item) {
        return new AttachedImageNested(item);
    }

    public AttachedImageNested<A> editAttachedImage() {
        return this.withNewAttachedImageLike(Optional.ofNullable(this.buildAttachedImage()).orElse(null));
    }

    public AttachedImageNested<A> editOrNewAttachedImage() {
        return this.withNewAttachedImageLike(Optional.ofNullable(this.buildAttachedImage()).orElse(new AttachedImageReferenceBuilder().build()));
    }

    public AttachedImageNested<A> editOrNewAttachedImageLike(AttachedImageReference item) {
        return this.withNewAttachedImageLike(Optional.ofNullable(this.buildAttachedImage()).orElse(item));
    }

    public DataImageError buildError() {
        return this.error != null ? this.error.build() : null;
    }

    public A withError(DataImageError error) {
        this._visitables.remove("error");
        if (error != null) {
            this.error = new DataImageErrorBuilder(error);
            this._visitables.get("error").add(this.error);
        } else {
            this.error = null;
            this._visitables.get("error").remove(this.error);
        }
        return (A)this;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public A withNewError(Integer count, String message) {
        return this.withError(new DataImageError(count, message));
    }

    public ErrorNested<A> withNewError() {
        return new ErrorNested(null);
    }

    public ErrorNested<A> withNewErrorLike(DataImageError item) {
        return new ErrorNested(item);
    }

    public ErrorNested<A> editError() {
        return this.withNewErrorLike(Optional.ofNullable(this.buildError()).orElse(null));
    }

    public ErrorNested<A> editOrNewError() {
        return this.withNewErrorLike(Optional.ofNullable(this.buildError()).orElse(new DataImageErrorBuilder().build()));
    }

    public ErrorNested<A> editOrNewErrorLike(DataImageError item) {
        return this.withNewErrorLike(Optional.ofNullable(this.buildError()).orElse(item));
    }

    public String getLastReconciled() {
        return this.lastReconciled;
    }

    public A withLastReconciled(String lastReconciled) {
        this.lastReconciled = lastReconciled;
        return (A)this;
    }

    public boolean hasLastReconciled() {
        return this.lastReconciled != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataImageStatusFluent that = (DataImageStatusFluent)o;
        if (!Objects.equals(this.attachedImage, that.attachedImage)) {
            return false;
        }
        if (!Objects.equals(this.error, that.error)) {
            return false;
        }
        if (!Objects.equals(this.lastReconciled, that.lastReconciled)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attachedImage, this.error, this.lastReconciled, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachedImage != null) {
            sb.append("attachedImage:");
            sb.append(this.attachedImage + ",");
        }
        if (this.error != null) {
            sb.append("error:");
            sb.append(this.error + ",");
        }
        if (this.lastReconciled != null) {
            sb.append("lastReconciled:");
            sb.append(this.lastReconciled + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ErrorNested<N>
    extends DataImageErrorFluent<ErrorNested<N>>
    implements Nested<N> {
        DataImageErrorBuilder builder;

        ErrorNested(DataImageError item) {
            this.builder = new DataImageErrorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DataImageStatusFluent.this.withError(this.builder.build());
        }

        public N endError() {
            return this.and();
        }
    }

    public class AttachedImageNested<N>
    extends AttachedImageReferenceFluent<AttachedImageNested<N>>
    implements Nested<N> {
        AttachedImageReferenceBuilder builder;

        AttachedImageNested(AttachedImageReference item) {
            this.builder = new AttachedImageReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DataImageStatusFluent.this.withAttachedImage(this.builder.build());
        }

        public N endAttachedImage() {
            return this.and();
        }
    }
}

