/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.installer.vsphere.v1.Topology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TopologyFluent<A extends TopologyFluent<A>>
extends BaseFluent<A> {
    private String computeCluster;
    private String datacenter;
    private String datastore;
    private String folder;
    private List<String> networks = new ArrayList<String>();
    private String resourcePool;
    private List<String> tagIDs = new ArrayList<String>();
    private String template;
    private Map<String, Object> additionalProperties;

    public TopologyFluent() {
    }

    public TopologyFluent(Topology instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Topology instance) {
        Topology topology = instance = instance != null ? instance : new Topology();
        if (instance != null) {
            this.withComputeCluster(instance.getComputeCluster());
            this.withDatacenter(instance.getDatacenter());
            this.withDatastore(instance.getDatastore());
            this.withFolder(instance.getFolder());
            this.withNetworks(instance.getNetworks());
            this.withResourcePool(instance.getResourcePool());
            this.withTagIDs(instance.getTagIDs());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getComputeCluster() {
        return this.computeCluster;
    }

    public A withComputeCluster(String computeCluster) {
        this.computeCluster = computeCluster;
        return (A)this;
    }

    public boolean hasComputeCluster() {
        return this.computeCluster != null;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public A withDatacenter(String datacenter) {
        this.datacenter = datacenter;
        return (A)this;
    }

    public boolean hasDatacenter() {
        return this.datacenter != null;
    }

    public String getDatastore() {
        return this.datastore;
    }

    public A withDatastore(String datastore) {
        this.datastore = datastore;
        return (A)this;
    }

    public boolean hasDatastore() {
        return this.datastore != null;
    }

    public String getFolder() {
        return this.folder;
    }

    public A withFolder(String folder) {
        this.folder = folder;
        return (A)this;
    }

    public boolean hasFolder() {
        return this.folder != null;
    }

    public A addToNetworks(int index, String item) {
        if (this.networks == null) {
            this.networks = new ArrayList<String>();
        }
        this.networks.add(index, item);
        return (A)this;
    }

    public A setToNetworks(int index, String item) {
        if (this.networks == null) {
            this.networks = new ArrayList<String>();
        }
        this.networks.set(index, item);
        return (A)this;
    }

    public A addToNetworks(String ... items) {
        if (this.networks == null) {
            this.networks = new ArrayList<String>();
        }
        for (String item : items) {
            this.networks.add(item);
        }
        return (A)this;
    }

    public A addAllToNetworks(Collection<String> items) {
        if (this.networks == null) {
            this.networks = new ArrayList<String>();
        }
        for (String item : items) {
            this.networks.add(item);
        }
        return (A)this;
    }

    public A removeFromNetworks(String ... items) {
        if (this.networks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.networks.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNetworks(Collection<String> items) {
        if (this.networks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.networks.remove(item);
        }
        return (A)this;
    }

    public List<String> getNetworks() {
        return this.networks;
    }

    public String getNetwork(int index) {
        return this.networks.get(index);
    }

    public String getFirstNetwork() {
        return this.networks.get(0);
    }

    public String getLastNetwork() {
        return this.networks.get(this.networks.size() - 1);
    }

    public String getMatchingNetwork(Predicate<String> predicate) {
        for (String item : this.networks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNetwork(Predicate<String> predicate) {
        for (String item : this.networks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNetworks(List<String> networks) {
        if (networks != null) {
            this.networks = new ArrayList<String>();
            for (String item : networks) {
                this.addToNetworks(item);
            }
        } else {
            this.networks = null;
        }
        return (A)this;
    }

    public A withNetworks(String ... networks) {
        if (this.networks != null) {
            this.networks.clear();
            this._visitables.remove("networks");
        }
        if (networks != null) {
            for (String item : networks) {
                this.addToNetworks(item);
            }
        }
        return (A)this;
    }

    public boolean hasNetworks() {
        return this.networks != null && !this.networks.isEmpty();
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public A withResourcePool(String resourcePool) {
        this.resourcePool = resourcePool;
        return (A)this;
    }

    public boolean hasResourcePool() {
        return this.resourcePool != null;
    }

    public A addToTagIDs(int index, String item) {
        if (this.tagIDs == null) {
            this.tagIDs = new ArrayList<String>();
        }
        this.tagIDs.add(index, item);
        return (A)this;
    }

    public A setToTagIDs(int index, String item) {
        if (this.tagIDs == null) {
            this.tagIDs = new ArrayList<String>();
        }
        this.tagIDs.set(index, item);
        return (A)this;
    }

    public A addToTagIDs(String ... items) {
        if (this.tagIDs == null) {
            this.tagIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.tagIDs.add(item);
        }
        return (A)this;
    }

    public A addAllToTagIDs(Collection<String> items) {
        if (this.tagIDs == null) {
            this.tagIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.tagIDs.add(item);
        }
        return (A)this;
    }

    public A removeFromTagIDs(String ... items) {
        if (this.tagIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.tagIDs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTagIDs(Collection<String> items) {
        if (this.tagIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.tagIDs.remove(item);
        }
        return (A)this;
    }

    public List<String> getTagIDs() {
        return this.tagIDs;
    }

    public String getTagID(int index) {
        return this.tagIDs.get(index);
    }

    public String getFirstTagID() {
        return this.tagIDs.get(0);
    }

    public String getLastTagID() {
        return this.tagIDs.get(this.tagIDs.size() - 1);
    }

    public String getMatchingTagID(Predicate<String> predicate) {
        for (String item : this.tagIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTagID(Predicate<String> predicate) {
        for (String item : this.tagIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTagIDs(List<String> tagIDs) {
        if (tagIDs != null) {
            this.tagIDs = new ArrayList<String>();
            for (String item : tagIDs) {
                this.addToTagIDs(item);
            }
        } else {
            this.tagIDs = null;
        }
        return (A)this;
    }

    public A withTagIDs(String ... tagIDs) {
        if (this.tagIDs != null) {
            this.tagIDs.clear();
            this._visitables.remove("tagIDs");
        }
        if (tagIDs != null) {
            for (String item : tagIDs) {
                this.addToTagIDs(item);
            }
        }
        return (A)this;
    }

    public boolean hasTagIDs() {
        return this.tagIDs != null && !this.tagIDs.isEmpty();
    }

    public String getTemplate() {
        return this.template;
    }

    public A withTemplate(String template) {
        this.template = template;
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopologyFluent that = (TopologyFluent)o;
        if (!Objects.equals(this.computeCluster, that.computeCluster)) {
            return false;
        }
        if (!Objects.equals(this.datacenter, that.datacenter)) {
            return false;
        }
        if (!Objects.equals(this.datastore, that.datastore)) {
            return false;
        }
        if (!Objects.equals(this.folder, that.folder)) {
            return false;
        }
        if (!Objects.equals(this.networks, that.networks)) {
            return false;
        }
        if (!Objects.equals(this.resourcePool, that.resourcePool)) {
            return false;
        }
        if (!Objects.equals(this.tagIDs, that.tagIDs)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.computeCluster, this.datacenter, this.datastore, this.folder, this.networks, this.resourcePool, this.tagIDs, this.template, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeCluster != null) {
            sb.append("computeCluster:");
            sb.append(this.computeCluster + ",");
        }
        if (this.datacenter != null) {
            sb.append("datacenter:");
            sb.append(this.datacenter + ",");
        }
        if (this.datastore != null) {
            sb.append("datastore:");
            sb.append(this.datastore + ",");
        }
        if (this.folder != null) {
            sb.append("folder:");
            sb.append(this.folder + ",");
        }
        if (this.networks != null && !this.networks.isEmpty()) {
            sb.append("networks:");
            sb.append(this.networks + ",");
        }
        if (this.resourcePool != null) {
            sb.append("resourcePool:");
            sb.append(this.resourcePool + ",");
        }
        if (this.tagIDs != null && !this.tagIDs.isEmpty()) {
            sb.append("tagIDs:");
            sb.append(this.tagIDs + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

