/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.SyncCondition;
import io.fabric8.openshift.api.model.hive.v1.SyncConditionBuilder;
import io.fabric8.openshift.api.model.hive.v1.SyncConditionFluent;
import io.fabric8.openshift.api.model.hive.v1.SyncSetObjectStatus;
import io.fabric8.openshift.api.model.hive.v1.SyncStatus;
import io.fabric8.openshift.api.model.hive.v1.SyncStatusBuilder;
import io.fabric8.openshift.api.model.hive.v1.SyncStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SyncSetObjectStatusFluent<A extends SyncSetObjectStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<SyncConditionBuilder> conditions = new ArrayList();
    private String name;
    private ArrayList<SyncStatusBuilder> patches = new ArrayList();
    private String resourceApplyMode;
    private ArrayList<SyncStatusBuilder> resources = new ArrayList();
    private ArrayList<SyncStatusBuilder> secrets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public SyncSetObjectStatusFluent() {
    }

    public SyncSetObjectStatusFluent(SyncSetObjectStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SyncSetObjectStatus instance) {
        SyncSetObjectStatus syncSetObjectStatus = instance = instance != null ? instance : new SyncSetObjectStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withName(instance.getName());
            this.withPatches(instance.getPatches());
            this.withResourceApplyMode(instance.getResourceApplyMode());
            this.withResources(instance.getResources());
            this.withSecrets(instance.getSecrets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, SyncCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        SyncConditionBuilder builder = new SyncConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, SyncCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        SyncConditionBuilder builder = new SyncConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(SyncCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (SyncCondition item : items) {
            SyncConditionBuilder builder = new SyncConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<SyncCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (SyncCondition item : items) {
            SyncConditionBuilder builder = new SyncConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(SyncCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (SyncCondition item : items) {
            SyncConditionBuilder builder = new SyncConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<SyncCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (SyncCondition item : items) {
            SyncConditionBuilder builder = new SyncConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<SyncConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<SyncConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            SyncConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SyncCondition> buildConditions() {
        return this.conditions != null ? SyncSetObjectStatusFluent.build(this.conditions) : null;
    }

    public SyncCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public SyncCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public SyncCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public SyncCondition buildMatchingCondition(Predicate<SyncConditionBuilder> predicate) {
        for (SyncConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<SyncConditionBuilder> predicate) {
        for (SyncConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<SyncCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (SyncCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(SyncCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (SyncCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(SyncCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, SyncCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<SyncConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToPatches(int index, SyncStatus item) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        SyncStatusBuilder builder = new SyncStatusBuilder(item);
        if (index < 0 || index >= this.patches.size()) {
            this._visitables.get("patches").add(builder);
            this.patches.add(builder);
        } else {
            this._visitables.get("patches").add(index, builder);
            this.patches.add(index, builder);
        }
        return (A)this;
    }

    public A setToPatches(int index, SyncStatus item) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        SyncStatusBuilder builder = new SyncStatusBuilder(item);
        if (index < 0 || index >= this.patches.size()) {
            this._visitables.get("patches").add(builder);
            this.patches.add(builder);
        } else {
            this._visitables.get("patches").set(index, builder);
            this.patches.set(index, builder);
        }
        return (A)this;
    }

    public A addToPatches(SyncStatus ... items) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("patches").add(builder);
            this.patches.add(builder);
        }
        return (A)this;
    }

    public A addAllToPatches(Collection<SyncStatus> items) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("patches").add(builder);
            this.patches.add(builder);
        }
        return (A)this;
    }

    public A removeFromPatches(SyncStatus ... items) {
        if (this.patches == null) {
            return (A)this;
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("patches").remove(builder);
            this.patches.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPatches(Collection<SyncStatus> items) {
        if (this.patches == null) {
            return (A)this;
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("patches").remove(builder);
            this.patches.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPatches(Predicate<SyncStatusBuilder> predicate) {
        if (this.patches == null) {
            return (A)this;
        }
        Iterator<SyncStatusBuilder> each = this.patches.iterator();
        Object visitables = this._visitables.get("patches");
        while (each.hasNext()) {
            SyncStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SyncStatus> buildPatches() {
        return this.patches != null ? SyncSetObjectStatusFluent.build(this.patches) : null;
    }

    public SyncStatus buildPatch(int index) {
        return this.patches.get(index).build();
    }

    public SyncStatus buildFirstPatch() {
        return this.patches.get(0).build();
    }

    public SyncStatus buildLastPatch() {
        return this.patches.get(this.patches.size() - 1).build();
    }

    public SyncStatus buildMatchingPatch(Predicate<SyncStatusBuilder> predicate) {
        for (SyncStatusBuilder item : this.patches) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPatch(Predicate<SyncStatusBuilder> predicate) {
        for (SyncStatusBuilder item : this.patches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPatches(List<SyncStatus> patches) {
        if (this.patches != null) {
            this._visitables.get("patches").clear();
        }
        if (patches != null) {
            this.patches = new ArrayList();
            for (SyncStatus item : patches) {
                this.addToPatches(item);
            }
        } else {
            this.patches = null;
        }
        return (A)this;
    }

    public A withPatches(SyncStatus ... patches) {
        if (this.patches != null) {
            this.patches.clear();
            this._visitables.remove("patches");
        }
        if (patches != null) {
            for (SyncStatus item : patches) {
                this.addToPatches(item);
            }
        }
        return (A)this;
    }

    public boolean hasPatches() {
        return this.patches != null && !this.patches.isEmpty();
    }

    public PatchesNested<A> addNewPatch() {
        return new PatchesNested(-1, null);
    }

    public PatchesNested<A> addNewPatchLike(SyncStatus item) {
        return new PatchesNested(-1, item);
    }

    public PatchesNested<A> setNewPatchLike(int index, SyncStatus item) {
        return new PatchesNested(index, item);
    }

    public PatchesNested<A> editPatch(int index) {
        if (this.patches.size() <= index) {
            throw new RuntimeException("Can't edit patches. Index exceeds size.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    public PatchesNested<A> editFirstPatch() {
        if (this.patches.size() == 0) {
            throw new RuntimeException("Can't edit first patches. The list is empty.");
        }
        return this.setNewPatchLike(0, this.buildPatch(0));
    }

    public PatchesNested<A> editLastPatch() {
        int index = this.patches.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last patches. The list is empty.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    public PatchesNested<A> editMatchingPatch(Predicate<SyncStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.patches.size(); ++i) {
            if (!predicate.test(this.patches.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching patches. No match found.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    public String getResourceApplyMode() {
        return this.resourceApplyMode;
    }

    public A withResourceApplyMode(String resourceApplyMode) {
        this.resourceApplyMode = resourceApplyMode;
        return (A)this;
    }

    public boolean hasResourceApplyMode() {
        return this.resourceApplyMode != null;
    }

    public A addToResources(int index, SyncStatus item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        SyncStatusBuilder builder = new SyncStatusBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get("resources").add(index, builder);
            this.resources.add(index, builder);
        }
        return (A)this;
    }

    public A setToResources(int index, SyncStatus item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        SyncStatusBuilder builder = new SyncStatusBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get("resources").set(index, builder);
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    public A addToResources(SyncStatus ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    public A addAllToResources(Collection<SyncStatus> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    public A removeFromResources(SyncStatus ... items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("resources").remove(builder);
            this.resources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResources(Collection<SyncStatus> items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("resources").remove(builder);
            this.resources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResources(Predicate<SyncStatusBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<SyncStatusBuilder> each = this.resources.iterator();
        Object visitables = this._visitables.get("resources");
        while (each.hasNext()) {
            SyncStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SyncStatus> buildResources() {
        return this.resources != null ? SyncSetObjectStatusFluent.build(this.resources) : null;
    }

    public SyncStatus buildResource(int index) {
        return this.resources.get(index).build();
    }

    public SyncStatus buildFirstResource() {
        return this.resources.get(0).build();
    }

    public SyncStatus buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    public SyncStatus buildMatchingResource(Predicate<SyncStatusBuilder> predicate) {
        for (SyncStatusBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<SyncStatusBuilder> predicate) {
        for (SyncStatusBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<SyncStatus> resources) {
        if (this.resources != null) {
            this._visitables.get("resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (SyncStatus item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    public A withResources(SyncStatus ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove("resources");
        }
        if (resources != null) {
            for (SyncStatus item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public ResourcesNested<A> addNewResource() {
        return new ResourcesNested(-1, null);
    }

    public ResourcesNested<A> addNewResourceLike(SyncStatus item) {
        return new ResourcesNested(-1, item);
    }

    public ResourcesNested<A> setNewResourceLike(int index, SyncStatus item) {
        return new ResourcesNested(index, item);
    }

    public ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    public ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editMatchingResource(Predicate<SyncStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public A addToSecrets(int index, SyncStatus item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        SyncStatusBuilder builder = new SyncStatusBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").add(index, builder);
            this.secrets.add(index, builder);
        }
        return (A)this;
    }

    public A setToSecrets(int index, SyncStatus item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        SyncStatusBuilder builder = new SyncStatusBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").set(index, builder);
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    public A addToSecrets(SyncStatus ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    public A addAllToSecrets(Collection<SyncStatus> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    public A removeFromSecrets(SyncStatus ... items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("secrets").remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSecrets(Collection<SyncStatus> items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (SyncStatus item : items) {
            SyncStatusBuilder builder = new SyncStatusBuilder(item);
            this._visitables.get("secrets").remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSecrets(Predicate<SyncStatusBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<SyncStatusBuilder> each = this.secrets.iterator();
        Object visitables = this._visitables.get("secrets");
        while (each.hasNext()) {
            SyncStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SyncStatus> buildSecrets() {
        return this.secrets != null ? SyncSetObjectStatusFluent.build(this.secrets) : null;
    }

    public SyncStatus buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public SyncStatus buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public SyncStatus buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    public SyncStatus buildMatchingSecret(Predicate<SyncStatusBuilder> predicate) {
        for (SyncStatusBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<SyncStatusBuilder> predicate) {
        for (SyncStatusBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<SyncStatus> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").clear();
        }
        if (secrets != null) {
            this.secrets = new ArrayList();
            for (SyncStatus item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    public A withSecrets(SyncStatus ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove("secrets");
        }
        if (secrets != null) {
            for (SyncStatus item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public SecretsNested<A> addNewSecret() {
        return new SecretsNested(-1, null);
    }

    public SecretsNested<A> addNewSecretLike(SyncStatus item) {
        return new SecretsNested(-1, item);
    }

    public SecretsNested<A> setNewSecretLike(int index, SyncStatus item) {
        return new SecretsNested(index, item);
    }

    public SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    public SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editMatchingSecret(Predicate<SyncStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SyncSetObjectStatusFluent that = (SyncSetObjectStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.patches, that.patches)) {
            return false;
        }
        if (!Objects.equals(this.resourceApplyMode, that.resourceApplyMode)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.name, this.patches, this.resourceApplyMode, this.resources, this.secrets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.patches != null && !this.patches.isEmpty()) {
            sb.append("patches:");
            sb.append(this.patches + ",");
        }
        if (this.resourceApplyMode != null) {
            sb.append("resourceApplyMode:");
            sb.append(this.resourceApplyMode + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretsNested<N>
    extends SyncStatusFluent<SecretsNested<N>>
    implements Nested<N> {
        SyncStatusBuilder builder;
        int index;

        SecretsNested(int index, SyncStatus item) {
            this.index = index;
            this.builder = new SyncStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SyncSetObjectStatusFluent.this.setToSecrets(this.index, this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends SyncStatusFluent<ResourcesNested<N>>
    implements Nested<N> {
        SyncStatusBuilder builder;
        int index;

        ResourcesNested(int index, SyncStatus item) {
            this.index = index;
            this.builder = new SyncStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SyncSetObjectStatusFluent.this.setToResources(this.index, this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }

    public class PatchesNested<N>
    extends SyncStatusFluent<PatchesNested<N>>
    implements Nested<N> {
        SyncStatusBuilder builder;
        int index;

        PatchesNested(int index, SyncStatus item) {
            this.index = index;
            this.builder = new SyncStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SyncSetObjectStatusFluent.this.setToPatches(this.index, this.builder.build());
        }

        public N endPatch() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends SyncConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        SyncConditionBuilder builder;
        int index;

        ConditionsNested(int index, SyncCondition item) {
            this.index = index;
            this.builder = new SyncConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SyncSetObjectStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

