/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfig;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfigFluent;
import io.fabric8.openshift.api.model.config.v1.GCPPlatformStatus;
import io.fabric8.openshift.api.model.config.v1.GCPResourceLabel;
import io.fabric8.openshift.api.model.config.v1.GCPResourceLabelBuilder;
import io.fabric8.openshift.api.model.config.v1.GCPResourceLabelFluent;
import io.fabric8.openshift.api.model.config.v1.GCPResourceTag;
import io.fabric8.openshift.api.model.config.v1.GCPResourceTagBuilder;
import io.fabric8.openshift.api.model.config.v1.GCPResourceTagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GCPPlatformStatusFluent<A extends GCPPlatformStatusFluent<A>>
extends BaseFluent<A> {
    private CloudLoadBalancerConfigBuilder cloudLoadBalancerConfig;
    private String projectID;
    private String region;
    private ArrayList<GCPResourceLabelBuilder> resourceLabels = new ArrayList();
    private ArrayList<GCPResourceTagBuilder> resourceTags = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GCPPlatformStatusFluent() {
    }

    public GCPPlatformStatusFluent(GCPPlatformStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GCPPlatformStatus instance) {
        GCPPlatformStatus gCPPlatformStatus = instance = instance != null ? instance : new GCPPlatformStatus();
        if (instance != null) {
            this.withCloudLoadBalancerConfig(instance.getCloudLoadBalancerConfig());
            this.withProjectID(instance.getProjectID());
            this.withRegion(instance.getRegion());
            this.withResourceLabels(instance.getResourceLabels());
            this.withResourceTags(instance.getResourceTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CloudLoadBalancerConfig buildCloudLoadBalancerConfig() {
        return this.cloudLoadBalancerConfig != null ? this.cloudLoadBalancerConfig.build() : null;
    }

    public A withCloudLoadBalancerConfig(CloudLoadBalancerConfig cloudLoadBalancerConfig) {
        this._visitables.remove("cloudLoadBalancerConfig");
        if (cloudLoadBalancerConfig != null) {
            this.cloudLoadBalancerConfig = new CloudLoadBalancerConfigBuilder(cloudLoadBalancerConfig);
            this._visitables.get("cloudLoadBalancerConfig").add(this.cloudLoadBalancerConfig);
        } else {
            this.cloudLoadBalancerConfig = null;
            this._visitables.get("cloudLoadBalancerConfig").remove(this.cloudLoadBalancerConfig);
        }
        return (A)this;
    }

    public boolean hasCloudLoadBalancerConfig() {
        return this.cloudLoadBalancerConfig != null;
    }

    public CloudLoadBalancerConfigNested<A> withNewCloudLoadBalancerConfig() {
        return new CloudLoadBalancerConfigNested(null);
    }

    public CloudLoadBalancerConfigNested<A> withNewCloudLoadBalancerConfigLike(CloudLoadBalancerConfig item) {
        return new CloudLoadBalancerConfigNested(item);
    }

    public CloudLoadBalancerConfigNested<A> editCloudLoadBalancerConfig() {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(null));
    }

    public CloudLoadBalancerConfigNested<A> editOrNewCloudLoadBalancerConfig() {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(new CloudLoadBalancerConfigBuilder().build()));
    }

    public CloudLoadBalancerConfigNested<A> editOrNewCloudLoadBalancerConfigLike(CloudLoadBalancerConfig item) {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(item));
    }

    public String getProjectID() {
        return this.projectID;
    }

    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)this;
    }

    public boolean hasProjectID() {
        return this.projectID != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToResourceLabels(int index, GCPResourceLabel item) {
        if (this.resourceLabels == null) {
            this.resourceLabels = new ArrayList();
        }
        GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);
        if (index < 0 || index >= this.resourceLabels.size()) {
            this._visitables.get("resourceLabels").add(builder);
            this.resourceLabels.add(builder);
        } else {
            this._visitables.get("resourceLabels").add(index, builder);
            this.resourceLabels.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceLabels(int index, GCPResourceLabel item) {
        if (this.resourceLabels == null) {
            this.resourceLabels = new ArrayList();
        }
        GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);
        if (index < 0 || index >= this.resourceLabels.size()) {
            this._visitables.get("resourceLabels").add(builder);
            this.resourceLabels.add(builder);
        } else {
            this._visitables.get("resourceLabels").set(index, builder);
            this.resourceLabels.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceLabels(GCPResourceLabel ... items) {
        if (this.resourceLabels == null) {
            this.resourceLabels = new ArrayList();
        }
        for (GCPResourceLabel item : items) {
            GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);
            this._visitables.get("resourceLabels").add(builder);
            this.resourceLabels.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceLabels(Collection<GCPResourceLabel> items) {
        if (this.resourceLabels == null) {
            this.resourceLabels = new ArrayList();
        }
        for (GCPResourceLabel item : items) {
            GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);
            this._visitables.get("resourceLabels").add(builder);
            this.resourceLabels.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceLabels(GCPResourceLabel ... items) {
        if (this.resourceLabels == null) {
            return (A)this;
        }
        for (GCPResourceLabel item : items) {
            GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);
            this._visitables.get("resourceLabels").remove(builder);
            this.resourceLabels.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceLabels(Collection<GCPResourceLabel> items) {
        if (this.resourceLabels == null) {
            return (A)this;
        }
        for (GCPResourceLabel item : items) {
            GCPResourceLabelBuilder builder = new GCPResourceLabelBuilder(item);
            this._visitables.get("resourceLabels").remove(builder);
            this.resourceLabels.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceLabels(Predicate<GCPResourceLabelBuilder> predicate) {
        if (this.resourceLabels == null) {
            return (A)this;
        }
        Iterator<GCPResourceLabelBuilder> each = this.resourceLabels.iterator();
        Object visitables = this._visitables.get("resourceLabels");
        while (each.hasNext()) {
            GCPResourceLabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<GCPResourceLabel> buildResourceLabels() {
        return this.resourceLabels != null ? GCPPlatformStatusFluent.build(this.resourceLabels) : null;
    }

    public GCPResourceLabel buildResourceLabel(int index) {
        return this.resourceLabels.get(index).build();
    }

    public GCPResourceLabel buildFirstResourceLabel() {
        return this.resourceLabels.get(0).build();
    }

    public GCPResourceLabel buildLastResourceLabel() {
        return this.resourceLabels.get(this.resourceLabels.size() - 1).build();
    }

    public GCPResourceLabel buildMatchingResourceLabel(Predicate<GCPResourceLabelBuilder> predicate) {
        for (GCPResourceLabelBuilder item : this.resourceLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceLabel(Predicate<GCPResourceLabelBuilder> predicate) {
        for (GCPResourceLabelBuilder item : this.resourceLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceLabels(List<GCPResourceLabel> resourceLabels) {
        if (this.resourceLabels != null) {
            this._visitables.get("resourceLabels").clear();
        }
        if (resourceLabels != null) {
            this.resourceLabels = new ArrayList();
            for (GCPResourceLabel item : resourceLabels) {
                this.addToResourceLabels(item);
            }
        } else {
            this.resourceLabels = null;
        }
        return (A)this;
    }

    public A withResourceLabels(GCPResourceLabel ... resourceLabels) {
        if (this.resourceLabels != null) {
            this.resourceLabels.clear();
            this._visitables.remove("resourceLabels");
        }
        if (resourceLabels != null) {
            for (GCPResourceLabel item : resourceLabels) {
                this.addToResourceLabels(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceLabels() {
        return this.resourceLabels != null && !this.resourceLabels.isEmpty();
    }

    public A addNewResourceLabel(String key, String value) {
        return this.addToResourceLabels(new GCPResourceLabel(key, value));
    }

    public ResourceLabelsNested<A> addNewResourceLabel() {
        return new ResourceLabelsNested(-1, null);
    }

    public ResourceLabelsNested<A> addNewResourceLabelLike(GCPResourceLabel item) {
        return new ResourceLabelsNested(-1, item);
    }

    public ResourceLabelsNested<A> setNewResourceLabelLike(int index, GCPResourceLabel item) {
        return new ResourceLabelsNested(index, item);
    }

    public ResourceLabelsNested<A> editResourceLabel(int index) {
        if (this.resourceLabels.size() <= index) {
            throw new RuntimeException("Can't edit resourceLabels. Index exceeds size.");
        }
        return this.setNewResourceLabelLike(index, this.buildResourceLabel(index));
    }

    public ResourceLabelsNested<A> editFirstResourceLabel() {
        if (this.resourceLabels.size() == 0) {
            throw new RuntimeException("Can't edit first resourceLabels. The list is empty.");
        }
        return this.setNewResourceLabelLike(0, this.buildResourceLabel(0));
    }

    public ResourceLabelsNested<A> editLastResourceLabel() {
        int index = this.resourceLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceLabels. The list is empty.");
        }
        return this.setNewResourceLabelLike(index, this.buildResourceLabel(index));
    }

    public ResourceLabelsNested<A> editMatchingResourceLabel(Predicate<GCPResourceLabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceLabels.size(); ++i) {
            if (!predicate.test(this.resourceLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceLabels. No match found.");
        }
        return this.setNewResourceLabelLike(index, this.buildResourceLabel(index));
    }

    public A addToResourceTags(int index, GCPResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get("resourceTags").add(index, builder);
            this.resourceTags.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceTags(int index, GCPResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get("resourceTags").set(index, builder);
            this.resourceTags.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceTags(GCPResourceTag ... items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (GCPResourceTag item : items) {
            GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceTags(Collection<GCPResourceTag> items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (GCPResourceTag item : items) {
            GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceTags(GCPResourceTag ... items) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        for (GCPResourceTag item : items) {
            GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);
            this._visitables.get("resourceTags").remove(builder);
            this.resourceTags.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceTags(Collection<GCPResourceTag> items) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        for (GCPResourceTag item : items) {
            GCPResourceTagBuilder builder = new GCPResourceTagBuilder(item);
            this._visitables.get("resourceTags").remove(builder);
            this.resourceTags.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceTags(Predicate<GCPResourceTagBuilder> predicate) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        Iterator<GCPResourceTagBuilder> each = this.resourceTags.iterator();
        Object visitables = this._visitables.get("resourceTags");
        while (each.hasNext()) {
            GCPResourceTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<GCPResourceTag> buildResourceTags() {
        return this.resourceTags != null ? GCPPlatformStatusFluent.build(this.resourceTags) : null;
    }

    public GCPResourceTag buildResourceTag(int index) {
        return this.resourceTags.get(index).build();
    }

    public GCPResourceTag buildFirstResourceTag() {
        return this.resourceTags.get(0).build();
    }

    public GCPResourceTag buildLastResourceTag() {
        return this.resourceTags.get(this.resourceTags.size() - 1).build();
    }

    public GCPResourceTag buildMatchingResourceTag(Predicate<GCPResourceTagBuilder> predicate) {
        for (GCPResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceTag(Predicate<GCPResourceTagBuilder> predicate) {
        for (GCPResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceTags(List<GCPResourceTag> resourceTags) {
        if (this.resourceTags != null) {
            this._visitables.get("resourceTags").clear();
        }
        if (resourceTags != null) {
            this.resourceTags = new ArrayList();
            for (GCPResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        } else {
            this.resourceTags = null;
        }
        return (A)this;
    }

    public A withResourceTags(GCPResourceTag ... resourceTags) {
        if (this.resourceTags != null) {
            this.resourceTags.clear();
            this._visitables.remove("resourceTags");
        }
        if (resourceTags != null) {
            for (GCPResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceTags() {
        return this.resourceTags != null && !this.resourceTags.isEmpty();
    }

    public A addNewResourceTag(String key, String parentID, String value) {
        return this.addToResourceTags(new GCPResourceTag(key, parentID, value));
    }

    public ResourceTagsNested<A> addNewResourceTag() {
        return new ResourceTagsNested(-1, null);
    }

    public ResourceTagsNested<A> addNewResourceTagLike(GCPResourceTag item) {
        return new ResourceTagsNested(-1, item);
    }

    public ResourceTagsNested<A> setNewResourceTagLike(int index, GCPResourceTag item) {
        return new ResourceTagsNested(index, item);
    }

    public ResourceTagsNested<A> editResourceTag(int index) {
        if (this.resourceTags.size() <= index) {
            throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ResourceTagsNested<A> editFirstResourceTag() {
        if (this.resourceTags.size() == 0) {
            throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
        }
        return this.setNewResourceTagLike(0, this.buildResourceTag(0));
    }

    public ResourceTagsNested<A> editLastResourceTag() {
        int index = this.resourceTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ResourceTagsNested<A> editMatchingResourceTag(Predicate<GCPResourceTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceTags.size(); ++i) {
            if (!predicate.test(this.resourceTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceTags. No match found.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GCPPlatformStatusFluent that = (GCPPlatformStatusFluent)o;
        if (!Objects.equals(this.cloudLoadBalancerConfig, that.cloudLoadBalancerConfig)) {
            return false;
        }
        if (!Objects.equals(this.projectID, that.projectID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.resourceLabels, that.resourceLabels)) {
            return false;
        }
        if (!Objects.equals(this.resourceTags, that.resourceTags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cloudLoadBalancerConfig, this.projectID, this.region, this.resourceLabels, this.resourceTags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cloudLoadBalancerConfig != null) {
            sb.append("cloudLoadBalancerConfig:");
            sb.append(this.cloudLoadBalancerConfig + ",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceLabels != null && !this.resourceLabels.isEmpty()) {
            sb.append("resourceLabels:");
            sb.append(this.resourceLabels + ",");
        }
        if (this.resourceTags != null && !this.resourceTags.isEmpty()) {
            sb.append("resourceTags:");
            sb.append(this.resourceTags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceTagsNested<N>
    extends GCPResourceTagFluent<ResourceTagsNested<N>>
    implements Nested<N> {
        GCPResourceTagBuilder builder;
        int index;

        ResourceTagsNested(int index, GCPResourceTag item) {
            this.index = index;
            this.builder = new GCPResourceTagBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GCPPlatformStatusFluent.this.setToResourceTags(this.index, this.builder.build());
        }

        public N endResourceTag() {
            return this.and();
        }
    }

    public class ResourceLabelsNested<N>
    extends GCPResourceLabelFluent<ResourceLabelsNested<N>>
    implements Nested<N> {
        GCPResourceLabelBuilder builder;
        int index;

        ResourceLabelsNested(int index, GCPResourceLabel item) {
            this.index = index;
            this.builder = new GCPResourceLabelBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GCPPlatformStatusFluent.this.setToResourceLabels(this.index, this.builder.build());
        }

        public N endResourceLabel() {
            return this.and();
        }
    }

    public class CloudLoadBalancerConfigNested<N>
    extends CloudLoadBalancerConfigFluent<CloudLoadBalancerConfigNested<N>>
    implements Nested<N> {
        CloudLoadBalancerConfigBuilder builder;

        CloudLoadBalancerConfigNested(CloudLoadBalancerConfig item) {
            this.builder = new CloudLoadBalancerConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GCPPlatformStatusFluent.this.withCloudLoadBalancerConfig(this.builder.build());
        }

        public N endCloudLoadBalancerConfig() {
            return this.and();
        }
    }
}

