/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.NamedRoleBinding;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NamedRoleBindingFluent<A extends NamedRoleBindingFluent<A>>
extends BaseFluent<A> {
    private String name;
    private RoleBindingBuilder roleBinding;
    private Map<String, Object> additionalProperties;

    public NamedRoleBindingFluent() {
    }

    public NamedRoleBindingFluent(NamedRoleBinding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamedRoleBinding instance) {
        NamedRoleBinding namedRoleBinding = instance = instance != null ? instance : new NamedRoleBinding();
        if (instance != null) {
            this.withName(instance.getName());
            this.withRoleBinding(instance.getRoleBinding());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public RoleBinding buildRoleBinding() {
        return this.roleBinding != null ? this.roleBinding.build() : null;
    }

    public A withRoleBinding(RoleBinding roleBinding) {
        this._visitables.remove("roleBinding");
        if (roleBinding != null) {
            this.roleBinding = new RoleBindingBuilder(roleBinding);
            this._visitables.get("roleBinding").add(this.roleBinding);
        } else {
            this.roleBinding = null;
            this._visitables.get("roleBinding").remove(this.roleBinding);
        }
        return (A)this;
    }

    public boolean hasRoleBinding() {
        return this.roleBinding != null;
    }

    public RoleBindingNested<A> withNewRoleBinding() {
        return new RoleBindingNested(null);
    }

    public RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item) {
        return new RoleBindingNested(item);
    }

    public RoleBindingNested<A> editRoleBinding() {
        return this.withNewRoleBindingLike(Optional.ofNullable(this.buildRoleBinding()).orElse(null));
    }

    public RoleBindingNested<A> editOrNewRoleBinding() {
        return this.withNewRoleBindingLike(Optional.ofNullable(this.buildRoleBinding()).orElse(new RoleBindingBuilder().build()));
    }

    public RoleBindingNested<A> editOrNewRoleBindingLike(RoleBinding item) {
        return this.withNewRoleBindingLike(Optional.ofNullable(this.buildRoleBinding()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedRoleBindingFluent that = (NamedRoleBindingFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.roleBinding, that.roleBinding)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.roleBinding, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.roleBinding != null) {
            sb.append("roleBinding:");
            sb.append(this.roleBinding + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RoleBindingNested<N>
    extends RoleBindingFluent<RoleBindingNested<N>>
    implements Nested<N> {
        RoleBindingBuilder builder;

        RoleBindingNested(RoleBinding item) {
            this.builder = new RoleBindingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamedRoleBindingFluent.this.withRoleBinding(this.builder.build());
        }

        public N endRoleBinding() {
            return this.and();
        }
    }
}

