/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.GitInfo;
import io.fabric8.openshift.api.model.GitRefInfo;
import io.fabric8.openshift.api.model.GitRefInfoBuilder;
import io.fabric8.openshift.api.model.GitRefInfoFluent;
import io.fabric8.openshift.api.model.SourceControlUser;
import io.fabric8.openshift.api.model.SourceControlUserBuilder;
import io.fabric8.openshift.api.model.SourceControlUserFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GitInfoFluent<A extends GitInfoFluent<A>>
extends BaseFluent<A> {
    private SourceControlUserBuilder author;
    private String commit;
    private SourceControlUserBuilder committer;
    private String httpProxy;
    private String httpsProxy;
    private String message;
    private String noProxy;
    private String ref;
    private ArrayList<GitRefInfoBuilder> refs = new ArrayList();
    private String uri;
    private Map<String, Object> additionalProperties;

    public GitInfoFluent() {
    }

    public GitInfoFluent(GitInfo instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GitInfo instance) {
        GitInfo gitInfo = instance = instance != null ? instance : new GitInfo();
        if (instance != null) {
            this.withAuthor(instance.getAuthor());
            this.withCommit(instance.getCommit());
            this.withCommitter(instance.getCommitter());
            this.withHttpProxy(instance.getHttpProxy());
            this.withHttpsProxy(instance.getHttpsProxy());
            this.withMessage(instance.getMessage());
            this.withNoProxy(instance.getNoProxy());
            this.withRef(instance.getRef());
            this.withRefs(instance.getRefs());
            this.withUri(instance.getUri());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SourceControlUser buildAuthor() {
        return this.author != null ? this.author.build() : null;
    }

    public A withAuthor(SourceControlUser author) {
        this._visitables.remove("author");
        if (author != null) {
            this.author = new SourceControlUserBuilder(author);
            this._visitables.get("author").add(this.author);
        } else {
            this.author = null;
            this._visitables.get("author").remove(this.author);
        }
        return (A)this;
    }

    public boolean hasAuthor() {
        return this.author != null;
    }

    public A withNewAuthor(String email, String name) {
        return this.withAuthor(new SourceControlUser(email, name));
    }

    public AuthorNested<A> withNewAuthor() {
        return new AuthorNested(null);
    }

    public AuthorNested<A> withNewAuthorLike(SourceControlUser item) {
        return new AuthorNested(item);
    }

    public AuthorNested<A> editAuthor() {
        return this.withNewAuthorLike(Optional.ofNullable(this.buildAuthor()).orElse(null));
    }

    public AuthorNested<A> editOrNewAuthor() {
        return this.withNewAuthorLike(Optional.ofNullable(this.buildAuthor()).orElse(new SourceControlUserBuilder().build()));
    }

    public AuthorNested<A> editOrNewAuthorLike(SourceControlUser item) {
        return this.withNewAuthorLike(Optional.ofNullable(this.buildAuthor()).orElse(item));
    }

    public String getCommit() {
        return this.commit;
    }

    public A withCommit(String commit) {
        this.commit = commit;
        return (A)this;
    }

    public boolean hasCommit() {
        return this.commit != null;
    }

    public SourceControlUser buildCommitter() {
        return this.committer != null ? this.committer.build() : null;
    }

    public A withCommitter(SourceControlUser committer) {
        this._visitables.remove("committer");
        if (committer != null) {
            this.committer = new SourceControlUserBuilder(committer);
            this._visitables.get("committer").add(this.committer);
        } else {
            this.committer = null;
            this._visitables.get("committer").remove(this.committer);
        }
        return (A)this;
    }

    public boolean hasCommitter() {
        return this.committer != null;
    }

    public A withNewCommitter(String email, String name) {
        return this.withCommitter(new SourceControlUser(email, name));
    }

    public CommitterNested<A> withNewCommitter() {
        return new CommitterNested(null);
    }

    public CommitterNested<A> withNewCommitterLike(SourceControlUser item) {
        return new CommitterNested(item);
    }

    public CommitterNested<A> editCommitter() {
        return this.withNewCommitterLike(Optional.ofNullable(this.buildCommitter()).orElse(null));
    }

    public CommitterNested<A> editOrNewCommitter() {
        return this.withNewCommitterLike(Optional.ofNullable(this.buildCommitter()).orElse(new SourceControlUserBuilder().build()));
    }

    public CommitterNested<A> editOrNewCommitterLike(SourceControlUser item) {
        return this.withNewCommitterLike(Optional.ofNullable(this.buildCommitter()).orElse(item));
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public A withHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return (A)this;
    }

    public boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public A withHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return (A)this;
    }

    public boolean hasHttpsProxy() {
        return this.httpsProxy != null;
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public String getRef() {
        return this.ref;
    }

    public A withRef(String ref) {
        this.ref = ref;
        return (A)this;
    }

    public boolean hasRef() {
        return this.ref != null;
    }

    public A addToRefs(int index, GitRefInfo item) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
        if (index < 0 || index >= this.refs.size()) {
            this._visitables.get("refs").add(builder);
            this.refs.add(builder);
        } else {
            this._visitables.get("refs").add(index, builder);
            this.refs.add(index, builder);
        }
        return (A)this;
    }

    public A setToRefs(int index, GitRefInfo item) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
        if (index < 0 || index >= this.refs.size()) {
            this._visitables.get("refs").add(builder);
            this.refs.add(builder);
        } else {
            this._visitables.get("refs").set(index, builder);
            this.refs.set(index, builder);
        }
        return (A)this;
    }

    public A addToRefs(GitRefInfo ... items) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        for (GitRefInfo item : items) {
            GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
            this._visitables.get("refs").add(builder);
            this.refs.add(builder);
        }
        return (A)this;
    }

    public A addAllToRefs(Collection<GitRefInfo> items) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        for (GitRefInfo item : items) {
            GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
            this._visitables.get("refs").add(builder);
            this.refs.add(builder);
        }
        return (A)this;
    }

    public A removeFromRefs(GitRefInfo ... items) {
        if (this.refs == null) {
            return (A)this;
        }
        for (GitRefInfo item : items) {
            GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
            this._visitables.get("refs").remove(builder);
            this.refs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRefs(Collection<GitRefInfo> items) {
        if (this.refs == null) {
            return (A)this;
        }
        for (GitRefInfo item : items) {
            GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
            this._visitables.get("refs").remove(builder);
            this.refs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRefs(Predicate<GitRefInfoBuilder> predicate) {
        if (this.refs == null) {
            return (A)this;
        }
        Iterator<GitRefInfoBuilder> each = this.refs.iterator();
        Object visitables = this._visitables.get("refs");
        while (each.hasNext()) {
            GitRefInfoBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<GitRefInfo> buildRefs() {
        return this.refs != null ? GitInfoFluent.build(this.refs) : null;
    }

    public GitRefInfo buildRef(int index) {
        return this.refs.get(index).build();
    }

    public GitRefInfo buildFirstRef() {
        return this.refs.get(0).build();
    }

    public GitRefInfo buildLastRef() {
        return this.refs.get(this.refs.size() - 1).build();
    }

    public GitRefInfo buildMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
        for (GitRefInfoBuilder item : this.refs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
        for (GitRefInfoBuilder item : this.refs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRefs(List<GitRefInfo> refs) {
        if (this.refs != null) {
            this._visitables.get("refs").clear();
        }
        if (refs != null) {
            this.refs = new ArrayList();
            for (GitRefInfo item : refs) {
                this.addToRefs(item);
            }
        } else {
            this.refs = null;
        }
        return (A)this;
    }

    public A withRefs(GitRefInfo ... refs) {
        if (this.refs != null) {
            this.refs.clear();
            this._visitables.remove("refs");
        }
        if (refs != null) {
            for (GitRefInfo item : refs) {
                this.addToRefs(item);
            }
        }
        return (A)this;
    }

    public boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    public RefsNested<A> addNewRef() {
        return new RefsNested(-1, null);
    }

    public RefsNested<A> addNewRefLike(GitRefInfo item) {
        return new RefsNested(-1, item);
    }

    public RefsNested<A> setNewRefLike(int index, GitRefInfo item) {
        return new RefsNested(index, item);
    }

    public RefsNested<A> editRef(int index) {
        if (this.refs.size() <= index) {
            throw new RuntimeException("Can't edit refs. Index exceeds size.");
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public RefsNested<A> editFirstRef() {
        if (this.refs.size() == 0) {
            throw new RuntimeException("Can't edit first refs. The list is empty.");
        }
        return this.setNewRefLike(0, this.buildRef(0));
    }

    public RefsNested<A> editLastRef() {
        int index = this.refs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last refs. The list is empty.");
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public RefsNested<A> editMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.refs.size(); ++i) {
            if (!predicate.test(this.refs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching refs. No match found.");
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public String getUri() {
        return this.uri;
    }

    public A withUri(String uri) {
        this.uri = uri;
        return (A)this;
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitInfoFluent that = (GitInfoFluent)o;
        if (!Objects.equals(this.author, that.author)) {
            return false;
        }
        if (!Objects.equals(this.commit, that.commit)) {
            return false;
        }
        if (!Objects.equals(this.committer, that.committer)) {
            return false;
        }
        if (!Objects.equals(this.httpProxy, that.httpProxy)) {
            return false;
        }
        if (!Objects.equals(this.httpsProxy, that.httpsProxy)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.ref, that.ref)) {
            return false;
        }
        if (!Objects.equals(this.refs, that.refs)) {
            return false;
        }
        if (!Objects.equals(this.uri, that.uri)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.author, this.commit, this.committer, this.httpProxy, this.httpsProxy, this.message, this.noProxy, this.ref, this.refs, this.uri, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.author != null) {
            sb.append("author:");
            sb.append(this.author + ",");
        }
        if (this.commit != null) {
            sb.append("commit:");
            sb.append(this.commit + ",");
        }
        if (this.committer != null) {
            sb.append("committer:");
            sb.append(this.committer + ",");
        }
        if (this.httpProxy != null) {
            sb.append("httpProxy:");
            sb.append(this.httpProxy + ",");
        }
        if (this.httpsProxy != null) {
            sb.append("httpsProxy:");
            sb.append(this.httpsProxy + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy + ",");
        }
        if (this.ref != null) {
            sb.append("ref:");
            sb.append(this.ref + ",");
        }
        if (this.refs != null && !this.refs.isEmpty()) {
            sb.append("refs:");
            sb.append(this.refs + ",");
        }
        if (this.uri != null) {
            sb.append("uri:");
            sb.append(this.uri + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RefsNested<N>
    extends GitRefInfoFluent<RefsNested<N>>
    implements Nested<N> {
        GitRefInfoBuilder builder;
        int index;

        RefsNested(int index, GitRefInfo item) {
            this.index = index;
            this.builder = new GitRefInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GitInfoFluent.this.setToRefs(this.index, this.builder.build());
        }

        public N endRef() {
            return this.and();
        }
    }

    public class CommitterNested<N>
    extends SourceControlUserFluent<CommitterNested<N>>
    implements Nested<N> {
        SourceControlUserBuilder builder;

        CommitterNested(SourceControlUser item) {
            this.builder = new SourceControlUserBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GitInfoFluent.this.withCommitter(this.builder.build());
        }

        public N endCommitter() {
            return this.and();
        }
    }

    public class AuthorNested<N>
    extends SourceControlUserFluent<AuthorNested<N>>
    implements Nested<N> {
        SourceControlUserBuilder builder;

        AuthorNested(SourceControlUser item) {
            this.builder = new SourceControlUserBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GitInfoFluent.this.withAuthor(this.builder.build());
        }

        public N endAuthor() {
            return this.and();
        }
    }
}

