/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.openshift.api.model.CustomDeploymentStrategyParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CustomDeploymentStrategyParamsFluent<A extends CustomDeploymentStrategyParamsFluent<A>>
extends BaseFluent<A> {
    private List<String> command = new ArrayList<String>();
    private ArrayList<EnvVarBuilder> environment = new ArrayList();
    private String image;
    private Map<String, Object> additionalProperties;

    public CustomDeploymentStrategyParamsFluent() {
    }

    public CustomDeploymentStrategyParamsFluent(CustomDeploymentStrategyParams instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomDeploymentStrategyParams instance) {
        CustomDeploymentStrategyParams customDeploymentStrategyParams = instance = instance != null ? instance : new CustomDeploymentStrategyParams();
        if (instance != null) {
            this.withCommand(instance.getCommand());
            this.withEnvironment(instance.getEnvironment());
            this.withImage(instance.getImage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)this;
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)this;
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)this;
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove("command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public A addToEnvironment(int index, EnvVar item) {
        if (this.environment == null) {
            this.environment = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.environment.size()) {
            this._visitables.get("environment").add(builder);
            this.environment.add(builder);
        } else {
            this._visitables.get("environment").add(index, builder);
            this.environment.add(index, builder);
        }
        return (A)this;
    }

    public A setToEnvironment(int index, EnvVar item) {
        if (this.environment == null) {
            this.environment = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.environment.size()) {
            this._visitables.get("environment").add(builder);
            this.environment.add(builder);
        } else {
            this._visitables.get("environment").set(index, builder);
            this.environment.set(index, builder);
        }
        return (A)this;
    }

    public A addToEnvironment(EnvVar ... items) {
        if (this.environment == null) {
            this.environment = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("environment").add(builder);
            this.environment.add(builder);
        }
        return (A)this;
    }

    public A addAllToEnvironment(Collection<EnvVar> items) {
        if (this.environment == null) {
            this.environment = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("environment").add(builder);
            this.environment.add(builder);
        }
        return (A)this;
    }

    public A removeFromEnvironment(EnvVar ... items) {
        if (this.environment == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("environment").remove(builder);
            this.environment.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEnvironment(Collection<EnvVar> items) {
        if (this.environment == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("environment").remove(builder);
            this.environment.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEnvironment(Predicate<EnvVarBuilder> predicate) {
        if (this.environment == null) {
            return (A)this;
        }
        Iterator<EnvVarBuilder> each = this.environment.iterator();
        Object visitables = this._visitables.get("environment");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<EnvVar> buildEnvironment() {
        return this.environment != null ? CustomDeploymentStrategyParamsFluent.build(this.environment) : null;
    }

    public EnvVar buildEnvironment(int index) {
        return this.environment.get(index).build();
    }

    public EnvVar buildFirstEnvironment() {
        return this.environment.get(0).build();
    }

    public EnvVar buildLastEnvironment() {
        return this.environment.get(this.environment.size() - 1).build();
    }

    public EnvVar buildMatchingEnvironment(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.environment) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnvironment(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.environment) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnvironment(List<EnvVar> environment) {
        if (this.environment != null) {
            this._visitables.get("environment").clear();
        }
        if (environment != null) {
            this.environment = new ArrayList();
            for (EnvVar item : environment) {
                this.addToEnvironment(item);
            }
        } else {
            this.environment = null;
        }
        return (A)this;
    }

    public A withEnvironment(EnvVar ... environment) {
        if (this.environment != null) {
            this.environment.clear();
            this._visitables.remove("environment");
        }
        if (environment != null) {
            for (EnvVar item : environment) {
                this.addToEnvironment(item);
            }
        }
        return (A)this;
    }

    public boolean hasEnvironment() {
        return this.environment != null && !this.environment.isEmpty();
    }

    public EnvironmentNested<A> addNewEnvironment() {
        return new EnvironmentNested(-1, null);
    }

    public EnvironmentNested<A> addNewEnvironmentLike(EnvVar item) {
        return new EnvironmentNested(-1, item);
    }

    public EnvironmentNested<A> setNewEnvironmentLike(int index, EnvVar item) {
        return new EnvironmentNested(index, item);
    }

    public EnvironmentNested<A> editEnvironment(int index) {
        if (this.environment.size() <= index) {
            throw new RuntimeException("Can't edit environment. Index exceeds size.");
        }
        return this.setNewEnvironmentLike(index, this.buildEnvironment(index));
    }

    public EnvironmentNested<A> editFirstEnvironment() {
        if (this.environment.size() == 0) {
            throw new RuntimeException("Can't edit first environment. The list is empty.");
        }
        return this.setNewEnvironmentLike(0, this.buildEnvironment(0));
    }

    public EnvironmentNested<A> editLastEnvironment() {
        int index = this.environment.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last environment. The list is empty.");
        }
        return this.setNewEnvironmentLike(index, this.buildEnvironment(index));
    }

    public EnvironmentNested<A> editMatchingEnvironment(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.environment.size(); ++i) {
            if (!predicate.test(this.environment.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching environment. No match found.");
        }
        return this.setNewEnvironmentLike(index, this.buildEnvironment(index));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomDeploymentStrategyParamsFluent that = (CustomDeploymentStrategyParamsFluent)o;
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.environment, that.environment)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.command, this.environment, this.image, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.environment != null && !this.environment.isEmpty()) {
            sb.append("environment:");
            sb.append(this.environment + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EnvironmentNested<N>
    extends EnvVarFluent<EnvironmentNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvironmentNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomDeploymentStrategyParamsFluent.this.setToEnvironment(this.index, this.builder.build());
        }

        public N endEnvironment() {
            return this.and();
        }
    }
}

