/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import io.fabric8.kubernetes.api.model.HostIP;
import io.fabric8.kubernetes.api.model.HostIPBuilder;
import io.fabric8.kubernetes.api.model.HostIPFluent;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodConditionBuilder;
import io.fabric8.kubernetes.api.model.PodConditionFluent;
import io.fabric8.kubernetes.api.model.PodIP;
import io.fabric8.kubernetes.api.model.PodIPBuilder;
import io.fabric8.kubernetes.api.model.PodIPFluent;
import io.fabric8.kubernetes.api.model.PodResourceClaimStatus;
import io.fabric8.kubernetes.api.model.PodResourceClaimStatusBuilder;
import io.fabric8.kubernetes.api.model.PodResourceClaimStatusFluent;
import io.fabric8.kubernetes.api.model.PodStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodStatusFluent<A extends PodStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<PodConditionBuilder> conditions = new ArrayList();
    private ArrayList<ContainerStatusBuilder> containerStatuses = new ArrayList();
    private ArrayList<ContainerStatusBuilder> ephemeralContainerStatuses = new ArrayList();
    private String hostIP;
    private ArrayList<HostIPBuilder> hostIPs = new ArrayList();
    private ArrayList<ContainerStatusBuilder> initContainerStatuses = new ArrayList();
    private String message;
    private String nominatedNodeName;
    private String phase;
    private String podIP;
    private ArrayList<PodIPBuilder> podIPs = new ArrayList();
    private String qosClass;
    private String reason;
    private String resize;
    private ArrayList<PodResourceClaimStatusBuilder> resourceClaimStatuses = new ArrayList();
    private String startTime;
    private Map<String, Object> additionalProperties;

    public PodStatusFluent() {
    }

    public PodStatusFluent(PodStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodStatus instance) {
        PodStatus podStatus = instance = instance != null ? instance : new PodStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withContainerStatuses(instance.getContainerStatuses());
            this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
            this.withHostIP(instance.getHostIP());
            this.withHostIPs(instance.getHostIPs());
            this.withInitContainerStatuses(instance.getInitContainerStatuses());
            this.withMessage(instance.getMessage());
            this.withNominatedNodeName(instance.getNominatedNodeName());
            this.withPhase(instance.getPhase());
            this.withPodIP(instance.getPodIP());
            this.withPodIPs(instance.getPodIPs());
            this.withQosClass(instance.getQosClass());
            this.withReason(instance.getReason());
            this.withResize(instance.getResize());
            this.withResourceClaimStatuses(instance.getResourceClaimStatuses());
            this.withStartTime(instance.getStartTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        PodConditionBuilder builder = new PodConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        PodConditionBuilder builder = new PodConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(PodCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<PodCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(PodCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<PodCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<PodConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<PodConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            PodConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodCondition> buildConditions() {
        return this.conditions != null ? PodStatusFluent.build(this.conditions) : null;
    }

    public PodCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public PodCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public PodCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public PodCondition buildMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        for (PodConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        for (PodConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<PodCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(PodCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(PodCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, PodCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get("containerStatuses").add(index, builder);
            this.containerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get("containerStatuses").set(index, builder);
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.containerStatuses.iterator();
        Object visitables = this._visitables.get("containerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ContainerStatus> buildContainerStatuses() {
        return this.containerStatuses != null ? PodStatusFluent.build(this.containerStatuses) : null;
    }

    public ContainerStatus buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    public ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get("containerStatuses").clear();
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList();
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)this;
    }

    public A withContainerStatuses(ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
            this._visitables.remove("containerStatuses");
        }
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    public ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNested(-1, null);
    }

    public ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusesNested(-1, item);
    }

    public ContainerStatusesNested<A> setNewContainerStatusLike(int index, ContainerStatus item) {
        return new ContainerStatusesNested(index, item);
    }

    public ContainerStatusesNested<A> editContainerStatus(int index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    public ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.test(this.containerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public A addToEphemeralContainerStatuses(int index, ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.ephemeralContainerStatuses.size()) {
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        } else {
            this._visitables.get("ephemeralContainerStatuses").add(index, builder);
            this.ephemeralContainerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToEphemeralContainerStatuses(int index, ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.ephemeralContainerStatuses.size()) {
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        } else {
            this._visitables.get("ephemeralContainerStatuses").set(index, builder);
            this.ephemeralContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToEphemeralContainerStatuses(ContainerStatus ... items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToEphemeralContainerStatuses(Collection<ContainerStatus> items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromEphemeralContainerStatuses(ContainerStatus ... items) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEphemeralContainerStatuses(Collection<ContainerStatus> items) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEphemeralContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.ephemeralContainerStatuses.iterator();
        Object visitables = this._visitables.get("ephemeralContainerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ContainerStatus> buildEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null ? PodStatusFluent.build(this.ephemeralContainerStatuses) : null;
    }

    public ContainerStatus buildEphemeralContainerStatus(int index) {
        return this.ephemeralContainerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(0).build();
    }

    public ContainerStatus buildLastEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(this.ephemeralContainerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEphemeralContainerStatuses(List<ContainerStatus> ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this._visitables.get("ephemeralContainerStatuses").clear();
        }
        if (ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses = new ArrayList();
            for (ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        } else {
            this.ephemeralContainerStatuses = null;
        }
        return (A)this;
    }

    public A withEphemeralContainerStatuses(ContainerStatus ... ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses.clear();
            this._visitables.remove("ephemeralContainerStatuses");
        }
        if (ephemeralContainerStatuses != null) {
            for (ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty();
    }

    public EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus() {
        return new EphemeralContainerStatusesNested(-1, null);
    }

    public EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(ContainerStatus item) {
        return new EphemeralContainerStatusesNested(-1, item);
    }

    public EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(int index, ContainerStatus item) {
        return new EphemeralContainerStatusesNested(index, item);
    }

    public EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(int index) {
        if (this.ephemeralContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainerStatuses. Index exceeds size.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus() {
        if (this.ephemeralContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(0, this.buildEphemeralContainerStatus(0));
    }

    public EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus() {
        int index = this.ephemeralContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainerStatuses.size(); ++i) {
            if (!predicate.test(this.ephemeralContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainerStatuses. No match found.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    public boolean hasHostIP() {
        return this.hostIP != null;
    }

    public A addToHostIPs(int index, HostIP item) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList();
        }
        HostIPBuilder builder = new HostIPBuilder(item);
        if (index < 0 || index >= this.hostIPs.size()) {
            this._visitables.get("hostIPs").add(builder);
            this.hostIPs.add(builder);
        } else {
            this._visitables.get("hostIPs").add(index, builder);
            this.hostIPs.add(index, builder);
        }
        return (A)this;
    }

    public A setToHostIPs(int index, HostIP item) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList();
        }
        HostIPBuilder builder = new HostIPBuilder(item);
        if (index < 0 || index >= this.hostIPs.size()) {
            this._visitables.get("hostIPs").add(builder);
            this.hostIPs.add(builder);
        } else {
            this._visitables.get("hostIPs").set(index, builder);
            this.hostIPs.set(index, builder);
        }
        return (A)this;
    }

    public A addToHostIPs(HostIP ... items) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList();
        }
        for (HostIP item : items) {
            HostIPBuilder builder = new HostIPBuilder(item);
            this._visitables.get("hostIPs").add(builder);
            this.hostIPs.add(builder);
        }
        return (A)this;
    }

    public A addAllToHostIPs(Collection<HostIP> items) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList();
        }
        for (HostIP item : items) {
            HostIPBuilder builder = new HostIPBuilder(item);
            this._visitables.get("hostIPs").add(builder);
            this.hostIPs.add(builder);
        }
        return (A)this;
    }

    public A removeFromHostIPs(HostIP ... items) {
        if (this.hostIPs == null) {
            return (A)this;
        }
        for (HostIP item : items) {
            HostIPBuilder builder = new HostIPBuilder(item);
            this._visitables.get("hostIPs").remove(builder);
            this.hostIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHostIPs(Collection<HostIP> items) {
        if (this.hostIPs == null) {
            return (A)this;
        }
        for (HostIP item : items) {
            HostIPBuilder builder = new HostIPBuilder(item);
            this._visitables.get("hostIPs").remove(builder);
            this.hostIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHostIPs(Predicate<HostIPBuilder> predicate) {
        if (this.hostIPs == null) {
            return (A)this;
        }
        Iterator<HostIPBuilder> each = this.hostIPs.iterator();
        Object visitables = this._visitables.get("hostIPs");
        while (each.hasNext()) {
            HostIPBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HostIP> buildHostIPs() {
        return this.hostIPs != null ? PodStatusFluent.build(this.hostIPs) : null;
    }

    public HostIP buildHostIP(int index) {
        return this.hostIPs.get(index).build();
    }

    public HostIP buildFirstHostIP() {
        return this.hostIPs.get(0).build();
    }

    public HostIP buildLastHostIP() {
        return this.hostIPs.get(this.hostIPs.size() - 1).build();
    }

    public HostIP buildMatchingHostIP(Predicate<HostIPBuilder> predicate) {
        for (HostIPBuilder item : this.hostIPs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHostIP(Predicate<HostIPBuilder> predicate) {
        for (HostIPBuilder item : this.hostIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostIPs(List<HostIP> hostIPs) {
        if (this.hostIPs != null) {
            this._visitables.get("hostIPs").clear();
        }
        if (hostIPs != null) {
            this.hostIPs = new ArrayList();
            for (HostIP item : hostIPs) {
                this.addToHostIPs(item);
            }
        } else {
            this.hostIPs = null;
        }
        return (A)this;
    }

    public A withHostIPs(HostIP ... hostIPs) {
        if (this.hostIPs != null) {
            this.hostIPs.clear();
            this._visitables.remove("hostIPs");
        }
        if (hostIPs != null) {
            for (HostIP item : hostIPs) {
                this.addToHostIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasHostIPs() {
        return this.hostIPs != null && !this.hostIPs.isEmpty();
    }

    public A addNewHostIP(String ip) {
        return this.addToHostIPs(new HostIP(ip));
    }

    public HostIPsNested<A> addNewHostIP() {
        return new HostIPsNested(-1, null);
    }

    public HostIPsNested<A> addNewHostIPLike(HostIP item) {
        return new HostIPsNested(-1, item);
    }

    public HostIPsNested<A> setNewHostIPLike(int index, HostIP item) {
        return new HostIPsNested(index, item);
    }

    public HostIPsNested<A> editHostIP(int index) {
        if (this.hostIPs.size() <= index) {
            throw new RuntimeException("Can't edit hostIPs. Index exceeds size.");
        }
        return this.setNewHostIPLike(index, this.buildHostIP(index));
    }

    public HostIPsNested<A> editFirstHostIP() {
        if (this.hostIPs.size() == 0) {
            throw new RuntimeException("Can't edit first hostIPs. The list is empty.");
        }
        return this.setNewHostIPLike(0, this.buildHostIP(0));
    }

    public HostIPsNested<A> editLastHostIP() {
        int index = this.hostIPs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostIPs. The list is empty.");
        }
        return this.setNewHostIPLike(index, this.buildHostIP(index));
    }

    public HostIPsNested<A> editMatchingHostIP(Predicate<HostIPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostIPs.size(); ++i) {
            if (!predicate.test(this.hostIPs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostIPs. No match found.");
        }
        return this.setNewHostIPLike(index, this.buildHostIP(index));
    }

    public A addToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get("initContainerStatuses").add(index, builder);
            this.initContainerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get("initContainerStatuses").set(index, builder);
            this.initContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToInitContainerStatuses(ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromInitContainerStatuses(ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.initContainerStatuses.iterator();
        Object visitables = this._visitables.get("initContainerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ContainerStatus> buildInitContainerStatuses() {
        return this.initContainerStatuses != null ? PodStatusFluent.build(this.initContainerStatuses) : null;
    }

    public ContainerStatus buildInitContainerStatus(int index) {
        return this.initContainerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    public ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this._visitables.get("initContainerStatuses").clear();
        }
        if (initContainerStatuses != null) {
            this.initContainerStatuses = new ArrayList();
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        } else {
            this.initContainerStatuses = null;
        }
        return (A)this;
    }

    public A withInitContainerStatuses(ContainerStatus ... initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this.initContainerStatuses.clear();
            this._visitables.remove("initContainerStatuses");
        }
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    public InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNested(-1, null);
    }

    public InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
        return new InitContainerStatusesNested(-1, item);
    }

    public InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index, ContainerStatus item) {
        return new InitContainerStatusesNested(index, item);
    }

    public InitContainerStatusesNested<A> editInitContainerStatus(int index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    public InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.test(this.initContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    public A withNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return (A)this;
    }

    public boolean hasNominatedNodeName() {
        return this.nominatedNodeName != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public String getPodIP() {
        return this.podIP;
    }

    public A withPodIP(String podIP) {
        this.podIP = podIP;
        return (A)this;
    }

    public boolean hasPodIP() {
        return this.podIP != null;
    }

    public A addToPodIPs(int index, PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        PodIPBuilder builder = new PodIPBuilder(item);
        if (index < 0 || index >= this.podIPs.size()) {
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        } else {
            this._visitables.get("podIPs").add(index, builder);
            this.podIPs.add(index, builder);
        }
        return (A)this;
    }

    public A setToPodIPs(int index, PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        PodIPBuilder builder = new PodIPBuilder(item);
        if (index < 0 || index >= this.podIPs.size()) {
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        } else {
            this._visitables.get("podIPs").set(index, builder);
            this.podIPs.set(index, builder);
        }
        return (A)this;
    }

    public A addToPodIPs(PodIP ... items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    public A addAllToPodIPs(Collection<PodIP> items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    public A removeFromPodIPs(PodIP ... items) {
        if (this.podIPs == null) {
            return (A)this;
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPodIPs(Collection<PodIP> items) {
        if (this.podIPs == null) {
            return (A)this;
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPodIPs(Predicate<PodIPBuilder> predicate) {
        if (this.podIPs == null) {
            return (A)this;
        }
        Iterator<PodIPBuilder> each = this.podIPs.iterator();
        Object visitables = this._visitables.get("podIPs");
        while (each.hasNext()) {
            PodIPBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodIP> buildPodIPs() {
        return this.podIPs != null ? PodStatusFluent.build(this.podIPs) : null;
    }

    public PodIP buildPodIP(int index) {
        return this.podIPs.get(index).build();
    }

    public PodIP buildFirstPodIP() {
        return this.podIPs.get(0).build();
    }

    public PodIP buildLastPodIP() {
        return this.podIPs.get(this.podIPs.size() - 1).build();
    }

    public PodIP buildMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        for (PodIPBuilder item : this.podIPs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        for (PodIPBuilder item : this.podIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodIPs(List<PodIP> podIPs) {
        if (this.podIPs != null) {
            this._visitables.get("podIPs").clear();
        }
        if (podIPs != null) {
            this.podIPs = new ArrayList();
            for (PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        } else {
            this.podIPs = null;
        }
        return (A)this;
    }

    public A withPodIPs(PodIP ... podIPs) {
        if (this.podIPs != null) {
            this.podIPs.clear();
            this._visitables.remove("podIPs");
        }
        if (podIPs != null) {
            for (PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasPodIPs() {
        return this.podIPs != null && !this.podIPs.isEmpty();
    }

    public A addNewPodIP(String ip) {
        return this.addToPodIPs(new PodIP(ip));
    }

    public PodIPsNested<A> addNewPodIP() {
        return new PodIPsNested(-1, null);
    }

    public PodIPsNested<A> addNewPodIPLike(PodIP item) {
        return new PodIPsNested(-1, item);
    }

    public PodIPsNested<A> setNewPodIPLike(int index, PodIP item) {
        return new PodIPsNested(index, item);
    }

    public PodIPsNested<A> editPodIP(int index) {
        if (this.podIPs.size() <= index) {
            throw new RuntimeException("Can't edit podIPs. Index exceeds size.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public PodIPsNested<A> editFirstPodIP() {
        if (this.podIPs.size() == 0) {
            throw new RuntimeException("Can't edit first podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(0, this.buildPodIP(0));
    }

    public PodIPsNested<A> editLastPodIP() {
        int index = this.podIPs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public PodIPsNested<A> editMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.podIPs.size(); ++i) {
            if (!predicate.test(this.podIPs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching podIPs. No match found.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public String getQosClass() {
        return this.qosClass;
    }

    public A withQosClass(String qosClass) {
        this.qosClass = qosClass;
        return (A)this;
    }

    public boolean hasQosClass() {
        return this.qosClass != null;
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getResize() {
        return this.resize;
    }

    public A withResize(String resize) {
        this.resize = resize;
        return (A)this;
    }

    public boolean hasResize() {
        return this.resize != null;
    }

    public A addToResourceClaimStatuses(int index, PodResourceClaimStatus item) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList();
        }
        PodResourceClaimStatusBuilder builder = new PodResourceClaimStatusBuilder(item);
        if (index < 0 || index >= this.resourceClaimStatuses.size()) {
            this._visitables.get("resourceClaimStatuses").add(builder);
            this.resourceClaimStatuses.add(builder);
        } else {
            this._visitables.get("resourceClaimStatuses").add(index, builder);
            this.resourceClaimStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceClaimStatuses(int index, PodResourceClaimStatus item) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList();
        }
        PodResourceClaimStatusBuilder builder = new PodResourceClaimStatusBuilder(item);
        if (index < 0 || index >= this.resourceClaimStatuses.size()) {
            this._visitables.get("resourceClaimStatuses").add(builder);
            this.resourceClaimStatuses.add(builder);
        } else {
            this._visitables.get("resourceClaimStatuses").set(index, builder);
            this.resourceClaimStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceClaimStatuses(PodResourceClaimStatus ... items) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList();
        }
        for (PodResourceClaimStatus item : items) {
            PodResourceClaimStatusBuilder builder = new PodResourceClaimStatusBuilder(item);
            this._visitables.get("resourceClaimStatuses").add(builder);
            this.resourceClaimStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceClaimStatuses(Collection<PodResourceClaimStatus> items) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList();
        }
        for (PodResourceClaimStatus item : items) {
            PodResourceClaimStatusBuilder builder = new PodResourceClaimStatusBuilder(item);
            this._visitables.get("resourceClaimStatuses").add(builder);
            this.resourceClaimStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceClaimStatuses(PodResourceClaimStatus ... items) {
        if (this.resourceClaimStatuses == null) {
            return (A)this;
        }
        for (PodResourceClaimStatus item : items) {
            PodResourceClaimStatusBuilder builder = new PodResourceClaimStatusBuilder(item);
            this._visitables.get("resourceClaimStatuses").remove(builder);
            this.resourceClaimStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceClaimStatuses(Collection<PodResourceClaimStatus> items) {
        if (this.resourceClaimStatuses == null) {
            return (A)this;
        }
        for (PodResourceClaimStatus item : items) {
            PodResourceClaimStatusBuilder builder = new PodResourceClaimStatusBuilder(item);
            this._visitables.get("resourceClaimStatuses").remove(builder);
            this.resourceClaimStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceClaimStatuses(Predicate<PodResourceClaimStatusBuilder> predicate) {
        if (this.resourceClaimStatuses == null) {
            return (A)this;
        }
        Iterator<PodResourceClaimStatusBuilder> each = this.resourceClaimStatuses.iterator();
        Object visitables = this._visitables.get("resourceClaimStatuses");
        while (each.hasNext()) {
            PodResourceClaimStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodResourceClaimStatus> buildResourceClaimStatuses() {
        return this.resourceClaimStatuses != null ? PodStatusFluent.build(this.resourceClaimStatuses) : null;
    }

    public PodResourceClaimStatus buildResourceClaimStatus(int index) {
        return this.resourceClaimStatuses.get(index).build();
    }

    public PodResourceClaimStatus buildFirstResourceClaimStatus() {
        return this.resourceClaimStatuses.get(0).build();
    }

    public PodResourceClaimStatus buildLastResourceClaimStatus() {
        return this.resourceClaimStatuses.get(this.resourceClaimStatuses.size() - 1).build();
    }

    public PodResourceClaimStatus buildMatchingResourceClaimStatus(Predicate<PodResourceClaimStatusBuilder> predicate) {
        for (PodResourceClaimStatusBuilder item : this.resourceClaimStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceClaimStatus(Predicate<PodResourceClaimStatusBuilder> predicate) {
        for (PodResourceClaimStatusBuilder item : this.resourceClaimStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceClaimStatuses(List<PodResourceClaimStatus> resourceClaimStatuses) {
        if (this.resourceClaimStatuses != null) {
            this._visitables.get("resourceClaimStatuses").clear();
        }
        if (resourceClaimStatuses != null) {
            this.resourceClaimStatuses = new ArrayList();
            for (PodResourceClaimStatus item : resourceClaimStatuses) {
                this.addToResourceClaimStatuses(item);
            }
        } else {
            this.resourceClaimStatuses = null;
        }
        return (A)this;
    }

    public A withResourceClaimStatuses(PodResourceClaimStatus ... resourceClaimStatuses) {
        if (this.resourceClaimStatuses != null) {
            this.resourceClaimStatuses.clear();
            this._visitables.remove("resourceClaimStatuses");
        }
        if (resourceClaimStatuses != null) {
            for (PodResourceClaimStatus item : resourceClaimStatuses) {
                this.addToResourceClaimStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceClaimStatuses() {
        return this.resourceClaimStatuses != null && !this.resourceClaimStatuses.isEmpty();
    }

    public A addNewResourceClaimStatus(String name, String resourceClaimName) {
        return this.addToResourceClaimStatuses(new PodResourceClaimStatus(name, resourceClaimName));
    }

    public ResourceClaimStatusesNested<A> addNewResourceClaimStatus() {
        return new ResourceClaimStatusesNested(-1, null);
    }

    public ResourceClaimStatusesNested<A> addNewResourceClaimStatusLike(PodResourceClaimStatus item) {
        return new ResourceClaimStatusesNested(-1, item);
    }

    public ResourceClaimStatusesNested<A> setNewResourceClaimStatusLike(int index, PodResourceClaimStatus item) {
        return new ResourceClaimStatusesNested(index, item);
    }

    public ResourceClaimStatusesNested<A> editResourceClaimStatus(int index) {
        if (this.resourceClaimStatuses.size() <= index) {
            throw new RuntimeException("Can't edit resourceClaimStatuses. Index exceeds size.");
        }
        return this.setNewResourceClaimStatusLike(index, this.buildResourceClaimStatus(index));
    }

    public ResourceClaimStatusesNested<A> editFirstResourceClaimStatus() {
        if (this.resourceClaimStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first resourceClaimStatuses. The list is empty.");
        }
        return this.setNewResourceClaimStatusLike(0, this.buildResourceClaimStatus(0));
    }

    public ResourceClaimStatusesNested<A> editLastResourceClaimStatus() {
        int index = this.resourceClaimStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceClaimStatuses. The list is empty.");
        }
        return this.setNewResourceClaimStatusLike(index, this.buildResourceClaimStatus(index));
    }

    public ResourceClaimStatusesNested<A> editMatchingResourceClaimStatus(Predicate<PodResourceClaimStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceClaimStatuses.size(); ++i) {
            if (!predicate.test(this.resourceClaimStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceClaimStatuses. No match found.");
        }
        return this.setNewResourceClaimStatusLike(index, this.buildResourceClaimStatus(index));
    }

    public String getStartTime() {
        return this.startTime;
    }

    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodStatusFluent that = (PodStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.containerStatuses, that.containerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.ephemeralContainerStatuses, that.ephemeralContainerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.hostIP, that.hostIP)) {
            return false;
        }
        if (!Objects.equals(this.hostIPs, that.hostIPs)) {
            return false;
        }
        if (!Objects.equals(this.initContainerStatuses, that.initContainerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.nominatedNodeName, that.nominatedNodeName)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.podIP, that.podIP)) {
            return false;
        }
        if (!Objects.equals(this.podIPs, that.podIPs)) {
            return false;
        }
        if (!Objects.equals(this.qosClass, that.qosClass)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.resize, that.resize)) {
            return false;
        }
        if (!Objects.equals(this.resourceClaimStatuses, that.resourceClaimStatuses)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.ephemeralContainerStatuses, this.hostIP, this.hostIPs, this.initContainerStatuses, this.message, this.nominatedNodeName, this.phase, this.podIP, this.podIPs, this.qosClass, this.reason, this.resize, this.resourceClaimStatuses, this.startTime, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.containerStatuses != null && !this.containerStatuses.isEmpty()) {
            sb.append("containerStatuses:");
            sb.append(this.containerStatuses + ",");
        }
        if (this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty()) {
            sb.append("ephemeralContainerStatuses:");
            sb.append(this.ephemeralContainerStatuses + ",");
        }
        if (this.hostIP != null) {
            sb.append("hostIP:");
            sb.append(this.hostIP + ",");
        }
        if (this.hostIPs != null && !this.hostIPs.isEmpty()) {
            sb.append("hostIPs:");
            sb.append(this.hostIPs + ",");
        }
        if (this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty()) {
            sb.append("initContainerStatuses:");
            sb.append(this.initContainerStatuses + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.nominatedNodeName != null) {
            sb.append("nominatedNodeName:");
            sb.append(this.nominatedNodeName + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.podIP != null) {
            sb.append("podIP:");
            sb.append(this.podIP + ",");
        }
        if (this.podIPs != null && !this.podIPs.isEmpty()) {
            sb.append("podIPs:");
            sb.append(this.podIPs + ",");
        }
        if (this.qosClass != null) {
            sb.append("qosClass:");
            sb.append(this.qosClass + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.resize != null) {
            sb.append("resize:");
            sb.append(this.resize + ",");
        }
        if (this.resourceClaimStatuses != null && !this.resourceClaimStatuses.isEmpty()) {
            sb.append("resourceClaimStatuses:");
            sb.append(this.resourceClaimStatuses + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceClaimStatusesNested<N>
    extends PodResourceClaimStatusFluent<ResourceClaimStatusesNested<N>>
    implements Nested<N> {
        PodResourceClaimStatusBuilder builder;
        int index;

        ResourceClaimStatusesNested(int index, PodResourceClaimStatus item) {
            this.index = index;
            this.builder = new PodResourceClaimStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToResourceClaimStatuses(this.index, this.builder.build());
        }

        public N endResourceClaimStatus() {
            return this.and();
        }
    }

    public class PodIPsNested<N>
    extends PodIPFluent<PodIPsNested<N>>
    implements Nested<N> {
        PodIPBuilder builder;
        int index;

        PodIPsNested(int index, PodIP item) {
            this.index = index;
            this.builder = new PodIPBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToPodIPs(this.index, this.builder.build());
        }

        public N endPodIP() {
            return this.and();
        }
    }

    public class InitContainerStatusesNested<N>
    extends ContainerStatusFluent<InitContainerStatusesNested<N>>
    implements Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        InitContainerStatusesNested(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        public N endInitContainerStatus() {
            return this.and();
        }
    }

    public class HostIPsNested<N>
    extends HostIPFluent<HostIPsNested<N>>
    implements Nested<N> {
        HostIPBuilder builder;
        int index;

        HostIPsNested(int index, HostIP item) {
            this.index = index;
            this.builder = new HostIPBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToHostIPs(this.index, this.builder.build());
        }

        public N endHostIP() {
            return this.and();
        }
    }

    public class EphemeralContainerStatusesNested<N>
    extends ContainerStatusFluent<EphemeralContainerStatusesNested<N>>
    implements Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        EphemeralContainerStatusesNested(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToEphemeralContainerStatuses(this.index, this.builder.build());
        }

        public N endEphemeralContainerStatus() {
            return this.and();
        }
    }

    public class ContainerStatusesNested<N>
    extends ContainerStatusFluent<ContainerStatusesNested<N>>
    implements Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        ContainerStatusesNested(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToContainerStatuses(this.index, this.builder.build());
        }

        public N endContainerStatus() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends PodConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        PodConditionBuilder builder;
        int index;

        ConditionsNested(int index, PodCondition item) {
            this.index = index;
            this.builder = new PodConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

