/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.BackendObjectReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.BackendObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.BackendObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRequestMirrorFilter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HTTPRequestMirrorFilterFluent<A extends HTTPRequestMirrorFilterFluent<A>>
extends BaseFluent<A> {
    private BackendObjectReferenceBuilder backendRef;
    private Map<String, Object> additionalProperties;

    public HTTPRequestMirrorFilterFluent() {
    }

    public HTTPRequestMirrorFilterFluent(HTTPRequestMirrorFilter instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPRequestMirrorFilter instance) {
        HTTPRequestMirrorFilter hTTPRequestMirrorFilter = instance = instance != null ? instance : new HTTPRequestMirrorFilter();
        if (instance != null) {
            this.withBackendRef(instance.getBackendRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BackendObjectReference buildBackendRef() {
        return this.backendRef != null ? this.backendRef.build() : null;
    }

    public A withBackendRef(BackendObjectReference backendRef) {
        this._visitables.remove("backendRef");
        if (backendRef != null) {
            this.backendRef = new BackendObjectReferenceBuilder(backendRef);
            this._visitables.get("backendRef").add(this.backendRef);
        } else {
            this.backendRef = null;
            this._visitables.get("backendRef").remove(this.backendRef);
        }
        return (A)this;
    }

    public boolean hasBackendRef() {
        return this.backendRef != null;
    }

    public A withNewBackendRef(String group, String kind, String name, String namespace, Integer port) {
        return this.withBackendRef(new BackendObjectReference(group, kind, name, namespace, port));
    }

    public BackendRefNested<A> withNewBackendRef() {
        return new BackendRefNested(null);
    }

    public BackendRefNested<A> withNewBackendRefLike(BackendObjectReference item) {
        return new BackendRefNested(item);
    }

    public BackendRefNested<A> editBackendRef() {
        return this.withNewBackendRefLike(Optional.ofNullable(this.buildBackendRef()).orElse(null));
    }

    public BackendRefNested<A> editOrNewBackendRef() {
        return this.withNewBackendRefLike(Optional.ofNullable(this.buildBackendRef()).orElse(new BackendObjectReferenceBuilder().build()));
    }

    public BackendRefNested<A> editOrNewBackendRefLike(BackendObjectReference item) {
        return this.withNewBackendRefLike(Optional.ofNullable(this.buildBackendRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRequestMirrorFilterFluent that = (HTTPRequestMirrorFilterFluent)o;
        if (!Objects.equals(this.backendRef, that.backendRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backendRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backendRef != null) {
            sb.append("backendRef:");
            sb.append(this.backendRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BackendRefNested<N>
    extends BackendObjectReferenceFluent<BackendRefNested<N>>
    implements Nested<N> {
        BackendObjectReferenceBuilder builder;

        BackendRefNested(BackendObjectReference item) {
            this.builder = new BackendObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRequestMirrorFilterFluent.this.withBackendRef(this.builder.build());
        }

        public N endBackendRef() {
            return this.and();
        }
    }
}

