/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.ExemptPriorityLevelConfiguration;
import io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.ExemptPriorityLevelConfigurationBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.ExemptPriorityLevelConfigurationFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.LimitedPriorityLevelConfiguration;
import io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.LimitedPriorityLevelConfigurationBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.LimitedPriorityLevelConfigurationFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1.PriorityLevelConfigurationSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PriorityLevelConfigurationSpecFluent<A extends PriorityLevelConfigurationSpecFluent<A>>
extends BaseFluent<A> {
    private ExemptPriorityLevelConfigurationBuilder exempt;
    private LimitedPriorityLevelConfigurationBuilder limited;
    private String type;
    private Map<String, Object> additionalProperties;

    public PriorityLevelConfigurationSpecFluent() {
    }

    public PriorityLevelConfigurationSpecFluent(PriorityLevelConfigurationSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PriorityLevelConfigurationSpec instance) {
        PriorityLevelConfigurationSpec priorityLevelConfigurationSpec = instance = instance != null ? instance : new PriorityLevelConfigurationSpec();
        if (instance != null) {
            this.withExempt(instance.getExempt());
            this.withLimited(instance.getLimited());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExemptPriorityLevelConfiguration buildExempt() {
        return this.exempt != null ? this.exempt.build() : null;
    }

    public A withExempt(ExemptPriorityLevelConfiguration exempt) {
        this._visitables.remove("exempt");
        if (exempt != null) {
            this.exempt = new ExemptPriorityLevelConfigurationBuilder(exempt);
            this._visitables.get("exempt").add(this.exempt);
        } else {
            this.exempt = null;
            this._visitables.get("exempt").remove(this.exempt);
        }
        return (A)this;
    }

    public boolean hasExempt() {
        return this.exempt != null;
    }

    public A withNewExempt(Integer lendablePercent, Integer nominalConcurrencyShares) {
        return this.withExempt(new ExemptPriorityLevelConfiguration(lendablePercent, nominalConcurrencyShares));
    }

    public ExemptNested<A> withNewExempt() {
        return new ExemptNested(null);
    }

    public ExemptNested<A> withNewExemptLike(ExemptPriorityLevelConfiguration item) {
        return new ExemptNested(item);
    }

    public ExemptNested<A> editExempt() {
        return this.withNewExemptLike(Optional.ofNullable(this.buildExempt()).orElse(null));
    }

    public ExemptNested<A> editOrNewExempt() {
        return this.withNewExemptLike(Optional.ofNullable(this.buildExempt()).orElse(new ExemptPriorityLevelConfigurationBuilder().build()));
    }

    public ExemptNested<A> editOrNewExemptLike(ExemptPriorityLevelConfiguration item) {
        return this.withNewExemptLike(Optional.ofNullable(this.buildExempt()).orElse(item));
    }

    public LimitedPriorityLevelConfiguration buildLimited() {
        return this.limited != null ? this.limited.build() : null;
    }

    public A withLimited(LimitedPriorityLevelConfiguration limited) {
        this._visitables.remove("limited");
        if (limited != null) {
            this.limited = new LimitedPriorityLevelConfigurationBuilder(limited);
            this._visitables.get("limited").add(this.limited);
        } else {
            this.limited = null;
            this._visitables.get("limited").remove(this.limited);
        }
        return (A)this;
    }

    public boolean hasLimited() {
        return this.limited != null;
    }

    public LimitedNested<A> withNewLimited() {
        return new LimitedNested(null);
    }

    public LimitedNested<A> withNewLimitedLike(LimitedPriorityLevelConfiguration item) {
        return new LimitedNested(item);
    }

    public LimitedNested<A> editLimited() {
        return this.withNewLimitedLike(Optional.ofNullable(this.buildLimited()).orElse(null));
    }

    public LimitedNested<A> editOrNewLimited() {
        return this.withNewLimitedLike(Optional.ofNullable(this.buildLimited()).orElse(new LimitedPriorityLevelConfigurationBuilder().build()));
    }

    public LimitedNested<A> editOrNewLimitedLike(LimitedPriorityLevelConfiguration item) {
        return this.withNewLimitedLike(Optional.ofNullable(this.buildLimited()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PriorityLevelConfigurationSpecFluent that = (PriorityLevelConfigurationSpecFluent)o;
        if (!Objects.equals(this.exempt, that.exempt)) {
            return false;
        }
        if (!Objects.equals(this.limited, that.limited)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.exempt, this.limited, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exempt != null) {
            sb.append("exempt:");
            sb.append(this.exempt + ",");
        }
        if (this.limited != null) {
            sb.append("limited:");
            sb.append(this.limited + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LimitedNested<N>
    extends LimitedPriorityLevelConfigurationFluent<LimitedNested<N>>
    implements Nested<N> {
        LimitedPriorityLevelConfigurationBuilder builder;

        LimitedNested(LimitedPriorityLevelConfiguration item) {
            this.builder = new LimitedPriorityLevelConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PriorityLevelConfigurationSpecFluent.this.withLimited(this.builder.build());
        }

        public N endLimited() {
            return this.and();
        }
    }

    public class ExemptNested<N>
    extends ExemptPriorityLevelConfigurationFluent<ExemptNested<N>>
    implements Nested<N> {
        ExemptPriorityLevelConfigurationBuilder builder;

        ExemptNested(ExemptPriorityLevelConfiguration item) {
            this.builder = new ExemptPriorityLevelConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PriorityLevelConfigurationSpecFluent.this.withExempt(this.builder.build());
        }

        public N endExempt() {
            return this.and();
        }
    }
}

