/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.ClusterRoleScopeRestriction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterRoleScopeRestrictionFluent<A extends ClusterRoleScopeRestrictionFluent<A>>
extends BaseFluent<A> {
    private Boolean allowEscalation;
    private List<String> namespaces = new ArrayList<String>();
    private List<String> roleNames = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ClusterRoleScopeRestrictionFluent() {
    }

    public ClusterRoleScopeRestrictionFluent(ClusterRoleScopeRestriction instance) {
        ClusterRoleScopeRestriction clusterRoleScopeRestriction = instance = instance != null ? instance : new ClusterRoleScopeRestriction();
        if (instance != null) {
            this.withAllowEscalation(instance.getAllowEscalation());
            this.withNamespaces(instance.getNamespaces());
            this.withRoleNames(instance.getRoleNames());
            this.withAllowEscalation(instance.getAllowEscalation());
            this.withNamespaces(instance.getNamespaces());
            this.withRoleNames(instance.getRoleNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllowEscalation() {
        return this.allowEscalation;
    }

    public A withAllowEscalation(Boolean allowEscalation) {
        this.allowEscalation = allowEscalation;
        return (A)this;
    }

    public boolean hasAllowEscalation() {
        return this.allowEscalation != null;
    }

    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    public A removeFromNamespaces(String ... items) {
        if (this.namespaces == null) {
            return (A)this;
        }
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            return (A)this;
        }
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNamespaces(List<String> namespaces) {
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this._visitables.remove("namespaces");
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    public boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    public A addToRoleNames(int index, String item) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        this.roleNames.add(index, item);
        return (A)this;
    }

    public A setToRoleNames(int index, String item) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        this.roleNames.set(index, item);
        return (A)this;
    }

    public A addToRoleNames(String ... items) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.roleNames.add(item);
        }
        return (A)this;
    }

    public A addAllToRoleNames(Collection<String> items) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.roleNames.add(item);
        }
        return (A)this;
    }

    public A removeFromRoleNames(String ... items) {
        if (this.roleNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.roleNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRoleNames(Collection<String> items) {
        if (this.roleNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.roleNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getRoleNames() {
        return this.roleNames;
    }

    public String getRoleName(int index) {
        return this.roleNames.get(index);
    }

    public String getFirstRoleName() {
        return this.roleNames.get(0);
    }

    public String getLastRoleName() {
        return this.roleNames.get(this.roleNames.size() - 1);
    }

    public String getMatchingRoleName(Predicate<String> predicate) {
        for (String item : this.roleNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRoleName(Predicate<String> predicate) {
        for (String item : this.roleNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoleNames(List<String> roleNames) {
        if (roleNames != null) {
            this.roleNames = new ArrayList<String>();
            for (String item : roleNames) {
                this.addToRoleNames(item);
            }
        } else {
            this.roleNames = null;
        }
        return (A)this;
    }

    public A withRoleNames(String ... roleNames) {
        if (this.roleNames != null) {
            this.roleNames.clear();
            this._visitables.remove("roleNames");
        }
        if (roleNames != null) {
            for (String item : roleNames) {
                this.addToRoleNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasRoleNames() {
        return this.roleNames != null && !this.roleNames.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleScopeRestrictionFluent that = (ClusterRoleScopeRestrictionFluent)o;
        if (!Objects.equals(this.allowEscalation, that.allowEscalation)) {
            return false;
        }
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.roleNames, that.roleNames)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowEscalation, this.namespaces, this.roleNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowEscalation != null) {
            sb.append("allowEscalation:");
            sb.append(this.allowEscalation + ",");
        }
        if (this.namespaces != null && !this.namespaces.isEmpty()) {
            sb.append("namespaces:");
            sb.append(this.namespaces + ",");
        }
        if (this.roleNames != null && !this.roleNames.isEmpty()) {
            sb.append("roleNames:");
            sb.append(this.roleNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowEscalation() {
        return this.withAllowEscalation(true);
    }
}

