/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageFluentImpl;
import io.fabric8.openshift.api.model.ImageLookupPolicy;
import io.fabric8.openshift.api.model.ImageLookupPolicyBuilder;
import io.fabric8.openshift.api.model.ImageLookupPolicyFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagFluent;
import io.fabric8.openshift.api.model.TagEventCondition;
import io.fabric8.openshift.api.model.TagEventConditionBuilder;
import io.fabric8.openshift.api.model.TagEventConditionFluentImpl;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.api.model.TagReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamTagFluentImpl<A extends ImageStreamTagFluent<A>>
extends BaseFluent<A>
implements ImageStreamTagFluent<A> {
    private String apiVersion;
    private ArrayList<TagEventConditionBuilder> conditions = new ArrayList();
    private Long generation;
    private ImageBuilder image;
    private String kind;
    private ImageLookupPolicyBuilder lookupPolicy;
    private ObjectMetaBuilder metadata;
    private TagReferenceBuilder tag;
    private Map<String, Object> additionalProperties;

    public ImageStreamTagFluentImpl() {
    }

    public ImageStreamTagFluentImpl(ImageStreamTag instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withConditions(instance.getConditions());
            this.withGeneration(instance.getGeneration());
            this.withImage(instance.getImage());
            this.withKind(instance.getKind());
            this.withLookupPolicy(instance.getLookupPolicy());
            this.withMetadata(instance.getMetadata());
            this.withTag(instance.getTag());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToConditions(int index, TagEventCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, TagEventCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(TagEventCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<TagEventCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(TagEventCondition ... items) {
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<TagEventCondition> items) {
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<TagEventConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<TagEventConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            TagEventConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TagEventCondition> getConditions() {
        return this.conditions != null ? ImageStreamTagFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<TagEventCondition> buildConditions() {
        return this.conditions != null ? ImageStreamTagFluentImpl.build(this.conditions) : null;
    }

    @Override
    public TagEventCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public TagEventCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public TagEventCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public TagEventCondition buildMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        for (TagEventConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        for (TagEventConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<TagEventCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(TagEventCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> setNewConditionLike(int index, TagEventCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> editMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public Boolean hasGeneration() {
        return this.generation != null;
    }

    @Override
    @Deprecated
    public Image getImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public A withImage(Image image) {
        this._visitables.get("image").remove(this.image);
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get("image").remove(this.image);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public ImageStreamTagFluent.ImageNested<A> withNewImage() {
        return new ImageNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.ImageNested<A> withNewImageLike(Image item) {
        return new ImageNestedImpl(item);
    }

    @Override
    public ImageStreamTagFluent.ImageNested<A> editImage() {
        return this.withNewImageLike(this.getImage());
    }

    @Override
    public ImageStreamTagFluent.ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : new ImageBuilder().build());
    }

    @Override
    public ImageStreamTagFluent.ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ImageLookupPolicy getLookupPolicy() {
        return this.lookupPolicy != null ? this.lookupPolicy.build() : null;
    }

    @Override
    public ImageLookupPolicy buildLookupPolicy() {
        return this.lookupPolicy != null ? this.lookupPolicy.build() : null;
    }

    @Override
    public A withLookupPolicy(ImageLookupPolicy lookupPolicy) {
        this._visitables.get("lookupPolicy").remove(this.lookupPolicy);
        if (lookupPolicy != null) {
            this.lookupPolicy = new ImageLookupPolicyBuilder(lookupPolicy);
            this._visitables.get("lookupPolicy").add(this.lookupPolicy);
        } else {
            this.lookupPolicy = null;
            this._visitables.get("lookupPolicy").remove(this.lookupPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLookupPolicy() {
        return this.lookupPolicy != null;
    }

    @Override
    public A withNewLookupPolicy(Boolean local) {
        return this.withLookupPolicy(new ImageLookupPolicy(local));
    }

    @Override
    public ImageStreamTagFluent.LookupPolicyNested<A> withNewLookupPolicy() {
        return new LookupPolicyNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item) {
        return new LookupPolicyNestedImpl(item);
    }

    @Override
    public ImageStreamTagFluent.LookupPolicyNested<A> editLookupPolicy() {
        return this.withNewLookupPolicyLike(this.getLookupPolicy());
    }

    @Override
    public ImageStreamTagFluent.LookupPolicyNested<A> editOrNewLookupPolicy() {
        return this.withNewLookupPolicyLike(this.getLookupPolicy() != null ? this.getLookupPolicy() : new ImageLookupPolicyBuilder().build());
    }

    @Override
    public ImageStreamTagFluent.LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item) {
        return this.withNewLookupPolicyLike(this.getLookupPolicy() != null ? this.getLookupPolicy() : item);
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ImageStreamTagFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageStreamTagFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageStreamTagFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ImageStreamTagFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public TagReference getTag() {
        return this.tag != null ? this.tag.build() : null;
    }

    @Override
    public TagReference buildTag() {
        return this.tag != null ? this.tag.build() : null;
    }

    @Override
    public A withTag(TagReference tag) {
        this._visitables.get("tag").remove(this.tag);
        if (tag != null) {
            this.tag = new TagReferenceBuilder(tag);
            this._visitables.get("tag").add(this.tag);
        } else {
            this.tag = null;
            this._visitables.get("tag").remove(this.tag);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public ImageStreamTagFluent.TagNested<A> withNewTag() {
        return new TagNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.TagNested<A> withNewTagLike(TagReference item) {
        return new TagNestedImpl(item);
    }

    @Override
    public ImageStreamTagFluent.TagNested<A> editTag() {
        return this.withNewTagLike(this.getTag());
    }

    @Override
    public ImageStreamTagFluent.TagNested<A> editOrNewTag() {
        return this.withNewTagLike(this.getTag() != null ? this.getTag() : new TagReferenceBuilder().build());
    }

    @Override
    public ImageStreamTagFluent.TagNested<A> editOrNewTagLike(TagReference item) {
        return this.withNewTagLike(this.getTag() != null ? this.getTag() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamTagFluentImpl that = (ImageStreamTagFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.generation, that.generation)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.lookupPolicy, that.lookupPolicy)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.tag, that.tag)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.conditions, this.generation, this.image, this.kind, this.lookupPolicy, this.metadata, this.tag, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.generation != null) {
            sb.append("generation:");
            sb.append(this.generation + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.lookupPolicy != null) {
            sb.append("lookupPolicy:");
            sb.append(this.lookupPolicy + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TagNestedImpl<N>
    extends TagReferenceFluentImpl<ImageStreamTagFluent.TagNested<N>>
    implements ImageStreamTagFluent.TagNested<N>,
    Nested<N> {
        TagReferenceBuilder builder;

        TagNestedImpl(TagReference item) {
            this.builder = new TagReferenceBuilder(this, item);
        }

        TagNestedImpl() {
            this.builder = new TagReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.withTag(this.builder.build());
        }

        @Override
        public N endTag() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageStreamTagFluent.MetadataNested<N>>
    implements ImageStreamTagFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class LookupPolicyNestedImpl<N>
    extends ImageLookupPolicyFluentImpl<ImageStreamTagFluent.LookupPolicyNested<N>>
    implements ImageStreamTagFluent.LookupPolicyNested<N>,
    Nested<N> {
        ImageLookupPolicyBuilder builder;

        LookupPolicyNestedImpl(ImageLookupPolicy item) {
            this.builder = new ImageLookupPolicyBuilder(this, item);
        }

        LookupPolicyNestedImpl() {
            this.builder = new ImageLookupPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.withLookupPolicy(this.builder.build());
        }

        @Override
        public N endLookupPolicy() {
            return this.and();
        }
    }

    class ImageNestedImpl<N>
    extends ImageFluentImpl<ImageStreamTagFluent.ImageNested<N>>
    implements ImageStreamTagFluent.ImageNested<N>,
    Nested<N> {
        ImageBuilder builder;

        ImageNestedImpl(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        ImageNestedImpl() {
            this.builder = new ImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.withImage(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends TagEventConditionFluentImpl<ImageStreamTagFluent.ConditionsNested<N>>
    implements ImageStreamTagFluent.ConditionsNested<N>,
    Nested<N> {
        TagEventConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, TagEventCondition item) {
            this.index = index;
            this.builder = new TagEventConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new TagEventConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

