/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.CertificateBundleSpec;
import io.fabric8.openshift.api.model.hive.v1.CertificateBundleSpecBuilder;
import io.fabric8.openshift.api.model.hive.v1.CertificateBundleSpecFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpec;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngress;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngressBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.ClusterInstallLocalReference;
import io.fabric8.openshift.api.model.hive.v1.ClusterInstallLocalReferenceBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterInstallLocalReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.ClusterMetadata;
import io.fabric8.openshift.api.model.hive.v1.ClusterMetadataBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.ClusterPoolReference;
import io.fabric8.openshift.api.model.hive.v1.ClusterPoolReferenceBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterPoolReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.ControlPlaneConfigSpec;
import io.fabric8.openshift.api.model.hive.v1.ControlPlaneConfigSpecBuilder;
import io.fabric8.openshift.api.model.hive.v1.ControlPlaneConfigSpecFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.Platform;
import io.fabric8.openshift.api.model.hive.v1.PlatformBuilder;
import io.fabric8.openshift.api.model.hive.v1.PlatformFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.Provisioning;
import io.fabric8.openshift.api.model.hive.v1.ProvisioningBuilder;
import io.fabric8.openshift.api.model.hive.v1.ProvisioningFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterDeploymentSpecFluentImpl<A extends ClusterDeploymentSpecFluent<A>>
extends BaseFluent<A>
implements ClusterDeploymentSpecFluent<A> {
    private String baseDomain;
    private LocalObjectReferenceBuilder boundServiceAccountSigningKeySecretRef;
    private ArrayList<CertificateBundleSpecBuilder> certificateBundles = new ArrayList();
    private ClusterInstallLocalReferenceBuilder clusterInstallRef;
    private ClusterMetadataBuilder clusterMetadata;
    private String clusterName;
    private ClusterPoolReferenceBuilder clusterPoolRef;
    private ControlPlaneConfigSpecBuilder controlPlaneConfig;
    private Duration hibernateAfter;
    private ArrayList<ClusterIngressBuilder> ingress = new ArrayList();
    private Integer installAttemptsLimit;
    private Boolean installed;
    private Boolean manageDNS;
    private PlatformBuilder platform;
    private String powerState;
    private Boolean preserveOnDelete;
    private ProvisioningBuilder provisioning;
    private LocalObjectReferenceBuilder pullSecretRef;
    private Map<String, Object> additionalProperties;

    public ClusterDeploymentSpecFluentImpl() {
    }

    public ClusterDeploymentSpecFluentImpl(ClusterDeploymentSpec instance) {
        this.withBaseDomain(instance.getBaseDomain());
        this.withBoundServiceAccountSigningKeySecretRef(instance.getBoundServiceAccountSigningKeySecretRef());
        this.withCertificateBundles(instance.getCertificateBundles());
        this.withClusterInstallRef(instance.getClusterInstallRef());
        this.withClusterMetadata(instance.getClusterMetadata());
        this.withClusterName(instance.getClusterName());
        this.withClusterPoolRef(instance.getClusterPoolRef());
        this.withControlPlaneConfig(instance.getControlPlaneConfig());
        this.withHibernateAfter(instance.getHibernateAfter());
        this.withIngress(instance.getIngress());
        this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit());
        this.withInstalled(instance.getInstalled());
        this.withManageDNS(instance.getManageDNS());
        this.withPlatform(instance.getPlatform());
        this.withPowerState(instance.getPowerState());
        this.withPreserveOnDelete(instance.getPreserveOnDelete());
        this.withProvisioning(instance.getProvisioning());
        this.withPullSecretRef(instance.getPullSecretRef());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)this;
    }

    @Override
    public Boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getBoundServiceAccountSigningKeySecretRef() {
        return this.boundServiceAccountSigningKeySecretRef != null ? this.boundServiceAccountSigningKeySecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildBoundServiceAccountSigningKeySecretRef() {
        return this.boundServiceAccountSigningKeySecretRef != null ? this.boundServiceAccountSigningKeySecretRef.build() : null;
    }

    @Override
    public A withBoundServiceAccountSigningKeySecretRef(LocalObjectReference boundServiceAccountSigningKeySecretRef) {
        this._visitables.get("boundServiceAccountSigningKeySecretRef").remove(this.boundServiceAccountSigningKeySecretRef);
        if (boundServiceAccountSigningKeySecretRef != null) {
            this.boundServiceAccountSigningKeySecretRef = new LocalObjectReferenceBuilder(boundServiceAccountSigningKeySecretRef);
            this._visitables.get("boundServiceAccountSigningKeySecretRef").add(this.boundServiceAccountSigningKeySecretRef);
        } else {
            this.boundServiceAccountSigningKeySecretRef = null;
            this._visitables.get("boundServiceAccountSigningKeySecretRef").remove(this.boundServiceAccountSigningKeySecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBoundServiceAccountSigningKeySecretRef() {
        return this.boundServiceAccountSigningKeySecretRef != null;
    }

    @Override
    public A withNewBoundServiceAccountSigningKeySecretRef(String name) {
        return this.withBoundServiceAccountSigningKeySecretRef(new LocalObjectReference(name));
    }

    @Override
    public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> withNewBoundServiceAccountSigningKeySecretRef() {
        return new BoundServiceAccountSigningKeySecretRefNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> withNewBoundServiceAccountSigningKeySecretRefLike(LocalObjectReference item) {
        return new BoundServiceAccountSigningKeySecretRefNestedImpl(item);
    }

    @Override
    public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> editBoundServiceAccountSigningKeySecretRef() {
        return this.withNewBoundServiceAccountSigningKeySecretRefLike(this.getBoundServiceAccountSigningKeySecretRef());
    }

    @Override
    public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> editOrNewBoundServiceAccountSigningKeySecretRef() {
        return this.withNewBoundServiceAccountSigningKeySecretRefLike(this.getBoundServiceAccountSigningKeySecretRef() != null ? this.getBoundServiceAccountSigningKeySecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> editOrNewBoundServiceAccountSigningKeySecretRefLike(LocalObjectReference item) {
        return this.withNewBoundServiceAccountSigningKeySecretRefLike(this.getBoundServiceAccountSigningKeySecretRef() != null ? this.getBoundServiceAccountSigningKeySecretRef() : item);
    }

    @Override
    public A addToCertificateBundles(Integer index, CertificateBundleSpec item) {
        if (this.certificateBundles == null) {
            this.certificateBundles = new ArrayList();
        }
        CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);
        this._visitables.get("certificateBundles").add(index >= 0 ? index.intValue() : this._visitables.get("certificateBundles").size(), builder);
        this.certificateBundles.add(index >= 0 ? index.intValue() : this.certificateBundles.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCertificateBundles(Integer index, CertificateBundleSpec item) {
        if (this.certificateBundles == null) {
            this.certificateBundles = new ArrayList();
        }
        CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get("certificateBundles").size()) {
            this._visitables.get("certificateBundles").add(builder);
        } else {
            this._visitables.get("certificateBundles").set(index, builder);
        }
        if (index < 0 || index >= this.certificateBundles.size()) {
            this.certificateBundles.add(builder);
        } else {
            this.certificateBundles.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCertificateBundles(CertificateBundleSpec ... items) {
        if (this.certificateBundles == null) {
            this.certificateBundles = new ArrayList();
        }
        for (CertificateBundleSpec item : items) {
            CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);
            this._visitables.get("certificateBundles").add(builder);
            this.certificateBundles.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCertificateBundles(Collection<CertificateBundleSpec> items) {
        if (this.certificateBundles == null) {
            this.certificateBundles = new ArrayList();
        }
        for (CertificateBundleSpec item : items) {
            CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);
            this._visitables.get("certificateBundles").add(builder);
            this.certificateBundles.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCertificateBundles(CertificateBundleSpec ... items) {
        for (CertificateBundleSpec item : items) {
            CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);
            this._visitables.get("certificateBundles").remove(builder);
            if (this.certificateBundles == null) continue;
            this.certificateBundles.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCertificateBundles(Collection<CertificateBundleSpec> items) {
        for (CertificateBundleSpec item : items) {
            CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);
            this._visitables.get("certificateBundles").remove(builder);
            if (this.certificateBundles == null) continue;
            this.certificateBundles.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCertificateBundles(Predicate<CertificateBundleSpecBuilder> predicate) {
        if (this.certificateBundles == null) {
            return (A)this;
        }
        Iterator<CertificateBundleSpecBuilder> each = this.certificateBundles.iterator();
        Object visitables = this._visitables.get("certificateBundles");
        while (each.hasNext()) {
            CertificateBundleSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CertificateBundleSpec> getCertificateBundles() {
        return this.certificateBundles != null ? ClusterDeploymentSpecFluentImpl.build(this.certificateBundles) : null;
    }

    @Override
    public List<CertificateBundleSpec> buildCertificateBundles() {
        return this.certificateBundles != null ? ClusterDeploymentSpecFluentImpl.build(this.certificateBundles) : null;
    }

    @Override
    public CertificateBundleSpec buildCertificateBundle(Integer index) {
        return this.certificateBundles.get(index).build();
    }

    @Override
    public CertificateBundleSpec buildFirstCertificateBundle() {
        return this.certificateBundles.get(0).build();
    }

    @Override
    public CertificateBundleSpec buildLastCertificateBundle() {
        return this.certificateBundles.get(this.certificateBundles.size() - 1).build();
    }

    @Override
    public CertificateBundleSpec buildMatchingCertificateBundle(Predicate<CertificateBundleSpecBuilder> predicate) {
        for (CertificateBundleSpecBuilder item : this.certificateBundles) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCertificateBundle(Predicate<CertificateBundleSpecBuilder> predicate) {
        for (CertificateBundleSpecBuilder item : this.certificateBundles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCertificateBundles(List<CertificateBundleSpec> certificateBundles) {
        if (this.certificateBundles != null) {
            this._visitables.get("certificateBundles").removeAll(this.certificateBundles);
        }
        if (certificateBundles != null) {
            this.certificateBundles = new ArrayList();
            for (CertificateBundleSpec item : certificateBundles) {
                this.addToCertificateBundles(item);
            }
        } else {
            this.certificateBundles = null;
        }
        return (A)this;
    }

    @Override
    public A withCertificateBundles(CertificateBundleSpec ... certificateBundles) {
        if (this.certificateBundles != null) {
            this.certificateBundles.clear();
        }
        if (certificateBundles != null) {
            for (CertificateBundleSpec item : certificateBundles) {
                this.addToCertificateBundles(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCertificateBundles() {
        return this.certificateBundles != null && !this.certificateBundles.isEmpty();
    }

    @Override
    public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> addNewCertificateBundle() {
        return new CertificateBundlesNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> addNewCertificateBundleLike(CertificateBundleSpec item) {
        return new CertificateBundlesNestedImpl(-1, item);
    }

    @Override
    public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> setNewCertificateBundleLike(Integer index, CertificateBundleSpec item) {
        return new CertificateBundlesNestedImpl(index, item);
    }

    @Override
    public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> editCertificateBundle(Integer index) {
        if (this.certificateBundles.size() <= index) {
            throw new RuntimeException("Can't edit certificateBundles. Index exceeds size.");
        }
        return this.setNewCertificateBundleLike(index, this.buildCertificateBundle(index));
    }

    @Override
    public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> editFirstCertificateBundle() {
        if (this.certificateBundles.size() == 0) {
            throw new RuntimeException("Can't edit first certificateBundles. The list is empty.");
        }
        return this.setNewCertificateBundleLike(0, this.buildCertificateBundle(0));
    }

    @Override
    public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> editLastCertificateBundle() {
        int index = this.certificateBundles.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last certificateBundles. The list is empty.");
        }
        return this.setNewCertificateBundleLike(index, this.buildCertificateBundle(index));
    }

    @Override
    public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> editMatchingCertificateBundle(Predicate<CertificateBundleSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.certificateBundles.size(); ++i) {
            if (!predicate.test(this.certificateBundles.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching certificateBundles. No match found.");
        }
        return this.setNewCertificateBundleLike(index, this.buildCertificateBundle(index));
    }

    @Override
    @Deprecated
    public ClusterInstallLocalReference getClusterInstallRef() {
        return this.clusterInstallRef != null ? this.clusterInstallRef.build() : null;
    }

    @Override
    public ClusterInstallLocalReference buildClusterInstallRef() {
        return this.clusterInstallRef != null ? this.clusterInstallRef.build() : null;
    }

    @Override
    public A withClusterInstallRef(ClusterInstallLocalReference clusterInstallRef) {
        this._visitables.get("clusterInstallRef").remove(this.clusterInstallRef);
        if (clusterInstallRef != null) {
            this.clusterInstallRef = new ClusterInstallLocalReferenceBuilder(clusterInstallRef);
            this._visitables.get("clusterInstallRef").add(this.clusterInstallRef);
        } else {
            this.clusterInstallRef = null;
            this._visitables.get("clusterInstallRef").remove(this.clusterInstallRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterInstallRef() {
        return this.clusterInstallRef != null;
    }

    @Override
    public A withNewClusterInstallRef(String group, String kind, String name, String version) {
        return this.withClusterInstallRef(new ClusterInstallLocalReference(group, kind, name, version));
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> withNewClusterInstallRef() {
        return new ClusterInstallRefNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> withNewClusterInstallRefLike(ClusterInstallLocalReference item) {
        return new ClusterInstallRefNestedImpl(item);
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> editClusterInstallRef() {
        return this.withNewClusterInstallRefLike(this.getClusterInstallRef());
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> editOrNewClusterInstallRef() {
        return this.withNewClusterInstallRefLike(this.getClusterInstallRef() != null ? this.getClusterInstallRef() : new ClusterInstallLocalReferenceBuilder().build());
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> editOrNewClusterInstallRefLike(ClusterInstallLocalReference item) {
        return this.withNewClusterInstallRefLike(this.getClusterInstallRef() != null ? this.getClusterInstallRef() : item);
    }

    @Override
    @Deprecated
    public ClusterMetadata getClusterMetadata() {
        return this.clusterMetadata != null ? this.clusterMetadata.build() : null;
    }

    @Override
    public ClusterMetadata buildClusterMetadata() {
        return this.clusterMetadata != null ? this.clusterMetadata.build() : null;
    }

    @Override
    public A withClusterMetadata(ClusterMetadata clusterMetadata) {
        this._visitables.get("clusterMetadata").remove(this.clusterMetadata);
        if (clusterMetadata != null) {
            this.clusterMetadata = new ClusterMetadataBuilder(clusterMetadata);
            this._visitables.get("clusterMetadata").add(this.clusterMetadata);
        } else {
            this.clusterMetadata = null;
            this._visitables.get("clusterMetadata").remove(this.clusterMetadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterMetadata() {
        return this.clusterMetadata != null;
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> withNewClusterMetadata() {
        return new ClusterMetadataNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> withNewClusterMetadataLike(ClusterMetadata item) {
        return new ClusterMetadataNestedImpl(item);
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> editClusterMetadata() {
        return this.withNewClusterMetadataLike(this.getClusterMetadata());
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> editOrNewClusterMetadata() {
        return this.withNewClusterMetadataLike(this.getClusterMetadata() != null ? this.getClusterMetadata() : new ClusterMetadataBuilder().build());
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> editOrNewClusterMetadataLike(ClusterMetadata item) {
        return this.withNewClusterMetadataLike(this.getClusterMetadata() != null ? this.getClusterMetadata() : item);
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)this;
    }

    @Override
    public Boolean hasClusterName() {
        return this.clusterName != null;
    }

    @Override
    @Deprecated
    public ClusterPoolReference getClusterPoolRef() {
        return this.clusterPoolRef != null ? this.clusterPoolRef.build() : null;
    }

    @Override
    public ClusterPoolReference buildClusterPoolRef() {
        return this.clusterPoolRef != null ? this.clusterPoolRef.build() : null;
    }

    @Override
    public A withClusterPoolRef(ClusterPoolReference clusterPoolRef) {
        this._visitables.get("clusterPoolRef").remove(this.clusterPoolRef);
        if (clusterPoolRef != null) {
            this.clusterPoolRef = new ClusterPoolReferenceBuilder(clusterPoolRef);
            this._visitables.get("clusterPoolRef").add(this.clusterPoolRef);
        } else {
            this.clusterPoolRef = null;
            this._visitables.get("clusterPoolRef").remove(this.clusterPoolRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterPoolRef() {
        return this.clusterPoolRef != null;
    }

    @Override
    public A withNewClusterPoolRef(String claimName, String claimedTimestamp, String namespace, String poolName) {
        return this.withClusterPoolRef(new ClusterPoolReference(claimName, claimedTimestamp, namespace, poolName));
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> withNewClusterPoolRef() {
        return new ClusterPoolRefNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> withNewClusterPoolRefLike(ClusterPoolReference item) {
        return new ClusterPoolRefNestedImpl(item);
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> editClusterPoolRef() {
        return this.withNewClusterPoolRefLike(this.getClusterPoolRef());
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> editOrNewClusterPoolRef() {
        return this.withNewClusterPoolRefLike(this.getClusterPoolRef() != null ? this.getClusterPoolRef() : new ClusterPoolReferenceBuilder().build());
    }

    @Override
    public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> editOrNewClusterPoolRefLike(ClusterPoolReference item) {
        return this.withNewClusterPoolRefLike(this.getClusterPoolRef() != null ? this.getClusterPoolRef() : item);
    }

    @Override
    @Deprecated
    public ControlPlaneConfigSpec getControlPlaneConfig() {
        return this.controlPlaneConfig != null ? this.controlPlaneConfig.build() : null;
    }

    @Override
    public ControlPlaneConfigSpec buildControlPlaneConfig() {
        return this.controlPlaneConfig != null ? this.controlPlaneConfig.build() : null;
    }

    @Override
    public A withControlPlaneConfig(ControlPlaneConfigSpec controlPlaneConfig) {
        this._visitables.get("controlPlaneConfig").remove(this.controlPlaneConfig);
        if (controlPlaneConfig != null) {
            this.controlPlaneConfig = new ControlPlaneConfigSpecBuilder(controlPlaneConfig);
            this._visitables.get("controlPlaneConfig").add(this.controlPlaneConfig);
        } else {
            this.controlPlaneConfig = null;
            this._visitables.get("controlPlaneConfig").remove(this.controlPlaneConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasControlPlaneConfig() {
        return this.controlPlaneConfig != null;
    }

    @Override
    public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> withNewControlPlaneConfig() {
        return new ControlPlaneConfigNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> withNewControlPlaneConfigLike(ControlPlaneConfigSpec item) {
        return new ControlPlaneConfigNestedImpl(item);
    }

    @Override
    public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> editControlPlaneConfig() {
        return this.withNewControlPlaneConfigLike(this.getControlPlaneConfig());
    }

    @Override
    public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> editOrNewControlPlaneConfig() {
        return this.withNewControlPlaneConfigLike(this.getControlPlaneConfig() != null ? this.getControlPlaneConfig() : new ControlPlaneConfigSpecBuilder().build());
    }

    @Override
    public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> editOrNewControlPlaneConfigLike(ControlPlaneConfigSpec item) {
        return this.withNewControlPlaneConfigLike(this.getControlPlaneConfig() != null ? this.getControlPlaneConfig() : item);
    }

    @Override
    public Duration getHibernateAfter() {
        return this.hibernateAfter;
    }

    @Override
    public A withHibernateAfter(Duration hibernateAfter) {
        this.hibernateAfter = hibernateAfter;
        return (A)this;
    }

    @Override
    public Boolean hasHibernateAfter() {
        return this.hibernateAfter != null;
    }

    @Override
    public A addToIngress(Integer index, ClusterIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        ClusterIngressBuilder builder = new ClusterIngressBuilder(item);
        this._visitables.get("ingress").add(index >= 0 ? index.intValue() : this._visitables.get("ingress").size(), builder);
        this.ingress.add(index >= 0 ? index.intValue() : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(Integer index, ClusterIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        ClusterIngressBuilder builder = new ClusterIngressBuilder(item);
        if (index < 0 || index >= this._visitables.get("ingress").size()) {
            this._visitables.get("ingress").add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(ClusterIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (ClusterIngress item : items) {
            ClusterIngressBuilder builder = new ClusterIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<ClusterIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (ClusterIngress item : items) {
            ClusterIngressBuilder builder = new ClusterIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(ClusterIngress ... items) {
        for (ClusterIngress item : items) {
            ClusterIngressBuilder builder = new ClusterIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<ClusterIngress> items) {
        for (ClusterIngress item : items) {
            ClusterIngressBuilder builder = new ClusterIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<ClusterIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<ClusterIngressBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            ClusterIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterIngress> getIngress() {
        return this.ingress != null ? ClusterDeploymentSpecFluentImpl.build(this.ingress) : null;
    }

    @Override
    public List<ClusterIngress> buildIngress() {
        return this.ingress != null ? ClusterDeploymentSpecFluentImpl.build(this.ingress) : null;
    }

    @Override
    public ClusterIngress buildIngress(Integer index) {
        return this.ingress.get(index).build();
    }

    @Override
    public ClusterIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public ClusterIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public ClusterIngress buildMatchingIngress(Predicate<ClusterIngressBuilder> predicate) {
        for (ClusterIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<ClusterIngressBuilder> predicate) {
        for (ClusterIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<ClusterIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").removeAll(this.ingress);
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (ClusterIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(ClusterIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
        }
        if (ingress != null) {
            for (ClusterIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public ClusterDeploymentSpecFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.IngressNested<A> addNewIngressLike(ClusterIngress item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public ClusterDeploymentSpecFluent.IngressNested<A> setNewIngressLike(Integer index, ClusterIngress item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public ClusterDeploymentSpecFluent.IngressNested<A> editIngress(Integer index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public ClusterDeploymentSpecFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public ClusterDeploymentSpecFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public ClusterDeploymentSpecFluent.IngressNested<A> editMatchingIngress(Predicate<ClusterIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public Integer getInstallAttemptsLimit() {
        return this.installAttemptsLimit;
    }

    @Override
    public A withInstallAttemptsLimit(Integer installAttemptsLimit) {
        this.installAttemptsLimit = installAttemptsLimit;
        return (A)this;
    }

    @Override
    public Boolean hasInstallAttemptsLimit() {
        return this.installAttemptsLimit != null;
    }

    @Override
    public Boolean getInstalled() {
        return this.installed;
    }

    @Override
    public A withInstalled(Boolean installed) {
        this.installed = installed;
        return (A)this;
    }

    @Override
    public Boolean hasInstalled() {
        return this.installed != null;
    }

    @Override
    public Boolean getManageDNS() {
        return this.manageDNS;
    }

    @Override
    public A withManageDNS(Boolean manageDNS) {
        this.manageDNS = manageDNS;
        return (A)this;
    }

    @Override
    public Boolean hasManageDNS() {
        return this.manageDNS != null;
    }

    @Override
    @Deprecated
    public Platform getPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public Platform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public A withPlatform(Platform platform) {
        this._visitables.get("platform").remove(this.platform);
        if (platform != null) {
            this.platform = new PlatformBuilder(platform);
            this._visitables.get("platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get("platform").remove(this.platform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    public ClusterDeploymentSpecFluent.PlatformNested<A> withNewPlatform() {
        return new PlatformNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.PlatformNested<A> withNewPlatformLike(Platform item) {
        return new PlatformNestedImpl(item);
    }

    @Override
    public ClusterDeploymentSpecFluent.PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(this.getPlatform());
    }

    @Override
    public ClusterDeploymentSpecFluent.PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : new PlatformBuilder().build());
    }

    @Override
    public ClusterDeploymentSpecFluent.PlatformNested<A> editOrNewPlatformLike(Platform item) {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : item);
    }

    @Override
    public String getPowerState() {
        return this.powerState;
    }

    @Override
    public A withPowerState(String powerState) {
        this.powerState = powerState;
        return (A)this;
    }

    @Override
    public Boolean hasPowerState() {
        return this.powerState != null;
    }

    @Override
    public Boolean getPreserveOnDelete() {
        return this.preserveOnDelete;
    }

    @Override
    public A withPreserveOnDelete(Boolean preserveOnDelete) {
        this.preserveOnDelete = preserveOnDelete;
        return (A)this;
    }

    @Override
    public Boolean hasPreserveOnDelete() {
        return this.preserveOnDelete != null;
    }

    @Override
    @Deprecated
    public Provisioning getProvisioning() {
        return this.provisioning != null ? this.provisioning.build() : null;
    }

    @Override
    public Provisioning buildProvisioning() {
        return this.provisioning != null ? this.provisioning.build() : null;
    }

    @Override
    public A withProvisioning(Provisioning provisioning) {
        this._visitables.get("provisioning").remove(this.provisioning);
        if (provisioning != null) {
            this.provisioning = new ProvisioningBuilder(provisioning);
            this._visitables.get("provisioning").add(this.provisioning);
        } else {
            this.provisioning = null;
            this._visitables.get("provisioning").remove(this.provisioning);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProvisioning() {
        return this.provisioning != null;
    }

    @Override
    public ClusterDeploymentSpecFluent.ProvisioningNested<A> withNewProvisioning() {
        return new ProvisioningNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.ProvisioningNested<A> withNewProvisioningLike(Provisioning item) {
        return new ProvisioningNestedImpl(item);
    }

    @Override
    public ClusterDeploymentSpecFluent.ProvisioningNested<A> editProvisioning() {
        return this.withNewProvisioningLike(this.getProvisioning());
    }

    @Override
    public ClusterDeploymentSpecFluent.ProvisioningNested<A> editOrNewProvisioning() {
        return this.withNewProvisioningLike(this.getProvisioning() != null ? this.getProvisioning() : new ProvisioningBuilder().build());
    }

    @Override
    public ClusterDeploymentSpecFluent.ProvisioningNested<A> editOrNewProvisioningLike(Provisioning item) {
        return this.withNewProvisioningLike(this.getProvisioning() != null ? this.getProvisioning() : item);
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecretRef() {
        return this.pullSecretRef != null ? this.pullSecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecretRef() {
        return this.pullSecretRef != null ? this.pullSecretRef.build() : null;
    }

    @Override
    public A withPullSecretRef(LocalObjectReference pullSecretRef) {
        this._visitables.get("pullSecretRef").remove(this.pullSecretRef);
        if (pullSecretRef != null) {
            this.pullSecretRef = new LocalObjectReferenceBuilder(pullSecretRef);
            this._visitables.get("pullSecretRef").add(this.pullSecretRef);
        } else {
            this.pullSecretRef = null;
            this._visitables.get("pullSecretRef").remove(this.pullSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecretRef() {
        return this.pullSecretRef != null;
    }

    @Override
    public A withNewPullSecretRef(String name) {
        return this.withPullSecretRef(new LocalObjectReference(name));
    }

    @Override
    public ClusterDeploymentSpecFluent.PullSecretRefNested<A> withNewPullSecretRef() {
        return new PullSecretRefNestedImpl();
    }

    @Override
    public ClusterDeploymentSpecFluent.PullSecretRefNested<A> withNewPullSecretRefLike(LocalObjectReference item) {
        return new PullSecretRefNestedImpl(item);
    }

    @Override
    public ClusterDeploymentSpecFluent.PullSecretRefNested<A> editPullSecretRef() {
        return this.withNewPullSecretRefLike(this.getPullSecretRef());
    }

    @Override
    public ClusterDeploymentSpecFluent.PullSecretRefNested<A> editOrNewPullSecretRef() {
        return this.withNewPullSecretRefLike(this.getPullSecretRef() != null ? this.getPullSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ClusterDeploymentSpecFluent.PullSecretRefNested<A> editOrNewPullSecretRefLike(LocalObjectReference item) {
        return this.withNewPullSecretRefLike(this.getPullSecretRef() != null ? this.getPullSecretRef() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterDeploymentSpecFluentImpl that = (ClusterDeploymentSpecFluentImpl)o;
        if (this.baseDomain != null ? !this.baseDomain.equals(that.baseDomain) : that.baseDomain != null) {
            return false;
        }
        if (this.boundServiceAccountSigningKeySecretRef != null ? !this.boundServiceAccountSigningKeySecretRef.equals(that.boundServiceAccountSigningKeySecretRef) : that.boundServiceAccountSigningKeySecretRef != null) {
            return false;
        }
        if (this.certificateBundles != null ? !this.certificateBundles.equals(that.certificateBundles) : that.certificateBundles != null) {
            return false;
        }
        if (this.clusterInstallRef != null ? !this.clusterInstallRef.equals(that.clusterInstallRef) : that.clusterInstallRef != null) {
            return false;
        }
        if (this.clusterMetadata != null ? !this.clusterMetadata.equals(that.clusterMetadata) : that.clusterMetadata != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.clusterPoolRef != null ? !this.clusterPoolRef.equals(that.clusterPoolRef) : that.clusterPoolRef != null) {
            return false;
        }
        if (this.controlPlaneConfig != null ? !this.controlPlaneConfig.equals(that.controlPlaneConfig) : that.controlPlaneConfig != null) {
            return false;
        }
        if (this.hibernateAfter != null ? !this.hibernateAfter.equals(that.hibernateAfter) : that.hibernateAfter != null) {
            return false;
        }
        if (this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null) {
            return false;
        }
        if (this.installAttemptsLimit != null ? !this.installAttemptsLimit.equals(that.installAttemptsLimit) : that.installAttemptsLimit != null) {
            return false;
        }
        if (this.installed != null ? !this.installed.equals(that.installed) : that.installed != null) {
            return false;
        }
        if (this.manageDNS != null ? !this.manageDNS.equals(that.manageDNS) : that.manageDNS != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        if (this.powerState != null ? !this.powerState.equals(that.powerState) : that.powerState != null) {
            return false;
        }
        if (this.preserveOnDelete != null ? !this.preserveOnDelete.equals(that.preserveOnDelete) : that.preserveOnDelete != null) {
            return false;
        }
        if (this.provisioning != null ? !this.provisioning.equals(that.provisioning) : that.provisioning != null) {
            return false;
        }
        if (this.pullSecretRef != null ? !this.pullSecretRef.equals(that.pullSecretRef) : that.pullSecretRef != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseDomain, this.boundServiceAccountSigningKeySecretRef, this.certificateBundles, this.clusterInstallRef, this.clusterMetadata, this.clusterName, this.clusterPoolRef, this.controlPlaneConfig, this.hibernateAfter, this.ingress, this.installAttemptsLimit, this.installed, this.manageDNS, this.platform, this.powerState, this.preserveOnDelete, this.provisioning, this.pullSecretRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain + ",");
        }
        if (this.boundServiceAccountSigningKeySecretRef != null) {
            sb.append("boundServiceAccountSigningKeySecretRef:");
            sb.append(this.boundServiceAccountSigningKeySecretRef + ",");
        }
        if (this.certificateBundles != null && !this.certificateBundles.isEmpty()) {
            sb.append("certificateBundles:");
            sb.append(this.certificateBundles + ",");
        }
        if (this.clusterInstallRef != null) {
            sb.append("clusterInstallRef:");
            sb.append(this.clusterInstallRef + ",");
        }
        if (this.clusterMetadata != null) {
            sb.append("clusterMetadata:");
            sb.append(this.clusterMetadata + ",");
        }
        if (this.clusterName != null) {
            sb.append("clusterName:");
            sb.append(this.clusterName + ",");
        }
        if (this.clusterPoolRef != null) {
            sb.append("clusterPoolRef:");
            sb.append(this.clusterPoolRef + ",");
        }
        if (this.controlPlaneConfig != null) {
            sb.append("controlPlaneConfig:");
            sb.append(this.controlPlaneConfig + ",");
        }
        if (this.hibernateAfter != null) {
            sb.append("hibernateAfter:");
            sb.append(this.hibernateAfter + ",");
        }
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.installAttemptsLimit != null) {
            sb.append("installAttemptsLimit:");
            sb.append(this.installAttemptsLimit + ",");
        }
        if (this.installed != null) {
            sb.append("installed:");
            sb.append(this.installed + ",");
        }
        if (this.manageDNS != null) {
            sb.append("manageDNS:");
            sb.append(this.manageDNS + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.powerState != null) {
            sb.append("powerState:");
            sb.append(this.powerState + ",");
        }
        if (this.preserveOnDelete != null) {
            sb.append("preserveOnDelete:");
            sb.append(this.preserveOnDelete + ",");
        }
        if (this.provisioning != null) {
            sb.append("provisioning:");
            sb.append(this.provisioning + ",");
        }
        if (this.pullSecretRef != null) {
            sb.append("pullSecretRef:");
            sb.append(this.pullSecretRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withInstalled() {
        return this.withInstalled(true);
    }

    @Override
    public A withManageDNS() {
        return this.withManageDNS(true);
    }

    @Override
    public A withPreserveOnDelete() {
        return this.withPreserveOnDelete(true);
    }

    class PullSecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ClusterDeploymentSpecFluent.PullSecretRefNested<N>>
    implements ClusterDeploymentSpecFluent.PullSecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.withPullSecretRef(this.builder.build());
        }

        @Override
        public N endPullSecretRef() {
            return this.and();
        }
    }

    class ProvisioningNestedImpl<N>
    extends ProvisioningFluentImpl<ClusterDeploymentSpecFluent.ProvisioningNested<N>>
    implements ClusterDeploymentSpecFluent.ProvisioningNested<N>,
    Nested<N> {
        ProvisioningBuilder builder;

        ProvisioningNestedImpl(Provisioning item) {
            this.builder = new ProvisioningBuilder(this, item);
        }

        ProvisioningNestedImpl() {
            this.builder = new ProvisioningBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.withProvisioning(this.builder.build());
        }

        @Override
        public N endProvisioning() {
            return this.and();
        }
    }

    class PlatformNestedImpl<N>
    extends PlatformFluentImpl<ClusterDeploymentSpecFluent.PlatformNested<N>>
    implements ClusterDeploymentSpecFluent.PlatformNested<N>,
    Nested<N> {
        PlatformBuilder builder;

        PlatformNestedImpl(Platform item) {
            this.builder = new PlatformBuilder(this, item);
        }

        PlatformNestedImpl() {
            this.builder = new PlatformBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.withPlatform(this.builder.build());
        }

        @Override
        public N endPlatform() {
            return this.and();
        }
    }

    class IngressNestedImpl<N>
    extends ClusterIngressFluentImpl<ClusterDeploymentSpecFluent.IngressNested<N>>
    implements ClusterDeploymentSpecFluent.IngressNested<N>,
    Nested<N> {
        ClusterIngressBuilder builder;
        Integer index;

        IngressNestedImpl(Integer index, ClusterIngress item) {
            this.index = index;
            this.builder = new ClusterIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new ClusterIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }

    class ControlPlaneConfigNestedImpl<N>
    extends ControlPlaneConfigSpecFluentImpl<ClusterDeploymentSpecFluent.ControlPlaneConfigNested<N>>
    implements ClusterDeploymentSpecFluent.ControlPlaneConfigNested<N>,
    Nested<N> {
        ControlPlaneConfigSpecBuilder builder;

        ControlPlaneConfigNestedImpl(ControlPlaneConfigSpec item) {
            this.builder = new ControlPlaneConfigSpecBuilder(this, item);
        }

        ControlPlaneConfigNestedImpl() {
            this.builder = new ControlPlaneConfigSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.withControlPlaneConfig(this.builder.build());
        }

        @Override
        public N endControlPlaneConfig() {
            return this.and();
        }
    }

    class ClusterPoolRefNestedImpl<N>
    extends ClusterPoolReferenceFluentImpl<ClusterDeploymentSpecFluent.ClusterPoolRefNested<N>>
    implements ClusterDeploymentSpecFluent.ClusterPoolRefNested<N>,
    Nested<N> {
        ClusterPoolReferenceBuilder builder;

        ClusterPoolRefNestedImpl(ClusterPoolReference item) {
            this.builder = new ClusterPoolReferenceBuilder(this, item);
        }

        ClusterPoolRefNestedImpl() {
            this.builder = new ClusterPoolReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.withClusterPoolRef(this.builder.build());
        }

        @Override
        public N endClusterPoolRef() {
            return this.and();
        }
    }

    class ClusterMetadataNestedImpl<N>
    extends ClusterMetadataFluentImpl<ClusterDeploymentSpecFluent.ClusterMetadataNested<N>>
    implements ClusterDeploymentSpecFluent.ClusterMetadataNested<N>,
    Nested<N> {
        ClusterMetadataBuilder builder;

        ClusterMetadataNestedImpl(ClusterMetadata item) {
            this.builder = new ClusterMetadataBuilder(this, item);
        }

        ClusterMetadataNestedImpl() {
            this.builder = new ClusterMetadataBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.withClusterMetadata(this.builder.build());
        }

        @Override
        public N endClusterMetadata() {
            return this.and();
        }
    }

    class ClusterInstallRefNestedImpl<N>
    extends ClusterInstallLocalReferenceFluentImpl<ClusterDeploymentSpecFluent.ClusterInstallRefNested<N>>
    implements ClusterDeploymentSpecFluent.ClusterInstallRefNested<N>,
    Nested<N> {
        ClusterInstallLocalReferenceBuilder builder;

        ClusterInstallRefNestedImpl(ClusterInstallLocalReference item) {
            this.builder = new ClusterInstallLocalReferenceBuilder(this, item);
        }

        ClusterInstallRefNestedImpl() {
            this.builder = new ClusterInstallLocalReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.withClusterInstallRef(this.builder.build());
        }

        @Override
        public N endClusterInstallRef() {
            return this.and();
        }
    }

    class CertificateBundlesNestedImpl<N>
    extends CertificateBundleSpecFluentImpl<ClusterDeploymentSpecFluent.CertificateBundlesNested<N>>
    implements ClusterDeploymentSpecFluent.CertificateBundlesNested<N>,
    Nested<N> {
        CertificateBundleSpecBuilder builder;
        Integer index;

        CertificateBundlesNestedImpl(Integer index, CertificateBundleSpec item) {
            this.index = index;
            this.builder = new CertificateBundleSpecBuilder(this, item);
        }

        CertificateBundlesNestedImpl() {
            this.index = -1;
            this.builder = new CertificateBundleSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.setToCertificateBundles(this.index, this.builder.build());
        }

        @Override
        public N endCertificateBundle() {
            return this.and();
        }
    }

    class BoundServiceAccountSigningKeySecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<N>>
    implements ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        BoundServiceAccountSigningKeySecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        BoundServiceAccountSigningKeySecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentSpecFluentImpl.this.withBoundServiceAccountSigningKeySecretRef(this.builder.build());
        }

        @Override
        public N endBoundServiceAccountSigningKeySecretRef() {
            return this.and();
        }
    }
}

