/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.WeChatConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.WeChatConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class WeChatConfigFluentImpl<A extends WeChatConfigFluent<A>>
extends BaseFluent<A>
implements WeChatConfigFluent<A> {
    private String agentID;
    private SecretKeySelector apiSecret;
    private String apiURL;
    private String corpID;
    private HTTPConfigBuilder httpConfig;
    private String message;
    private String messageType;
    private Boolean sendResolved;
    private String toParty;
    private String toTag;
    private String toUser;
    private Map<String, Object> additionalProperties;

    public WeChatConfigFluentImpl() {
    }

    public WeChatConfigFluentImpl(WeChatConfig instance) {
        this.withAgentID(instance.getAgentID());
        this.withApiSecret(instance.getApiSecret());
        this.withApiURL(instance.getApiURL());
        this.withCorpID(instance.getCorpID());
        this.withHttpConfig(instance.getHttpConfig());
        this.withMessage(instance.getMessage());
        this.withMessageType(instance.getMessageType());
        this.withSendResolved(instance.getSendResolved());
        this.withToParty(instance.getToParty());
        this.withToTag(instance.getToTag());
        this.withToUser(instance.getToUser());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getAgentID() {
        return this.agentID;
    }

    @Override
    public A withAgentID(String agentID) {
        this.agentID = agentID;
        return (A)this;
    }

    @Override
    public Boolean hasAgentID() {
        return this.agentID != null;
    }

    @Override
    public SecretKeySelector getApiSecret() {
        return this.apiSecret;
    }

    @Override
    public A withApiSecret(SecretKeySelector apiSecret) {
        this.apiSecret = apiSecret;
        return (A)this;
    }

    @Override
    public Boolean hasApiSecret() {
        return this.apiSecret != null;
    }

    @Override
    public A withNewApiSecret(String key, String name, Boolean optional) {
        return this.withApiSecret(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getApiURL() {
        return this.apiURL;
    }

    @Override
    public A withApiURL(String apiURL) {
        this.apiURL = apiURL;
        return (A)this;
    }

    @Override
    public Boolean hasApiURL() {
        return this.apiURL != null;
    }

    @Override
    public String getCorpID() {
        return this.corpID;
    }

    @Override
    public A withCorpID(String corpID) {
        this.corpID = corpID;
        return (A)this;
    }

    @Override
    public Boolean hasCorpID() {
        return this.corpID != null;
    }

    @Override
    @Deprecated
    public HTTPConfig getHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    @Override
    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    @Override
    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.get("httpConfig").remove(this.httpConfig);
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    @Override
    public WeChatConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNestedImpl();
    }

    @Override
    public WeChatConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNestedImpl(item);
    }

    @Override
    public WeChatConfigFluent.HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(this.getHttpConfig());
    }

    @Override
    public WeChatConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(this.getHttpConfig() != null ? this.getHttpConfig() : new HTTPConfigBuilder().build());
    }

    @Override
    public WeChatConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(this.getHttpConfig() != null ? this.getHttpConfig() : item);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    @Override
    public A withMessageType(String messageType) {
        this.messageType = messageType;
        return (A)this;
    }

    @Override
    public Boolean hasMessageType() {
        return this.messageType != null;
    }

    @Override
    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    @Override
    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    @Override
    public Boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    @Override
    public String getToParty() {
        return this.toParty;
    }

    @Override
    public A withToParty(String toParty) {
        this.toParty = toParty;
        return (A)this;
    }

    @Override
    public Boolean hasToParty() {
        return this.toParty != null;
    }

    @Override
    public String getToTag() {
        return this.toTag;
    }

    @Override
    public A withToTag(String toTag) {
        this.toTag = toTag;
        return (A)this;
    }

    @Override
    public Boolean hasToTag() {
        return this.toTag != null;
    }

    @Override
    public String getToUser() {
        return this.toUser;
    }

    @Override
    public A withToUser(String toUser) {
        this.toUser = toUser;
        return (A)this;
    }

    @Override
    public Boolean hasToUser() {
        return this.toUser != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeChatConfigFluentImpl that = (WeChatConfigFluentImpl)o;
        if (this.agentID != null ? !this.agentID.equals(that.agentID) : that.agentID != null) {
            return false;
        }
        if (this.apiSecret != null ? !this.apiSecret.equals(that.apiSecret) : that.apiSecret != null) {
            return false;
        }
        if (this.apiURL != null ? !this.apiURL.equals(that.apiURL) : that.apiURL != null) {
            return false;
        }
        if (this.corpID != null ? !this.corpID.equals(that.corpID) : that.corpID != null) {
            return false;
        }
        if (this.httpConfig != null ? !this.httpConfig.equals(that.httpConfig) : that.httpConfig != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.messageType != null ? !this.messageType.equals(that.messageType) : that.messageType != null) {
            return false;
        }
        if (this.sendResolved != null ? !this.sendResolved.equals(that.sendResolved) : that.sendResolved != null) {
            return false;
        }
        if (this.toParty != null ? !this.toParty.equals(that.toParty) : that.toParty != null) {
            return false;
        }
        if (this.toTag != null ? !this.toTag.equals(that.toTag) : that.toTag != null) {
            return false;
        }
        if (this.toUser != null ? !this.toUser.equals(that.toUser) : that.toUser != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.agentID, this.apiSecret, this.apiURL, this.corpID, this.httpConfig, this.message, this.messageType, this.sendResolved, this.toParty, this.toTag, this.toUser, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.agentID != null) {
            sb.append("agentID:");
            sb.append(this.agentID + ",");
        }
        if (this.apiSecret != null) {
            sb.append("apiSecret:");
            sb.append(this.apiSecret + ",");
        }
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(this.apiURL + ",");
        }
        if (this.corpID != null) {
            sb.append("corpID:");
            sb.append(this.corpID + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(this.httpConfig + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.messageType != null) {
            sb.append("messageType:");
            sb.append(this.messageType + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.toParty != null) {
            sb.append("toParty:");
            sb.append(this.toParty + ",");
        }
        if (this.toTag != null) {
            sb.append("toTag:");
            sb.append(this.toTag + ",");
        }
        if (this.toUser != null) {
            sb.append("toUser:");
            sb.append(this.toUser + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    class HttpConfigNestedImpl<N>
    extends HTTPConfigFluentImpl<WeChatConfigFluent.HttpConfigNested<N>>
    implements WeChatConfigFluent.HttpConfigNested<N>,
    Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNestedImpl(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        HttpConfigNestedImpl() {
            this.builder = new HTTPConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)WeChatConfigFluentImpl.this.withHttpConfig(this.builder.build());
        }

        @Override
        public N endHttpConfig() {
            return this.and();
        }
    }
}

